/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.ranking.NonPerformanceCurveRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.ranking.TimeOnDistanceAllowancePerNauticalMileMap;
import com.sap.sailing.domain.ranking.TimeOnTimeFactorMapping;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.util.SerializableRunnable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class TimeOnTimeAndDistanceRankingMetric
extends NonPerformanceCurveRankingMetric {
    private static final long serialVersionUID = 2827013130741242548L;
    private final TimeOnTimeFactorMapping timeOnTimeFactor;
    private final TimeOnDistanceAllowancePerNauticalMileMap timeOnDistanceFactorNauticalMile;
    private ConcurrentHashMap<Competitor, Double> timeOnTimeFactorCache;
    private ConcurrentHashMap<Competitor, SerializableRunnable> timeOnTimeFactorCacheUpdateCallbacks;
    private ConcurrentHashMap<Competitor, Duration> timeOnDistanceFactorInSecondsPerNauticalMileCache;
    private ConcurrentHashMap<Competitor, SerializableRunnable> timeOnDistanceFactorInSecondsPerNauticalMileCacheUpdateCallbacks;

    public TimeOnTimeAndDistanceRankingMetric(TrackedRace trackedRace) {
        this(trackedRace, (TimeOnTimeAndDistanceRankingMetric totadrm) -> (TimeOnTimeFactorMapping & Serializable)c -> trackedRace.getTrackedRegatta().getRegatta().getTimeOnTimeFactor((Competitor)c, Optional.of(totadrm.getTimeOnTimeFactorCacheUpdateCallback((Competitor)c))), (TimeOnTimeAndDistanceRankingMetric totadrm) -> (TimeOnDistanceAllowancePerNauticalMileMap & Serializable)c -> trackedRace.getTrackedRegatta().getRegatta().getTimeOnDistanceAllowancePerNauticalMile((Competitor)c, Optional.of(totadrm.getTimeOnDistanceAllowanceCacheUpdateCallback((Competitor)c))));
    }

    public TimeOnTimeAndDistanceRankingMetric(TrackedRace trackedRace, TimeOnTimeFactorMapping timeOnTimeFactor, TimeOnDistanceAllowancePerNauticalMileMap timeOnDistanceFactorInSecondsPerNauticalMile) {
        this(trackedRace, (TimeOnTimeAndDistanceRankingMetric totadrm) -> timeOnTimeFactor, (TimeOnTimeAndDistanceRankingMetric totadrm) -> timeOnDistanceFactorInSecondsPerNauticalMile);
    }

    private TimeOnTimeAndDistanceRankingMetric(TrackedRace trackedRace, Function<TimeOnTimeAndDistanceRankingMetric, TimeOnTimeFactorMapping> timeOnTimeFactorMappingFunction, Function<TimeOnTimeAndDistanceRankingMetric, TimeOnDistanceAllowancePerNauticalMileMap> timeOnDistanceFactorInSecondsPerNauticalMileFunction) {
        super(trackedRace);
        this.timeOnTimeFactor = timeOnTimeFactorMappingFunction.apply(this);
        this.timeOnDistanceFactorNauticalMile = timeOnDistanceFactorInSecondsPerNauticalMileFunction.apply(this);
        this.timeOnTimeFactorCache = new ConcurrentHashMap();
        this.timeOnDistanceFactorInSecondsPerNauticalMileCache = new ConcurrentHashMap();
        this.timeOnTimeFactorCacheUpdateCallbacks = new ConcurrentHashMap();
        this.timeOnDistanceFactorInSecondsPerNauticalMileCacheUpdateCallbacks = new ConcurrentHashMap();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.timeOnTimeFactorCache = new ConcurrentHashMap();
        this.timeOnDistanceFactorInSecondsPerNauticalMileCache = new ConcurrentHashMap();
        this.timeOnTimeFactorCacheUpdateCallbacks = new ConcurrentHashMap();
        this.timeOnDistanceFactorInSecondsPerNauticalMileCacheUpdateCallbacks = new ConcurrentHashMap();
    }

    private Runnable getTimeOnTimeFactorCacheUpdateCallback(Competitor competitor) {
        SerializableRunnable & Serializable result = (SerializableRunnable & Serializable)() -> {
            Double d = this.timeOnTimeFactorCache.remove(competitor);
        };
        this.timeOnTimeFactorCacheUpdateCallbacks.put(competitor, result);
        return result;
    }

    private Runnable getTimeOnDistanceAllowanceCacheUpdateCallback(Competitor competitor) {
        SerializableRunnable & Serializable result = (SerializableRunnable & Serializable)() -> {
            Duration duration = this.timeOnDistanceFactorInSecondsPerNauticalMileCache.remove(competitor);
        };
        this.timeOnDistanceFactorInSecondsPerNauticalMileCacheUpdateCallbacks.put(competitor, result);
        return result;
    }

    @Override
    public RankingMetrics getType() {
        return RankingMetrics.TIME_ON_TIME_AND_DISTANCE;
    }

    @Override
    public Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        RankingMetric.RankingInfo rankingInfo = this.getRankingInfo(timePoint, cache);
        Comparator durationComparatorNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
        return (c1, c2) -> {
            RankingMetric.CompetitorRankingInfo c1CompetitorRankingInfo = rankingInfo.getCompetitorRankingInfo().apply((Competitor)c1);
            RankingMetric.CompetitorRankingInfo c2CompetitorRankingInfo = rankingInfo.getCompetitorRankingInfo().apply((Competitor)c2);
            return durationComparatorNullsLast.compare(c1CompetitorRankingInfo == null ? null : c1CompetitorRankingInfo.getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead(), c2CompetitorRankingInfo == null ? null : c2CompetitorRankingInfo.getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead());
        };
    }

    @Override
    public Comparator<TrackedLegOfCompetitor> getLegRankingComparator(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        boolean fastestCompetitorHasStartedLeg;
        HashMap<Competitor, MillisecondsDurationImpl> correctedTimesToReachFastestBoatsPositionAtTimePointOrEndOfLegMeasuredFromStartOfRace = new HashMap<Competitor, MillisecondsDurationImpl>();
        Competitor fastestCompetitorInLeg = this.getCompetitorFarthestAheadInLeg(trackedLeg, timePoint, cache);
        if (fastestCompetitorInLeg != null) {
            Distance totalWindwardDistanceLegLeaderTraveledUpToTimePointOrLegEnd;
            Position positionOfFastestBoatInLegAtTimePointOrLegEnd;
            TrackedLegOfCompetitor trackedLegOfFastestCompetitorInLeg = trackedLeg.getTrackedLeg(fastestCompetitorInLeg);
            fastestCompetitorHasStartedLeg = this.isAssumedToHaveStartedLeg(timePoint, trackedLegOfFastestCompetitorInLeg);
            TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
            if (trackedLegOfFastestCompetitorInLeg.hasFinishedLeg(timePoint)) {
                positionOfFastestBoatInLegAtTimePointOrLegEnd = this.getTrackedRace().getApproximatePosition(trackedLeg.getLeg().getTo(), timePoint);
                Distance.NullDistance totalWindwardDistanceIncludingCompleteLeg = Distance.NULL;
                Course course = this.getTrackedRace().getRace().getCourse();
                course.lockForRead();
                try {
                    for (TrackedLeg tl : this.getTrackedRace().getTrackedLegs()) {
                        totalWindwardDistanceIncludingCompleteLeg = totalWindwardDistanceIncludingCompleteLeg.add(tl.getWindwardDistance(cache));
                        if (tl != trackedLeg) {
                            if (totalWindwardDistanceIncludingCompleteLeg != null) continue;
                        }
                        break;
                    }
                }
                finally {
                    course.unlockAfterRead();
                }
                totalWindwardDistanceLegLeaderTraveledUpToTimePointOrLegEnd = totalWindwardDistanceIncludingCompleteLeg;
            } else {
                positionOfFastestBoatInLegAtTimePointOrLegEnd = this.getTrackedRace().getTrack(fastestCompetitorInLeg).getEstimatedPosition(timePoint, true);
                totalWindwardDistanceLegLeaderTraveledUpToTimePointOrLegEnd = this.getWindwardDistanceTraveled(fastestCompetitorInLeg, timePoint, cache);
            }
            for (Competitor competitor : this.getCompetitors()) {
                MillisecondsDurationImpl correctedTime;
                TrackedLegOfCompetitor competitorLeg = trackedLeg.getTrackedLeg(competitor);
                if (competitorLeg != null && competitorLeg.hasStartedLeg(timePoint)) {
                    Duration timeToReachFastest = this.getPredictedDurationToEndOfLegOrTo(timePoint, competitorLeg, trackedLegOfFastestCompetitorInLeg, cache);
                    Duration totalDurationSinceRaceStart = timeToReachFastest == null ? null : (startOfRace == null ? null : startOfRace.until(timePoint).plus(timeToReachFastest));
                    correctedTime = this.getCalculatedTime(competitor, () -> trackedLeg.getLeg(), () -> positionOfFastestBoatInLegAtTimePointOrLegEnd, totalDurationSinceRaceStart, totalWindwardDistanceLegLeaderTraveledUpToTimePointOrLegEnd);
                } else {
                    correctedTime = new MillisecondsDurationImpl(Long.MAX_VALUE);
                }
                correctedTimesToReachFastestBoatsPositionAtTimePointOrEndOfLegMeasuredFromStartOfRace.put(competitor, correctedTime);
            }
        } else {
            fastestCompetitorHasStartedLeg = false;
        }
        Comparator durationComparatorNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
        return (tloc1, tloc2) -> fastestCompetitorHasStartedLeg ? durationComparatorNullsLast.compare((Duration)correctedTimesToReachFastestBoatsPositionAtTimePointOrEndOfLegMeasuredFromStartOfRace.get(tloc1.getCompetitor()), (Duration)correctedTimesToReachFastestBoatsPositionAtTimePointOrEndOfLegMeasuredFromStartOfRace.get(tloc2.getCompetitor())) : 0;
    }

    @Override
    public Duration getCorrectedTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration timeActuallySpent = this.getActualTimeSinceStartOfRace(competitor, timePoint);
        Distance windwardDistanceSailed = this.getWindwardDistanceTraveled(competitor, timePoint, cache);
        return this.getCalculatedTime(competitor, () -> this.getTrackedRace().getCurrentLeg(competitor, timePoint).getLeg(), () -> this.getTrackedRace().getTrack(competitor).getEstimatedPosition(timePoint, true), timeActuallySpent, windwardDistanceSailed);
    }

    double getTimeOnTimeFactor(Competitor competitor) {
        return this.timeOnTimeFactorCache.computeIfAbsent(competitor, (Function<Competitor, Double>)((Object)this.timeOnTimeFactor));
    }

    Duration getTimeOnDistanceFactorInSecondsPerNauticalMile(Competitor competitor) {
        return this.timeOnDistanceFactorInSecondsPerNauticalMileCache.computeIfAbsent(competitor, (Function<Competitor, Duration>)((Object)this.timeOnDistanceFactorNauticalMile));
    }

    @Override
    protected Duration getCalculatedTime(Competitor who, Supplier<Leg> leg, Supplier<Position> estimatedPosition, Duration totalDurationSinceRaceStart, Distance totalWindwardDistanceTraveled) {
        Duration timeOnDistanceFactorInSecondsPerNauticalMile = this.getTimeOnDistanceFactorInSecondsPerNauticalMile(who);
        return totalDurationSinceRaceStart == null ? null : totalDurationSinceRaceStart.times(this.getTimeOnTimeFactor(who)).minus(totalWindwardDistanceTraveled == null || timeOnDistanceFactorInSecondsPerNauticalMile == null ? Duration.NULL : timeOnDistanceFactorInSecondsPerNauticalMile.times(totalWindwardDistanceTraveled.getNauticalMiles()));
    }

    @Override
    protected Duration getDurationToReachAtEqualPerformance(Competitor who, Competitor to, Waypoint fromWaypoint, TimePoint timePointOfTosPosition, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        MillisecondsDurationImpl t_who;
        MarkPassing whenToPassedFromWaypoint = this.getTrackedRace().getMarkPassing(to, fromWaypoint);
        if (whenToPassedFromWaypoint == null) {
            t_who = null;
        } else {
            this.validateGetDurationToReachAtEqualPerformanceParameters(to, fromWaypoint, timePointOfTosPosition, whenToPassedFromWaypoint);
            Duration t_to = whenToPassedFromWaypoint.getTimePoint().until(timePointOfTosPosition);
            Distance d_to = this.getWindwardDistanceTraveled(to, fromWaypoint, timePointOfTosPosition, cache);
            double f_to = this.getTimeOnTimeFactor(to);
            Duration timeOnDistanceFactorInSecondsPerNauticalMileTo = this.getTimeOnDistanceFactorInSecondsPerNauticalMile(to);
            double g_to = timeOnDistanceFactorInSecondsPerNauticalMileTo == null ? 0.0 : timeOnDistanceFactorInSecondsPerNauticalMileTo.asSeconds();
            Distance d_who = d_to;
            double f_who = this.getTimeOnTimeFactor(who);
            Duration timeOnDistanceFactorInSecondsPerNauticalMileWho = this.getTimeOnDistanceFactorInSecondsPerNauticalMile(who);
            double g_who = timeOnDistanceFactorInSecondsPerNauticalMileWho == null ? 0.0 : timeOnDistanceFactorInSecondsPerNauticalMileWho.asSeconds();
            t_who = d_to == null ? null : new MillisecondsDurationImpl(Double.valueOf((1.0 / (d_to.inTime(t_to.times(f_to)).getMetersPerSecond() / 1852.0) - g_to + g_who) * d_who.getNauticalMiles() / f_who * 1000.0).longValue());
        }
        return t_who;
    }

    @Override
    public Duration getGapToLeaderInOwnTime(RankingMetric.RankingInfo rankingInfo, Competitor competitor, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        Competitor leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead = rankingInfo.getLeaderByCorrectedEstimatedTimeToCompetitorFarthestAhead();
        if (leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead == null) {
            result = null;
        } else {
            Duration t_k = rankingInfo.getCompetitorRankingInfo().apply(leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead).getEstimatedActualDurationFromRaceStartToCompetitorFarthestAhead();
            Duration t_i = rankingInfo.getCompetitorRankingInfo().apply(competitor).getEstimatedActualDurationFromRaceStartToCompetitorFarthestAhead();
            Distance d = rankingInfo.getCompetitorRankingInfo().apply(rankingInfo.getCompetitorFarthestAhead()).getWindwardDistanceSailed();
            result = this.getGapToCompetitorInOwnTime(competitor, leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead, t_i, t_k, d);
        }
        return result;
    }

    private Duration getGapToCompetitorInOwnTime(Competitor i, Competitor k, Duration t_i, Duration t_k, Distance d) {
        double f_i = this.getTimeOnTimeFactor(i);
        Duration g_i = this.getTimeOnDistanceFactorInSecondsPerNauticalMile(i);
        double f_k = this.getTimeOnTimeFactor(k);
        Duration g_k = this.getTimeOnDistanceFactorInSecondsPerNauticalMile(k);
        Duration diff_t_i = t_i == null || t_k == null || d == null ? null : t_i.minus(t_k.times(f_k).plus((g_i == null ? Duration.NULL : g_i).minus(g_k == null ? Duration.NULL : g_k).times(d.getNauticalMiles())).divide(f_i));
        return diff_t_i;
    }

    @Override
    public Duration getLegGapToLegLeaderInOwnTime(TrackedLegOfCompetitor trackedLegOfCompetitor, TimePoint timePoint, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        assert (rankingInfo instanceof NonPerformanceCurveRankingMetric.NonPerformanceCurveRankingInfo);
        NonPerformanceCurveRankingMetric.NonPerformanceCurveRankingInfo npcRankingInfo = (NonPerformanceCurveRankingMetric.NonPerformanceCurveRankingInfo)rankingInfo;
        Leg leg = trackedLegOfCompetitor.getLeg();
        if (this.getTrackedRace().getStartOfRace() == null || !trackedLegOfCompetitor.hasStartedLeg(timePoint)) {
            result = null;
        } else {
            Competitor farthestAheadOrEarliestLegFinisher = this.getCompetitorFarthestAheadInLeg(trackedLegOfCompetitor.getTrackedLeg(), timePoint, cache);
            if (farthestAheadOrEarliestLegFinisher == null) {
                result = null;
            } else {
                TrackedLegOfCompetitor tlocOfFarthestAhead = trackedLegOfCompetitor.getTrackedLeg().getTrackedLeg(farthestAheadOrEarliestLegFinisher);
                boolean farthestAheadAlreadyFinishedLeg = tlocOfFarthestAhead.hasFinishedLeg(timePoint);
                Distance windwardDistanceFarthestTraveledUntilFinishingLeg = this.getWindwardDistanceTraveled(farthestAheadOrEarliestLegFinisher, farthestAheadAlreadyFinishedLeg ? tlocOfFarthestAhead.getFinishTime() : timePoint, cache);
                Competitor legLeader = npcRankingInfo.getLeaderInLegByCalculatedTime(trackedLegOfCompetitor.getTrackedLeg().getLeg(), cache);
                result = this.getGapToCompetitorInOwnTime(trackedLegOfCompetitor.getCompetitor(), legLeader, npcRankingInfo.getActualTimeFromRaceStartToReachFarthestAheadInLeg(trackedLegOfCompetitor.getCompetitor(), leg, cache), npcRankingInfo.getActualTimeFromRaceStartToReachFarthestAheadInLeg(legLeader, leg, cache), windwardDistanceFarthestTraveledUntilFinishingLeg);
            }
        }
        return result;
    }
}

