/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveByImpliedWindRankingMetric;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveRankingMetric;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveRankingMetricLeaderForBaseline;
import com.sap.sailing.domain.ranking.OneDesignRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.ranking.TimeOnTimeAndDistanceRankingMetric;
import java.util.HashMap;
import java.util.Map;

public final class RankingMetricsFactory {
    private static final Map<Class<? extends RankingMetric>, RankingMetrics> byClass = new HashMap<Class<? extends RankingMetric>, RankingMetrics>();

    static {
        RankingMetrics[] rankingMetricsArray = RankingMetrics.values();
        int n = rankingMetricsArray.length;
        int n2 = 0;
        while (n2 < n) {
            RankingMetrics rm = rankingMetricsArray[n2];
            byClass.put(((RankingMetric)RankingMetricsFactory.getRankingMetricConstructor(rm).apply(null)).getClass(), rm);
            ++n2;
        }
    }

    public static RankingMetrics getForClass(Class<? extends RankingMetric> c) {
        return byClass.get(c);
    }

    public static RankingMetricConstructor getRankingMetricConstructor(RankingMetrics rankingMetric) {
        switch (rankingMetric) {
            case ONE_DESIGN: {
                return OneDesignRankingMetric::new;
            }
            case ORC_PERFORMANCE_CURVE: {
                return ORCPerformanceCurveRankingMetric::new;
            }
            case ORC_PERFORMANCE_CURVE_LEADER_FOR_BASELINE: {
                return ORCPerformanceCurveRankingMetricLeaderForBaseline::new;
            }
            case ORC_PERFORMANCE_CURVE_BY_IMPLIED_WIND: {
                return ORCPerformanceCurveByImpliedWindRankingMetric::new;
            }
            case TIME_ON_TIME_AND_DISTANCE: {
                return TimeOnTimeAndDistanceRankingMetric::new;
            }
        }
        throw new IllegalArgumentException(rankingMetric.name());
    }
}

