/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.ranking;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.impl.CompetitorImpl;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.AbstractRaceRankComparator;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.stream.StreamSupport;

public abstract class AbstractRankingMetric
implements RankingMetric {
    private static final long serialVersionUID = -3671039530564696392L;
    private final TrackedRace trackedRace;
    private static final Competitor NULL_COMPETITOR = new CompetitorImpl(null, null, null, null, null, null, null, null, null, null);

    protected AbstractRankingMetric(TrackedRace trackedRace) {
        this.trackedRace = trackedRace;
    }

    @Override
    public TrackedRace getTrackedRace() {
        return this.trackedRace;
    }

    protected Competitor getCompetitorFarthestAhead(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Comparator<Competitor> oneDesignComparator = this.getWindwardDistanceTraveledComparator(timePoint, cache);
        Optional<Competitor> competitorFarthestAhead = StreamSupport.stream(this.getCompetitors().spliterator(), false).sorted(oneDesignComparator).findFirst();
        return competitorFarthestAhead.orElse(null);
    }

    @Override
    public Duration getActualTimeSinceStartOfRace(Competitor competitor, TimePoint timePoint) {
        MarkPassing finishingMarkPassing;
        Waypoint finish;
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        Object result = startOfRace == null || timePoint.before(startOfRace) ? null : ((finish = this.getTrackedRace().getRace().getCourse().getLastWaypoint()) == null ? null : ((finishingMarkPassing = this.getTrackedRace().getMarkPassing(competitor, finish)) != null ? (finishingMarkPassing.getTimePoint().before(timePoint) ? startOfRace.until(finishingMarkPassing.getTimePoint()) : startOfRace.until(timePoint)) : (this.trackedRace.getEndOfTracking() != null && timePoint.after(this.trackedRace.getEndOfTracking()) ? null : startOfRace.until(timePoint))));
        return result;
    }

    protected Iterable<Competitor> getCompetitors() {
        return this.getTrackedRace().getRace().getCompetitors();
    }

    protected TrackedLegOfCompetitor getCurrentLegOrLastLegIfAlreadyFinished(Competitor who, TimePoint timePoint) {
        TrackedLeg lastTrackedLeg;
        TrackedLegOfCompetitor whosLastTrackedLeg;
        Waypoint lastWaypoint;
        TrackedLegOfCompetitor currentLegWho = this.getTrackedRace().getCurrentLeg(who, timePoint);
        if (currentLegWho == null && (lastWaypoint = this.getTrackedRace().getRace().getCourse().getLastWaypoint()) != null && this.getTrackedRace().getRace().getCourse().getNumberOfWaypoints() > 1 && this.isAssumedToHaveFinishedLeg(timePoint, whosLastTrackedLeg = (lastTrackedLeg = this.getTrackedRace().getTrackedLegFinishingAt(lastWaypoint)).getTrackedLeg(who))) {
            currentLegWho = whosLastTrackedLeg;
        }
        return currentLegWho;
    }

    protected Duration getPredictedDurationToEndOfLegOrTo(TimePoint timePoint, TrackedLegOfCompetitor legWho, TrackedLegOfCompetitor legTo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Position positionOfTo;
        Position positionOfEndOfLeg;
        Duration durationToReach;
        TimePoint whosLegFinishTime;
        assert (this.isAssumedToHaveStartedLeg(timePoint, legWho) || this.isAssumedToHaveFinishedLeg(timePoint, legWho));
        assert (this.isAssumedToHaveStartedLeg(timePoint, legTo) || this.isAssumedToHaveFinishedLeg(timePoint, legTo));
        Duration toEndOfLegOrTo = this.isAssumedToHaveFinishedLeg(timePoint, legTo) ? ((whosLegFinishTime = legWho.getFinishTime()) != null && !whosLegFinishTime.after(timePoint) ? timePoint.until(whosLegFinishTime) : ((durationToReach = this.getDurationToReach(positionOfEndOfLeg = this.getTrackedRace().getApproximatePosition(legWho.getLeg().getTo(), timePoint), timePoint, legWho, cache)) == null ? null : durationToReach.abs())) : ((positionOfTo = this.getTrackedRace().getTrack(legTo.getCompetitor()).getEstimatedPosition(timePoint, true)) == null ? null : this.getDurationToReach(positionOfTo, timePoint, legWho, cache));
        return toEndOfLegOrTo;
    }

    private Duration getDurationToReach(Position windwardPositionToReachInWhosCurrentLeg, TimePoint timePoint, TrackedLegOfCompetitor whosLeg, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Speed averageVMG = whosLeg.getAverageVelocityMadeGood(timePoint, cache);
        Speed vmg = averageVMG == null || Double.isNaN(averageVMG.getKnots()) ? whosLeg.getVelocityMadeGood(timePoint, WindPositionMode.EXACT, cache) : averageVMG;
        Duration toEndOfLegOrTo = vmg == null || vmg.getKnots() == 0.0 ? null : vmg.getDuration(whosLeg.getTrackedLeg().getWindwardDistance(this.getTrackedRace().getTrack(whosLeg.getCompetitor()).getEstimatedPosition(timePoint, true), windwardPositionToReachInWhosCurrentLeg, timePoint, WindPositionMode.LEG_MIDDLE));
        return toEndOfLegOrTo;
    }

    protected void validateGetDurationToReachAtEqualPerformanceParameters(Competitor to, Waypoint fromWaypoint, TimePoint timePointOfTosPosition, MarkPassing whenToPassedFromWaypoint) {
        if (whenToPassedFromWaypoint == null) {
            throw new IllegalArgumentException("Competitor " + to + " is expected to have passed " + fromWaypoint + " but hasn't");
        }
        if (whenToPassedFromWaypoint.getTimePoint().after(timePointOfTosPosition)) {
            throw new IllegalArgumentException("Competitor " + to + " was expected to have passed " + fromWaypoint + " before " + timePointOfTosPosition + " but did pass it at " + whenToPassedFromWaypoint.getTimePoint());
        }
    }

    protected Distance getWindwardDistanceTraveled(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getWindwardDistanceTraveled(competitor, this.getTrackedRace().getRace().getCourse().getFirstWaypoint(), timePoint, cache);
    }

    private Comparator<Competitor> getWindwardDistanceTraveledComparator(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        final HashMap<Competitor, Distance> windwardDistanceTraveledPerCompetitor = new HashMap<Competitor, Distance>();
        for (Competitor competitor : this.getCompetitors()) {
            windwardDistanceTraveledPerCompetitor.put(competitor, this.getWindwardDistanceTraveled(competitor, timePoint, cache));
        }
        return new AbstractRaceRankComparator<Distance>(this.getTrackedRace(), timePoint, false){

            @Override
            protected Distance getComparisonValueForSameLeg(Competitor competitor) {
                return (Distance)windwardDistanceTraveledPerCompetitor.get(competitor);
            }
        };
    }

    protected Distance getWindwardDistanceTraveled(Competitor competitor, Waypoint from, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Distance.NullDistance result;
        if (from == null) {
            result = null;
        } else {
            Distance.NullDistance d = Distance.NULL;
            boolean count = false;
            Course course = this.getTrackedRace().getRace().getCourse();
            course.lockForRead();
            try {
                for (TrackedLeg trackedLeg : this.getTrackedRace().getTrackedLegs()) {
                    boolean bl = count = count || trackedLeg.getLeg().getFrom() == from;
                    if (!count) continue;
                    LegType legTypeForRanking = this.getLegTypeForRanking(trackedLeg);
                    TrackedLegOfCompetitor trackedLegOfCompetitor = trackedLeg.getTrackedLeg(competitor);
                    if (!this.isAssumedToHaveStartedLeg(timePoint, trackedLegOfCompetitor)) continue;
                    if (!this.isAssumedToHaveFinishedLeg(timePoint, trackedLegOfCompetitor)) {
                        Position estimatedPosition = this.getTrackedRace().getTrack(competitor).getEstimatedPosition(timePoint, true);
                        if (estimatedPosition != null) {
                            Distance windwardDistanceFromLegStart = trackedLeg.getWindwardDistanceFromLegStart(legTypeForRanking, estimatedPosition, cache);
                            if (windwardDistanceFromLegStart == null) {
                                d = null;
                            } else {
                                Distance legWindwardDistance = trackedLeg.getWindwardDistance(legTypeForRanking, cache);
                                if (legWindwardDistance != null && legWindwardDistance.compareTo((Object)windwardDistanceFromLegStart) < 0) {
                                    d = d.add(legWindwardDistance);
                                } else if (windwardDistanceFromLegStart.getMeters() > 0.0) {
                                    d = d.add(windwardDistanceFromLegStart);
                                }
                            }
                        }
                        break;
                    }
                    Distance legWindwardDistance = trackedLeg.getWindwardDistance(legTypeForRanking, cache);
                    if (legWindwardDistance == null) continue;
                    d = d.add(legWindwardDistance);
                }
            }
            finally {
                course.unlockAfterRead();
            }
            result = d;
        }
        return result;
    }

    protected LegType getLegTypeForRanking(TrackedLeg trackedLeg) {
        return null;
    }

    protected boolean isAssumedToHaveFinishedLeg(TimePoint timePoint, TrackedLegOfCompetitor trackedLegOfCompetitor) {
        Waypoint legEndWaypoint = trackedLegOfCompetitor.getLeg().getTo();
        MarkPassing markPassing = this.findMarkPassingForWaypointOrSuccessorAtOrBeforeTimePoint(timePoint, trackedLegOfCompetitor, legEndWaypoint);
        return markPassing != null;
    }

    protected boolean isAssumedToHaveStartedLeg(TimePoint timePoint, TrackedLegOfCompetitor trackedLegOfCompetitor) {
        Waypoint legStartWaypoint = trackedLegOfCompetitor.getLeg().getFrom();
        MarkPassing markPassing = this.findMarkPassingForWaypointOrSuccessorAtOrBeforeTimePoint(timePoint, trackedLegOfCompetitor, legStartWaypoint);
        return markPassing != null;
    }

    private MarkPassing findMarkPassingForWaypointOrSuccessorAtOrBeforeTimePoint(TimePoint timePoint, TrackedLegOfCompetitor trackedLegOfCompetitor, Waypoint legStartWaypoint) {
        Iterable waypoints = this.getTrackedRace().getRace().getCourse().getWaypoints();
        boolean checkForMarkPassing = false;
        MarkPassing markPassing = null;
        for (Waypoint waypoint : waypoints) {
            MarkPassing markPassingCandidate;
            if (waypoint == legStartWaypoint) {
                checkForMarkPassing = true;
            }
            if (!checkForMarkPassing || (markPassingCandidate = this.getTrackedRace().getMarkPassing(trackedLegOfCompetitor.getCompetitor(), waypoint)) == null || markPassingCandidate.getTimePoint().after(timePoint)) continue;
            markPassing = markPassingCandidate;
            break;
        }
        return markPassing;
    }

    protected Competitor getCompetitorFarthestAheadInLeg(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Competitor result;
        Competitor firstAroundMark = this.getFirstLegFinisherBefore(trackedLeg, timePoint);
        if (firstAroundMark != null) {
            result = firstAroundMark;
        } else {
            ArrayList copyOfMarkPassingsForLegStart = new ArrayList();
            Iterable<MarkPassing> markPassingsForLegStart = this.getTrackedRace().getMarkPassingsInOrder(trackedLeg.getLeg().getFrom());
            this.getTrackedRace().lockForRead(markPassingsForLegStart);
            try {
                Util.addAll(markPassingsForLegStart, copyOfMarkPassingsForLegStart);
            }
            finally {
                this.getTrackedRace().unlockAfterRead(markPassingsForLegStart);
            }
            MeterDistance maxWindwardDistanceTraveled = new MeterDistance(Double.MIN_VALUE);
            Competitor competitorFarthestAlong = null;
            for (MarkPassing mp : copyOfMarkPassingsForLegStart) {
                if (mp.getTimePoint().after(timePoint)) break;
                Distance windwardDistanceTraveled = this.getWindwardDistanceTraveled(mp.getCompetitor(), mp.getWaypoint(), timePoint, cache);
                if (windwardDistanceTraveled == null || windwardDistanceTraveled.compareTo((Object)maxWindwardDistanceTraveled) <= 0) continue;
                maxWindwardDistanceTraveled = windwardDistanceTraveled;
                competitorFarthestAlong = mp.getCompetitor();
            }
            result = competitorFarthestAlong;
        }
        return result;
    }

    private Competitor getFirstLegFinisherBefore(TrackedLeg trackedLeg, TimePoint timePoint) {
        Iterable<MarkPassing> markPassingsForLegEnd = this.getTrackedRace().getMarkPassingsInOrder(trackedLeg.getLeg().getTo());
        Competitor firstAroundMark = null;
        this.getTrackedRace().lockForRead(markPassingsForLegEnd);
        try {
            MarkPassing markPassing;
            Iterator<MarkPassing> i = markPassingsForLegEnd.iterator();
            if (i.hasNext() && !(markPassing = i.next()).getTimePoint().after(timePoint)) {
                firstAroundMark = markPassing.getCompetitor();
            }
        }
        finally {
            this.getTrackedRace().unlockAfterRead(markPassingsForLegEnd);
        }
        return firstAroundMark;
    }

    public abstract class AbstractRankingInfo
    implements RankingMetric.RankingInfo {
        private static final long serialVersionUID = -1714363056412906424L;
        private final TimePoint timePoint;
        private final ConcurrentMap<Leg, Competitor> competitorFarthestAheadInLeg;

        public AbstractRankingInfo(TimePoint timePoint) {
            this.timePoint = timePoint;
            this.competitorFarthestAheadInLeg = new ConcurrentHashMap<Leg, Competitor>();
        }

        @Override
        public TimePoint getTimePoint() {
            return this.timePoint;
        }

        @Override
        public Competitor getCompetitorFarthestAheadInLeg(Leg leg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
            Competitor result = (Competitor)this.competitorFarthestAheadInLeg.get(leg);
            if (result == NULL_COMPETITOR) {
                result = null;
            } else if (result == null) {
                result = AbstractRankingMetric.this.getCompetitorFarthestAheadInLeg(AbstractRankingMetric.this.getTrackedRace().getTrackedLeg(leg), timePoint, cache);
                this.competitorFarthestAheadInLeg.put(leg, result == null ? NULL_COMPETITOR : result);
            }
            return result;
        }
    }

    public abstract class AbstractRankingInfoWithCompetitorRankingInfoCache
    extends AbstractRankingInfo
    implements RankingMetric.RankingInfoWithLegLeader {
        private static final long serialVersionUID = 4476276127292347825L;
        private final Function<Competitor, RankingMetric.CompetitorRankingInfo> competitorRankingInfo;
        private final Competitor leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead;
        private final Competitor competitorFarthestAhead;

        public AbstractRankingInfoWithCompetitorRankingInfoCache(TimePoint timePoint, Map<Competitor, RankingMetric.CompetitorRankingInfo> competitorRankingInfo, Competitor competitorFarthestAhead) {
            super(timePoint);
            this.competitorFarthestAhead = competitorFarthestAhead;
            this.competitorRankingInfo = c -> (RankingMetric.CompetitorRankingInfo)competitorRankingInfo.get(c);
            Comparator durationComparatorNullsLast = Comparator.nullsLast(Comparator.naturalOrder());
            this.leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead = competitorRankingInfo.keySet().stream().sorted((c1, c2) -> durationComparatorNullsLast.compare(((RankingMetric.CompetitorRankingInfo)competitorRankingInfo.get(c1)).getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead(), ((RankingMetric.CompetitorRankingInfo)competitorRankingInfo.get(c2)).getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead())).findFirst().orElse(null);
        }

        @Override
        public Function<Competitor, RankingMetric.CompetitorRankingInfo> getCompetitorRankingInfo() {
            return this.competitorRankingInfo;
        }

        @Override
        public Competitor getLeaderByCorrectedEstimatedTimeToCompetitorFarthestAhead() {
            return this.leaderByCorrectedEstimatedTimeToCompetitorFarthestAhead;
        }

        @Override
        public Competitor getCompetitorFarthestAhead() {
            return this.competitorFarthestAhead;
        }

        @Override
        public Competitor getLeaderInLegByCalculatedTime(Leg leg, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
            TrackedLeg trackedLeg = AbstractRankingMetric.this.getTrackedRace().getTrackedLeg(leg);
            return trackedLeg.getLeader(this.getTimePoint(), cache);
        }
    }

    public class CompetitorRankingInfoImpl
    implements RankingMetric.CompetitorRankingInfo {
        private static final long serialVersionUID = 2699792976562460961L;
        private final TimePoint timePoint;
        private final Competitor competitor;
        private final Distance windwardDistanceSailed;
        private final Duration durationSinceStartOfRaceUntilTimePoint;
        private final Duration timeElapsed;
        private final Duration correctedTime;
        private final Duration estimatedActualDurationToCompetitorFarthestAhead;
        private final Duration correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;

        public CompetitorRankingInfoImpl(TimePoint timePoint, Competitor competitor, Distance windwardDistanceSailed, Duration durationSinceStartOfRaceUntilTimePoint, Duration timeElapsed, Duration correctedTime, Duration estimatedActualDurationToCompetitorFarthestAhead, Duration correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead) {
            this.timePoint = timePoint;
            this.competitor = competitor;
            this.windwardDistanceSailed = windwardDistanceSailed;
            this.durationSinceStartOfRaceUntilTimePoint = durationSinceStartOfRaceUntilTimePoint;
            this.timeElapsed = timeElapsed;
            this.correctedTime = correctedTime;
            this.estimatedActualDurationToCompetitorFarthestAhead = estimatedActualDurationToCompetitorFarthestAhead;
            this.correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead = correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;
        }

        @Override
        public TimePoint getTimePoint() {
            return this.timePoint;
        }

        @Override
        public Competitor getCompetitor() {
            return this.competitor;
        }

        @Override
        public Distance getWindwardDistanceSailed() {
            return this.windwardDistanceSailed;
        }

        @Override
        public Duration getDurationSinceStartOfRaceUntilTimePoint() {
            return this.durationSinceStartOfRaceUntilTimePoint;
        }

        @Override
        public Duration getTimeElapsed() {
            return this.timeElapsed;
        }

        @Override
        public Duration getCorrectedTime() {
            return this.correctedTime;
        }

        @Override
        public Duration getEstimatedActualDurationFromTimePointToCompetitorFarthestAhead() {
            return this.estimatedActualDurationToCompetitorFarthestAhead;
        }

        @Override
        public Duration getCorrectedTimeAtEstimatedArrivalAtCompetitorFarthestAhead() {
            return this.correctedTimeAtEstimatedArrivalAtCompetitorFarthestAhead;
        }
    }
}

