/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.orc.impl;

import com.sap.sailing.domain.abstractlog.orc.RaceLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCCertificateAssignmentFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCImpliedWindSourceEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCImpliedWindSourceFinder;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataAnalyzer;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCLegDataEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatEvent;
import com.sap.sailing.domain.abstractlog.orc.RaceLogORCScratchBoatFinder;
import com.sap.sailing.domain.abstractlog.orc.RegattaLogORCCertificateAssignmentEvent;
import com.sap.sailing.domain.abstractlog.orc.RegattaLogORCCertificateAssignmentFinder;
import com.sap.sailing.domain.abstractlog.orc.impl.RaceLogORCLegDataEventImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.impl.SimpleRaceLogIdentifierImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.impl.BaseRegattaLogEventVisitor;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.common.orc.FixedSpeedImpliedWind;
import com.sap.sailing.domain.common.orc.ImpliedWindSource;
import com.sap.sailing.domain.common.orc.ImpliedWindSourceVisitor;
import com.sap.sailing.domain.common.orc.ORCCertificate;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveCourse;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.OtherRaceAsImpliedWindSource;
import com.sap.sailing.domain.common.orc.OwnMaxImpliedWind;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveCourseImpl;
import com.sap.sailing.domain.common.orc.impl.OwnMaxImpliedWindImpl;
import com.sap.sailing.domain.orc.ORCPerformanceCurve;
import com.sap.sailing.domain.orc.ORCPerformanceCurveRankingMetric;
import com.sap.sailing.domain.orc.impl.ImpliedWindRetrieverWithNoTrackedRace;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveImpl;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveLegAdapter;
import com.sap.sailing.domain.orc.impl.ORCPerformanceCurveLegAdapterWithConstantDistance;
import com.sap.sailing.domain.ranking.AbstractRankingMetric;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;

public class ORCPerformanceCurveByImpliedWindRankingMetric
extends AbstractRankingMetric
implements ORCPerformanceCurveRankingMetric {
    private static final long serialVersionUID = -7814822523533929816L;
    private static final Logger logger = Logger.getLogger(ORCPerformanceCurveByImpliedWindRankingMetric.class.getName());
    private Map<Boat, ORCCertificate> certificates;
    private Boat boatWithLeastGPH;
    private ORCPerformanceCurveCourse totalCourse;
    private final Map<Serializable, Boat> boatsById = this.initBoatsById();
    private transient RaceLogEventVisitor certificatesAndCourseAndScratchBoatFromRaceLogUpdater;
    private transient RegattaLogEventVisitor certificatesFromRegattaLogUpdater;
    private Competitor explicitScratchBoat;
    private ImpliedWindSource impliedWindSource;

    public ORCPerformanceCurveByImpliedWindRankingMetric(TrackedRace trackedRace) {
        super(trackedRace);
        this.initializeListeners();
        this.updateCertificatesFromLogs();
        this.updateCourseFromRaceLogs();
        this.updateImpliedWindSource();
    }

    @Override
    public RankingMetrics getType() {
        return RankingMetrics.ORC_PERFORMANCE_CURVE_BY_IMPLIED_WIND;
    }

    private void initializeListeners() {
        this.certificatesAndCourseAndScratchBoatFromRaceLogUpdater = this.createCertificatesFromRaceLogAndCourseAndScratchBoatUpdater();
        this.certificatesFromRegattaLogUpdater = this.createCertificatesFromRegattaLogUpdater();
        if (this.getTrackedRace() != null) {
            this.addTrackedRaceListener(this.getTrackedRace());
            for (RegattaLog regattaLog : this.getTrackedRace().getAttachedRegattaLogs()) {
                regattaLog.addListener((Object)this.certificatesFromRegattaLogUpdater);
            }
            for (RaceLog raceLog : this.getTrackedRace().getAttachedRaceLogs()) {
                raceLog.addListener((Object)this.certificatesAndCourseAndScratchBoatFromRaceLogUpdater);
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        ois.registerValidation(() -> this.initializeListeners(), -1);
    }

    private void addTrackedRaceListener(TrackedRace trackedRace) {
        trackedRace.addListener(new AbstractRaceChangeListener(){

            @Override
            public void regattaLogAttached(RegattaLog regattaLog) {
                regattaLog.addListener((Object)ORCPerformanceCurveByImpliedWindRankingMetric.this.certificatesFromRegattaLogUpdater);
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCertificatesFromLogs();
            }

            @Override
            public void raceLogAttached(RaceLog raceLog) {
                raceLog.addListener((Object)ORCPerformanceCurveByImpliedWindRankingMetric.this.certificatesAndCourseAndScratchBoatFromRaceLogUpdater);
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCertificatesFromLogs();
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateScratchBoatFromLogs();
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
            }

            @Override
            public void raceLogDetached(RaceLog raceLog) {
                raceLog.removeListener((Object)ORCPerformanceCurveByImpliedWindRankingMetric.this.certificatesAndCourseAndScratchBoatFromRaceLogUpdater);
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCertificatesFromLogs();
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateScratchBoatFromLogs();
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
            }

            @Override
            public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
            }

            @Override
            public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
            }
        });
    }

    @Override
    public ORCCertificate getCertificate(Boat boat) {
        return this.certificates.get(boat);
    }

    protected Boat getBoatWithLeastGph() {
        return this.boatWithLeastGPH;
    }

    private Map<Serializable, Boat> initBoatsById() {
        HashMap<Serializable, Boat> result = new HashMap<Serializable, Boat>();
        if (this.getTrackedRace() != null) {
            for (Boat boat : this.getTrackedRace().getTrackedRegatta().getRegatta().getAllBoats()) {
                result.put(boat.getId(), boat);
            }
        }
        return result;
    }

    private RaceLogEventVisitor createCertificatesFromRaceLogAndCourseAndScratchBoatUpdater() {
        return new BaseRaceLogEventVisitor(){

            public void visit(RaceLogORCLegDataEvent orcLegDataEventImpl) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
            }

            public void visit(RaceLogORCCertificateAssignmentEvent event) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCertificatesFromLogs();
            }

            public void visit(RaceLogORCImpliedWindSourceEvent event) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateImpliedWindSource();
            }

            public void visit(RaceLogRevokeEvent event) {
                if (event.getRevokedEventType().equals(RaceLogORCLegDataEventImpl.class.getName())) {
                    ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCourseFromRaceLogs();
                } else if (event.getRevokedEventType().equals(RaceLogORCLegDataEventImpl.class.getName())) {
                    ORCPerformanceCurveByImpliedWindRankingMetric.this.updateScratchBoatFromLogs();
                }
            }

            public void visit(RaceLogORCScratchBoatEvent event) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateScratchBoatFromLogs();
            }
        };
    }

    private RegattaLogEventVisitor createCertificatesFromRegattaLogUpdater() {
        return new BaseRegattaLogEventVisitor(){

            public void visit(RegattaLogORCCertificateAssignmentEvent event) {
                ORCPerformanceCurveByImpliedWindRankingMetric.this.updateCertificatesFromLogs();
            }
        };
    }

    private void updateScratchBoatFromLogs() {
        Competitor scratchBoatFromLog = null;
        for (RaceLog raceLog : this.getTrackedRace().getAttachedRaceLogs()) {
            scratchBoatFromLog = (Competitor)new RaceLogORCScratchBoatFinder(raceLog).analyze();
            if (scratchBoatFromLog != null) break;
        }
        this.explicitScratchBoat = scratchBoatFromLog;
    }

    private void updateImpliedWindSource() {
        ImpliedWindSource newImpliedWindSource = null;
        if (this.getTrackedRace() != null) {
            for (RaceLog raceLog : this.getTrackedRace().getAttachedRaceLogs()) {
                newImpliedWindSource = (ImpliedWindSource)new RaceLogORCImpliedWindSourceFinder(raceLog).analyze();
                if (newImpliedWindSource != null) break;
            }
        }
        this.impliedWindSource = newImpliedWindSource != null ? newImpliedWindSource : new OwnMaxImpliedWindImpl();
    }

    protected ImpliedWindSource getImpliedWindSource() {
        return this.impliedWindSource;
    }

    private void updateCertificatesFromLogs() {
        if (this.getTrackedRace() != null) {
            HashMap<Boat, ORCCertificate> newCertificates = new HashMap<Boat, ORCCertificate>();
            for (RegattaLog regattaLog : this.getTrackedRace().getAttachedRegattaLogs()) {
                newCertificates.putAll((Map)new RegattaLogORCCertificateAssignmentFinder(regattaLog, this.boatsById).analyze());
            }
            for (RaceLog raceLog : this.getTrackedRace().getAttachedRaceLogs()) {
                newCertificates.putAll((Map)new RaceLogORCCertificateAssignmentFinder(raceLog, this.boatsById).analyze());
            }
            this.certificates = newCertificates;
            MillisecondsDurationImpl minGPH = new MillisecondsDurationImpl(Long.MAX_VALUE);
            Boat boatWithMinGPH = null;
            for (Map.Entry<Boat, ORCCertificate> e : this.certificates.entrySet()) {
                if (e.getValue().getGPH() == null || e.getValue().getGPH().compareTo((Object)minGPH) >= 0) continue;
                boatWithMinGPH = e.getKey();
                minGPH = e.getValue().getGPH();
            }
            this.boatWithLeastGPH = boatWithMinGPH;
        }
    }

    private void updateCourseFromRaceLogs() {
        if (this.getTrackedRace() != null) {
            HashMap<Integer, ORCPerformanceCurveLeg> legsWithDefinitions = new HashMap<Integer, ORCPerformanceCurveLeg>();
            for (RaceLog raceLog : this.getTrackedRace().getAttachedRaceLogs()) {
                legsWithDefinitions.putAll((Map)new RaceLogORCLegDataAnalyzer(raceLog).analyze());
            }
            List legs = this.getTrackedRace().getRace().getCourse().getLegs();
            int oneBasedLegNumber = 1;
            ArrayList<ORCPerformanceCurveLeg> performanceCurveLegs = new ArrayList<ORCPerformanceCurveLeg>(Util.size((Iterable)legs));
            for (Leg leg : legs) {
                performanceCurveLegs.add(legsWithDefinitions.computeIfAbsent(oneBasedLegNumber, i -> new ORCPerformanceCurveLegAdapter(this.getTrackedRace().getTrackedLeg(leg))));
                ++oneBasedLegNumber;
            }
            this.totalCourse = new ORCPerformanceCurveCourseImpl(performanceCurveLegs);
        }
    }

    public ORCPerformanceCurveCourse getTotalCourse() {
        return this.totalCourse;
    }

    private ORCPerformanceCurveCourse getPartialCourse(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        ORCPerformanceCurveCourse result;
        MarkPassing finishMarkPassing;
        Leg firstLeg = this.getTrackedRace().getRace().getCourse().getFirstLeg();
        Waypoint finish = this.getTrackedRace().getRace().getCourse().getLastWaypoint();
        if (finish != null && (finishMarkPassing = this.getTrackedRace().getMarkPassing(competitor, finish)) != null && !finishMarkPassing.getTimePoint().after(timePoint)) {
            result = cache.getTotalCourse(this.getTrackedRace(), () -> this.getTotalCourse());
        } else {
            TrackedLegOfCompetitor trackedLegOfCompetitor = this.getTrackedRace().getTrackedLeg(competitor, timePoint);
            if (trackedLegOfCompetitor == null) {
                TrackedLegOfCompetitor trackedFirstLegOfCompetitor = this.getTrackedRace().getTrackedLeg(competitor, firstLeg);
                result = trackedFirstLegOfCompetitor != null && trackedFirstLegOfCompetitor.hasStartedLeg(timePoint) ? cache.getTotalCourse(this.getTrackedRace(), () -> this.getTotalCourse()) : cache.getTotalCourse(this.getTrackedRace(), () -> this.getTotalCourse()).subcourse(0, 0.0);
            } else {
                ORCPerformanceCurveCourse totalCourse = cache.getTotalCourse(this.getTrackedRace(), () -> this.getTotalCourse());
                int zeroBasedIndexOfCurrentLeg = this.getTrackedRace().getRace().getCourse().getIndexOfWaypoint(trackedLegOfCompetitor.getLeg().getFrom());
                ORCPerformanceCurveLeg currentLeg = (ORCPerformanceCurveLeg)Util.get((Iterable)totalCourse.getLegs(), (int)zeroBasedIndexOfCurrentLeg);
                LegType legType = currentLeg.getType().isProjectToWindForUpwindAndDownwind() ? null : LegType.REACHING;
                Distance windwardToGo = trackedLegOfCompetitor.getWindwardDistanceToGo(legType, timePoint, WindPositionMode.LEG_MIDDLE, cache);
                Distance windwardTotal = trackedLegOfCompetitor.getTrackedLeg().getWindwardDistance(legType, timePoint, cache);
                if (windwardToGo != null && windwardTotal != null) {
                    double shareOfCurrentLeg = 1.0 - windwardToGo.divide(windwardTotal);
                    result = totalCourse.subcourse(zeroBasedIndexOfCurrentLeg, shareOfCurrentLeg, (zeroBasedLegIndex, leg) -> this.replaceWindwardLeewardByConstructed((int)zeroBasedLegIndex, (ORCPerformanceCurveLeg)leg, timePoint, cache));
                } else {
                    result = cache.getTotalCourse(this.getTrackedRace(), () -> this.getTotalCourse()).subcourse(0, 0.0);
                }
            }
        }
        return result;
    }

    private ORCPerformanceCurveLeg replaceWindwardLeewardByConstructed(int zeroBasedLegIndex, ORCPerformanceCurveLeg originalLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        ORCPerformanceCurveLegAdapterWithConstantDistance result;
        assert (originalLeg.getType() == ORCPerformanceCurveLegTypes.WINDWARD_LEEWARD_REAL_LIVE);
        List legs = this.getTrackedRace().getRace().getCourse().getLegs();
        if (zeroBasedLegIndex >= legs.size()) {
            logger.warning("Couldn't construct leg adapter for leg #" + zeroBasedLegIndex + " as there are only " + legs.size() + " legs in the race course of " + this.getTrackedRace() + "; using original leg");
            result = originalLeg;
        } else {
            TrackedLeg trackedLeg = this.getTrackedRace().getTrackedLeg((Leg)legs.get(zeroBasedLegIndex));
            result = new ORCPerformanceCurveLegAdapterWithConstantDistance(trackedLeg, originalLeg.getLength());
        }
        return result;
    }

    protected Competitor getExplicitScratchBoat() {
        return this.explicitScratchBoat;
    }

    private Competitor getScratchBoat(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Competitor result = this.getExplicitScratchBoat() != null ? this.getExplicitScratchBoat() : this.getCompetitorFarthestAhead(timePoint, cache);
        return result;
    }

    @Override
    public Comparator<Competitor> getRaceRankingComparator(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Map<Competitor, Speed> impliedWindByCompetitor = this.getImpliedWindByCompetitor(timePoint, cache);
        return (c1, c2) -> Comparator.nullsLast((impliedWindSpeed1, impliedWindSpeed2) -> impliedWindSpeed2.compareTo(impliedWindSpeed1)).compare((Speed)impliedWindByCompetitor.get(c1), (Speed)impliedWindByCompetitor.get(c2));
    }

    protected Map<Competitor, Speed> getImpliedWindByCompetitor(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, Speed> impliedWindByCompetitor = new HashMap<Competitor, Speed>();
        for (Competitor competitor : this.getTrackedRace().getRace().getCompetitors()) {
            impliedWindByCompetitor.put(competitor, cache.getImpliedWind(timePoint, this.getTrackedRace(), competitor, this.getImpliedWindSupplier(cache)));
        }
        return impliedWindByCompetitor;
    }

    protected ORCPerformanceCurve getPerformanceCurveForPartialCourse(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        ORCCertificate certificate;
        ORCPerformanceCurveCourse competitorsPartialCourseAtTimePoint = this.getPartialCourse(competitor, timePoint, cache);
        ORCPerformanceCurveImpl performanceCurveForPartialCourse = competitorsPartialCourseAtTimePoint.getTotalLength().equals(Distance.NULL) ? null : ((certificate = this.getCertificate(this.getTrackedRace().getBoatOfCompetitor(competitor))) != null ? new ORCPerformanceCurveImpl(certificate, competitorsPartialCourseAtTimePoint, cache) : null);
        return performanceCurveForPartialCourse;
    }

    @Override
    public Speed getImpliedWind(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws FunctionEvaluationException, MaxIterationsExceededException {
        Duration timeSailedSinceRaceStart;
        ORCPerformanceCurve performanceCurveForPartialCourse = cache.getPerformanceCurveForPartialCourse(timePoint, this.getTrackedRace(), competitor, this.getPerformanceCurveSupplier(cache));
        Speed result = performanceCurveForPartialCourse != null ? ((timeSailedSinceRaceStart = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint)) != null ? performanceCurveForPartialCourse.getImpliedWind(timeSailedSinceRaceStart) : null) : null;
        return result;
    }

    @Override
    public Comparator<TrackedLegOfCompetitor> getLegRankingComparator(TrackedLeg trackedLeg, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, Speed> impliedWindByCompetitor = new HashMap<Competitor, Speed>();
        for (Competitor competitor : this.getTrackedRace().getRace().getCompetitors()) {
            Speed impliedWind = trackedLeg.getTrackedLeg(competitor).hasFinishedLeg(timePoint) ? cache.getImpliedWind(trackedLeg.getTrackedLeg(competitor).getFinishTime(), this.getTrackedRace(), competitor, this.getImpliedWindSupplier(cache)) : cache.getImpliedWind(timePoint, this.getTrackedRace(), competitor, this.getImpliedWindSupplier(cache));
            impliedWindByCompetitor.put(competitor, impliedWind);
        }
        return (tloc1, tloc2) -> {
            boolean hasStarted1 = tloc1.hasStartedLeg(timePoint);
            boolean hasStarted2 = tloc2.hasStartedLeg(timePoint);
            int result = !hasStarted1 ? (!hasStarted2 ? 0 : 1) : (!hasStarted2 ? -1 : Comparator.nullsLast((impliedWind1, impliedWind2) -> impliedWind2.compareTo(impliedWind1)).compare((Speed)impliedWindByCompetitor.get(tloc1.getCompetitor()), (Speed)impliedWindByCompetitor.get(tloc2.getCompetitor())));
            return result;
        };
    }

    @Override
    public Duration getCorrectedTime(Competitor competitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result = null;
        Competitor scratchBoat = cache.getScratchBoat(timePoint, this.getTrackedRace(), tp -> this.getScratchBoat((TimePoint)tp, cache));
        if (competitor == scratchBoat) {
            result = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint);
        } else {
            ORCPerformanceCurve competitorPerformanceCurve;
            BiFunction<TimePoint, Competitor, ORCPerformanceCurve> performanceCurveSupplier = this.getPerformanceCurveSupplier(cache);
            ORCPerformanceCurve scratchBoatPerformanceCurve = cache.getPerformanceCurveForPartialCourse(timePoint, this.getTrackedRace(), scratchBoat, performanceCurveSupplier);
            if (scratchBoatPerformanceCurve != null && (competitorPerformanceCurve = cache.getPerformanceCurveForPartialCourse(timePoint, this.getTrackedRace(), competitor, performanceCurveSupplier)) != null) {
                Speed competitorImpliedWind;
                Duration competitorElapsedTimeSinceRaceStart = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint);
                try {
                    competitorImpliedWind = competitorPerformanceCurve.getImpliedWind(competitorElapsedTimeSinceRaceStart);
                }
                catch (FunctionEvaluationException | MaxIterationsExceededException e) {
                    logger.log(Level.WARNING, "Problem evaluating performance curve function for competitor " + competitor + " for duration " + competitorElapsedTimeSinceRaceStart, e);
                    logger.fine("The performance curve was: " + competitorPerformanceCurve);
                    competitorImpliedWind = null;
                }
                if (competitorImpliedWind != null) {
                    try {
                        result = scratchBoatPerformanceCurve.getAllowancePerCourse(competitorImpliedWind);
                    }
                    catch (FunctionEvaluationException e) {
                        logger.log(Level.WARNING, "Problem evaluating performance curve function on scratch boat " + scratchBoat + " to compute corrected time of competitor " + competitor + " based on her implied wind ", e);
                        logger.fine("The scratch boat performance curve was: " + scratchBoatPerformanceCurve);
                    }
                }
            }
        }
        return result;
    }

    protected BiFunction<TimePoint, Competitor, Speed> getImpliedWindSupplier(WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return (timePoint, competitor) -> {
            try {
                return this.getImpliedWind((Competitor)competitor, (TimePoint)timePoint, cache);
            }
            catch (FunctionEvaluationException | MaxIterationsExceededException e) {
                logger.log(Level.WARNING, "Problem evaluating performance curve", e);
                return null;
            }
        };
    }

    protected BiFunction<TimePoint, Competitor, ORCPerformanceCurve> getPerformanceCurveSupplier(WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return (timePoint, competitor) -> {
            try {
                return this.getPerformanceCurveForPartialCourse((Competitor)competitor, (TimePoint)timePoint, cache);
            }
            catch (FunctionEvaluationException e) {
                logger.log(Level.WARNING, "Problem evaluating performance curve function for " + competitor, e);
                return null;
            }
        };
    }

    @Override
    public ORCPerformanceCurveRankingInfo getRankingInfo(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        HashMap<Competitor, RankingMetric.CompetitorRankingInfo> competitorRankingInfo = new HashMap<Competitor, RankingMetric.CompetitorRankingInfo>();
        TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
        Competitor competitorFarthestAhead = this.getCompetitorFarthestAhead(timePoint, cache);
        if (startOfRace != null) {
            Duration durationSinceStartOfRaceUntilTimePoint = startOfRace.until(timePoint);
            for (Competitor competitor : this.getTrackedRace().getRace().getCompetitors()) {
                Duration correctedTime = this.getCorrectedTime(competitor, timePoint, cache);
                competitorRankingInfo.put(competitor, new AbstractRankingMetric.CompetitorRankingInfoImpl(timePoint, competitor, this.getWindwardDistanceTraveled(competitor, timePoint, cache), durationSinceStartOfRaceUntilTimePoint, this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint), correctedTime, this.getEstimatedActualDurationToCompetitorFarthestAhead(competitor, competitorFarthestAhead, timePoint, cache), correctedTime));
            }
        }
        return new ORCPerformanceCurveRankingInfo(timePoint, competitorFarthestAhead, competitorRankingInfo, cache);
    }

    private Duration getEstimatedActualDurationToCompetitorFarthestAhead(Competitor competitor, Competitor competitorFarthestAhead, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        ORCPerformanceCurveCourse courseOfCompetitorFarthestAhead = this.getPartialCourse(competitorFarthestAhead, timePoint, cache);
        try {
            ORCCertificate certificate = this.getCertificate(this.getTrackedRace().getBoatOfCompetitor(competitor));
            if (certificate != null) {
                ORCPerformanceCurveImpl performanceCurveForCompetitorToPositionOfCompetitorFarthestAhread = new ORCPerformanceCurveImpl(certificate, courseOfCompetitorFarthestAhead, cache);
                Speed competitorsCurrentImpliedWind = cache.getImpliedWind(timePoint, this.getTrackedRace(), competitorFarthestAhead, this.getImpliedWindSupplier(cache));
                if (competitorsCurrentImpliedWind != null) {
                    Duration allowanceToPositionOfBoatFarthestAhead = performanceCurveForCompetitorToPositionOfCompetitorFarthestAhread.getAllowancePerCourse(competitorsCurrentImpliedWind);
                    Duration competitorElapsedTime = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, timePoint);
                    result = competitorElapsedTime == null ? null : allowanceToPositionOfBoatFarthestAhead.minus(competitorElapsedTime);
                } else {
                    result = null;
                }
            } else {
                result = null;
            }
        }
        catch (FunctionEvaluationException e) {
            logger.log(Level.SEVERE, "Problem evaluating ORC PCS function", e);
            result = null;
        }
        return result;
    }

    @Override
    public Duration getGapToLeaderInOwnTime(RankingMetric.RankingInfo rankingInfo, Competitor competitor, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        block7: {
            assert (rankingInfo instanceof ORCPerformanceCurveRankingInfo);
            TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
            if (startOfRace != null) {
                Duration timeSailedSinceRaceStart = this.getTrackedRace().getTimeSailedSinceRaceStart(competitor, rankingInfo.getTimePoint());
                Competitor leader = rankingInfo.getLeaderByCorrectedEstimatedTimeToCompetitorFarthestAhead();
                try {
                    ORCPerformanceCurve competitorPerformanceCurve = cache.getPerformanceCurveForPartialCourse(rankingInfo.getTimePoint(), this.getTrackedRace(), competitor, this.getPerformanceCurveSupplier(cache));
                    if (competitorPerformanceCurve == null) {
                        result = null;
                        break block7;
                    }
                    Speed impliedWindOfLeader = cache.getImpliedWind(rankingInfo.getTimePoint(), this.getTrackedRace(), leader, this.getImpliedWindSupplier(cache));
                    if (impliedWindOfLeader != null) {
                        Duration allowanceForLeaderInCompetitorsPerformanceCurve = competitorPerformanceCurve.getAllowancePerCourse(impliedWindOfLeader);
                        result = timeSailedSinceRaceStart.minus(allowanceForLeaderInCompetitorsPerformanceCurve);
                        break block7;
                    }
                    result = null;
                }
                catch (FunctionEvaluationException e) {
                    logger.log(Level.WARNING, "Problem evaluating performance curve for competitor " + competitor + " for time point " + rankingInfo.getTimePoint(), e);
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    @Override
    public Duration getLegGapToLegLeaderInOwnTime(TrackedLegOfCompetitor trackedLegOfCompetitor, TimePoint timePoint, RankingMetric.RankingInfo rankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Duration result;
        block7: {
            assert (rankingInfo instanceof ORCPerformanceCurveRankingInfo);
            TimePoint startOfRace = this.getTrackedRace().getStartOfRace();
            if (trackedLegOfCompetitor.hasStartedLeg(timePoint) && startOfRace != null) {
                ORCPerformanceCurveRankingInfo orcPcsRankingInfo = (ORCPerformanceCurveRankingInfo)rankingInfo;
                Competitor legLeader = orcPcsRankingInfo.getLeaderInLegByCalculatedTime(trackedLegOfCompetitor.getLeg(), cache);
                Competitor competitor = trackedLegOfCompetitor.getCompetitor();
                try {
                    TimePoint timeForCompetitorImpliedWindCalculation = this.timePointOrLegFinishTimeIfFinishedAtTimePoint(trackedLegOfCompetitor, timePoint, cache);
                    ORCPerformanceCurve competitorPerformanceCurveForLeg = this.getPerformanceCurveForPartialCourse(competitor, timeForCompetitorImpliedWindCalculation, cache);
                    if (competitorPerformanceCurveForLeg == null) {
                        result = null;
                        break block7;
                    }
                    TimePoint timeForLegLeaderImpliedWindCalculation = this.timePointOrLegFinishTimeIfFinishedAtTimePoint(this.getTrackedRace().getTrackedLeg(legLeader, trackedLegOfCompetitor.getLeg()), timePoint, cache);
                    Speed legLeaderImpliedWindInOrAtEndOfLeg = cache.getImpliedWind(timeForLegLeaderImpliedWindCalculation, this.getTrackedRace(), legLeader, this.getImpliedWindSupplier(cache));
                    if (legLeaderImpliedWindInOrAtEndOfLeg != null) {
                        Duration correctedTimeOfLegLeaderInCompetitorsPerformanceCurve = competitorPerformanceCurveForLeg.getAllowancePerCourse(legLeaderImpliedWindInOrAtEndOfLeg);
                        Duration actualRaceDurationForCompetitor = startOfRace.until(timeForCompetitorImpliedWindCalculation);
                        result = actualRaceDurationForCompetitor.minus(correctedTimeOfLegLeaderInCompetitorsPerformanceCurve);
                        break block7;
                    }
                    result = null;
                }
                catch (FunctionEvaluationException e) {
                    logger.log(Level.WARNING, "Problem with performance curve calculation for competitor " + competitor + " or " + legLeader, e);
                    result = null;
                }
            } else {
                result = null;
            }
        }
        return result;
    }

    private TimePoint timePointOrLegFinishTimeIfFinishedAtTimePoint(TrackedLegOfCompetitor trackedLegOfCompetitor, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws FunctionEvaluationException {
        TimePoint timeForImpliedWindCalculation = trackedLegOfCompetitor.hasFinishedLeg(timePoint) ? trackedLegOfCompetitor.getFinishTime() : timePoint;
        return timeForImpliedWindCalculation;
    }

    @Override
    protected LegType getLegTypeForRanking(TrackedLeg trackedLeg) {
        int zeroBasedLegIndex = trackedLeg.getLeg().getZeroBasedIndexOfStartWaypoint();
        ORCPerformanceCurveLeg orcLeg = (ORCPerformanceCurveLeg)Util.get((Iterable)this.getTotalCourse().getLegs(), (int)zeroBasedLegIndex);
        return ORCPerformanceCurveLegTypes.getLegType((ORCPerformanceCurveLegTypes)orcLeg.getType());
    }

    @Override
    public Speed getReferenceImpliedWind(final TimePoint timePoint, final WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return (Speed)this.getImpliedWindSource().accept((ImpliedWindSourceVisitor)new ImpliedWindSourceVisitor<Speed>(){

            public Speed visit(FixedSpeedImpliedWind impliedWindSource) {
                return impliedWindSource.getFixedImpliedWindSpeed();
            }

            public Speed visit(OwnMaxImpliedWind impliedWindSource) {
                return Collections.max(ORCPerformanceCurveByImpliedWindRankingMetric.this.getImpliedWindByCompetitor(timePoint, cache).values(), Comparator.nullsFirst(Comparator.naturalOrder()));
            }

            public Speed visit(OtherRaceAsImpliedWindSource impliedWindSource) {
                ImpliedWindSource otherRaceImpliedWindSource;
                RaceLog raceLog;
                SimpleRaceLogIdentifierImpl raceLogIdentifier = new SimpleRaceLogIdentifierImpl((String)impliedWindSource.getLeaderboardAndRaceColumnAndFleetOfDefiningRace().getA(), (String)impliedWindSource.getLeaderboardAndRaceColumnAndFleetOfDefiningRace().getB(), (String)impliedWindSource.getLeaderboardAndRaceColumnAndFleetOfDefiningRace().getC());
                TrackedRace otherTrackedRace = ORCPerformanceCurveByImpliedWindRankingMetric.this.getTrackedRace().getRaceLogResolver().resolveTrackedRace((SimpleRaceLogIdentifier)raceLogIdentifier);
                Object result = otherTrackedRace == null ? ((raceLog = ORCPerformanceCurveByImpliedWindRankingMetric.this.getTrackedRace().getRaceLogResolver().resolve((SimpleRaceLogIdentifier)raceLogIdentifier)) != null ? ((otherRaceImpliedWindSource = (ImpliedWindSource)new RaceLogORCImpliedWindSourceFinder(raceLog).analyze()) != null ? (Speed)otherRaceImpliedWindSource.accept((ImpliedWindSourceVisitor)new ImpliedWindRetrieverWithNoTrackedRace(timePoint, cache, ORCPerformanceCurveByImpliedWindRankingMetric.this.getTrackedRace().getRaceLogResolver())) : null) : null) : otherTrackedRace.getReferenceImpliedWind(timePoint, cache);
                return result;
            }
        });
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " for race " + this.getTrackedRace();
    }

    private class ORCPerformanceCurveRankingInfo
    extends AbstractRankingMetric.AbstractRankingInfoWithCompetitorRankingInfoCache {
        private static final long serialVersionUID = -3578498778702139675L;

        public ORCPerformanceCurveRankingInfo(TimePoint timePoint, Competitor competitorFarthestAhead, Map<Competitor, RankingMetric.CompetitorRankingInfo> competitorRankingInfo, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
            super(timePoint, competitorRankingInfo, competitorFarthestAhead);
        }
    }
}

