/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassinghash.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.MarkPassingDataFinder;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Set;
import org.json.simple.JSONObject;

public class MarkPassingRaceFingerprintImpl
implements MarkPassingRaceFingerprint {
    private final int calculatorVersion;
    private final int competitorHash;
    private final TimePoint startOfTracking;
    private final TimePoint startTimeReceived;
    private final TimePoint endOfTracking;
    private final TimePoint startTimeFromRaceLog;
    private final TimePoint finishTimeFromRaceLog;
    private final int fixedAndSuppressedMarkPassingsFromRaceLogHash;
    private final int waypointsHash;
    private final int numberOfGPSFixes;
    private final int gpsFixesHash;

    public MarkPassingRaceFingerprintImpl(TrackedRace trackedRace) {
        this.calculatorVersion = 2;
        this.competitorHash = this.calculateHashForCompetitors(trackedRace);
        this.startOfTracking = trackedRace.getStartOfTracking();
        this.endOfTracking = trackedRace.getEndOfTracking();
        this.startTimeReceived = trackedRace.getStartTimeReceived();
        Util.Pair<TimePoint, TimePoint> startAndFinishedTimeFromRaceLogs = trackedRace.getStartAndFinishedTimeFromRaceLogs();
        this.startTimeFromRaceLog = startAndFinishedTimeFromRaceLogs == null ? null : (TimePoint)startAndFinishedTimeFromRaceLogs.getA();
        this.finishTimeFromRaceLog = startAndFinishedTimeFromRaceLogs == null ? null : (TimePoint)startAndFinishedTimeFromRaceLogs.getB();
        this.waypointsHash = this.calculateHashForWaypoints(trackedRace);
        this.numberOfGPSFixes = this.calculateHashForNumberOfGPSFixes(trackedRace);
        this.gpsFixesHash = this.calculateHashForGPSFixes(trackedRace);
        this.fixedAndSuppressedMarkPassingsFromRaceLogHash = this.calculateFixedAndSuppressedMarkPassingsFromRaceLogHash(trackedRace);
    }

    private int calculateFixedAndSuppressedMarkPassingsFromRaceLogHash(TrackedRace trackedRace) {
        int result = 1023;
        for (RaceLog raceLog : trackedRace.getAttachedRaceLogs()) {
            for (Util.Triple triple : (Set)new MarkPassingDataFinder(raceLog).analyze()) {
                result ^= ((Competitor)triple.getA()).getId().hashCode();
                result ^= ((Integer)triple.getB()).intValue();
                if (triple.getC() == null) continue;
                result ^= ((TimePoint)triple.getC()).hashCode();
            }
        }
        return result;
    }

    public MarkPassingRaceFingerprintImpl(JSONObject json) {
        this.calculatorVersion = ((Number)json.get((Object)JSON_FIELDS.CALCULATOR_VERSION.name())).intValue();
        this.competitorHash = ((Number)json.get((Object)JSON_FIELDS.COMPETITOR_HASH.name())).intValue();
        this.startOfTracking = TimePoint.of((Long)((Long)json.get((Object)JSON_FIELDS.START_OF_TRACKING_AS_MILLIS.name())));
        this.endOfTracking = TimePoint.of((Long)((Long)json.get((Object)JSON_FIELDS.END_OF_TRACKING_AS_MILLIS.name())));
        this.startTimeReceived = TimePoint.of((Long)((Long)json.get((Object)JSON_FIELDS.START_TIME_RECEIVED_AS_MILLIS.name())));
        this.startTimeFromRaceLog = TimePoint.of((Long)((Long)json.get((Object)JSON_FIELDS.START_TIME_FROM_RACE_LOG_AS_MILLIS.name())));
        this.finishTimeFromRaceLog = TimePoint.of((Long)((Long)json.get((Object)JSON_FIELDS.FINISH_TIME_FROM_RACE_LOG_AS_MILLIS.name())));
        this.waypointsHash = ((Number)json.get((Object)JSON_FIELDS.WAYPOINTS_HASH.name())).intValue();
        this.numberOfGPSFixes = ((Number)json.get((Object)JSON_FIELDS.NUMBEROFGPSFIXES.name())).intValue();
        this.gpsFixesHash = ((Number)json.get((Object)JSON_FIELDS.GPSFIXES_HASH.name())).intValue();
        this.fixedAndSuppressedMarkPassingsFromRaceLogHash = ((Number)json.get((Object)JSON_FIELDS.FIXED_AND_SUPPRESSED_MARK_PASSINGS_FROM_RACE_LOG_HASH.name())).intValue();
    }

    @Override
    public JSONObject toJson() {
        JSONObject result = new JSONObject();
        result.put((Object)JSON_FIELDS.CALCULATOR_VERSION.name(), (Object)this.calculatorVersion);
        result.put((Object)JSON_FIELDS.COMPETITOR_HASH.name(), (Object)this.competitorHash);
        result.put((Object)JSON_FIELDS.START_OF_TRACKING_AS_MILLIS.name(), this.startOfTracking == null ? null : Long.valueOf(this.startOfTracking.asMillis()));
        result.put((Object)JSON_FIELDS.END_OF_TRACKING_AS_MILLIS.name(), this.endOfTracking == null ? null : Long.valueOf(this.endOfTracking.asMillis()));
        result.put((Object)JSON_FIELDS.START_TIME_RECEIVED_AS_MILLIS.name(), this.startTimeReceived == null ? null : Long.valueOf(this.startTimeReceived.asMillis()));
        result.put((Object)JSON_FIELDS.START_TIME_FROM_RACE_LOG_AS_MILLIS.name(), this.startTimeFromRaceLog == null ? null : Long.valueOf(this.startTimeFromRaceLog.asMillis()));
        result.put((Object)JSON_FIELDS.FINISH_TIME_FROM_RACE_LOG_AS_MILLIS.name(), this.finishTimeFromRaceLog == null ? null : Long.valueOf(this.finishTimeFromRaceLog.asMillis()));
        result.put((Object)JSON_FIELDS.WAYPOINTS_HASH.name(), (Object)this.waypointsHash);
        result.put((Object)JSON_FIELDS.NUMBEROFGPSFIXES.name(), (Object)this.numberOfGPSFixes);
        result.put((Object)JSON_FIELDS.GPSFIXES_HASH.name(), (Object)this.gpsFixesHash);
        result.put((Object)JSON_FIELDS.FIXED_AND_SUPPRESSED_MARK_PASSINGS_FROM_RACE_LOG_HASH.name(), (Object)this.fixedAndSuppressedMarkPassingsFromRaceLogHash);
        return result;
    }

    @Override
    public boolean matches(TrackedRace trackedRace) {
        Util.Pair<TimePoint, TimePoint> startAndFinishedTimeFromRaceLogs;
        boolean result = !Util.equalsWithNull((Object)this.calculatorVersion, (Object)2) ? false : (!Util.equalsWithNull((Object)this.startOfTracking, (Object)trackedRace.getStartOfTracking()) ? false : (!Util.equalsWithNull((Object)this.endOfTracking, (Object)trackedRace.getEndOfTracking()) ? false : (!Util.equalsWithNull((Object)this.startTimeReceived, (Object)trackedRace.getStartTimeReceived()) ? false : (!Util.equalsWithNull((Object)this.startTimeFromRaceLog, (Object)((startAndFinishedTimeFromRaceLogs = trackedRace.getStartAndFinishedTimeFromRaceLogs()) == null ? null : startAndFinishedTimeFromRaceLogs.getA())) ? false : (!Util.equalsWithNull((Object)this.finishTimeFromRaceLog, (Object)(startAndFinishedTimeFromRaceLogs == null ? null : startAndFinishedTimeFromRaceLogs.getB())) ? false : (this.waypointsHash != this.calculateHashForWaypoints(trackedRace) ? false : (this.competitorHash != this.calculateHashForCompetitors(trackedRace) ? false : (this.numberOfGPSFixes != this.calculateHashForNumberOfGPSFixes(trackedRace) ? false : (this.fixedAndSuppressedMarkPassingsFromRaceLogHash != this.calculateFixedAndSuppressedMarkPassingsFromRaceLogHash(trackedRace) ? false : this.gpsFixesHash == this.calculateHashForGPSFixes(trackedRace))))))))));
        return result;
    }

    private int calculateHashForCompetitors(TrackedRace trackedRace) {
        int hashForCompetitors = 1023;
        for (Competitor c : trackedRace.getRace().getCompetitors()) {
            hashForCompetitors ^= c.getId().hashCode();
        }
        return hashForCompetitors;
    }

    private int calculateHashForNumberOfGPSFixes(TrackedRace trackedRace) {
        int count = 0;
        for (Mark m : trackedRace.getMarks()) {
            count += trackedRace.getTrack(m).size();
        }
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            count += trackedRace.getTrack(competitor).size();
        }
        return count;
    }

    private int calculateHashForGPSFixes(TrackedRace trackedRace) {
        int res = 511;
        for (Mark m : trackedRace.getMarks()) {
            GPSFixTrack<Mark, GPSFix> markTrack = trackedRace.getTrack(m);
            markTrack.lockForRead();
            try {
                for (GPSFix gf : markTrack.getRawFixes()) {
                    res ^= gf.getTimePoint().hashCode();
                    res ^= gf.getPosition().hashCode();
                }
            }
            finally {
                markTrack.unlockAfterRead();
            }
        }
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            GPSFixTrack<Competitor, GPSFixMoving> competitorTrack = trackedRace.getTrack(competitor);
            competitorTrack.lockForRead();
            try {
                for (GPSFixMoving gfm : competitorTrack.getRawFixes()) {
                    res ^= gfm.getTimePoint().hashCode();
                    res ^= gfm.getPosition().hashCode();
                    res ^= gfm.getSpeed().getBearing().hashCode();
                    res ^= Double.hashCode(gfm.getSpeed().getKnots());
                }
            }
            finally {
                competitorTrack.unlockAfterRead();
            }
        }
        return res;
    }

    private int calculateHashForWaypoints(TrackedRace trackedRace) {
        Iterable waypoints = trackedRace.getRace().getCourse().getWaypoints();
        int res = 0;
        for (Waypoint p : waypoints) {
            Iterable marks = p.getMarks();
            for (Mark m : marks) {
                res ^= m.getId().hashCode();
            }
            res ^= p.getPassingInstructions().name().hashCode();
            res = (res << 5) - res;
        }
        return res;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.calculatorVersion;
        result = 31 * result + this.competitorHash;
        result = 31 * result + (this.endOfTracking == null ? 0 : this.endOfTracking.hashCode());
        result = 31 * result + (this.finishTimeFromRaceLog == null ? 0 : this.finishTimeFromRaceLog.hashCode());
        result = 31 * result + this.gpsFixesHash;
        result = 31 * result + this.numberOfGPSFixes;
        result = 31 * result + (this.startOfTracking == null ? 0 : this.startOfTracking.hashCode());
        result = 31 * result + (this.startTimeFromRaceLog == null ? 0 : this.startTimeFromRaceLog.hashCode());
        result = 31 * result + (this.startTimeReceived == null ? 0 : this.startTimeReceived.hashCode());
        result = 31 * result + this.waypointsHash;
        result = 31 * result + this.fixedAndSuppressedMarkPassingsFromRaceLogHash;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MarkPassingRaceFingerprintImpl other = (MarkPassingRaceFingerprintImpl)obj;
        if (this.calculatorVersion != other.calculatorVersion) {
            return false;
        }
        if (this.competitorHash != other.competitorHash) {
            return false;
        }
        if (this.endOfTracking == null ? other.endOfTracking != null : !this.endOfTracking.equals(other.endOfTracking)) {
            return false;
        }
        if (this.finishTimeFromRaceLog == null ? other.finishTimeFromRaceLog != null : !this.finishTimeFromRaceLog.equals(other.finishTimeFromRaceLog)) {
            return false;
        }
        if (this.gpsFixesHash != other.gpsFixesHash) {
            return false;
        }
        if (this.numberOfGPSFixes != other.numberOfGPSFixes) {
            return false;
        }
        if (this.startOfTracking == null ? other.startOfTracking != null : !this.startOfTracking.equals(other.startOfTracking)) {
            return false;
        }
        if (this.startTimeFromRaceLog == null ? other.startTimeFromRaceLog != null : !this.startTimeFromRaceLog.equals(other.startTimeFromRaceLog)) {
            return false;
        }
        if (this.startTimeReceived == null ? other.startTimeReceived != null : !this.startTimeReceived.equals(other.startTimeReceived)) {
            return false;
        }
        if (this.waypointsHash != other.waypointsHash) {
            return false;
        }
        return this.fixedAndSuppressedMarkPassingsFromRaceLogHash == other.fixedAndSuppressedMarkPassingsFromRaceLogHash;
    }

    private static enum JSON_FIELDS {
        COMPETITOR_HASH,
        START_OF_TRACKING_AS_MILLIS,
        END_OF_TRACKING_AS_MILLIS,
        START_TIME_RECEIVED_AS_MILLIS,
        START_TIME_FROM_RACE_LOG_AS_MILLIS,
        FINISH_TIME_FROM_RACE_LOG_AS_MILLIS,
        WAYPOINTS_HASH,
        NUMBEROFGPSFIXES,
        GPSFIXES_HASH,
        RACE_ID,
        CALCULATOR_VERSION,
        FIXED_AND_SUPPRESSED_MARK_PASSINGS_FROM_RACE_LOG_HASH;

    }
}

