/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.splining;

import com.sap.sailing.domain.common.Position;
import com.sap.sse.common.Bearing;
import java.util.ArrayList;
import java.util.List;

public class Vector2D {
    private List<Double> components;

    public Vector2D(double ... components) {
        this.components = new ArrayList<Double>(2);
        int i = 0;
        while (i < 2) {
            this.components.add(components[i]);
            ++i;
        }
    }

    public Vector2D(List<Double> components) {
        this.components = new ArrayList<Double>();
        int i = 0;
        while (i < 2) {
            this.components.add(components.get(i));
            ++i;
        }
    }

    public Vector2D(Position position) {
        this(position.getLngDeg(), position.getLatDeg());
    }

    public Vector2D(Bearing direction, double length) {
        this(Vector2D.calculateXFromBearing(direction, length), Vector2D.calculateYFromBearing(direction, length));
    }

    private static double calculateXFromBearing(Bearing bearing, double length) {
        double degrees = bearing.getDegrees();
        if (degrees == 0.0 || degrees == 180.0) {
            return 0.0;
        }
        if (degrees > 0.0 && degrees < 90.0) {
            return Math.sin(degrees % 90.0) * length;
        }
        if (degrees == 90.0) {
            return length;
        }
        if (degrees > 90.0 && degrees < 180.0) {
            return Math.cos(degrees % 90.0) * length;
        }
        if (degrees > 180.0 && degrees < 270.0) {
            return -Math.sin(degrees % 90.0) * length;
        }
        if (degrees == 270.0) {
            return -length;
        }
        if (degrees > 270.0 && degrees < 360.0) {
            return -Math.cos(degrees % 90.0) * length;
        }
        throw new IllegalArgumentException("The given Bearing was greater than 360 degrees.");
    }

    private static double calculateYFromBearing(Bearing bearing, double length) {
        double degrees = bearing.getDegrees();
        if (degrees == 90.0 || degrees == 270.0) {
            return 0.0;
        }
        if (degrees == 0.0) {
            return length;
        }
        if (degrees > 0.0 && degrees < 90.0) {
            return Math.cos(degrees % 90.0) * length;
        }
        if (degrees > 90.0 && degrees < 180.0) {
            return -Math.sin(degrees % 90.0) * length;
        }
        if (degrees > 180.0 && degrees < 270.0) {
            return -Math.cos(degrees % 90.0) * length;
        }
        if (degrees == 180.0) {
            return -length;
        }
        if (degrees > 270.0 && degrees < 360.0) {
            return Math.sin(degrees % 90.0) * length;
        }
        throw new IllegalArgumentException("The given Bearing was greater than 360 degrees.");
    }

    public Vector2D getPerpendicularVector() {
        return new Vector2D(-this.y(), this.y());
    }

    public Vector2D add(Vector2D v) {
        return new Vector2D(this.x() + v.x(), this.y() + v.y());
    }

    public Vector2D subtract(Vector2D v) {
        return new Vector2D(this.x() - v.x(), this.y() - v.y());
    }

    public Vector2D multiply(double scalar) {
        return new Vector2D(this.x() * scalar, this.y() * scalar);
    }

    public Vector2D divide(double scalar) {
        return this.multiply(1.0 / scalar);
    }

    public double dotProduct(Vector2D v) {
        return this.x() * v.x() + this.y() * v.y();
    }

    public double getLength() {
        return Math.sqrt(Math.pow(this.x(), 2.0) + Math.pow(this.y(), 2.0));
    }

    public double getDistanceToPoint(Vector2D p) {
        return p.subtract(this).getLength();
    }

    public double get(int i) {
        return this.components.get(i);
    }

    public double x() {
        return this.components.get(0);
    }

    public double y() {
        return this.components.get(1);
    }

    public void set(int i, double d) {
        this.components.set(i, d);
    }

    public String toString() {
        return "Vector2D: " + this.components.toString();
    }

    public Vector2D normalize() {
        return this.divide(this.getLength());
    }
}

