/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.splining;

import java.util.ArrayList;
import java.util.List;

public class DoubleMatrix {
    private List<List<Double>> matrix = new ArrayList<List<Double>>();

    public DoubleMatrix(int dimensionX, int dimensionY, double ... values) {
        if (values.length != dimensionX * dimensionY) {
            throw new IllegalArgumentException("Given dimensions of matrix does not match the number of given initial values.");
        }
        int y = 0;
        while (y < dimensionY) {
            this.matrix.add(new ArrayList());
            int x = 0;
            while (x < dimensionX) {
                this.matrix.get(y).add(values[y * dimensionX + x]);
                ++x;
            }
            ++y;
        }
    }

    public DoubleMatrix(int dimensionX, int dimensionY, List<Double> values) {
        if (values.size() != dimensionX * dimensionY) {
            throw new IllegalArgumentException("Given dimensions of matrix does not match the number of given initial values.");
        }
        int y = 0;
        while (y < dimensionY) {
            this.matrix.add(new ArrayList());
            int x = 0;
            while (x < dimensionX) {
                this.matrix.get(y).add(values.get(y * dimensionX + x));
                ++x;
            }
            ++y;
        }
    }

    public double get(int x, int y) {
        return this.matrix.get(y).get(x);
    }

    public int getRowCount() {
        return this.matrix.size();
    }

    public int getColumnCount() {
        return this.matrix.get(0).size();
    }

    public String toString() {
        String result = "DoubleMatrix: ";
        for (List<Double> row : this.matrix) {
            result = String.valueOf(result) + row.toString();
        }
        return result;
    }

    public List<Double> getColumn(int x) {
        if (x > this.matrix.get(0).size()) {
            throw new IllegalArgumentException("The matrix does not contain the given amount of columns");
        }
        ArrayList<Double> column = new ArrayList<Double>();
        for (List<Double> row : this.matrix) {
            column.add(row.get(x));
        }
        return column;
    }

    public List<Double> getRow(int y) {
        if (y > this.matrix.size()) {
            throw new IllegalArgumentException("The matrix does not contain the given amount of rows");
        }
        return this.matrix.get(y);
    }

    public DoubleMatrix multiply(DoubleMatrix matrix) {
        if (this.getColumnCount() != matrix.getRowCount()) {
            throw new IllegalArgumentException("Matrices can NOT be multiplied. Row count of the given matrix ( " + matrix.toString() + " ) does NOT equal column count of this matrix (" + this.toString() + ").");
        }
        ArrayList<Double> resultValues = new ArrayList<Double>();
        int row = 0;
        while (row < this.getRowCount()) {
            int col = 0;
            while (col < matrix.getColumnCount()) {
                double value = 0.0;
                int i = 0;
                while (i < this.getColumnCount()) {
                    value += this.get(i, row) * matrix.get(col, i);
                    ++i;
                }
                resultValues.add(value);
                ++col;
            }
            ++row;
        }
        return new DoubleMatrix(matrix.getColumnCount(), this.getRowCount(), resultValues);
    }

    public DoubleMatrix multiply(double scalar) {
        ArrayList<Double> resultValues = new ArrayList<Double>();
        int x = 0;
        while (x < this.getColumnCount()) {
            int y = 0;
            while (y < this.getRowCount()) {
                resultValues.add(this.get(x, y) * scalar);
                ++y;
            }
            ++x;
        }
        return new DoubleMatrix(this.getColumnCount(), this.getRowCount(), resultValues);
    }
}

