/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.markpassingcalculation.impl;

import com.sap.sailing.domain.base.CPUMeteringType;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.PassingInstruction;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.markpassingcalculation.Candidate;
import com.sap.sailing.domain.markpassingcalculation.CandidateFinder;
import com.sap.sailing.domain.markpassingcalculation.impl.DistanceCandidateImpl;
import com.sap.sailing.domain.markpassingcalculation.impl.Edge;
import com.sap.sailing.domain.markpassingcalculation.impl.TimeRangeWithNullStartMeaningEmpty;
import com.sap.sailing.domain.markpassingcalculation.impl.XTECandidateImpl;
import com.sap.sailing.domain.shared.tracking.impl.TimedComparator;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.impl.MarkPositionAtTimePointCacheImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.TimeRangeImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CandidateFinderImpl
implements CandidateFinder {
    private final int STRICTNESS_OF_DISTANCE_BASED_PROBABILITY = 10;
    private static final double PENALTY_FOR_WRONG_SIDE = 0.8;
    private static final double PENALTY_FOR_WRONG_DIRECTION = 0.7;
    private static final double PENALTY_FOR_LINE_PASSED_IN_WRONG_DIRECTION = 0.3;
    private static final double PENALTY_FOR_DISTANCE_CANDIDATES = 0.63;
    private static final double WORST_PENALTY_FOR_OTHER_COMPETITORS_BEING_FAR_FROM_START = 0.1;
    private static final double NUMBER_OF_HULL_LENGTHS_DISTANCE_FROM_START_AT_WHICH_WORST_PENALTY_APPLIES = 10.0;
    private static final Duration EARLIEST_START_MARK_PASSING_THIS_MUCH_BEFORE_START = Duration.ONE_MINUTE;
    private static final Duration LATEST_FINISH_MARK_PASSING_THIS_MUCH_AFTER_RACE_FINISHED = Duration.ONE_MINUTE.times(5L);
    private static final Logger logger = Logger.getLogger(CandidateFinderImpl.class.getName());
    private Map<Competitor, LinkedHashMap<GPSFix, Map<Waypoint, List<Distance>>>> distanceCache = new LinkedHashMap<Competitor, LinkedHashMap<GPSFix, Map<Waypoint, List<Distance>>>>();
    private Map<Competitor, LinkedHashMap<GPSFix, Map<Waypoint, List<Distance>>>> xteCache = new LinkedHashMap<Competitor, LinkedHashMap<GPSFix, Map<Waypoint, List<Distance>>>>();
    private Map<Competitor, Map<Waypoint, Map<List<GPSFix>, Candidate>>> xteCandidates = new HashMap<Competitor, Map<Waypoint, Map<List<GPSFix>, Candidate>>>();
    private Map<Competitor, Map<Waypoint, Map<GPSFix, Candidate>>> distanceCandidates = new HashMap<Competitor, Map<Waypoint, Map<GPSFix, Candidate>>>();
    private final DynamicTrackedRace race;
    private TimeRangeWithNullStartMeaningEmpty timeRangeForValidCandidates;
    private final double penaltyForSkipping = Edge.getPenaltyForSkipping();
    private final Map<Waypoint, PassingInstruction> passingInstructions = new LinkedHashMap<Waypoint, PassingInstruction>();
    private final Comparator<Timed> comp = TimedComparator.INSTANCE;
    private final ExecutorService executor;

    public CandidateFinderImpl(DynamicTrackedRace race) {
        this(race, ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor());
    }

    public CandidateFinderImpl(DynamicTrackedRace race, ExecutorService executor) {
        this.race = race;
        this.executor = executor;
        this.timeRangeForValidCandidates = this.getTimeRangeOrNull(this.getTimePointWhenToStartConsideringCandidates(race.getStartOfRace(false)), this.getTimePointWhenToFinishConsideringCandidates(race.getFinishedTime()));
        RaceDefinition raceDefinition = race.getRace();
        for (Competitor c : raceDefinition.getCompetitors()) {
            this.xteCache.put(c, new LimitedLinkedHashMap(25));
            this.distanceCache.put(c, new LimitedLinkedHashMap(25));
            this.xteCandidates.put(c, new HashMap());
            this.distanceCandidates.put(c, new HashMap());
        }
    }

    private TimePoint getTimePointWhenToStartConsideringCandidates(TimePoint startOfRace) {
        return startOfRace == null ? null : startOfRace.minus(EARLIEST_START_MARK_PASSING_THIS_MUCH_BEFORE_START);
    }

    private TimePoint getTimePointWhenToFinishConsideringCandidates(TimePoint finishedTime) {
        return finishedTime == null ? null : finishedTime.plus(LATEST_FINISH_MARK_PASSING_THIS_MUCH_AFTER_RACE_FINISHED);
    }

    private Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> clearAllCandidates() {
        return this.updateCandiatesAfterRaceTimeRangeChanged(TimePoint.EndOfTime, TimePoint.BeginningOfTime);
    }

    private Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> updateCandiatesAfterRaceTimeRangeChanged(TimePoint startOfRangeToAdd, TimePoint endOfRangeToAdd) {
        HashMap<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> result = new HashMap<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>>();
        if (startOfRangeToAdd.after(endOfRangeToAdd)) {
            TimeRangeImpl timeRangeToRemoveCandidatesFrom = new TimeRangeImpl(endOfRangeToAdd, startOfRangeToAdd);
            HashMap<Competitor, Set<Candidate>> candidatesToRemovePerCompetitor = new HashMap<Competitor, Set<Candidate>>();
            this.removeCandidatesInTimeRange((TimeRange)timeRangeToRemoveCandidatesFrom, candidatesToRemovePerCompetitor, this.distanceCandidates);
            this.removeCandidatesInTimeRange((TimeRange)timeRangeToRemoveCandidatesFrom, candidatesToRemovePerCompetitor, this.xteCandidates);
            for (Map.Entry e : candidatesToRemovePerCompetitor.entrySet()) {
                result.put((Competitor)e.getKey(), (Util.Pair<Iterable<Candidate>, Iterable<Candidate>>)new Util.Pair(Collections.emptySet(), (Object)((Iterable)e.getValue())));
            }
        } else {
            for (Competitor competitor : this.race.getRace().getCompetitors()) {
                ArrayList<GPSFixMoving> newFixesForCompetitor = new ArrayList<GPSFixMoving>();
                GPSFixTrack track = this.race.getTrack(competitor);
                if (track != null) {
                    track.lockForRead();
                    try {
                        Iterator i = track.getFixesIterator(startOfRangeToAdd, true);
                        while (i.hasNext()) {
                            GPSFixMoving fix = (GPSFixMoving)i.next();
                            if (fix.getTimePoint().after(endOfRangeToAdd)) {
                                break;
                            }
                            newFixesForCompetitor.add(fix);
                        }
                    }
                    finally {
                        track.unlockAfterRead();
                    }
                }
                Util.Pair<Iterable<Candidate>, Iterable<Candidate>> newAndRemovedCandidatesForCompetitor = this.getCandidateDeltas(competitor, newFixesForCompetitor);
                result.put(competitor, newAndRemovedCandidatesForCompetitor);
            }
        }
        return result;
    }

    private <K> void removeCandidatesInTimeRange(TimeRange timeRangeToRemoveCandidatesFrom, Map<Competitor, Set<Candidate>> candidatesRemovedPerCompetitor, Map<Competitor, Map<Waypoint, Map<K, Candidate>>> candidatePerWaypointPerCompetitor) {
        for (Map.Entry<Competitor, Map<Waypoint, Map<K, Candidate>>> e : candidatePerWaypointPerCompetitor.entrySet()) {
            Set<Candidate> candidatesRemoved = candidatesRemovedPerCompetitor.get(e.getKey());
            if (candidatesRemoved == null) {
                candidatesRemoved = new HashSet<Candidate>();
                candidatesRemovedPerCompetitor.put(e.getKey(), candidatesRemoved);
            }
            for (Map<K, Candidate> m : e.getValue().values()) {
                Iterator<Candidate> candidateIter = m.values().iterator();
                while (candidateIter.hasNext()) {
                    Candidate candidate = candidateIter.next();
                    if (!timeRangeToRemoveCandidatesFrom.includes(candidate.getTimePoint())) continue;
                    candidateIter.remove();
                    candidatesRemoved.add(candidate);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Util.Pair<Iterable<Candidate>, Iterable<Candidate>> getAllCandidates(Competitor c) {
        Set<GPSFixMoving> fixes = this.getAllFixes(c);
        this.distanceCache.get(c).clear();
        this.xteCache.get(c).clear();
        Map<Competitor, Map<Waypoint, Map<List<GPSFix>, Candidate>>> map = this.xteCandidates;
        synchronized (map) {
            this.xteCandidates.get(c).clear();
        }
        map = this.distanceCandidates;
        synchronized (map) {
            this.distanceCandidates.get(c).clear();
        }
        return this.getCandidateDeltas(c, fixes);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Map<Competitor, List<GPSFixMoving>> calculateFixesAffectedByNewMarkFixes(Map<Mark, List<GPSFix>> markFixes) {
        affectedFixes = new HashMap<Competitor, List<GPSFixMoving>>();
        start = null;
        end = null;
        for (Map.Entry<Mark, List<GPSFix>> fixes : markFixes.entrySet()) {
            for (GPSFix fix : fixes.getValue()) {
                timePoints = this.race.getOrCreateTrack(fixes.getKey()).getEstimatedPositionTimePeriodAffectedBy(fix);
                newStart = timePoints.from();
                newEnd = timePoints.to();
                start = start == null || start.after(newStart) != false ? newStart : start;
                v0 = end = end == null || end.before(newEnd) != false ? newEnd : end;
            }
        }
        for (Competitor c : this.race.getRace().getCompetitors()) {
            block5: {
                competitorFixes = new ArrayList<GPSFixMoving>();
                track = this.race.getTrack(c);
                comFix = (GPSFixMoving)track.getFirstFixAtOrAfter(start);
                if (comFix == null) break block5;
                if (end == null) ** GOTO lbl36
                while (comFix != null && !comFix.getTimePoint().after(end)) {
                    competitorFixes.add(comFix);
                    this.distanceCache.get(c).remove(comFix);
                    this.xteCache.get(c).remove(comFix);
                    comFix = (GPSFixMoving)track.getFirstFixAfter(comFix.getTimePoint());
                }
                break block5;
lbl-1000:
                // 1 sources

                {
                    competitorFixes.add(comFix);
                    this.distanceCache.get(c).remove(comFix);
                    this.xteCache.get(c).remove(comFix);
                    comFix = (GPSFixMoving)track.getFirstFixAfter(comFix.getTimePoint());
lbl36:
                    // 2 sources

                    ** while (comFix != null)
                }
            }
            if (competitorFixes.isEmpty()) continue;
            affectedFixes.put(c, competitorFixes);
        }
        return affectedFixes;
    }

    @Override
    public Util.Pair<Iterable<Candidate>, Iterable<Candidate>> getCandidateDeltas(Competitor c, Iterable<GPSFixMoving> fixes) {
        ArrayList newCans = new ArrayList();
        ArrayList wrongCans = new ArrayList();
        Course course = this.race.getRace().getCourse();
        course.lockForRead();
        try {
            Util.Pair<List<Candidate>, List<Candidate>> distanceCandidates = this.checkForDistanceCandidateChanges(c, fixes, this.race.getRace().getCourse().getWaypoints());
            Util.Pair<List<Candidate>, List<Candidate>> xteCandidates = this.checkForXTECandidatesChanges(c, fixes, this.race.getRace().getCourse().getWaypoints());
            logger.finest(String.valueOf(((List)distanceCandidates.getA()).size()) + " new Distance Candidates, " + ((List)xteCandidates.getA()).size() + " new XTE Candidates, " + ((List)distanceCandidates.getB()).size() + " removed distance Candidates and " + ((List)xteCandidates.getB()).size() + " removed XTE Candidates.");
            newCans.addAll((Collection)xteCandidates.getA());
            newCans.addAll((Collection)distanceCandidates.getA());
            wrongCans.addAll((Collection)xteCandidates.getB());
            wrongCans.addAll((Collection)distanceCandidates.getB());
        }
        finally {
            course.unlockAfterRead();
        }
        return new Util.Pair(newCans, wrongCans);
    }

    private Map<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> invalidateAfterCourseChange(int zeroBasedIndexOfWaypointChanged) {
        ConcurrentHashMap<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> result = new ConcurrentHashMap<Competitor, Util.Pair<List<Candidate>, List<Candidate>>>();
        Course course = this.race.getRace().getCourse();
        for (Competitor c : this.race.getRace().getCompetitors()) {
            this.distanceCache.get(c).clear();
            this.xteCache.get(c).clear();
        }
        ArrayList<Waypoint> changedWaypoints = new ArrayList<Waypoint>();
        course.lockForRead();
        try {
            for (Waypoint w : course.getWaypoints()) {
                if (course.getIndexOfWaypoint(w) <= zeroBasedIndexOfWaypointChanged - 2) continue;
                changedWaypoints.add(w);
            }
            logger.finer(() -> "Changed waypoints: " + changedWaypoints);
            HashSet<Callable> tasks = new HashSet<Callable>();
            Thread executingThread = Thread.currentThread();
            for (Competitor c : this.race.getRace().getCompetitors()) {
                tasks.add(this.race.getTrackedRegatta().cpuMeterCallable(() -> {
                    LockUtil.propagateLockSetFrom((Thread)executingThread);
                    try {
                        ArrayList<Candidate> badCans = new ArrayList<Candidate>();
                        ArrayList newCans = new ArrayList();
                        for (Waypoint w : changedWaypoints) {
                            Map<List<GPSFix>, Candidate> xteCans = this.getXteCandidates(c, w);
                            badCans.addAll(xteCans.values());
                            xteCans.clear();
                            Map<GPSFix, Candidate> distanceCans = this.getDistanceCandidates(c, w);
                            badCans.addAll(distanceCans.values());
                            distanceCans.clear();
                        }
                        Set<GPSFixMoving> allFixes = this.getAllFixes(c);
                        newCans.addAll((Collection)this.checkForDistanceCandidateChanges(c, allFixes, changedWaypoints).getA());
                        newCans.addAll((Collection)this.checkForXTECandidatesChanges(c, allFixes, changedWaypoints).getA());
                        result.put(c, new Util.Pair(newCans, badCans));
                        return null;
                    }
                    finally {
                        LockUtil.unpropagateLockSetFrom((Thread)executingThread);
                    }
                }, CPUMeteringType.MARK_PASSINGS.name()));
            }
            ThreadPoolUtil.INSTANCE.invokeAllAndLogExceptions(this.executor, Level.SEVERE, "Problem trying to update competitor candidate sets after waypoints starting at zero-based index " + zeroBasedIndexOfWaypointChanged + " have changed: %s", tasks);
        }
        finally {
            course.unlockAfterRead();
        }
        return result;
    }

    @Override
    public Map<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> updateWaypoints(Iterable<Waypoint> addedWaypoints, Iterable<Waypoint> removedWaypoints, int smallestIndex) {
        Map<Competitor, List<Candidate>> removedWaypointCandidates = this.removeWaypoints(removedWaypoints);
        Map<Competitor, Util.Pair<List<Candidate>, List<Candidate>>> newAndUpdatedCandidates = this.invalidateAfterCourseChange(smallestIndex);
        for (Map.Entry<Competitor, List<Candidate>> entry : removedWaypointCandidates.entrySet()) {
            Util.Pair<List<Candidate>, List<Candidate>> candidatesForCompetitor = newAndUpdatedCandidates.get(entry.getKey());
            if (candidatesForCompetitor == null) continue;
            ((List)candidatesForCompetitor.getB()).addAll((Collection)entry.getValue());
        }
        return newAndUpdatedCandidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Competitor, List<Candidate>> removeWaypoints(Iterable<Waypoint> waypoints) {
        HashMap<Competitor, List<Candidate>> result = new HashMap<Competitor, List<Candidate>>();
        for (Competitor c : this.race.getRace().getCompetitors()) {
            result.put(c, new ArrayList());
        }
        for (Waypoint w : waypoints) {
            this.passingInstructions.remove(w);
            for (Map.Entry entry : result.entrySet()) {
                Competitor c = (Competitor)entry.getKey();
                List badCans = (List)entry.getValue();
                badCans.addAll(this.getXteCandidates(c, w).values());
                Map<Competitor, Map<Waypoint, Map<List<GPSFix>, Candidate>>> map = this.xteCandidates;
                synchronized (map) {
                    this.xteCandidates.get(c).remove(w);
                }
                badCans.addAll(this.getDistanceCandidates(c, w).values());
                map = this.distanceCandidates;
                synchronized (map) {
                    this.distanceCandidates.get(c).remove(w);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<GPSFix, Candidate> getDistanceCandidates(Competitor c, Waypoint w) {
        Map<Competitor, Map<Waypoint, Map<GPSFix, Candidate>>> map = this.distanceCandidates;
        synchronized (map) {
            Map<GPSFix, Candidate> result = this.distanceCandidates.get(c).get(w);
            if (result == null) {
                result = new HashMap<GPSFix, Candidate>();
                this.distanceCandidates.get(c).put(w, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<List<GPSFix>, Candidate> getXteCandidates(Competitor c, Waypoint w) {
        Map<Competitor, Map<Waypoint, Map<List<GPSFix>, Candidate>>> map = this.xteCandidates;
        synchronized (map) {
            Map<List<GPSFix>, Candidate> result = this.xteCandidates.get(c).get(w);
            if (result == null) {
                result = new HashMap<List<GPSFix>, Candidate>();
                this.xteCandidates.get(c).put(w, result);
            }
            return result;
        }
    }

    private PassingInstruction determinePassingInstructions(Waypoint w) {
        Waypoint firstWaypoint = this.race.getRace().getCourse().getFirstWaypoint();
        Waypoint lastWaypoint = this.race.getRace().getCourse().getLastWaypoint();
        PassingInstruction instruction = w.getPassingInstructions();
        if ((w.equals(firstWaypoint) || w.equals(lastWaypoint)) && instruction == PassingInstruction.Gate) {
            instruction = PassingInstruction.Line;
        }
        if (instruction == PassingInstruction.None || instruction == null) {
            int numberOfMarks = Util.size((Iterable)w.getMarks());
            instruction = numberOfMarks == 2 ? (w.equals(firstWaypoint) || w.equals(lastWaypoint) ? PassingInstruction.Line : PassingInstruction.Gate) : (numberOfMarks == 1 ? PassingInstruction.Single_Unknown : PassingInstruction.None);
        }
        return instruction;
    }

    private Set<GPSFixMoving> getAllFixes(Competitor c) {
        TreeSet<Timed> fixes = new TreeSet<Timed>(this.comp);
        if (this.timeRangeForValidCandidates.getTimeRangeOrNull() != null) {
            GPSFixTrack track = this.race.getTrack(c);
            track.lockForRead();
            try {
                for (GPSFixMoving fix : track.getFixes(this.timeRangeForValidCandidates.getTimeRangeOrNull().from(), true, this.timeRangeForValidCandidates.getTimeRangeOrNull().to(), true)) {
                    fixes.add((Timed)fix);
                }
            }
            finally {
                track.unlockAfterRead();
            }
        }
        return fixes;
    }

    private Util.Pair<List<Candidate>, List<Candidate>> checkForDistanceCandidateChanges(Competitor c, Iterable<GPSFixMoving> fixes, Iterable<Waypoint> waypoints) {
        TimePoint t;
        Util.Pair result = new Util.Pair(new ArrayList(), new ArrayList());
        TreeSet<Timed> affectedFixes = new TreeSet<Timed>(this.comp);
        GPSFixTrack track = this.race.getTrack(c);
        GPSFixMoving lastIterationFix = null;
        GPSFixMoving lastIterationAfterFix = null;
        Iterator firstFixAfterIterator = null;
        for (GPSFixMoving gPSFixMoving : fixes) {
            GPSFixMoving fixAfter;
            GPSFixMoving fixBefore;
            block28: {
                if (this.timeRangeForValidCandidates.getTimeRangeOrNull() == null || !this.timeRangeForValidCandidates.getTimeRangeOrNull().includes(gPSFixMoving.getTimePoint())) continue;
                affectedFixes.add((Timed)gPSFixMoving);
                fixBefore = null;
                fixAfter = null;
                track.lockForRead();
                try {
                    boolean fixIsValid = track.isValid(gPSFixMoving);
                    if (!fixIsValid) break block28;
                    t = gPSFixMoving.getTimePoint();
                    if (gPSFixMoving == lastIterationAfterFix) {
                        fixBefore = lastIterationFix;
                    } else {
                        fixBefore = (GPSFixMoving)track.getLastFixBefore(t);
                        firstFixAfterIterator = track.getFixesIterator(t, false);
                    }
                    try {
                        fixAfter = (GPSFixMoving)Util.nextOrNull((Iterator)firstFixAfterIterator);
                    }
                    catch (ConcurrentModificationException e) {
                        firstFixAfterIterator = track.getFixesIterator(t, false);
                        fixAfter = (GPSFixMoving)Util.nextOrNull((Iterator)firstFixAfterIterator);
                    }
                    lastIterationFix = gPSFixMoving;
                    lastIterationAfterFix = fixAfter;
                }
                finally {
                    track.unlockAfterRead();
                }
            }
            if (fixBefore != null) {
                affectedFixes.add((Timed)fixBefore);
            }
            if (fixAfter == null) continue;
            affectedFixes.add((Timed)fixAfter);
        }
        lastIterationFix = null;
        lastIterationAfterFix = null;
        firstFixAfterIterator = null;
        for (GPSFixMoving gPSFixMoving : affectedFixes) {
            GPSFixMoving fixAfter;
            GPSFixMoving fixBefore;
            Position p = null;
            try {
                track.lockForRead();
                TimePoint timePoint = gPSFixMoving.getTimePoint();
                if (gPSFixMoving == lastIterationAfterFix) {
                    fixBefore = lastIterationFix;
                } else {
                    fixBefore = (GPSFixMoving)track.getLastFixBefore(timePoint);
                    firstFixAfterIterator = track.getFixesIterator(timePoint, false);
                }
                try {
                    fixAfter = (GPSFixMoving)Util.nextOrNull(firstFixAfterIterator);
                }
                catch (ConcurrentModificationException e) {
                    firstFixAfterIterator = track.getFixesIterator(timePoint, false);
                    fixAfter = (GPSFixMoving)Util.nextOrNull((Iterator)firstFixAfterIterator);
                }
                lastIterationFix = gPSFixMoving;
                lastIterationAfterFix = fixAfter;
            }
            finally {
                track.unlockAfterRead();
            }
            if (fixBefore == null || fixAfter == null) continue;
            t = null;
            Map<Waypoint, List<Distance>> fixDistances = this.getDistances(c, (GPSFix)gPSFixMoving);
            Map<Waypoint, List<Distance>> fixDistancesBefore = this.getDistances(c, (GPSFix)fixBefore);
            Map<Waypoint, List<Distance>> fixDistancesAfter = this.getDistances(c, (GPSFix)fixAfter);
            for (Waypoint w : waypoints) {
                DistanceCandidateImpl newCan;
                Boolean wasCan = false;
                Boolean isCan = false;
                Candidate oldCan = null;
                Double probability = null;
                Distance distance = null;
                Double startProbabilityBasedOnOtherCompetitors = null;
                double onCorrectSideOfWaypoint = 0.8;
                List<Distance> waypointDistances = fixDistances.get(w);
                List<Distance> waypointDistancesBefore = fixDistancesBefore.get(w);
                List<Distance> waypointDistancesAfter = fixDistancesAfter.get(w);
                if (waypointDistances == null || waypointDistancesBefore == null || waypointDistancesAfter == null) continue;
                Iterator<Distance> disIter = waypointDistances.iterator();
                Iterator<Distance> disBeforeIter = waypointDistancesBefore.iterator();
                Iterator<Distance> disAfterIter = waypointDistancesAfter.iterator();
                boolean portMark = true;
                while (disIter.hasNext() && disBeforeIter.hasNext() && disAfterIter.hasNext()) {
                    Distance dis = disIter.next();
                    Distance disBefore = disBeforeIter.next();
                    Distance disAfter = disAfterIter.next();
                    if (dis != null && disBefore != null && disAfter != null && Math.abs(dis.getMeters()) < Math.abs(disBefore.getMeters()) && Math.abs(dis.getMeters()) < Math.abs(disAfter.getMeters())) {
                        t = gPSFixMoving.getTimePoint();
                        MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this.race, t);
                        p = gPSFixMoving.getPosition();
                        Double newProbability = this.getDistanceBasedProbability(w, t, dis, markPositionCache, this.race.getBoatOfCompetitor(c).getBoatClass().getHullLength());
                        if (newProbability != null) {
                            Double newStartProbabilityBasedOnOtherCompetitors;
                            double newOnCorrectSideOfWaypointPenalty = this.getSidePenalty(w, p, t, portMark, markPositionCache);
                            newProbability = newProbability * (newOnCorrectSideOfWaypointPenalty * 0.63);
                            if (this.isStartWaypoint(w)) {
                                newStartProbabilityBasedOnOtherCompetitors = this.getProbabilityForStartCandidateBasedOnOtherCompetitorsBehavior(c, t, markPositionCache);
                                if (newStartProbabilityBasedOnOtherCompetitors != null) {
                                    newProbability = newProbability * newStartProbabilityBasedOnOtherCompetitors;
                                }
                            } else {
                                newStartProbabilityBasedOnOtherCompetitors = null;
                            }
                            if (newProbability > this.penaltyForSkipping && (probability == null || newProbability > probability)) {
                                isCan = true;
                                probability = newProbability;
                                onCorrectSideOfWaypoint = newOnCorrectSideOfWaypointPenalty;
                                distance = dis;
                                startProbabilityBasedOnOtherCompetitors = newStartProbabilityBasedOnOtherCompetitors;
                            }
                        }
                    }
                    portMark = false;
                }
                oldCan = this.getDistanceCandidates(c, w).get(gPSFixMoving);
                if (oldCan != null) {
                    wasCan = true;
                }
                if (!wasCan.booleanValue() && isCan.booleanValue()) {
                    newCan = new DistanceCandidateImpl(this.race.getRace().getCourse().getIndexOfWaypoint(w) + 1, t, probability, startProbabilityBasedOnOtherCompetitors, w, onCorrectSideOfWaypoint, distance);
                    this.getDistanceCandidates(c, w).put((GPSFix)gPSFixMoving, newCan);
                    ((List)result.getA()).add(newCan);
                    logger.finest("Added distance candidate " + ((Object)newCan).toString() + " for " + c);
                    continue;
                }
                if (wasCan.booleanValue() && !isCan.booleanValue()) {
                    this.getDistanceCandidates(c, w).remove(gPSFixMoving);
                    ((List)result.getB()).add(oldCan);
                    continue;
                }
                if (!wasCan.booleanValue() || !isCan.booleanValue() || oldCan.getProbability() == probability) continue;
                newCan = new DistanceCandidateImpl(this.race.getRace().getCourse().getIndexOfWaypoint(w) + 1, t, probability, startProbabilityBasedOnOtherCompetitors, w, onCorrectSideOfWaypoint, distance);
                this.getDistanceCandidates(c, w).put((GPSFix)gPSFixMoving, newCan);
                ((List)result.getA()).add(newCan);
                logger.finest("Added distance candidate " + ((Object)newCan).toString() + " for " + c);
                ((List)result.getB()).add(oldCan);
            }
        }
        return result;
    }

    private Map<Waypoint, List<Distance>> getDistances(Competitor c, GPSFix fix) {
        Map<Waypoint, List<Distance>> result = this.distanceCache.get(c).get(fix);
        MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this.race, fix.getTimePoint());
        if (result == null) {
            result = new LinkedHashMap<Waypoint, List<Distance>>();
            Course course = this.race.getRace().getCourse();
            course.lockForRead();
            try {
                for (Waypoint w : course.getWaypoints()) {
                    List<Distance> distances = this.calculateDistance(fix.getPosition(), w, fix.getTimePoint(), markPositionCache);
                    result.put(w, distances);
                }
            }
            finally {
                course.unlockAfterRead();
            }
            this.distanceCache.get(c).put(fix, result);
        }
        return result;
    }

    private Util.Pair<List<Candidate>, List<Candidate>> checkForXTECandidatesChanges(Competitor c, Iterable<GPSFixMoving> fixes, Iterable<Waypoint> waypoints) {
        Util.Pair result = new Util.Pair(new ArrayList(), new ArrayList());
        GPSFixTrack track = this.race.getTrack(c);
        GPSFixMoving lastIterationFix = null;
        GPSFixMoving lastIterationAfterFix = null;
        Iterator firstFixAfterIterator = null;
        for (GPSFixMoving fix : fixes) {
            boolean fixIsValid;
            GPSFixMoving fixAfter;
            GPSFixMoving fixBefore;
            TimePoint t;
            block28: {
                if (this.timeRangeForValidCandidates.getTimeRangeOrNull() == null || !this.timeRangeForValidCandidates.getTimeRangeOrNull().includes(fix.getTimePoint())) continue;
                t = fix.getTimePoint();
                fixBefore = null;
                fixAfter = null;
                track.lockForRead();
                try {
                    fixIsValid = track.isValid(fix);
                    if (!fixIsValid) break block28;
                    if (fix == lastIterationAfterFix) {
                        fixBefore = lastIterationFix;
                    } else {
                        fixBefore = (GPSFixMoving)track.getLastFixBefore(t);
                        firstFixAfterIterator = track.getFixesIterator(t, false);
                    }
                    try {
                        fixAfter = (GPSFixMoving)Util.nextOrNull(firstFixAfterIterator);
                    }
                    catch (ConcurrentModificationException e) {
                        firstFixAfterIterator = track.getFixesIterator(t, false);
                        fixAfter = (GPSFixMoving)Util.nextOrNull((Iterator)firstFixAfterIterator);
                    }
                    lastIterationFix = fix;
                    lastIterationAfterFix = fixAfter;
                }
                finally {
                    track.unlockAfterRead();
                }
            }
            if (!fixIsValid) continue;
            Map<Waypoint, List<Distance>> xtesBefore = null;
            Map<Waypoint, List<Distance>> xtesAfter = null;
            TimePoint tBefore = null;
            TimePoint tAfter = null;
            if (fixBefore != null) {
                xtesBefore = this.getXTE(c, (GPSFix)fixBefore);
                tBefore = fixBefore.getTimePoint();
            }
            if (fixAfter != null) {
                xtesAfter = this.getXTE(c, (GPSFix)fixAfter);
                tAfter = fixAfter.getTimePoint();
            }
            Map<Waypoint, List<Distance>> xtes = this.getXTE(c, (GPSFix)fix);
            for (Waypoint w : waypoints) {
                Double xteBefore;
                Double xteAfter;
                int size;
                ArrayList<List<GPSFix>> oldCandidates = new ArrayList<List<GPSFix>>();
                HashMap<List<GPSFix>, Candidate> newCandidates = new HashMap<List<GPSFix>, Candidate>();
                Map<List<GPSFix>, Candidate> waypointCandidates = this.getXteCandidates(c, w);
                for (List<GPSFix> fixPair : waypointCandidates.keySet()) {
                    if (!fixPair.contains(fix)) continue;
                    oldCandidates.add(fixPair);
                }
                List<Distance> wayPointXTEs = xtes.get(w);
                int n = size = wayPointXTEs == null ? 0 : wayPointXTEs.size();
                if (size > 0) {
                    Double d = wayPointXTEs.get(0).getMeters();
                    if (d == 0.0) {
                        newCandidates.put(Arrays.asList(fix, fix), this.createCandidate(c, 0.0, 0.0, t, t, w, true));
                    } else {
                        if (fixAfter != null && xtesAfter != null && xtesAfter.get(w) != null && !xtesAfter.get(w).isEmpty() && (xteAfter = Double.valueOf(xtesAfter.get(w).get(0).getMeters())) != null && d < 0.0 != xteAfter <= 0.0) {
                            newCandidates.put(Arrays.asList(fix, fixAfter), this.createCandidate(c, d, xteAfter, t, tAfter, w, true));
                        }
                        if (fixBefore != null && xtesBefore.get(w) != null && !xtesBefore.get(w).isEmpty()) {
                            xteBefore = xtesBefore.get(w).get(0).getMeters();
                            if (d < 0.0 != xteBefore <= 0.0) {
                                newCandidates.put(Arrays.asList(fixBefore, fix), this.createCandidate(c, xteBefore, d, tBefore, t, w, true));
                            }
                        }
                    }
                }
                if (size > 1) {
                    Double d = wayPointXTEs.get(1).getMeters();
                    if (d == 0.0) {
                        newCandidates.put(Arrays.asList(fix, fix), this.createCandidate(c, 0.0, 0.0, t, t, w, false));
                    } else {
                        if (fixAfter != null && xtesAfter != null && xtesAfter.get(w).size() >= 2) {
                            xteAfter = xtesAfter.get(w).get(1).getMeters();
                            if (d < 0.0 != xteAfter <= 0.0) {
                                newCandidates.put(Arrays.asList(fix, fixAfter), this.createCandidate(c, d, xteAfter, t, tAfter, w, Util.size((Iterable)w.getMarks()) < 2));
                            }
                        }
                        if (fixBefore != null && xtesBefore.get(w).size() >= 2) {
                            xteBefore = xtesBefore.get(w).get(1).getMeters();
                            if (d < 0.0 != xteBefore <= 0.0) {
                                newCandidates.put(Arrays.asList(fixBefore, fix), this.createCandidate(c, xteBefore, d, tBefore, t, w, Util.size((Iterable)w.getMarks()) < 2));
                            }
                        }
                    }
                }
                for (Map.Entry entry : newCandidates.entrySet()) {
                    Candidate newCan = (Candidate)entry.getValue();
                    List canFixes = (List)entry.getKey();
                    if (oldCandidates.contains(canFixes)) {
                        oldCandidates.remove(canFixes);
                        Candidate oldCan = waypointCandidates.get(canFixes);
                        if (newCan.compareTo(oldCan) == 0) continue;
                        ((List)result.getB()).add(oldCan);
                        waypointCandidates.remove(canFixes);
                        if (!(newCan.getProbability() > this.penaltyForSkipping)) continue;
                        ((List)result.getA()).add(newCan);
                        logger.finest("Added XTE " + newCan.toString() + " for " + c);
                        waypointCandidates.put(canFixes, newCan);
                        continue;
                    }
                    if (!(newCan.getProbability() > this.penaltyForSkipping)) continue;
                    ((List)result.getA()).add(newCan);
                    logger.finest("Added XTE " + newCan.toString() + " for " + c);
                    waypointCandidates.put(canFixes, newCan);
                }
                for (List list : oldCandidates) {
                    ((List)result.getB()).add(waypointCandidates.get(list));
                    waypointCandidates.remove(list);
                }
            }
        }
        return result;
    }

    private Map<Waypoint, List<Distance>> getXTE(Competitor c, GPSFix fix) {
        Map<Waypoint, List<Distance>> result = this.xteCache.get(c).get(fix);
        Course course = this.race.getRace().getCourse();
        course.lockForRead();
        try {
            if (result == null) {
                result = new HashMap<Waypoint, List<Distance>>();
                this.xteCache.get(c).put(fix, result);
            }
            Position p = fix.getPosition();
            TimePoint t = fix.getTimePoint();
            MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this.race, t);
            for (Waypoint w : course.getWaypoints()) {
                if (result.containsKey(w)) continue;
                ArrayList<Distance> distances = new ArrayList<Distance>();
                result.put(w, distances);
                for (Util.Pair<Position, Bearing> crossingInfo : this.getCrossingInformation(w, t, markPositionCache)) {
                    if (crossingInfo.getA() == null || crossingInfo.getB() == null) continue;
                    distances.add(p.crossTrackError((Position)crossingInfo.getA(), (Bearing)crossingInfo.getB()));
                }
            }
        }
        finally {
            course.unlockAfterRead();
        }
        return result;
    }

    private Candidate createCandidate(Competitor c, double xte1, double xte2, TimePoint t1, TimePoint t2, Waypoint w, Boolean portMark) {
        Double startProbabilityBasedOnOtherCompetitors;
        long differenceInMillis = t2.asMillis() - t1.asMillis();
        double ratio = Math.abs(xte1) / (Math.abs(xte1) + Math.abs(xte2));
        TimePoint t = t1.plus((long)((double)differenceInMillis * ratio));
        Position p = this.race.getTrack(c).getEstimatedPosition(t, false);
        List<Distance> distances = this.calculateDistance(p, w, t, new MarkPositionAtTimePointCacheImpl(this.race, t));
        Distance d = portMark != false ? distances.get(0) : distances.get(1);
        MarkPositionAtTimePointCacheImpl markPositionCache = new MarkPositionAtTimePointCacheImpl(this.race, t);
        double sidePenalty = this.getSidePenalty(w, p, t, portMark, markPositionCache);
        Double distanceBasedProbability = this.getDistanceBasedProbability(w, t, d, markPositionCache, this.race.getBoatOfCompetitor(c).getBoatClass().getHullLength());
        double probability = distanceBasedProbability == null ? sidePenalty : distanceBasedProbability * sidePenalty;
        Double passesInTheRightDirectionProbability = this.passesInTheRightDirection(w, xte1, xte2, portMark);
        double d2 = probability = passesInTheRightDirectionProbability == null ? probability : probability * passesInTheRightDirectionProbability;
        if (this.isStartWaypoint(w)) {
            startProbabilityBasedOnOtherCompetitors = this.getProbabilityForStartCandidateBasedOnOtherCompetitorsBehavior(c, t, markPositionCache);
            if (startProbabilityBasedOnOtherCompetitors != null) {
                probability *= startProbabilityBasedOnOtherCompetitors.doubleValue();
            }
        } else {
            startProbabilityBasedOnOtherCompetitors = null;
        }
        return new XTECandidateImpl(this.race.getRace().getCourse().getIndexOfWaypoint(w) + 1, t, probability, startProbabilityBasedOnOtherCompetitors, w, sidePenalty, passesInTheRightDirectionProbability);
    }

    private Double getProbabilityForStartCandidateBasedOnOtherCompetitorsBehavior(Competitor c, TimePoint t, MarkPositionAtTimePointCache markPositionCache) {
        Double result;
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        if (this.race.getStartOfRace(false) == null && this.race.isGateStart() != Boolean.TRUE) {
            Waypoint start = this.race.getRace().getCourse().getFirstWaypoint();
            Iterable<Util.Pair<Position, Bearing>> crossingInformationForStart = this.getCrossingInformation(start, t, markPositionCache);
            if (start == null) {
                result = 1.0;
            } else {
                boolean startIsLine = this.getPassingInstructions(start) == PassingInstruction.Line;
                ArrayList<AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine> distancesToStartLineOfOtherCompetitors = new ArrayList<AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine>();
                for (Competitor otherCompetitor : this.race.getRace().getCompetitors()) {
                    Distance crossTrackError;
                    Distance otherCompetitorsDistanceToStartAtT;
                    Position estimatedPositionAtT;
                    GPSFixTrack track;
                    if (otherCompetitor == c || (track = this.race.getTrack(otherCompetitor)) == null || (estimatedPositionAtT = track.getEstimatedPosition(t, true)) == null || (otherCompetitorsDistanceToStartAtT = this.getMinDistanceOrNull(this.calculateDistance(estimatedPositionAtT, start, t, markPositionCache))) == null) continue;
                    if (startIsLine) {
                        Util.Pair<Position, Bearing> crossingInformationForStartLine = crossingInformationForStart.iterator().next();
                        crossTrackError = estimatedPositionAtT.crossTrackError((Position)crossingInformationForStartLine.getA(), (Bearing)crossingInformationForStartLine.getB());
                    } else {
                        crossTrackError = null;
                    }
                    distancesToStartLineOfOtherCompetitors.add(new AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine(otherCompetitorsDistanceToStartAtT, crossTrackError));
                }
                result = this.getProbabilityOfStartBasedOnOtherCompetitorsStartLineDistances(distancesToStartLineOfOtherCompetitors, startIsLine);
            }
        } else {
            result = null;
        }
        return result;
    }

    protected Double getProbabilityOfStartBasedOnOtherCompetitorsStartLineDistances(List<AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine> distancesToStartLineOfOtherCompetitors, boolean startIsLine) {
        Double result;
        Distance hullLength = this.race.getRace().getBoatClass().getHullLength();
        if (!distancesToStartLineOfOtherCompetitors.isEmpty()) {
            Collections.sort(distancesToStartLineOfOtherCompetitors, (a, b) -> a.getAbsoluteGeometricDistance().compareTo((Object)b.getAbsoluteGeometricDistance()));
            Distance.NullDistance weightedAbsoluteDistanceSum = Distance.NULL;
            int i = 0;
            double weightSum = 0.0;
            for (AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine d : distancesToStartLineOfOtherCompetitors) {
                double weight = this.weight((double)i / (double)distancesToStartLineOfOtherCompetitors.size());
                Distance weightedDistance = d.getAbsoluteGeometricDistance().scale(weight);
                weightedAbsoluteDistanceSum = weightedAbsoluteDistanceSum.add(weightedDistance);
                weightSum += weight;
                ++i;
            }
            Distance weightedAverageAbsoluteDistance = weightedAbsoluteDistanceSum.scale(1.0 / weightSum);
            double probabilityOfStartWithOthers = Math.max(0.1, Math.min(1.0, 1.0 - 0.09 * (weightedAverageAbsoluteDistance.divide(hullLength) - 1.0)));
            if (startIsLine) {
                Collections.sort(distancesToStartLineOfOtherCompetitors, (a, b) -> a.getSignedProjectedDistance().compareTo((Object)b.getSignedProjectedDistance()));
                Distance.NullDistance weightedSignedDistanceSum = Distance.NULL;
                weightSum = 0.0;
                i = 0;
                for (AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine d : distancesToStartLineOfOtherCompetitors) {
                    double weight = this.weight((double)i / (double)distancesToStartLineOfOtherCompetitors.size());
                    weightedSignedDistanceSum = weightedSignedDistanceSum.add(d.getSignedProjectedDistance().scale(weight));
                    weightSum += weight;
                    ++i;
                }
                Distance weightedAverageSignedDistance = weightedSignedDistanceSum.scale(1.0 / weightSum);
                i = 0;
                double signedDistanceVarianceSumInSquareMeters = 0.0;
                weightSum = 0.0;
                for (AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine d : distancesToStartLineOfOtherCompetitors) {
                    double differenceFromWeightedAverageInMeters = d.getSignedProjectedDistance().getMeters() - weightedAverageSignedDistance.getMeters();
                    double weight = this.weight((double)i / (double)distancesToStartLineOfOtherCompetitors.size());
                    signedDistanceVarianceSumInSquareMeters += weight * differenceFromWeightedAverageInMeters * differenceFromWeightedAverageInMeters;
                    weightSum += weight;
                    ++i;
                }
                double weightedVarianceInSquareMeters = signedDistanceVarianceSumInSquareMeters / weightSum;
                double weightedVarianceRatioToSquaredHullLength = weightedVarianceInSquareMeters / hullLength.getMeters() / hullLength.getMeters();
                double probabilityOfLateStart = Math.max(0.1, Math.min(1.0, 1.0 - 0.09 * (weightedVarianceRatioToSquaredHullLength - 1.0)));
                result = 1.0 - (1.0 - probabilityOfLateStart) * (1.0 - probabilityOfStartWithOthers);
            } else {
                result = probabilityOfStartWithOthers;
            }
        } else {
            result = 1.0;
        }
        return result;
    }

    private double weight(double relativePositionInDistanceCollectionInIncreasingOrder) {
        double SHARPNESS_OF_DECLINE = 100.0;
        double CENTER_OF_DECLINE = 0.8;
        return (-Math.atan(100.0 * (relativePositionInDistanceCollectionInIncreasingOrder - 0.8)) + 1.5707963267948966) / Math.PI;
    }

    private Distance getMinDistanceOrNull(List<Distance> distances) {
        Distance result = null;
        for (Distance d : distances) {
            if (d == null || result != null && result.compareTo((Object)d) <= 0) continue;
            result = d;
        }
        return result;
    }

    private boolean isStartWaypoint(Waypoint w) {
        return this.race.getRace().getCourse().getFirstWaypoint() == w;
    }

    private double getSidePenalty(Waypoint w, Position p, TimePoint t, boolean portMark, MarkPositionAtTimePointCache markPositionCache) {
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        boolean isOnRightSide = true;
        MeterDistance onWrongSide = new MeterDistance(0.0);
        PassingInstruction instruction = this.getPassingInstructions(w);
        if (instruction == PassingInstruction.Line) {
            ArrayList<Position> pos = new ArrayList<Position>();
            for (Mark m : w.getMarks()) {
                Position po = markPositionCache.getEstimatedPosition(m);
                if (po == null) {
                    isOnRightSide = true;
                    break;
                }
                pos.add(po);
            }
            if (pos.size() != 2) {
                isOnRightSide = true;
            }
            Position leftMarkPos = (Position)pos.get(0);
            Position rightMarkPos = (Position)pos.get(1);
            Bearing diff1 = leftMarkPos.getBearingGreatCircle(p).getDifferenceTo(leftMarkPos.getBearingGreatCircle(rightMarkPos));
            Bearing diff2 = rightMarkPos.getBearingGreatCircle(p).getDifferenceTo(rightMarkPos.getBearingGreatCircle(leftMarkPos));
            if (Math.abs(diff1.getDegrees()) > 90.0 || Math.abs(diff2.getDegrees()) > 90.0) {
                isOnRightSide = false;
                Distance leftDistance = p.getDistance(leftMarkPos);
                Distance rightDistance = p.getDistance(rightMarkPos);
                onWrongSide = leftDistance.getMeters() < rightDistance.getMeters() ? leftDistance : rightDistance;
            }
        } else {
            Mark m = null;
            if (instruction == PassingInstruction.Single_Unknown || instruction == PassingInstruction.Port || instruction == PassingInstruction.Starboard || instruction == PassingInstruction.FixedBearing || instruction == PassingInstruction.Offset) {
                m = (Mark)w.getMarks().iterator().next();
            } else if (instruction == PassingInstruction.Gate) {
                Util.Pair<Mark, Mark> pair = this.getPortAndStarboardMarks(t, w, markPositionCache);
                Mark mark = m = portMark ? (Mark)pair.getA() : (Mark)pair.getB();
            }
            if (m != null) {
                Util.Pair crossingInfo = (Util.Pair)Util.get(this.getCrossingInformation(w, t, markPositionCache), (int)(portMark ? 0 : 1));
                boolean bl = isOnRightSide = p.crossTrackError((Position)crossingInfo.getA(), ((Bearing)crossingInfo.getB()).add((Bearing)new DegreeBearingImpl(90.0))).getMeters() < 0.0;
                if (!isOnRightSide) {
                    onWrongSide = p.getDistance((Position)crossingInfo.getA());
                }
            }
        }
        double result = isOnRightSide ? 1.0 : Math.min(1.0, 0.19999999999999996 * Math.pow(1.5, -0.2 * onWrongSide.add(GPSFix.TYPICAL_HDOP.scale(-2.0)).getMeters()) + 0.8);
        return result;
    }

    private Double passesInTheRightDirection(Waypoint w, double xte1, double xte2, boolean portMark) {
        PassingInstruction instruction = this.getPassingInstructions(w);
        Double result = instruction == PassingInstruction.Single_Unknown ? null : (instruction == PassingInstruction.Port || instruction == PassingInstruction.Gate && portMark ? Double.valueOf(xte1 > xte2 ? 1.0 : 0.7) : (instruction == PassingInstruction.Starboard || instruction == PassingInstruction.Gate && !portMark ? Double.valueOf(xte1 < xte2 ? 1.0 : 0.7) : (instruction == PassingInstruction.Line ? Double.valueOf(xte1 > xte2 ? 1.0 : 0.3) : null)));
        return result;
    }

    private Double getDistanceBasedProbability(Waypoint w, TimePoint t, Distance distance, MarkPositionAtTimePointCache markPositionCache, Distance hullLength) {
        Distance legLength;
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        assert (distance.getMeters() >= 0.0);
        Double result = Util.size((Iterable)w.getControlPoint().getMarks()) > 1 ? Double.valueOf(1.0 / (10.0 * Math.abs(Math.max(0.0, distance.add(GPSFix.TYPICAL_HDOP.add(hullLength).scale(-2.0)).divide(hullLength.scale(150.0)))) + 1.0)) : ((legLength = this.getAverageLengthOfAdjacentLegs(t, w, markPositionCache)) != null ? Double.valueOf(1.0 / (10.0 * Math.abs(Math.max(0.0, distance.add(GPSFix.TYPICAL_HDOP.add(hullLength).scale(-2.0)).divide(legLength))) + 1.0)) : null);
        return result;
    }

    private Distance getAverageLengthOfAdjacentLegs(TimePoint t, Waypoint w, MarkPositionAtTimePointCache markPositionCache) {
        Object result;
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        Course course = this.race.getRace().getCourse();
        if (course.getNumberOfWaypoints() < 2) {
            result = null;
        } else if (w == course.getFirstWaypoint()) {
            result = this.race.getTrackedLegStartingAt(w).getGreatCircleDistance(t, markPositionCache);
        } else if (w == course.getLastWaypoint()) {
            result = this.race.getTrackedLegFinishingAt(w).getGreatCircleDistance(t, markPositionCache);
        } else {
            Distance before = this.race.getTrackedLegStartingAt(w).getGreatCircleDistance(t, markPositionCache);
            Distance after = this.race.getTrackedLegFinishingAt(w).getGreatCircleDistance(t, markPositionCache);
            result = after != null && before != null ? new MeterDistance(before.add(after).getMeters() / 2.0) : null;
        }
        return result;
    }

    private List<Distance> calculateDistance(Position p, Waypoint w, TimePoint t, MarkPositionAtTimePointCache markPositionCache) {
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        ArrayList<Distance> distances = new ArrayList<Distance>();
        PassingInstruction instruction = this.getPassingInstructions(w);
        boolean singleMark = false;
        switch (instruction) {
            case Port: 
            case Starboard: 
            case Single_Unknown: 
            case FixedBearing: {
                singleMark = true;
                break;
            }
            case Gate: {
                Util.Pair<Mark, Mark> posGate = this.getPortAndStarboardMarks(t, w, markPositionCache);
                if (posGate.getA() != null) {
                    Position portGatePosition = markPositionCache.getEstimatedPosition((Mark)posGate.getA());
                    distances.add(portGatePosition != null ? p.getDistance(portGatePosition) : null);
                } else {
                    distances.add(null);
                }
                if (posGate.getB() != null) {
                    Position starboardGatePosition = markPositionCache.getEstimatedPosition((Mark)posGate.getB());
                    distances.add(starboardGatePosition != null ? p.getDistance(starboardGatePosition) : null);
                    break;
                }
                distances.add(null);
                break;
            }
            case Line: {
                Util.Pair<Mark, Mark> posLine = this.getPortAndStarboardMarks(t, w, markPositionCache);
                if (posLine.getA() == null || posLine.getB() == null) break;
                Position portLinePosition = markPositionCache.getEstimatedPosition((Mark)posLine.getA());
                Position starboardLinePosition = markPositionCache.getEstimatedPosition((Mark)posLine.getB());
                distances.add(portLinePosition != null && starboardLinePosition != null ? p.getDistanceToLine(portLinePosition, starboardLinePosition).abs() : null);
                break;
            }
            case Offset: {
                singleMark = true;
                break;
            }
            case None: {
                break;
            }
        }
        if (singleMark) {
            Position markPosition = markPositionCache.getEstimatedPosition((Mark)w.getMarks().iterator().next());
            distances.add(markPosition != null ? p.getDistance(markPosition) : null);
        }
        return distances;
    }

    private PassingInstruction getPassingInstructions(Waypoint w) {
        PassingInstruction result;
        if (this.passingInstructions.containsKey(w)) {
            result = this.passingInstructions.get(w);
        } else {
            result = this.determinePassingInstructions(w);
            this.passingInstructions.put(w, result);
        }
        return result;
    }

    private Iterable<Util.Pair<Position, Bearing>> getCrossingInformation(Waypoint w, TimePoint t, MarkPositionAtTimePointCache markPositionCache) {
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        ArrayList<Util.Pair<Position, Bearing>> result = new ArrayList<Util.Pair<Position, Bearing>>();
        PassingInstruction instruction = this.getPassingInstructions(w);
        if (instruction == PassingInstruction.Line) {
            Util.Pair<Mark, Mark> marks = this.getPortAndStarboardMarks(t, w, markPositionCache);
            Bearing b = null;
            Mark portMark = (Mark)marks.getA();
            Mark starBoardMark = (Mark)marks.getB();
            if (portMark != null && starBoardMark != null) {
                Position portPosition = markPositionCache.getEstimatedPosition(portMark);
                Position starboardPosition = markPositionCache.getEstimatedPosition(starBoardMark);
                if (portPosition != null && starboardPosition != null) {
                    b = portPosition.getBearingGreatCircle(starboardPosition);
                    result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)portPosition, (Object)b));
                }
            }
        } else if (instruction == PassingInstruction.Gate) {
            Mark starboardMark;
            Position before = markPositionCache.getApproximatePosition(this.race.getTrackedLegFinishingAt(w).getLeg().getFrom());
            Position after = markPositionCache.getApproximatePosition(this.race.getTrackedLegStartingAt(w).getLeg().getTo());
            Util.Pair<Mark, Mark> pos = this.getPortAndStarboardMarks(t, w, markPositionCache);
            Mark portMark = (Mark)pos.getA();
            if (portMark != null) {
                Position portPosition = markPositionCache.getEstimatedPosition(portMark);
                Bearing crossingPort = before.getBearingGreatCircle(portPosition).middle(after.getBearingGreatCircle(portPosition));
                result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)portPosition, (Object)crossingPort));
            }
            if ((starboardMark = (Mark)pos.getB()) != null) {
                Position starboardPosition = markPositionCache.getEstimatedPosition(starboardMark);
                Bearing crossingStarboard = before.getBearingGreatCircle(starboardPosition).middle(after.getBearingGreatCircle(starboardPosition));
                result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)starboardPosition, (Object)crossingStarboard));
            }
        } else {
            Bearing b = null;
            Position p = markPositionCache.getEstimatedPosition((Mark)w.getMarks().iterator().next());
            if (instruction == PassingInstruction.FixedBearing) {
                b = w.getFixedBearing();
            } else if (w == this.race.getRace().getCourse().getFirstWaypoint()) {
                if (instruction == PassingInstruction.None || instruction == PassingInstruction.Single_Unknown) {
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegStartingAt(w)).add((Bearing)new DegreeBearingImpl(90.0));
                    result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)p, (Object)b));
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegStartingAt(w)).add((Bearing)new DegreeBearingImpl(270.0));
                } else {
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegStartingAt(w)).add((Bearing)new DegreeBearingImpl((double)(instruction == PassingInstruction.Port ? 90 : 270)));
                }
            } else if (w == this.race.getRace().getCourse().getLastWaypoint()) {
                if (instruction == PassingInstruction.None || instruction == PassingInstruction.Single_Unknown) {
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegFinishingAt(w)).add((Bearing)new DegreeBearingImpl(90.0));
                    result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)p, (Object)b));
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegFinishingAt(w)).add((Bearing)new DegreeBearingImpl(270.0));
                } else {
                    b = markPositionCache.getLegBearing(this.race.getTrackedLegFinishingAt(w)).add((Bearing)new DegreeBearingImpl((double)(instruction == PassingInstruction.Port ? 90 : 270)));
                }
            } else {
                Bearing before = markPositionCache.getLegBearing(this.race.getTrackedLegFinishingAt(w));
                Bearing after = markPositionCache.getLegBearing(this.race.getTrackedLegStartingAt(w));
                if (before != null && after != null) {
                    b = before.middle(after.reverse());
                }
            }
            result.add((Util.Pair<Position, Bearing>)new Util.Pair((Object)p, (Object)b));
        }
        return result;
    }

    private Util.Pair<Mark, Mark> getPortAndStarboardMarks(TimePoint t, Waypoint w, MarkPositionAtTimePointCache markPositionCache) {
        Mark starboardMarkWhileApproachingLine;
        Mark portMarkWhileApproachingLine;
        assert (t.equals(markPositionCache.getTimePoint()));
        assert (this.race == markPositionCache.getTrackedRace());
        ArrayList<Position> markPositions = new ArrayList<Position>();
        for (Mark mark : w.getMarks()) {
            Position estimatedMarkPosition = markPositionCache.getEstimatedPosition(mark);
            if (estimatedMarkPosition == null) {
                return new Util.Pair(null, null);
            }
            markPositions.add(estimatedMarkPosition);
        }
        if (markPositions.size() != 2) {
            return new Util.Pair(null, null);
        }
        List legs = this.race.getRace().getCourse().getLegs();
        int indexOfWaypoint = this.race.getRace().getCourse().getIndexOfWaypoint(w);
        if (indexOfWaypoint < 0 || legs.isEmpty()) {
            return new Util.Pair(null, null);
        }
        boolean isStartLine = indexOfWaypoint == 0;
        Bearing legDeterminingDirectionBearing = markPositionCache.getLegBearing(this.race.getTrackedLeg((Leg)legs.get(isStartLine ? 0 : indexOfWaypoint - 1)));
        if (legDeterminingDirectionBearing == null) {
            return new Util.Pair(null, null);
        }
        Distance crossTrackErrorOfMark0OnLineFromMark1ToNextWaypoint = ((Position)markPositions.get(0)).crossTrackError((Position)markPositions.get(1), legDeterminingDirectionBearing);
        if (crossTrackErrorOfMark0OnLineFromMark1ToNextWaypoint.getMeters() < 0.0) {
            portMarkWhileApproachingLine = (Mark)Util.get((Iterable)w.getMarks(), (int)0);
            starboardMarkWhileApproachingLine = (Mark)Util.get((Iterable)w.getMarks(), (int)1);
        } else {
            portMarkWhileApproachingLine = (Mark)Util.get((Iterable)w.getMarks(), (int)1);
            starboardMarkWhileApproachingLine = (Mark)Util.get((Iterable)w.getMarks(), (int)0);
        }
        return new Util.Pair((Object)portMarkWhileApproachingLine, (Object)starboardMarkWhileApproachingLine);
    }

    private TimeRangeWithNullStartMeaningEmpty getTimeRangeOrNull(TimePoint from, TimePoint to) {
        TimePoint effectiveFrom = this.getEffectiveFrom(from);
        return new TimeRangeWithNullStartMeaningEmpty(effectiveFrom, to);
    }

    private TimePoint getEffectiveFrom(TimePoint from) {
        TimePoint effectiveFrom = from == null && this.race.getTrackedRegatta().getRegatta().useStartTimeInference() ? (this.race.getStartOfTracking() == null ? TimePoint.BeginningOfTime : this.race.getStartOfTracking()) : from;
        return effectiveFrom;
    }

    @Override
    public Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> getCandidateDeltasAfterRaceStartTimeChange() {
        TimePoint newNonInferredStartTime = this.race.getStartOfRace(false);
        TimePoint newTimePointWhenToStartConsideringCandidates = this.getTimePointWhenToStartConsideringCandidates(newNonInferredStartTime);
        TimePoint newEffectiveTimePointWhenToStartConsideringCandidates = this.getEffectiveFrom(newTimePointWhenToStartConsideringCandidates);
        TimeRangeWithNullStartMeaningEmpty newTimeRange = this.timeRangeForValidCandidates.getWithNewFrom(newEffectiveTimePointWhenToStartConsideringCandidates);
        return this.getCandidateDeltasAfterTimingChange(newEffectiveTimePointWhenToStartConsideringCandidates, newTimeRange);
    }

    private Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> getCandidateDeltasAfterTimingChange(TimePoint newTimePointWhenToStartConsideringCandidates, TimeRangeWithNullStartMeaningEmpty newTimeRange) {
        Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> result;
        if (!Util.equalsWithNull((Object)newTimeRange, (Object)this.timeRangeForValidCandidates)) {
            if (newTimeRange.getTimeRangeOrNull() == null) {
                result = this.clearAllCandidates();
            } else if (this.timeRangeForValidCandidates.getTimeRangeOrNull() == null) {
                result = this.updateCandiatesAfterRaceTimeRangeChanged(newTimeRange.getTimeRangeOrNull().from(), newTimeRange.getTimeRangeOrNull().to());
            } else {
                TimePoint oldTimePointWhenToStartConsideringCandidates = this.timeRangeForValidCandidates.getTimeRangeOrNull().from();
                result = this.updateCandiatesAfterRaceTimeRangeChanged(newTimePointWhenToStartConsideringCandidates, oldTimePointWhenToStartConsideringCandidates);
            }
            this.timeRangeForValidCandidates = newTimeRange;
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    @Override
    public Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> getCandidateDeltasAfterStartOfTrackingChange() {
        TimePoint newNonInferredStartTime = this.race.getStartOfRace(false);
        TimePoint newTimePointWhenToStartConsideringCandidates = this.getTimePointWhenToStartConsideringCandidates(newNonInferredStartTime);
        TimePoint newEffectiveTimePointWhenToStartConsideringCandidates = this.getEffectiveFrom(newTimePointWhenToStartConsideringCandidates);
        TimeRangeWithNullStartMeaningEmpty newTimeRange = this.timeRangeForValidCandidates.getWithNewFrom(newEffectiveTimePointWhenToStartConsideringCandidates);
        return this.getCandidateDeltasAfterTimingChange(newEffectiveTimePointWhenToStartConsideringCandidates, newTimeRange);
    }

    @Override
    public Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> getCandidateDeltasAfterRaceFinishedTimeChange(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
        Map<Competitor, Util.Pair<Iterable<Candidate>, Iterable<Candidate>>> result;
        TimePoint newTimePointWhenToFinishConsideringCandidates = this.getTimePointWhenToFinishConsideringCandidates(newFinishedTime);
        TimeRangeWithNullStartMeaningEmpty newTimeRange = this.timeRangeForValidCandidates.getWithNewTo(newTimePointWhenToFinishConsideringCandidates);
        if (!Util.equalsWithNull((Object)newTimeRange, (Object)this.timeRangeForValidCandidates)) {
            if (newTimeRange.getTimeRangeOrNull() == null) {
                result = this.clearAllCandidates();
            } else if (this.timeRangeForValidCandidates.getTimeRangeOrNull() == null) {
                result = this.updateCandiatesAfterRaceTimeRangeChanged(newTimeRange.getTimeRangeOrNull().from(), newTimeRange.getTimeRangeOrNull().to());
            } else {
                TimePoint oldTimePointWhenToFinishConsideringCandidates = this.timeRangeForValidCandidates.getTimeRangeOrNull().to();
                result = this.updateCandiatesAfterRaceTimeRangeChanged(oldTimePointWhenToFinishConsideringCandidates, newTimePointWhenToFinishConsideringCandidates);
            }
            this.timeRangeForValidCandidates = newTimeRange;
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public static class AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine {
        private final Distance absoluteGeometricDistance;
        private final Distance signedProjectedDistance;

        public AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine(Distance absoluteGeometricDistance, Distance signedProjectedDistance) {
            this.absoluteGeometricDistance = absoluteGeometricDistance;
            this.signedProjectedDistance = signedProjectedDistance;
        }

        public Distance getAbsoluteGeometricDistance() {
            return this.absoluteGeometricDistance;
        }

        public Distance getSignedProjectedDistance() {
            return this.signedProjectedDistance;
        }

        public String toString() {
            return "AbsoluteGeometricDistanceAndSignedProjectedDistanceToStartLine [absoluteGeometricDistance=" + this.absoluteGeometricDistance + ", signedProjectedDistance=" + this.signedProjectedDistance + "]";
        }
    }

    private class LimitedLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int limit;

        public LimitedLinkedHashMap(int limit) {
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.limit;
        }
    }
}

