/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.SpeedWithBearingWithConfidence;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.maneuverdetection.CompleteManeuverCurveWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.ManeuverDetectorWithEstimationDataSupport;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.CompleteManeuverCurveWithEstimationDataImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverMainCurveDetailsWithBearingSteps;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverMainCurveWithEstimationDataImpl;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverSpot;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.CompleteManeuverCurve;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.SpeedWithBearingStep;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.impl.CompleteManeuverCurveImpl;
import com.sap.sailing.domain.tracking.impl.ManeuverCurveBoundariesImpl;
import com.sap.sailing.domain.tracking.impl.NonCachingMarkPositionAtTimePointCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ManeuverDetectorWithEstimationDataSupportDecoratorImpl
implements ManeuverDetectorWithEstimationDataSupport {
    private final ManeuverDetectorImpl maneuverDetector;
    private final PolarDataService polarDataService;

    public ManeuverDetectorWithEstimationDataSupportDecoratorImpl(ManeuverDetectorImpl maneuverDetector, PolarDataService polarDataService) {
        this.maneuverDetector = maneuverDetector;
        this.polarDataService = polarDataService;
    }

    @Override
    public List<Maneuver> detectManeuvers() {
        return this.maneuverDetector.detectManeuvers();
    }

    @Override
    public TrackTimeInfo getTrackTimeInfo() {
        return this.maneuverDetector.getTrackTimeInfo();
    }

    @Override
    public List<Maneuver> detectManeuvers(Iterable<CompleteManeuverCurve> maneuverCurves) {
        ArrayList<Maneuver> maneuvers = new ArrayList<Maneuver>();
        for (CompleteManeuverCurve maneuverCurve : maneuverCurves) {
            TimePoint maneuverTimePoint = maneuverCurve.getMainCurveBoundaries().getTimePoint();
            Position maneuverPosition = this.maneuverDetector.track.getEstimatedPosition(maneuverTimePoint, false);
            Wind wind = this.maneuverDetector.trackedRace.getWind(maneuverPosition, maneuverTimePoint, this.maneuverDetector.trackedRace.getWindSources(WindSourceType.MANEUVER_BASED_ESTIMATION));
            maneuvers.addAll(this.maneuverDetector.determineManeuversFromManeuverCurve(maneuverCurve.getMainCurveBoundaries(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries(), wind, maneuverCurve.getMarkPassing()));
        }
        return maneuvers;
    }

    @Override
    public List<CompleteManeuverCurve> detectCompleteManeuverCurves() {
        List<? extends ManeuverSpot> maneuverSpots = this.maneuverDetector.detectManeuverSpots();
        return maneuverSpots.stream().filter(maneuverSpot -> maneuverSpot.getManeuverCurve() != null).map(maneuverSpot -> maneuverSpot.getManeuverCurve()).collect(Collectors.toList());
    }

    @Override
    public List<CompleteManeuverCurve> getCompleteManeuverCurves(Iterable<Maneuver> maneuvers) {
        ArrayList<CompleteManeuverCurve> result = new ArrayList<CompleteManeuverCurve>();
        CompleteManeuverCurve curveToAdd = null;
        boolean previousManeuverCouldBelongToSameCurve = false;
        Maneuver previousManeuver = null;
        for (Maneuver maneuver : maneuvers) {
            boolean maneuverCouldBelongToSameCurve;
            boolean bl = maneuverCouldBelongToSameCurve = maneuver.getType() == ManeuverType.PENALTY_CIRCLE || maneuver.isMarkPassing() && (maneuver.getType() == ManeuverType.TACK || maneuver.getType() == ManeuverType.JIBE);
            if (previousManeuverCouldBelongToSameCurve && maneuverCouldBelongToSameCurve && previousManeuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter().equals(maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore()) && previousManeuver.getToSide() == maneuver.getToSide()) {
                curveToAdd = this.extendCompleteManeuverCurveWithManeuver(curveToAdd, maneuver);
            } else {
                if (curveToAdd != null) {
                    result.add(curveToAdd);
                }
                curveToAdd = this.convertManeuverToCompleteManeuverCurve(maneuver);
            }
            previousManeuver = maneuver;
            previousManeuverCouldBelongToSameCurve = maneuverCouldBelongToSameCurve;
        }
        if (curveToAdd != null) {
            result.add(curveToAdd);
        }
        return result;
    }

    private CompleteManeuverCurve convertManeuverToCompleteManeuverCurve(Maneuver maneuver) {
        ManeuverMainCurveDetailsWithBearingSteps mainCurveBoundaries = new ManeuverMainCurveDetailsWithBearingSteps(maneuver.getMainCurveBoundaries().getTimePointBefore(), maneuver.getMainCurveBoundaries().getTimePointAfter(), maneuver.getTimePoint(), maneuver.getMainCurveBoundaries().getSpeedWithBearingBefore(), maneuver.getMainCurveBoundaries().getSpeedWithBearingAfter(), maneuver.getMainCurveBoundaries().getDirectionChangeInDegrees(), maneuver.getMaxTurningRateInDegreesPerSecond(), maneuver.getMainCurveBoundaries().getLowestSpeed(), maneuver.getMainCurveBoundaries().getHighestSpeed(), this.maneuverDetector.getSpeedWithBearingSteps(maneuver.getMainCurveBoundaries().getTimePointBefore(), maneuver.getMainCurveBoundaries().getTimePointAfter()));
        return new CompleteManeuverCurveImpl(mainCurveBoundaries, maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries(), maneuver.getMarkPassing());
    }

    private CompleteManeuverCurve extendCompleteManeuverCurveWithManeuver(CompleteManeuverCurve maneuverCurve, Maneuver maneuver) {
        ManeuverMainCurveDetailsWithBearingSteps mainCurveDetails = this.maneuverDetector.computeManeuverMainCurveDetails(maneuverCurve.getMainCurveBoundaries().getTimePointBefore(), maneuver.getMainCurveBoundaries().getTimePointAfter(), maneuver.getToSide());
        if (mainCurveDetails == null) {
            return maneuverCurve;
        }
        Speed lowestSpeed = maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed().compareTo((Object)maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed()) > 0 ? maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed() : maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed();
        Speed highestSpeed = maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getHighestSpeed().compareTo((Object)maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getHighestSpeed()) < 0 ? maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getHighestSpeed() : maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getHighestSpeed();
        ManeuverCurveBoundariesImpl maneuverCurveWithStableSpeedAndCourseBoundaries = new ManeuverCurveBoundariesImpl(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore(), maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore(), maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getDirectionChangeInDegrees() + maneuver.getManeuverCurveWithStableSpeedAndCourseBoundaries().getDirectionChangeInDegrees(), lowestSpeed, highestSpeed);
        return new CompleteManeuverCurveImpl(mainCurveDetails, maneuverCurveWithStableSpeedAndCourseBoundaries, maneuverCurve.getMarkPassing() == null ? maneuver.getMarkPassing() : maneuverCurve.getMarkPassing());
    }

    @Override
    public List<CompleteManeuverCurveWithEstimationData> getCompleteManeuverCurvesWithEstimationData(Iterable<CompleteManeuverCurve> maneuverCurves) {
        ArrayList<CompleteManeuverCurveWithEstimationData> result = new ArrayList<CompleteManeuverCurveWithEstimationData>();
        CompleteManeuverCurve previousManeuverCurve = null;
        CompleteManeuverCurve currentManeuverCurve = null;
        for (CompleteManeuverCurve nextManeuverCurve : maneuverCurves) {
            if (currentManeuverCurve != null) {
                CompleteManeuverCurveWithEstimationData maneuverCurveWithEstimationData = this.calculateCompleteManeuverCurveWithEstimationData(currentManeuverCurve, previousManeuverCurve, nextManeuverCurve);
                result.add(maneuverCurveWithEstimationData);
            }
            previousManeuverCurve = currentManeuverCurve;
            currentManeuverCurve = nextManeuverCurve;
        }
        if (currentManeuverCurve != null) {
            CompleteManeuverCurveWithEstimationData maneuverCurveWithEstimationData = this.calculateCompleteManeuverCurveWithEstimationData(currentManeuverCurve, previousManeuverCurve, null);
            result.add(maneuverCurveWithEstimationData);
        }
        return result;
    }

    private CompleteManeuverCurveWithEstimationData calculateCompleteManeuverCurveWithEstimationData(CompleteManeuverCurve maneuverCurve, CompleteManeuverCurve previousManeuverCurve, CompleteManeuverCurve nextManeuverCurve) {
        SpeedWithBearing boatSpeed;
        GPSFixMoving lastFixBeforeFirstManeuverFix;
        GPSFixMoving firstFixAfterLastManeuverFix;
        Bearing courseAtMaxTurningRate = null;
        SpeedWithBearingStep stepWithLowestSpeed = null;
        SpeedWithBearingStep stepWithHighestSpeed = null;
        SpeedWithBearingStep stepWithMaxTurningRate = null;
        SpeedWithBearingStep previousStep = null;
        for (SpeedWithBearingStep step : maneuverCurve.getMainCurveBoundaries().getSpeedWithBearingSteps()) {
            if (stepWithLowestSpeed == null || stepWithLowestSpeed.getSpeedWithBearing().compareTo((Object)step.getSpeedWithBearing()) > 0) {
                stepWithLowestSpeed = step;
            }
            if (stepWithHighestSpeed == null || stepWithHighestSpeed.getSpeedWithBearing().compareTo((Object)step.getSpeedWithBearing()) < 0) {
                stepWithHighestSpeed = step;
            }
            if (previousStep != null && (stepWithMaxTurningRate == null || stepWithMaxTurningRate.getTurningRateInDegreesPerSecond() < step.getTurningRateInDegreesPerSecond())) {
                stepWithMaxTurningRate = step;
                courseAtMaxTurningRate = previousStep.getSpeedWithBearing().getBearing().add((Bearing)new DegreeBearingImpl(step.getCourseChangeInDegrees() / 2.0));
            }
            previousStep = step;
        }
        int gpsFixCountWithinMainCurve = 0;
        int gpsFixCountWithinWholeCurve = 0;
        int gpsFixesCountFromPreviousManeuver = 0;
        int gpsFixesCountToNextManeuver = 0;
        try {
            this.maneuverDetector.track.lockForRead();
            boolean considerPreviousManeuver = previousManeuverCurve != null && previousManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter().before(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore());
            boolean considerNextManeuver = nextManeuverCurve != null && nextManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore().after(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter());
            for (GPSFixMoving fix : this.maneuverDetector.track.getFixes(considerPreviousManeuver ? previousManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter() : maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore(), !considerPreviousManeuver, considerNextManeuver ? nextManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore() : maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), !considerNextManeuver)) {
                if (fix.getTimePoint().before(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore())) {
                    ++gpsFixesCountFromPreviousManeuver;
                    continue;
                }
                if (fix.getTimePoint().after(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter())) {
                    ++gpsFixesCountToNextManeuver;
                    continue;
                }
                if (!fix.getTimePoint().before(maneuverCurve.getMainCurveBoundaries().getTimePointBefore()) && !fix.getTimePoint().after(maneuverCurve.getMainCurveBoundaries().getTimePointAfter())) {
                    ++gpsFixCountWithinMainCurve;
                }
                ++gpsFixCountWithinWholeCurve;
            }
        }
        finally {
            this.maneuverDetector.track.unlockAfterRead();
        }
        if (courseAtMaxTurningRate == null) {
            courseAtMaxTurningRate = stepWithLowestSpeed.getSpeedWithBearing().getBearing();
        }
        Duration longestGpsFixIntervalBetweenTwoFixes = this.maneuverDetector.track.getLongestIntervalBetweenTwoFixes(maneuverCurve.getMainCurveBoundaries().getTimePointBefore(), maneuverCurve.getMainCurveBoundaries().getTimePointAfter());
        ManeuverMainCurveWithEstimationDataImpl mainCurve = new ManeuverMainCurveWithEstimationDataImpl(maneuverCurve.getMainCurveBoundaries().getTimePointBefore(), maneuverCurve.getMainCurveBoundaries().getTimePointAfter(), maneuverCurve.getMainCurveBoundaries().getSpeedWithBearingBefore(), maneuverCurve.getMainCurveBoundaries().getSpeedWithBearingAfter(), maneuverCurve.getMainCurveBoundaries().getDirectionChangeInDegrees(), stepWithLowestSpeed.getSpeedWithBearing(), stepWithLowestSpeed.getTimePoint(), stepWithHighestSpeed.getSpeedWithBearing(), stepWithHighestSpeed.getTimePoint(), maneuverCurve.getMainCurveBoundaries().getTimePoint(), maneuverCurve.getMainCurveBoundaries().getMaxTurningRateInDegreesPerSecond(), courseAtMaxTurningRate, Math.abs(maneuverCurve.getMainCurveBoundaries().getDirectionChangeInDegrees()) / maneuverCurve.getMainCurveBoundaries().getDuration().asSeconds(), gpsFixCountWithinMainCurve, longestGpsFixIntervalBetweenTwoFixes);
        longestGpsFixIntervalBetweenTwoFixes = this.maneuverDetector.track.getLongestIntervalBetweenTwoFixes(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter());
        TrackTimeInfo trackTimeInfo = previousManeuverCurve == null || nextManeuverCurve == null ? this.maneuverDetector.getTrackTimeInfo() : null;
        Util.Pair<Duration, SpeedWithBearing> durationAndAvgSpeedWithBearingBefore = this.calculateDurationAndAvgSpeedWithBearingBetweenTimePoints(previousManeuverCurve == null ? trackTimeInfo.getTrackStartTimePoint() : previousManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore());
        Util.Pair<Duration, SpeedWithBearing> durationAndAvgSpeedWithBearingAfter = this.calculateDurationAndAvgSpeedWithBearingBetweenTimePoints(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), nextManeuverCurve == null ? trackTimeInfo.getLatestRawFixTimePoint() : nextManeuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore());
        Duration intervalBetweenLastFixOfCurveAndNextFix = Duration.NULL;
        GPSFixMoving lastManeuverFix = (GPSFixMoving)this.maneuverDetector.track.getLastFixAtOrBefore(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter());
        if (lastManeuverFix != null && (firstFixAfterLastManeuverFix = (GPSFixMoving)this.maneuverDetector.track.getFirstFixAfter(lastManeuverFix.getTimePoint())) != null) {
            intervalBetweenLastFixOfCurveAndNextFix = lastManeuverFix.getTimePoint().until(firstFixAfterLastManeuverFix.getTimePoint());
        }
        Duration intervalBetweenFirstFixOfCurveAndPreviousFix = Duration.NULL;
        GPSFixMoving firstManeuverFix = (GPSFixMoving)this.maneuverDetector.track.getFirstFixAtOrAfter(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore());
        if (firstManeuverFix != null && (lastFixBeforeFirstManeuverFix = (GPSFixMoving)this.maneuverDetector.track.getLastFixBefore(firstManeuverFix.getTimePoint())) != null) {
            intervalBetweenFirstFixOfCurveAndPreviousFix = lastFixBeforeFirstManeuverFix.getTimePoint().until(firstManeuverFix.getTimePoint());
        }
        ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataImpl curveWithUnstableCourseAndSpeed = new ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataImpl(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getDirectionChangeInDegrees(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getLowestSpeed(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getHighestSpeed(), (SpeedWithBearing)durationAndAvgSpeedWithBearingBefore.getB(), (Duration)durationAndAvgSpeedWithBearingBefore.getA(), gpsFixesCountFromPreviousManeuver, (SpeedWithBearing)durationAndAvgSpeedWithBearingAfter.getB(), (Duration)durationAndAvgSpeedWithBearingAfter.getA(), gpsFixesCountToNextManeuver, gpsFixCountWithinWholeCurve, longestGpsFixIntervalBetweenTwoFixes, intervalBetweenLastFixOfCurveAndNextFix, intervalBetweenFirstFixOfCurveAndPreviousFix);
        TimePoint maneuverTimePoint = maneuverCurve.getMainCurveBoundaries().getTimePoint();
        Position maneuverPosition = this.maneuverDetector.track.getEstimatedPosition(maneuverTimePoint, false);
        Wind wind = this.maneuverDetector.trackedRace.getWind(maneuverPosition, maneuverTimePoint);
        int numberOfJibes = this.maneuverDetector.getNumberOfJibes(mainCurve, wind);
        int numberOfTacks = this.maneuverDetector.getNumberOfTacks(mainCurve, wind);
        boolean maneuverStartsByRunningAwayFromWind = (mainCurve.getSpeedWithBearingBefore().getBearing().getDegrees() - 180.0) * mainCurve.getDirectionChangeInDegrees() < 0.0;
        Bearing relativeBearingToNextMarkPassingBeforeManeuver = this.getRelativeBearingToNextMark(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointBefore(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingBefore().getBearing());
        Bearing relativeBearingToNextMarkPassingAfterManeuver = this.getRelativeBearingToNextMark(maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getTimePointAfter(), maneuverCurve.getManeuverCurveWithStableSpeedAndCourseBoundaries().getSpeedWithBearingAfter().getBearing());
        BoatClass boatClass = this.maneuverDetector.trackedRace.getRace().getBoatOfCompetitor(this.maneuverDetector.competitor).getBoatClass();
        Double targetTackAngle = null;
        Double targetJibeAngle = null;
        SpeedWithBearing speedWithBearing = boatSpeed = curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore().compareTo((Object)curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter()) < 0 ? curveWithUnstableCourseAndSpeed.getSpeedWithBearingBefore() : curveWithUnstableCourseAndSpeed.getSpeedWithBearingAfter();
        if (this.polarDataService != null && this.polarDataService.getAllBoatClassesWithPolarSheetsAvailable().contains(boatClass)) {
            SpeedWithBearingWithConfidence<Void> closestTackTwa = this.polarDataService.getClosestTwaTws(ManeuverType.TACK, (Speed)boatSpeed, curveWithUnstableCourseAndSpeed.getDirectionChangeInDegrees(), boatClass);
            SpeedWithBearingWithConfidence<Void> closestJibeTwa = this.polarDataService.getClosestTwaTws(ManeuverType.JIBE, (Speed)boatSpeed, curveWithUnstableCourseAndSpeed.getDirectionChangeInDegrees(), boatClass);
            if (closestTackTwa != null) {
                targetTackAngle = this.polarDataService.getManeuverAngleInDegreesFromTwa(ManeuverType.TACK, closestTackTwa.getObject().getBearing());
            }
            if (closestJibeTwa != null) {
                targetJibeAngle = this.polarDataService.getManeuverAngleInDegreesFromTwa(ManeuverType.JIBE, closestJibeTwa.getObject().getBearing());
            }
        }
        Distance closestDistanceToMark = this.getClosestDistanceToMark(mainCurve.getTimePointOfMaxTurningRate());
        return new CompleteManeuverCurveWithEstimationDataImpl(maneuverPosition, mainCurve, curveWithUnstableCourseAndSpeed, wind, numberOfTacks, numberOfJibes, maneuverStartsByRunningAwayFromWind, relativeBearingToNextMarkPassingBeforeManeuver, relativeBearingToNextMarkPassingAfterManeuver, maneuverCurve.isMarkPassing(), closestDistanceToMark, targetTackAngle, targetJibeAngle);
    }

    public Distance getClosestDistanceToMark(TimePoint timePoint) {
        NonCachingMarkPositionAtTimePointCache markPositionAtTimePointCache = new NonCachingMarkPositionAtTimePointCache(this.maneuverDetector.trackedRace, timePoint);
        Distance result = null;
        TrackedLegOfCompetitor legAfter = this.maneuverDetector.trackedRace.getTrackedLeg(this.maneuverDetector.competitor, timePoint);
        if (legAfter != null) {
            Position maneuverPosition = this.maneuverDetector.track.getEstimatedPosition(timePoint, false);
            if (legAfter.getLeg().getTo() != null) {
                result = this.getClosestDistanceToMarkInternal(markPositionAtTimePointCache, legAfter.getLeg().getTo(), maneuverPosition);
            }
            if (legAfter.getLeg().getFrom() != null) {
                Distance distance = this.getClosestDistanceToMarkInternal(markPositionAtTimePointCache, legAfter.getLeg().getFrom(), maneuverPosition);
                if (result == null || distance != null && distance.compareTo((Object)result) < 0) {
                    result = distance;
                }
            }
        }
        return result;
    }

    private Distance getClosestDistanceToMarkInternal(NonCachingMarkPositionAtTimePointCache markPositionAtTimePointCache, Waypoint waypoint, Position maneuverPosition) {
        Distance result = null;
        for (Mark mark : waypoint.getMarks()) {
            Position markPosition = markPositionAtTimePointCache.getEstimatedPosition(mark);
            if (markPosition == null) continue;
            Distance distance = markPosition.getDistance(maneuverPosition);
            if (result != null && distance.compareTo((Object)result) >= 0) continue;
            result = distance;
        }
        return result;
    }

    private Util.Pair<Duration, SpeedWithBearing> calculateDurationAndAvgSpeedWithBearingBetweenTimePoints(TimePoint from, TimePoint to) {
        Duration duration = from.until(to);
        Position fromPosition = this.maneuverDetector.track.getEstimatedPosition(from, false);
        Position toPosition = this.maneuverDetector.track.getEstimatedPosition(to, false);
        Distance distance = fromPosition.getDistance(toPosition);
        Bearing bearing = fromPosition.getBearingGreatCircle(toPosition);
        Speed speed = distance.inTime(Math.abs(duration.asMillis()));
        KnotSpeedWithBearingImpl avgSpeedWithBearing = new KnotSpeedWithBearingImpl(speed.getKnots(), bearing);
        return new Util.Pair((Object)duration, (Object)avgSpeedWithBearing);
    }

    public Bearing getRelativeBearingToNextMark(TimePoint timePoint, Bearing boatCourse) {
        NonCachingMarkPositionAtTimePointCache markPositionAtTimePointCache = new NonCachingMarkPositionAtTimePointCache(this.maneuverDetector.trackedRace, timePoint);
        Bearing result = null;
        TrackedLegOfCompetitor legAfter = this.maneuverDetector.trackedRace.getTrackedLeg(this.maneuverDetector.competitor, timePoint);
        if (legAfter != null && legAfter.getLeg().getTo() != null) {
            Position maneuverEndPosition = this.maneuverDetector.track.getEstimatedPosition(timePoint, false);
            Waypoint nextWaypoint = legAfter.getLeg().getTo();
            for (Mark mark : nextWaypoint.getMarks()) {
                Position nextMarkPosition = markPositionAtTimePointCache.getEstimatedPosition(mark);
                Bearing absoluteBearing = maneuverEndPosition.getBearingGreatCircle(nextMarkPosition);
                Bearing resultCandidate = absoluteBearing.getDifferenceTo(boatCourse);
                if (result == null) {
                    result = resultCandidate;
                    continue;
                }
                if (Math.signum(result.getDegrees()) != Math.signum(resultCandidate.getDegrees())) {
                    result = new DegreeBearingImpl(0.0);
                    break;
                }
                if (!(Math.abs(result.getDegrees()) > Math.abs(resultCandidate.getDegrees()))) continue;
                result = resultCandidate;
            }
        }
        return result;
    }
}

