/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.maneuverdetection;

import com.sap.sse.shared.util.impl.ApproximateTime;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShortTimeAfterLastHitCache<K, V> {
    private static final Logger logger = Logger.getLogger(ShortTimeAfterLastHitCache.class.getName());
    private final ConcurrentMap<K, ValueWithTimestampSinceLastHit<V>> cache;
    private ScheduledFuture<?> invalidatorHandle;
    private final long preserveHowManyMilliseconds;
    private final UncachedValueRetrieverCallback<K, V> uncachedValueRetrieverCallback;
    private final CachedValueCleaningCallback<K, V> cachedValueCleaningCallback;
    private long hits;
    private long misses;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        if (this.cachedValueCleaningCallback != null) {
            Iterator iterator = this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                iterator.remove();
                if (this.cachedValueCleaningCallback == null) continue;
                this.cachedValueCleaningCallback.cleanValue(entry.getKey(), ((ValueWithTimestampSinceLastHit)entry.getValue()).getValue());
            }
        } else {
            this.cache.clear();
        }
        if (this.isInvalidatorHandleNecessary()) {
            ConcurrentMap<K, ValueWithTimestampSinceLastHit<V>> concurrentMap = this.cache;
            synchronized (concurrentMap) {
                if (this.invalidatorHandle != null && this.cache.isEmpty()) {
                    this.invalidatorHandle.cancel(false);
                    this.invalidatorHandle = null;
                }
            }
        }
    }

    public ShortTimeAfterLastHitCache(long preserveHowManyMilliseconds, UncachedValueRetrieverCallback<K, V> uncachedValueRetrieverCallback) {
        this(preserveHowManyMilliseconds, uncachedValueRetrieverCallback, null);
    }

    public ShortTimeAfterLastHitCache(long preserveHowManyMilliseconds, UncachedValueRetrieverCallback<K, V> uncachedValueRetrieverCallback, CachedValueCleaningCallback<K, V> cachedValueCleaningCallback) {
        this.preserveHowManyMilliseconds = preserveHowManyMilliseconds;
        this.uncachedValueRetrieverCallback = uncachedValueRetrieverCallback;
        this.cache = new ConcurrentHashMap<K, ValueWithTimestampSinceLastHit<V>>();
        this.cachedValueCleaningCallback = cachedValueCleaningCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToCache(K key, V value) {
        long timestamp = this.calculateCurrentTimestamp();
        ConcurrentMap<K, ValueWithTimestampSinceLastHit<V>> concurrentMap = this.cache;
        synchronized (concurrentMap) {
            this.cache.put(key, new ValueWithTimestampSinceLastHit<V>(value, timestamp));
            this.ensureTimerIsRunning();
        }
    }

    private long calculateCurrentTimestamp() {
        long timestamp = this.preserveHowManyMilliseconds > 1000L ? ApproximateTime.approximateNow().asMillis() : System.currentTimeMillis();
        return timestamp;
    }

    public V getValue(K key) {
        V value = this.getCachedValue(key);
        if (value == null && (value = this.uncachedValueRetrieverCallback.getUncachedValue(key)) != null) {
            this.addToCache(key, value);
        }
        return value;
    }

    public V getCachedValue(K key) {
        V value;
        ValueWithTimestampSinceLastHit valueWrapper = (ValueWithTimestampSinceLastHit)this.cache.get(key);
        if (valueWrapper == null) {
            ++this.misses;
            value = null;
        } else {
            ++this.hits;
            valueWrapper.setTimestampSinceLastHit(this.calculateCurrentTimestamp());
            value = valueWrapper.getValue();
        }
        if ((this.hits + this.misses) % 100000L == 0L && logger.isLoggable(Level.FINE)) {
            logger.fine("hits: " + this.hits + ", misses: " + this.misses);
        }
        return value;
    }

    private void ensureTimerIsRunning() {
        if (this.isInvalidatorHandleNecessary() && this.invalidatorHandle == null) {
            this.invalidatorHandle = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(new CacheInvalidator(), this.preserveHowManyMilliseconds, this.preserveHowManyMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    private boolean isInvalidatorHandleNecessary() {
        return this.preserveHowManyMilliseconds != Long.MAX_VALUE;
    }

    private class CacheInvalidator
    implements Runnable {
        private CacheInvalidator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long oldestToKeep = System.currentTimeMillis() - ShortTimeAfterLastHitCache.this.preserveHowManyMilliseconds;
            Iterator iterator = ShortTimeAfterLastHitCache.this.cache.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((ValueWithTimestampSinceLastHit)entry.getValue()).getTimestampSinceLastHit() >= oldestToKeep) continue;
                iterator.remove();
                if (ShortTimeAfterLastHitCache.this.cachedValueCleaningCallback == null) continue;
                ShortTimeAfterLastHitCache.this.cachedValueCleaningCallback.cleanValue(entry.getKey(), ((ValueWithTimestampSinceLastHit)entry.getValue()).getValue());
            }
            if (ShortTimeAfterLastHitCache.this.isInvalidatorHandleNecessary()) {
                ConcurrentMap concurrentMap = ShortTimeAfterLastHitCache.this.cache;
                synchronized (concurrentMap) {
                    if (ShortTimeAfterLastHitCache.this.invalidatorHandle != null && ShortTimeAfterLastHitCache.this.cache.isEmpty()) {
                        ShortTimeAfterLastHitCache.this.invalidatorHandle.cancel(false);
                        ShortTimeAfterLastHitCache.this.invalidatorHandle = null;
                    }
                }
            }
        }
    }

    public static interface CachedValueCleaningCallback<K, V> {
        public void cleanValue(K var1, V var2);
    }

    public static interface UncachedValueRetrieverCallback<K, V> {
        public V getUncachedValue(K var1);
    }

    private static class ValueWithTimestampSinceLastHit<V> {
        private final V value;
        private volatile long timestampSinceLastHit;

        public ValueWithTimestampSinceLastHit(V value, long timestampSinceLastHit) {
            this.value = value;
            this.timestampSinceLastHit = timestampSinceLastHit;
        }

        public long getTimestampSinceLastHit() {
            return this.timestampSinceLastHit;
        }

        public void setTimestampSinceLastHit(long timePointSinceAlive) {
            this.timestampSinceLastHit = timePointSinceAlive;
        }

        public V getValue() {
            return this.value;
        }
    }
}

