/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.meta;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardChangeListener;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.impl.SimpleAbstractRaceColumn;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.regattalike.RegattaLikeIdentifier;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.Map;

public class MetaLeaderboardColumn
extends SimpleAbstractRaceColumn
implements RaceColumn,
RaceColumnListener,
LeaderboardChangeListener {
    private static final long serialVersionUID = 3092096133388262955L;
    private final Leaderboard leaderboard;
    private final Fleet metaFleet;

    public MetaLeaderboardColumn(Leaderboard leaderboard, Fleet metaFleet) {
        this.leaderboard = leaderboard;
        this.metaFleet = metaFleet;
        leaderboard.addRaceColumnListener(this);
        leaderboard.addLeaderboardChangeListener(this);
    }

    @Override
    public RaceLog getRaceLog(Fleet fleet) {
        return null;
    }

    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    public String getName() {
        return this.leaderboard.getDisplayName() != null ? this.leaderboard.getDisplayName() : this.leaderboard.getName();
    }

    @Override
    public Iterable<? extends Fleet> getFleets() {
        return Collections.singleton(this.metaFleet);
    }

    @Override
    public Fleet getFleetByName(String fleetName) {
        return fleetName.equals(this.metaFleet.getName()) ? this.metaFleet : null;
    }

    @Override
    public Fleet getFleetOfCompetitor(Competitor competitor) {
        return this.metaFleet;
    }

    @Override
    public void setTrackedRace(Fleet fleet, TrackedRace race) {
    }

    @Override
    public boolean hasTrackedRaces() {
        return false;
    }

    @Override
    public TrackedRace getTrackedRace(Fleet fleet) {
        return null;
    }

    @Override
    public TrackedRace getTrackedRace(Competitor competitor) {
        return null;
    }

    @Override
    public RaceIdentifier getRaceIdentifier(Fleet fleet) {
        return null;
    }

    @Override
    public void setRaceIdentifier(Fleet fleet, RaceIdentifier raceIdentifier) {
    }

    @Override
    public boolean isMedalRace() {
        return false;
    }

    @Override
    public boolean isOneAlwaysStaysOne() {
        return false;
    }

    @Override
    public void releaseTrackedRace(Fleet fleet) {
    }

    @Override
    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.getRaceColumnListeners().notifyListenersAboutTrackedRaceLinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
        this.getRaceColumnListeners().notifyListenersAboutTrackedRaceUnlinked(raceColumn, fleet, trackedRace);
    }

    @Override
    public void isMedalRaceChanged(RaceColumn raceColumn, boolean newIsMedalRace) {
        this.getRaceColumnListeners().notifyListenersAboutIsMedalRaceChanged(raceColumn, newIsMedalRace);
    }

    @Override
    public void isFleetsCanRunInParallelChanged(RaceColumn raceColumn, boolean newIsFleetsCanRunInParallel) {
        this.getRaceColumnListeners().notifyListenersAboutIsFleetsCanRunInParallelChanged(raceColumn, newIsFleetsCanRunInParallel);
    }

    @Override
    public void isStartsWithZeroScoreChanged(RaceColumn raceColumn, boolean newIsStartsWithZeroScore) {
        this.getRaceColumnListeners().notifyListenersAboutIsStartsWithZeroScoreChanged(raceColumn, newIsStartsWithZeroScore);
    }

    @Override
    public void isFirstColumnIsNonDiscardableCarryForwardChanged(RaceColumn raceColumn, boolean firstColumnIsNonDiscardableCarryForward) {
        this.getRaceColumnListeners().notifyListenersAboutIsFirstColumnIsNonDiscardableCarryForwardChanged(raceColumn, firstColumnIsNonDiscardableCarryForward);
    }

    @Override
    public void hasSplitFleetContiguousScoringChanged(RaceColumn raceColumn, boolean hasSplitFleetContiguousScoring) {
        this.getRaceColumnListeners().notifyListenersAboutHasSplitFleetContiguousScoringChanged(raceColumn, hasSplitFleetContiguousScoring);
    }

    @Override
    public void hasCrossFleetMergedRankingChanged(RaceColumn raceColumn, boolean hasCrossFleetMergedRanking) {
        this.getRaceColumnListeners().notifyListenersAboutHasCrossFleetMergedRankingChanged(raceColumn, hasCrossFleetMergedRanking);
    }

    @Override
    public void oneAlwaysStaysOneChanged(RaceColumn raceColumn, boolean oneAlwaysStaysOne) {
        this.getRaceColumnListeners().notifyListenersAboutOneAlwaysStaysOneChanged(raceColumn, oneAlwaysStaysOne);
    }

    @Override
    public boolean canAddRaceColumnToContainer(RaceColumn raceColumn) {
        return this.getRaceColumnListeners().canAddRaceColumnToContainer(raceColumn);
    }

    @Override
    public void raceColumnAddedToContainer(RaceColumn raceColumn) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnAddedToContainer(raceColumn);
    }

    @Override
    public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnRemovedFromContainer(raceColumn);
    }

    @Override
    public void raceColumnMoved(RaceColumn raceColumn, int newIndex) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnMoved(raceColumn, newIndex);
    }

    @Override
    public void raceColumnNameChanged(RaceColumn raceColumn, String oldName, String newName) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnNameChanged(raceColumn, oldName, newName);
    }

    @Override
    public void factorChanged(RaceColumn raceColumn, Double oldFactor, Double newFactor) {
        this.getRaceColumnListeners().notifyListenersAboutFactorChanged(raceColumn, oldFactor, newFactor);
    }

    @Override
    public void competitorDisplayNameChanged(Competitor competitor, String oldDisplayName, String displayName) {
        this.getRaceColumnListeners().notifyListenersAboutCompetitorDisplayNameChanged(competitor, oldDisplayName, displayName);
    }

    @Override
    public void resultDiscardingRuleChanged(ResultDiscardingRule oldDiscardingRule, ResultDiscardingRule newDiscardingRule) {
        this.getRaceColumnListeners().notifyListenersAboutResultDiscardingRuleChanged(oldDiscardingRule, newDiscardingRule);
    }

    @Override
    public void maximumNumberOfDiscardsChanged(Integer oldMaximumNumberOfDiscards, Integer newMaximumNumberOfDiscards) {
        this.getRaceColumnListeners().notifyListenersAboutMaximumNumberOfDiscardsChanged(oldMaximumNumberOfDiscards, newMaximumNumberOfDiscards);
    }

    @Override
    public void raceLogEventAdded(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        this.getRaceColumnListeners().notifyListenersAboutRaceLogEventAdded(raceColumn, raceLogIdentifier, event);
    }

    @Override
    public boolean isTransient() {
        return false;
    }

    @Override
    public RaceLogIdentifier getRaceLogIdentifier(Fleet fleet) {
        return null;
    }

    @Override
    public void removeRaceIdentifier(Fleet fleet) {
    }

    @Override
    public void setMasterDataExportOngoingThreadFlag(boolean flagValue) {
    }

    @Override
    public void setRaceLogInformationAndLoad(RaceLogStore raceLogStore, RegattaLikeIdentifier regattaLikeParent) {
    }

    @Override
    public void setRaceLogInformation(RaceLogStore raceLogStore, RegattaLikeIdentifier regattaLikeParent) {
    }

    @Override
    public void reloadRaceLog(Fleet fleet) {
    }

    @Override
    public RaceExecutionOrderProvider getRaceExecutionOrderProvider() {
        return null;
    }

    @Override
    public Iterable<Competitor> getAllCompetitors() {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered().getB();
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        return this.leaderboard.getAllCompetitorsWithRaceDefinitionsConsidered();
    }

    @Override
    public Iterable<Competitor> getAllCompetitors(Fleet fleet) {
        Iterable<Competitor> result = fleet == this.metaFleet ? this.leaderboard.getAllCompetitors() : Collections.emptySet();
        return result;
    }

    @Override
    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats() {
        return Collections.emptyMap();
    }

    @Override
    public Map<Competitor, Boat> getAllCompetitorsAndTheirBoats(Fleet fleet) {
        return Collections.emptyMap();
    }

    @Override
    public RegattaLog getRegattaLog() {
        return null;
    }

    @Override
    public Iterable<Mark> getCourseMarks() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<Mark> getCourseMarks(Fleet fleet) {
        return Collections.emptySet();
    }

    @Override
    public Iterable<Mark> getAvailableMarks() {
        return Collections.emptySet();
    }

    @Override
    public Iterable<Mark> getAvailableMarks(Fleet fleet) {
        return Collections.emptySet();
    }

    @Override
    public void registerCompetitor(CompetitorWithBoat competitorWithBoat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void registerCompetitors(Iterable<CompetitorWithBoat> competitorsWithBoat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void registerCompetitor(Competitor competitor, Boat boat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void registerCompetitors(Map<Competitor, Boat> competitorsAndBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void deregisterCompetitor(Competitor competitors, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void deregisterCompetitors(Iterable<? extends Competitor> competitors, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        throw new CompetitorRegistrationOnRaceLogDisabledException();
    }

    @Override
    public void enableCompetitorRegistrationOnRaceLog(Fleet fleetByName) {
    }

    @Override
    public void disableCompetitorRegistrationOnRaceLog(Fleet fleetByName) {
    }

    public void displayNameChanged(String oldDisplayName, String newDisplayName) {
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnNameChanged(this, oldDisplayName, newDisplayName);
    }
}

