/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.meta;

import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupListener;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.meta.AbstractMetaLeaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.util.Collections;

public class LeaderboardGroupMetaLeaderboard
extends AbstractMetaLeaderboard
implements LeaderboardGroupListener,
RaceColumnListener {
    private static final long serialVersionUID = 8087872002175528002L;
    private final LeaderboardGroup leaderboardGroup;

    public LeaderboardGroupMetaLeaderboard(LeaderboardGroup leaderboardGroup, ScoringScheme scoringScheme, ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        super(LeaderboardGroupMetaLeaderboard.getOverallLeaderboardName(leaderboardGroup.getName()), scoringScheme, resultDiscardingRule);
        this.leaderboardGroup = leaderboardGroup;
        leaderboardGroup.addLeaderboardGroupListener(this);
        this.registerAsScoreCorrectionChangeForwarderAndRaceColumnListenerOnAllLeaderboards();
    }

    public static String getOverallLeaderboardName(String leaderboardGroupName) {
        return String.valueOf(leaderboardGroupName) + " " + "Overall";
    }

    public void registerAsScoreCorrectionChangeForwarderAndRaceColumnListenerOnAllLeaderboards() {
        for (Leaderboard leaderboard : this.leaderboardGroup.getLeaderboards()) {
            this.registerScoreCorrectionAndRaceColumnChangeForwarder(leaderboard);
        }
    }

    @Override
    public Iterable<Leaderboard> getLeaderboards() {
        return this.leaderboardGroup.getLeaderboards();
    }

    @Override
    public void leaderboardAdded(LeaderboardGroup group, Leaderboard leaderboard) {
        this.registerScoreCorrectionAndRaceColumnChangeForwarder(leaderboard);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace == null) continue;
                this.getRaceColumnListeners().notifyListenersAboutTrackedRaceLinked(raceColumn, fleet, trackedRace);
            }
        }
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnAddedToContainer(this.getColumnForLeaderboard(leaderboard));
    }

    @Override
    public void leaderboardRemoved(LeaderboardGroup group, Leaderboard leaderboard) {
        leaderboard.removeRaceColumnListener(this);
        this.unregisterScoreCorrectionChangeForwarder(leaderboard);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace == null) continue;
                this.getRaceColumnListeners().notifyListenersAboutTrackedRaceUnlinked(raceColumn, fleet, trackedRace);
            }
        }
        this.getRaceColumnListeners().notifyListenersAboutRaceColumnRemovedFromContainer(this.getColumnForLeaderboard(leaderboard));
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return Collections.emptySet();
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return LeaderboardType.RegattaMetaLeaderboard;
    }
}

