/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.meta;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.impl.FleetImpl;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.MetaLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractSimpleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.meta.MetaLeaderboardColumn;
import com.sap.sailing.domain.leaderboard.meta.MetaLeaderboardScoreCorrection;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.ObscuringIterable;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.metering.CPUMeter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class AbstractMetaLeaderboard
extends AbstractSimpleLeaderboardImpl
implements MetaLeaderboard {
    private static final long serialVersionUID = 2368754404068836260L;
    private final Fleet metaFleet;
    private final ScoringScheme scoringScheme;
    private final String name;
    private transient WeakHashMap<Leaderboard, MetaLeaderboardColumn> columnsForLeaderboards;
    private transient WeakHashMap<Leaderboard, ScoreCorrectionListener> scoreCorrectionChangeForwardersByLeaderboard;
    private transient CPUMeter cpuMeter = CPUMeter.create();

    public AbstractMetaLeaderboard(String name, ScoringScheme scoringScheme, ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        super(resultDiscardingRule);
        this.metaFleet = new FleetImpl("MetaFleet");
        this.scoringScheme = scoringScheme;
        this.name = name;
        this.columnsForLeaderboards = new WeakHashMap();
        this.scoreCorrectionChangeForwardersByLeaderboard = new WeakHashMap();
    }

    public CPUMeter getCPUMeter() {
        return this.cpuMeter;
    }

    @Override
    protected SettableScoreCorrection createScoreCorrection() {
        return new MetaLeaderboardScoreCorrection(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(new HashMap<Leaderboard, MetaLeaderboardColumn>(this.columnsForLeaderboards));
        oos.writeObject(new HashMap<Leaderboard, ScoreCorrectionListener>(this.scoreCorrectionChangeForwardersByLeaderboard));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.cpuMeter = CPUMeter.create();
        Map columnsForLeaderboardAsStrongMap = (Map)ois.readObject();
        this.columnsForLeaderboards = new WeakHashMap(columnsForLeaderboardAsStrongMap);
        Map scoreCorrectionChangeForwardersByLeaderboardAsStrongMap = (Map)ois.readObject();
        this.scoreCorrectionChangeForwardersByLeaderboard = new WeakHashMap(scoreCorrectionChangeForwardersByLeaderboardAsStrongMap);
    }

    @Override
    public abstract Iterable<Leaderboard> getLeaderboards();

    @Override
    public MetaLeaderboardScoreCorrection getScoreCorrection() {
        return (MetaLeaderboardScoreCorrection)super.getScoreCorrection();
    }

    @Override
    public Iterable<Boat> getAllBoats() {
        HashSet<Boat> boats = new HashSet<Boat>();
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            for (Boat boat : leaderboard.getAllBoats()) {
                boats.add(boat);
            }
        }
        return boats;
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        HashSet competitors = new HashSet();
        HashSet raceDefinitionsConsidered = new HashSet();
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> allCompetitorsFromLeaderboardWithRaceDefinitionsConsidered = leaderboard.getAllCompetitorsWithRaceDefinitionsConsidered();
            Util.addAll((Iterable)((Iterable)allCompetitorsFromLeaderboardWithRaceDefinitionsConsidered.getA()), raceDefinitionsConsidered);
            Util.addAll((Iterable)((Iterable)allCompetitorsFromLeaderboardWithRaceDefinitionsConsidered.getB()), competitors);
        }
        return new Util.Pair(raceDefinitionsConsidered, competitors);
    }

    @Override
    public Iterable<Competitor> getAllCompetitors(RaceColumn raceColumn, Fleet fleet) {
        Iterable<Competitor> result = fleet == this.metaFleet && Util.contains(this.getRaceColumns(), (Object)raceColumn) ? ((MetaLeaderboardColumn)raceColumn).getAllCompetitors() : Collections.emptySet();
        return result;
    }

    @Override
    public Boat getBoatOfCompetitor(Competitor competitor, RaceColumn raceColumn, Fleet fleet) {
        return null;
    }

    @Override
    public Fleet getFleet(String fleetName) {
        return fleetName.equals(this.metaFleet.getName()) ? this.metaFleet : null;
    }

    @Override
    public int getTrackedRank(Competitor competitor, RaceColumn race, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result;
        Leaderboard leaderboard = ((MetaLeaderboardColumn)race).getLeaderboard();
        if (leaderboard.hasScores(competitor, timePoint)) {
            Iterable<Competitor> competitorsFromBestToWorst = leaderboard.getCompetitorsFromBestToWorst(timePoint, cache);
            result = Util.indexOf((Iterable)new ObscuringIterable(competitorsFromBestToWorst, this.getSuppressedCompetitors()), (Object)competitor) + 1;
        } else {
            result = 0;
        }
        return result;
    }

    @Override
    public Iterable<RaceColumn> getRaceColumns() {
        ArrayList<RaceColumn> result = new ArrayList<RaceColumn>(Util.size(this.getLeaderboards()));
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            result.add(this.getColumnForLeaderboard(leaderboard));
        }
        return result;
    }

    protected MetaLeaderboardColumn getColumnForLeaderboard(Leaderboard leaderboard) {
        MetaLeaderboardColumn result = this.columnsForLeaderboards.get(leaderboard);
        if (result == null) {
            result = new MetaLeaderboardColumn(leaderboard, this.metaFleet);
            result.addRaceColumnListener(this);
            this.columnsForLeaderboards.put(leaderboard, result);
        }
        return result;
    }

    protected void registerScoreCorrectionAndRaceColumnChangeForwarder(Leaderboard leaderboard) {
        leaderboard.addRaceColumnListener(this);
        ScoreCorrectionChangeForwarder listener = new ScoreCorrectionChangeForwarder();
        this.scoreCorrectionChangeForwardersByLeaderboard.put(leaderboard, listener);
        leaderboard.addScoreCorrectionListener(listener);
    }

    protected void unregisterScoreCorrectionChangeForwarder(Leaderboard leaderboard) {
        leaderboard.getScoreCorrection().removeScoreCorrectionListener(this.scoreCorrectionChangeForwardersByLeaderboard.get(leaderboard));
    }

    @Override
    public Competitor getCompetitorByIdAsString(String idAsString) {
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            Competitor result = leaderboard.getCompetitorByIdAsString(idAsString);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public Long getDelayToLiveInMillis() {
        int i = Util.size(this.getLeaderboards()) - 1;
        while (i >= 0) {
            Long result = ((Leaderboard)Util.get(this.getLeaderboards(), (int)i)).getDelayToLiveInMillis();
            if (result != null) {
                return result;
            }
            --i;
        }
        return null;
    }

    @Override
    public Iterable<TrackedRace> getTrackedRaces() {
        HashSet<TrackedRace> result = new HashSet<TrackedRace>();
        for (Leaderboard leaderboard : this.getLeaderboards()) {
            Util.addAll(leaderboard.getTrackedRaces(), result);
        }
        return result;
    }

    @Override
    public ScoringScheme getScoringScheme() {
        return this.scoringScheme;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean isResultsAreOfficial(RaceColumn raceColumn, Fleet fleet) {
        if (!(raceColumn instanceof MetaLeaderboardColumn)) {
            throw new IllegalArgumentException("Expected a MetaLeaderboardColumn in a MetaLeaderboard but got " + raceColumn.getClass());
        }
        MetaLeaderboardColumn metaRaceColumn = (MetaLeaderboardColumn)raceColumn;
        Leaderboard leaderboard = metaRaceColumn.getLeaderboard();
        for (RaceColumn raceColumnLeaderboardRaceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet2 : raceColumnLeaderboardRaceColumn.getFleets()) {
                if (leaderboard.isResultsAreOfficial(raceColumnLeaderboardRaceColumn, fleet2)) continue;
                return false;
            }
        }
        return true;
    }

    private class ScoreCorrectionChangeForwarder
    implements ScoreCorrectionListener,
    Serializable {
        private static final long serialVersionUID = 915433462154943441L;

        private ScoreCorrectionChangeForwarder() {
        }

        @Override
        public void correctedScoreChanged(Competitor competitor, RaceColumn raceColumn, Double oldCorrectedScore, Double newCorrectedScore) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListeners(competitor, raceColumn, oldCorrectedScore, newCorrectedScore);
        }

        @Override
        public void incrementalScoreCorrectionChanged(Competitor competitor, RaceColumn raceColumn, Double oldScoreOffsetInPoints, Double newScoreOffsetInPoints) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListenersAboutIncrementalScoreChange(competitor, raceColumn, oldScoreOffsetInPoints, newScoreOffsetInPoints);
        }

        @Override
        public void maxPointsReasonChanged(Competitor competitor, RaceColumn raceColumn, MaxPointsReason oldMaxPointsReason, MaxPointsReason newMaxPointsReason) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListeners(competitor, raceColumn, oldMaxPointsReason, newMaxPointsReason);
        }

        @Override
        public void carriedPointsChanged(Competitor competitor, Double oldCarriedPoints, Double newCarriedPoints) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListenersAboutCarriedPointsChange(competitor, oldCarriedPoints, newCarriedPoints);
        }

        @Override
        public void isSuppressedChanged(Competitor competitor, boolean newIsSuppressed) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListenersAboutIsSuppressedChange(competitor, newIsSuppressed);
        }

        @Override
        public void timePointOfLastCorrectionsValidityChanged(TimePoint oldTimePointOfLastCorrectionsValidity, TimePoint newTimePointOfLastCorrectionsValidity) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListenersAboutLastCorrectionsValidityChanged(oldTimePointOfLastCorrectionsValidity, newTimePointOfLastCorrectionsValidity);
        }

        @Override
        public void commentChanged(String oldComment, String newComment) {
            AbstractMetaLeaderboard.this.getScoreCorrection().notifyListenersAboutCommentChanged(oldComment, newComment);
        }
    }
}

