/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sse.common.Util;
import java.util.Comparator;

public class LowPointTieBreakBasedOnLastSeriesOnly
extends LowPoint {
    private static final long serialVersionUID = -2837189757937229157L;

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_TIE_BREAK_BASED_ON_LAST_SERIES_ONLY;
    }

    @Override
    protected Comparator<Util.Pair<RaceColumn, Double>> getRuleA8_1ScoreComparator(boolean nullScoresAreBetter) {
        return (p1, p2) -> {
            int result = this.isFromLastNonMedalSeries((Util.Pair<RaceColumn, Double>)p1) != this.isFromLastNonMedalSeries((Util.Pair<RaceColumn, Double>)p2) ? (this.isFromLastNonMedalSeries((Util.Pair<RaceColumn, Double>)p1) ? -1 : 1) : this.getScoreComparator(nullScoresAreBetter).compare((Double)p1.getB(), (Double)p2.getB());
            return result;
        };
    }

    @Override
    protected boolean isConsiderDiscardedScoresDuringBetterScoreTieBreak() {
        return true;
    }

    private boolean isFromLastNonMedalSeries(Util.Pair<RaceColumn, Double> raceColumnAndNetPoints) {
        boolean result;
        RaceColumn raceColumn = (RaceColumn)raceColumnAndNetPoints.getA();
        if (raceColumn instanceof RaceColumnInSeries) {
            Series series = ((RaceColumnInSeries)raceColumn).getSeries();
            Regatta regatta = series.getRegatta();
            boolean found = false;
            boolean lastNonMedal = true;
            for (Series series2 : regatta.getSeries()) {
                if (!found) {
                    if (series2 != series) continue;
                    found = true;
                    continue;
                }
                if (series2.isMedal()) continue;
                lastNonMedal = false;
            }
            assert (found);
            result = lastNonMedal;
        } else {
            result = !raceColumn.isMedalRace();
        }
        return result;
    }
}

