/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.leaderboard.impl.AbstractSimpleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardTotalRankComparator;
import com.sap.sailing.domain.leaderboard.impl.LowPoint;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Logger;

public class LowPointFirstToWinThreeRaces
extends LowPoint {
    private static final Logger logger = Logger.getLogger(LowPointFirstToWinThreeRaces.class.getName());
    private static final long serialVersionUID = 7072175334160798617L;

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT_FIRST_TO_WIN_THREE_RACES;
    }

    @Override
    public boolean isMedalWinAmountCriteria() {
        return true;
    }

    @Override
    public int compareByMedalRacesWon(int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        return 0;
    }

    @Override
    public int compareByLastMedalRacesCriteria(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, boolean nullScoresAreBetter, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache, TimePoint timePoint, int zeroBasedIndexOfLastMedalSeriesInWhichBothScored, int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        int result;
        if (zeroBasedIndexOfLastMedalSeriesInWhichBothScored < 0) {
            result = 0;
        } else if (!(leaderboard instanceof RegattaLeaderboard)) {
            result = 0;
        } else {
            Regatta regatta = ((RegattaLeaderboard)leaderboard).getRegatta();
            Series medalSeriesInWhichBothScored = (Series)Util.get(regatta.getSeries(), (int)zeroBasedIndexOfLastMedalSeriesInWhichBothScored);
            assert (medalSeriesInWhichBothScored.isMedal());
            RaceColumn firstNonCarryRaceColumnInMedalSeries = (RaceColumn)Util.first((Iterable)Util.filter(medalSeriesInWhichBothScored.getRaceColumns(), rc -> !rc.isCarryForward()));
            Fleet o1MedalFleet = firstNonCarryRaceColumnInMedalSeries.getFleetOfCompetitor(o1);
            Fleet o2MedalFleet = firstNonCarryRaceColumnInMedalSeries.getFleetOfCompetitor(o2);
            Supplier<LeaderboardTotalRankComparator> openingSeriesTotalRankComparator = () -> this.getOpeningSeriesRankComparator(raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, totalPointsSupplier, cache);
            if (o1MedalFleet == o2MedalFleet) {
                result = this.compareByInMedalSeriesFleetRules(o1, o2, totalPointsSupplier, medalSeriesInWhichBothScored, openingSeriesTotalRankComparator, nullScoresAreBetter, leaderboard, timePoint, cache);
            } else {
                if (o1MedalFleet == null) {
                    result = 1;
                    logger.warning("Competitor " + o1.getName() + " has a score in medal series " + medalSeriesInWhichBothScored.getName() + " but is not assigned to a fleet; ranking worse than " + o2.getName());
                } else if (o2MedalFleet == null) {
                    result = -1;
                    logger.warning("Competitor " + o2.getName() + " has a score in medal series " + medalSeriesInWhichBothScored.getName() + " but is not assigned to a fleet; ranking worse than " + o1.getName());
                } else {
                    int o1RankInMedalSeriesFleet = this.getRankInMedalSeriesFleet(medalSeriesInWhichBothScored, o1MedalFleet, totalPointsSupplier, o1, openingSeriesTotalRankComparator, firstNonCarryRaceColumnInMedalSeries, nullScoresAreBetter, leaderboard, timePoint, cache);
                    int o2RankInMedalSeriesFleet = this.getRankInMedalSeriesFleet(medalSeriesInWhichBothScored, o2MedalFleet, totalPointsSupplier, o2, openingSeriesTotalRankComparator, firstNonCarryRaceColumnInMedalSeries, nullScoresAreBetter, leaderboard, timePoint, cache);
                    result = Integer.compare(o1RankInMedalSeriesFleet, o2RankInMedalSeriesFleet);
                }
                if (result == 0) {
                    result = openingSeriesTotalRankComparator.get().compare(o1, o2);
                }
            }
        }
        return result;
    }

    private int getRankInMedalSeriesFleet(Series medalSeries, Fleet medalFleet, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, Competitor competitor, Supplier<LeaderboardTotalRankComparator> openingSeriesTotalRankComparator, RaceColumn firstNonCarryRaceColumnInMedalSeries, boolean nullScoresAreBetter, Leaderboard leaderboard, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        List competitorsInMedalFleet = Util.asList(firstNonCarryRaceColumnInMedalSeries.getAllCompetitors(medalFleet));
        competitorsInMedalFleet.sort((c1, c2) -> this.compareByInMedalSeriesFleetRules((Competitor)c1, (Competitor)c2, totalPointsSupplier, medalSeries, openingSeriesTotalRankComparator, nullScoresAreBetter, leaderboard, timePoint, cache));
        return competitorsInMedalFleet.indexOf(competitor) + 1;
    }

    private int compareByInMedalSeriesFleetRules(Competitor o1, Competitor o2, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, Series medalSeriesInWhichBothScored, Supplier<LeaderboardTotalRankComparator> openingSeriesTotalRankComparator, boolean nullScoresAreBetter, Leaderboard leaderboard, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result;
        int numberOfMedalRacesWonO2;
        int numberOfMedalRacesWonO1 = Util.stream(medalSeriesInWhichBothScored.getRaceColumns()).mapToInt(raceColumn -> this.getWinCount(leaderboard, o1, (RaceColumn)raceColumn, (Double)totalPointsSupplier.apply(o1, (RaceColumn)raceColumn), timePoint, c -> (Double)totalPointsSupplier.apply((Competitor)c, (RaceColumn)raceColumn), cache)).sum();
        if (numberOfMedalRacesWonO1 != (numberOfMedalRacesWonO2 = Util.stream(medalSeriesInWhichBothScored.getRaceColumns()).mapToInt(raceColumn -> this.getWinCount(leaderboard, o2, (RaceColumn)raceColumn, (Double)totalPointsSupplier.apply(o2, (RaceColumn)raceColumn), timePoint, c -> (Double)totalPointsSupplier.apply((Competitor)c, (RaceColumn)raceColumn), cache)).sum())) {
            result = Integer.compare(numberOfMedalRacesWonO2, numberOfMedalRacesWonO1);
        } else {
            result = this.compareByScoresFromLastToFirstRace(medalSeriesInWhichBothScored.getRaceColumns(), o1, o2, totalPointsSupplier, nullScoresAreBetter);
            if (result == 0) {
                result = openingSeriesTotalRankComparator.get().compare(o1, o2);
            }
        }
        return result;
    }

    private int compareByScoresFromLastToFirstRace(Iterable<? extends RaceColumnInSeries> raceColumns, Competitor o1, Competitor o2, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, boolean nullScoresAreBetter) {
        assert (Util.stream(raceColumns).allMatch(rc -> rc.getFleetOfCompetitor(o1) == rc.getFleetOfCompetitor(o2)));
        List medalRaceRolumnsWithReverseOrdering = Util.asList(raceColumns);
        Collections.reverse(medalRaceRolumnsWithReverseOrdering);
        int result = 0;
        for (RaceColumnInSeries raceColumn : medalRaceRolumnsWithReverseOrdering) {
            Double o1Score = totalPointsSupplier.apply(o1, raceColumn);
            Double o2Score = totalPointsSupplier.apply(o2, raceColumn);
            result = this.getScoreComparator(nullScoresAreBetter).compare(o1Score, o2Score);
            if (result != 0) break;
        }
        return result;
    }

    @Override
    public Double getNetPointsForScoreSum(AbstractSimpleLeaderboardImpl leaderboard, Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        LeaderboardDTOCalculationReuseCache cache;
        Double netPoints = super.getNetPointsForScoreSum(leaderboard, competitor, raceColumn, timePoint, discardedRaceColumns);
        Double result = netPoints != null && raceColumn.isMedalRace() && !raceColumn.isCarryForward() ? Double.valueOf(this.isWin(leaderboard, competitor, raceColumn, timePoint, arg_0 -> LowPointFirstToWinThreeRaces.lambda$8(leaderboard, raceColumn, timePoint, cache = new LeaderboardDTOCalculationReuseCache(timePoint), arg_0), cache) ? 1.0 : 0.0) : netPoints;
        return result;
    }

    @Override
    public int compareByNumberOfRacesScored(int competitor1NumberOfRacesScored, int competitor2NumberOfRacesScored) {
        return 0;
    }

    @Override
    public double getScoreFactor(RaceColumn raceColumn) {
        Double factor = raceColumn.getExplicitFactor();
        if (factor == null) {
            factor = 1.0;
        }
        return factor;
    }

    @Override
    public int getWinCount(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, Double totalPoints, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Integer winCount = raceColumn.isCarryForward() ? Integer.valueOf(totalPoints == null ? 0 : totalPoints.intValue()) : Integer.valueOf(super.getWinCount(leaderboard, competitor, raceColumn, totalPoints, timePoint, totalPointsSupplier, cache));
        return winCount;
    }

    @Override
    public boolean isWin(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Fleet fleetOfCompetitor = raceColumn.getFleetOfCompetitor(competitor);
        Double competitorTotalPoints = totalPointsSupplier.apply(competitor);
        Comparator<Double> scoreComparator = this.getScoreComparator(false);
        for (Competitor otherCompetitor : leaderboard.getCompetitors()) {
            int finishingOrderCompareResult;
            if (otherCompetitor == competitor || raceColumn.getFleetOfCompetitor(otherCompetitor) != fleetOfCompetitor) continue;
            int totalPointsCompareResult = scoreComparator.compare(competitorTotalPoints, totalPointsSupplier.apply(otherCompetitor));
            if (totalPointsCompareResult > 0) {
                return false;
            }
            if (totalPointsCompareResult != 0 || (finishingOrderCompareResult = Integer.compare(leaderboard.getTrackedRank(competitor, raceColumn, timePoint, cache), leaderboard.getTrackedRank(otherCompetitor, raceColumn, timePoint, cache))) <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareByScoreSum(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, double o1ScoreSum, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, double o2ScoreSum, boolean nullScoresAreBetter, boolean haveValidMedalRaceScores, Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries) {
        return haveValidMedalRaceScores ? 0 : super.compareByScoreSum(o1, o1Scores, o1ScoreSum, o2, o2Scores, o2ScoreSum, nullScoresAreBetter, haveValidMedalRaceScores, competitorsRankedByOpeningSeries);
    }

    @Override
    public int compareByMedalRaceScore(Double o1MedalRaceScore, Double o2MedalRaceScore, boolean nullScoresAreBetter) {
        return 0;
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result;
        if (!this.hasMedalScores(o1Scores)) {
            result = this.compareByA81TieBreak(o1, o1Scores, o2, o2Scores, raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, discardedRaceColumnsPerCompetitor, totalPointsSupplier, cache);
        } else {
            LeaderboardTotalRankComparator openingSeriesRankComparator = this.getOpeningSeriesRankComparator(raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, totalPointsSupplier, cache);
            result = openingSeriesRankComparator.compare(o1, o2);
        }
        return result;
    }

    protected int compareByA81TieBreak(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return super.compareByBetterScore(o1, o1Scores, o2, o2Scores, raceColumnsToConsider, nullScoresAreBetter, timePoint, leaderboard, discardedRaceColumnsPerCompetitor, totalPointsSupplier, cache);
    }

    private boolean hasMedalScores(List<Util.Pair<RaceColumn, Double>> o1Scores) {
        return o1Scores.stream().anyMatch(p -> ((RaceColumn)p.getA()).isMedalRace() && p.getB() != null);
    }

    @Override
    public Double getPenaltyScore(RaceColumn raceColumn, Competitor competitor, MaxPointsReason maxPointsReason, Integer numberOfCompetitorsInRace, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, Leaderboard leaderboard, Supplier<Double> uncorrectedScoreProvider) {
        Double uncorrectedScore;
        Double result = (maxPointsReason == MaxPointsReason.STP || maxPointsReason == MaxPointsReason.SCP) && raceColumn.isMedalRace() ? ((uncorrectedScore = uncorrectedScoreProvider.get()) == null ? null : Double.valueOf(uncorrectedScore + 1.1)) : super.getPenaltyScore(raceColumn, competitor, maxPointsReason, numberOfCompetitorsInRace, numberOfCompetitorsInLeaderboardFetcher, timePoint, leaderboard, uncorrectedScoreProvider);
        return result;
    }

    private static /* synthetic */ Double lambda$8(AbstractSimpleLeaderboardImpl abstractSimpleLeaderboardImpl, RaceColumn raceColumn, TimePoint timePoint, LeaderboardDTOCalculationReuseCache leaderboardDTOCalculationReuseCache, Competitor c) {
        return abstractSimpleLeaderboardImpl.getTotalPoints(c, raceColumn, timePoint, leaderboardDTOCalculationReuseCache);
    }
}

