/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.AbstractScoringSchemeImpl;
import com.sap.sse.common.TimePoint;
import java.util.concurrent.Callable;
import java.util.function.Supplier;

public class LowPoint
extends AbstractScoringSchemeImpl {
    private static final long serialVersionUID = -2767385186133743330L;

    public LowPoint() {
        super(false);
    }

    @Override
    public Double getScoreForRank(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, int rank, Callable<Integer> numberOfCompetitorsInRaceFetcher, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint) {
        int effectiveRank = this.getEffectiveRank(raceColumn, competitor, rank);
        Double result = effectiveRank == 0 ? null : Double.valueOf(effectiveRank);
        return result;
    }

    protected int getEffectiveRank(RaceColumn raceColumn, Competitor competitor, int rank) {
        int competitorFleetOrdering;
        int effectiveRank;
        if (rank == 0) {
            effectiveRank = 0;
        } else if (raceColumn.hasSplitFleetContiguousScoring() && (competitorFleetOrdering = raceColumn.getFleetOfCompetitor(competitor).getOrdering()) != 0) {
            int numberOfCompetitorsInBetterFleets = this.getNumberOfCompetitorsInBetterFleets(raceColumn, competitorFleetOrdering);
            effectiveRank = rank + numberOfCompetitorsInBetterFleets;
        } else {
            effectiveRank = rank;
        }
        return effectiveRank;
    }

    @Override
    public Double getPenaltyScore(RaceColumn raceColumn, Competitor competitor, MaxPointsReason maxPointsReason, Integer numberOfCompetitorsInRace, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, Leaderboard leaderboard, Supplier<Double> uncorrectedScoreProvider) {
        Double uncorrectedScore;
        Double result = maxPointsReason == MaxPointsReason.STP ? ((uncorrectedScore = uncorrectedScoreProvider.get()) == null ? null : Double.valueOf(uncorrectedScore + 1.0)) : (numberOfCompetitorsInRace == null || raceColumn.hasSplitFleetContiguousScoring() ? Double.valueOf(numberOfCompetitorsInLeaderboardFetcher.getNumberOfCompetitorsInLeaderboard() + 1) : Double.valueOf(numberOfCompetitorsInRace + 1));
        return result;
    }

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.LOW_POINT;
    }

    @Override
    public boolean isValidInNetScore(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, TimePoint at) {
        return true;
    }

    @Override
    public int compareByNumberOfRacesScored(int competitor1NumberOfRacesScored, int competitor2NumberOfRacesScored) {
        return (int)Math.signum(competitor2NumberOfRacesScored) - (int)Math.signum(competitor1NumberOfRacesScored);
    }
}

