/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.impl.HighPointFirstGetsFixedScore;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.graph.DirectedEdge;
import com.sap.sse.util.graph.DirectedGraph;
import com.sap.sse.util.topologicalordering.TopologicalComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class HighPointFirstGets1LastBreaksTie
extends HighPointFirstGetsFixedScore {
    private static final long serialVersionUID = 1L;

    public HighPointFirstGets1LastBreaksTie() {
        super(1.0, 0.0);
    }

    @Override
    public ScoringSchemeType getType() {
        return ScoringSchemeType.HIGH_POINT_FIRST_GETS_ONE;
    }

    @Override
    public Double getPenaltyScore(RaceColumn raceColumn, Competitor competitor, MaxPointsReason maxPointsReason, Integer numberOfCompetitorsInRace, NumberOfCompetitorsInLeaderboardFetcher numberOfCompetitorsInLeaderboardFetcher, TimePoint timePoint, Leaderboard leaderboard, Supplier<Double> uncorrectedScoreProvider) {
        return -1.0;
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Double o1NetPoints = leaderboard.getNetPoints(o1, raceColumnsToConsider, timePoint);
        Double o2NetPoints = leaderboard.getNetPoints(o2, raceColumnsToConsider, timePoint);
        assert (Math.abs(o1NetPoints - o2NetPoints) < 1.0E-5);
        HashSet<Competitor> nodesInGraph = new HashSet<Competitor>();
        nodesInGraph.add(o1);
        nodesInGraph.add(o2);
        for (Competitor c : leaderboard.getCompetitors()) {
            if (!leaderboard.getNetPoints(c, raceColumnsToConsider, timePoint).equals(o1NetPoints)) continue;
            nodesInGraph.add(c);
        }
        Set<DirectedEdge<Competitor>> edges = this.constructEdges(nodesInGraph, leaderboard, raceColumnsToConsider, timePoint, nullScoresAreBetter);
        DirectedGraph graph = DirectedGraph.create(nodesInGraph, edges);
        TopologicalComparator comparator = new TopologicalComparator(graph);
        int resultBasedOnGraphSort = comparator.compare((Object)o1, (Object)o2);
        int result = resultBasedOnGraphSort == 0 && graph.areOnSameCycleCluster((Object)o1, (Object)o2) && graph.getCycleCluster((Object)o1).getClusterNodes().size() == 2 ? this.compareByDirectComparison(o1Scores, o1, o2Scores, o2, nullScoresAreBetter, timePoint) : resultBasedOnGraphSort;
        return result;
    }

    private int compareByDirectComparison(List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o1, List<Util.Pair<RaceColumn, Double>> o2Scores, Competitor o2, boolean nullScoresAreBetter, TimePoint timePoint) {
        int lastDirectComparison = 0;
        Comparator<Double> pureScoreComparator = this.getScoreComparator(nullScoresAreBetter);
        Iterator<Util.Pair<RaceColumn, Double>> o1Iter = o1Scores.iterator();
        double o1DirectComparisonScore = 0.0;
        double o2DirectComparisonScore = 0.0;
        block0: while (o1Iter.hasNext()) {
            Util.Pair<RaceColumn, Double> o1Result = o1Iter.next();
            for (Util.Pair<RaceColumn, Double> o2Result : o2Scores) {
                if (o2Result.getA() != o1Result.getA() || ((RaceColumn)o2Result.getA()).getFleetOfCompetitor(o2) != ((RaceColumn)o1Result.getA()).getFleetOfCompetitor(o1)) continue;
                o1DirectComparisonScore += ((Double)o1Result.getB()).doubleValue();
                o2DirectComparisonScore += ((Double)o2Result.getB()).doubleValue();
                lastDirectComparison = pureScoreComparator.compare((Double)o1Result.getB(), (Double)o2Result.getB());
                continue block0;
            }
        }
        return o1DirectComparisonScore == o2DirectComparisonScore ? lastDirectComparison : pureScoreComparator.compare(o1DirectComparisonScore, o2DirectComparisonScore);
    }

    private Set<DirectedEdge<Competitor>> constructEdges(Set<Competitor> nodesInGraph, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint, boolean nullScoresAreBetter) {
        Comparator<Double> pureScoreComparator = this.getScoreComparator(nullScoresAreBetter);
        HashSet<DirectedEdge<Competitor>> edges = new HashSet<DirectedEdge<Competitor>>();
        for (RaceColumn raceColumn : raceColumnsToConsider) {
            for (Fleet fleet : raceColumn.getFleets()) {
                Iterable<Competitor> competitorsInRace = leaderboard.getCompetitors(raceColumn, fleet);
                HashSet equalRankedCompetitorsInRace = new HashSet();
                Util.addAll(competitorsInRace, equalRankedCompetitorsInRace);
                equalRankedCompetitorsInRace.retainAll(nodesInGraph);
                ArrayList competitorsInRaceOrderedByScoreInRace = new ArrayList(equalRankedCompetitorsInRace);
                Collections.sort(competitorsInRaceOrderedByScoreInRace, (c1, c2) -> pureScoreComparator.compare(leaderboard.getTotalPoints((Competitor)c1, raceColumn, timePoint), leaderboard.getTotalPoints((Competitor)c2, raceColumn, timePoint)));
                int i = 0;
                while (i < competitorsInRaceOrderedByScoreInRace.size()) {
                    int j = i + 1;
                    while (j < competitorsInRaceOrderedByScoreInRace.size()) {
                        if (pureScoreComparator.compare(leaderboard.getTotalPoints((Competitor)competitorsInRaceOrderedByScoreInRace.get(i), raceColumn, timePoint), leaderboard.getTotalPoints((Competitor)competitorsInRaceOrderedByScoreInRace.get(j), raceColumn, timePoint)) < 0) {
                            edges.add((DirectedEdge<Competitor>)DirectedEdge.create((Object)((Competitor)competitorsInRaceOrderedByScoreInRace.get(i)), (Object)((Competitor)competitorsInRaceOrderedByScoreInRace.get(j))));
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        return edges;
    }

    @Override
    public int compareByLastRace(List<Util.Pair<RaceColumn, Double>> o1ScoresIncludingDiscarded, List<Util.Pair<RaceColumn, Double>> o2ScoresIncludingDiscarded, boolean nullScoresAreBetter, Competitor o1, Competitor o2, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return 0;
    }
}

