/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.ResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.SettableScoreCorrection;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractLeaderboardWithCache;
import com.sap.sailing.domain.leaderboard.impl.CompetitorProviderFromRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.leaderboard.impl.DelegateLeaderboard;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.ObscuringIterable;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.metering.CPUMeter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;

public class DelegatingRegattaLeaderboardWithCompetitorElimination
extends AbstractLeaderboardWithCache
implements RegattaLeaderboardWithEliminations {
    private static final long serialVersionUID = 8331154893189722924L;
    private final String name;
    private final DelegateLeaderboard fullLeaderboard;
    private final ConcurrentHashMap<Competitor, Boolean> eliminatedCompetitors;

    public DelegatingRegattaLeaderboardWithCompetitorElimination(Supplier<RegattaLeaderboard> fullLeaderboardSupplier, String name) {
        this.name = name;
        this.eliminatedCompetitors = new ConcurrentHashMap();
        this.fullLeaderboard = new DelegateLeaderboard(fullLeaderboardSupplier);
    }

    public String getName() {
        return this.name;
    }

    public CPUMeter getCPUMeter() {
        return this.getDelegateLeaderboard().getCPUMeter();
    }

    private RegattaLeaderboard getDelegateLeaderboard() {
        return this.fullLeaderboard.getDelegateLeaderboard();
    }

    @Override
    public Iterable<Competitor> getCompetitors() {
        return new ObscuringIterable(this.getDelegateLeaderboard().getCompetitors(), (Iterable)this.eliminatedCompetitors.keySet());
    }

    @Override
    public void setEliminated(Competitor competitor, boolean eliminated) {
        if (eliminated) {
            this.eliminatedCompetitors.put(competitor, true);
        } else {
            this.eliminatedCompetitors.remove(competitor);
        }
        this.getLeaderboardDTOCache().invalidate(this);
    }

    @Override
    public boolean isEliminated(Competitor competitor) {
        return this.eliminatedCompetitors.containsKey(competitor);
    }

    @Override
    public Set<Competitor> getEliminatedCompetitors() {
        return new HashSet<Competitor>(this.eliminatedCompetitors.keySet());
    }

    @Override
    public Map<RaceColumn, List<Competitor>> getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NoWindException {
        Map<RaceColumn, List<Competitor>> preResult = this.getDelegateLeaderboard().getRankedCompetitorsFromBestToWorstAfterEachRaceColumn(timePoint, cache);
        for (List<Competitor> e : preResult.values()) {
            e.removeAll(this.eliminatedCompetitors.keySet());
        }
        return preResult;
    }

    @Override
    public Map<Competitor, Double> getCompetitorsForWhichThereAreCarriedPoints() {
        HashMap<Competitor, Double> result = new HashMap<Competitor, Double>();
        for (Map.Entry<Competitor, Double> e : this.getDelegateLeaderboard().getCompetitorsForWhichThereAreCarriedPoints().entrySet()) {
            if (this.isEliminated(e.getKey())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn raceColumn, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new ObscuringIterable(this.getDelegateLeaderboard().getCompetitorsFromBestToWorst(raceColumn, timePoint, cache), (Iterable)this.eliminatedCompetitors.keySet());
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new ObscuringIterable(this.getDelegateLeaderboard().getCompetitorsFromBestToWorst(timePoint, cache), (Iterable)this.eliminatedCompetitors.keySet());
    }

    @Override
    public Iterable<Competitor> getCompetitorsFromBestToWorst(RaceColumn raceColumn, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return new ObscuringIterable(this.getDelegateLeaderboard().getCompetitorsFromBestToWorst(raceColumn, timePoint, totalPointsSupplier, cache), (Iterable)this.eliminatedCompetitors.keySet());
    }

    @Override
    public Map<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry> getContent(TimePoint timePoint) throws NoWindException {
        HashMap<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry> result = new HashMap<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry>();
        for (Map.Entry<Util.Pair<Competitor, RaceColumn>, Leaderboard.Entry> e : this.getDelegateLeaderboard().getContent(timePoint).entrySet()) {
            if (this.isEliminated((Competitor)e.getKey().getA())) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    @Override
    public LeaderboardType getLeaderboardType() {
        return LeaderboardType.RegattaLeaderboardWithEliminations;
    }

    @Override
    public CompetitorProviderFromRaceColumnsAndRegattaLike getOrCreateCompetitorsProvider() {
        return this.getDelegateLeaderboard().getOrCreateCompetitorsProvider();
    }

    @Override
    public Regatta getRegatta() {
        return this.getDelegateLeaderboard().getRegatta();
    }

    @Override
    public Iterable<Competitor> getCompetitorsRegisteredInRegattaLog() {
        return this.getDelegateLeaderboard().getCompetitorsRegisteredInRegattaLog();
    }

    @Override
    public IsRegattaLike getRegattaLike() {
        return this.getDelegateLeaderboard().getRegattaLike();
    }

    @Override
    public RaceLog getRacelog(String raceColumnName, String fleetName) {
        return this.getDelegateLeaderboard().getRacelog(raceColumnName, fleetName);
    }

    @Override
    public void registerCompetitor(Competitor competitor) {
        this.getDelegateLeaderboard().registerCompetitor(competitor);
    }

    @Override
    public void registerCompetitors(Iterable<Competitor> competitors) {
        this.getDelegateLeaderboard().registerCompetitors(competitors);
    }

    @Override
    public void deregisterCompetitor(Competitor competitor) {
        this.getDelegateLeaderboard().deregisterCompetitor(competitor);
    }

    @Override
    public void deregisterCompetitors(Iterable<Competitor> competitor) {
        this.getDelegateLeaderboard().deregisterCompetitors(competitor);
    }

    @Override
    public Iterable<Competitor> getAllCompetitors() {
        return this.getDelegateLeaderboard().getAllCompetitors();
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        return this.getDelegateLeaderboard().getAllCompetitorsWithRaceDefinitionsConsidered();
    }

    @Override
    public Iterable<Competitor> getAllCompetitors(RaceColumn raceColumn, Fleet fleet) {
        return this.getDelegateLeaderboard().getAllCompetitors(raceColumn, fleet);
    }

    @Override
    public Iterable<Competitor> getCompetitors(RaceColumn raceColumn, Fleet fleet) {
        return this.getDelegateLeaderboard().getCompetitors(raceColumn, fleet);
    }

    @Override
    public Iterable<Competitor> getSuppressedCompetitors() {
        return this.getDelegateLeaderboard().getSuppressedCompetitors();
    }

    @Override
    public boolean isSuppressed(Competitor competitor) {
        return this.getDelegateLeaderboard().isSuppressed(competitor);
    }

    @Override
    public void setSuppressed(Competitor competitor, boolean suppressed) {
        this.getDelegateLeaderboard().setSuppressed(competitor, suppressed);
    }

    @Override
    public Fleet getFleet(String fleetName) {
        return this.getDelegateLeaderboard().getFleet(fleetName);
    }

    @Override
    public Leaderboard.Entry getEntry(Competitor competitor, RaceColumn race, TimePoint timePoint) throws NoWindException {
        return this.getDelegateLeaderboard().getEntry(competitor, race, timePoint);
    }

    @Override
    public Leaderboard.Entry getEntry(Competitor competitor, RaceColumn race, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getDelegateLeaderboard().getEntry(competitor, race, timePoint, discardedRaceColumns, cache);
    }

    @Override
    public Map<RaceColumn, Map<Competitor, Double>> getNetPointsSumAfterRaceColumn(TimePoint timePoint) throws NoWindException {
        return this.getDelegateLeaderboard().getNetPointsSumAfterRaceColumn(timePoint);
    }

    @Override
    public double getCarriedPoints(Competitor competitor) {
        return this.getDelegateLeaderboard().getCarriedPoints(competitor);
    }

    @Override
    public int getTrackedRank(Competitor competitor, RaceColumn race, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getDelegateLeaderboard().getTrackedRank(competitor, race, timePoint, cache);
    }

    @Override
    public Double getTotalPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return this.getDelegateLeaderboard().getTotalPoints(competitor, raceColumn, timePoint, cache);
    }

    @Override
    public MaxPointsReason getMaxPointsReason(Competitor competitor, RaceColumn race, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getMaxPointsReason(competitor, race, timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn race, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getNetPoints(competitor, race, timePoint);
    }

    @Override
    public boolean isDiscarded(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getDelegateLeaderboard().isDiscarded(competitor, raceColumn, timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getNetPoints(competitor, timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getNetPoints(competitor, raceColumnsToConsider, timePoint);
    }

    @Override
    public Iterable<RaceColumn> getRaceColumns() {
        RegattaLeaderboard theFullLeaderboard = this.getDelegateLeaderboard();
        return theFullLeaderboard == null ? Collections.emptySet() : theFullLeaderboard.getRaceColumns();
    }

    @Override
    public RaceColumn getRaceColumnByName(String name) {
        return this.getDelegateLeaderboard().getRaceColumnByName(name);
    }

    @Override
    public void setCarriedPoints(Competitor competitor, double carriedPoints) {
        this.getDelegateLeaderboard().setCarriedPoints(competitor, carriedPoints);
    }

    @Override
    public void unsetCarriedPoints(Competitor competitor) {
        this.getDelegateLeaderboard().unsetCarriedPoints(competitor);
    }

    @Override
    public boolean hasCarriedPoints() {
        return this.getDelegateLeaderboard().hasCarriedPoints();
    }

    @Override
    public boolean hasCarriedPoints(Competitor competitor) {
        return this.getDelegateLeaderboard().hasCarriedPoints(competitor);
    }

    @Override
    public SettableScoreCorrection getScoreCorrection() {
        return this.getDelegateLeaderboard().getScoreCorrection();
    }

    @Override
    public void addScoreCorrectionListener(ScoreCorrectionListener listener) {
        this.fullLeaderboard.runOrSchedule(leaderboard -> leaderboard.addScoreCorrectionListener(listener));
    }

    @Override
    public void removeScoreCorrectionListener(ScoreCorrectionListener listener) {
        this.fullLeaderboard.runOrSchedule(leaderboard -> leaderboard.removeScoreCorrectionListener(listener));
    }

    @Override
    public Competitor getCompetitorByName(String competitorName) {
        return this.getDelegateLeaderboard().getCompetitorByName(competitorName);
    }

    @Override
    public void setDisplayName(Competitor competitor, String displayName) {
        this.getDelegateLeaderboard().setDisplayName(competitor, displayName);
    }

    @Override
    public String getDisplayName(Competitor competitor) {
        return this.getDelegateLeaderboard().getDisplayName(competitor);
    }

    @Override
    public boolean countRaceForComparisonWithDiscardingThresholds(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint) {
        return this.getDelegateLeaderboard().countRaceForComparisonWithDiscardingThresholds(competitor, raceColumn, timePoint);
    }

    @Override
    public ResultDiscardingRule getResultDiscardingRule() {
        return this.getDelegateLeaderboard().getResultDiscardingRule();
    }

    @Override
    public void setCrossLeaderboardResultDiscardingRule(ThresholdBasedResultDiscardingRule discardingRule) {
        this.getDelegateLeaderboard().setCrossLeaderboardResultDiscardingRule(discardingRule);
    }

    @Override
    public Competitor getCompetitorByIdAsString(String idAsString) {
        return this.getDelegateLeaderboard().getCompetitorByIdAsString(idAsString);
    }

    @Override
    public void addRaceColumnListener(RaceColumnListener listener) {
        this.getDelegateLeaderboard().addRaceColumnListener(listener);
    }

    @Override
    public void removeRaceColumnListener(RaceColumnListener listener) {
        this.getDelegateLeaderboard().removeRaceColumnListener(listener);
    }

    @Override
    public Long getDelayToLiveInMillis() {
        return this.getDelegateLeaderboard().getDelayToLiveInMillis();
    }

    @Override
    public Iterable<TrackedRace> getTrackedRaces() {
        return this.getDelegateLeaderboard().getTrackedRaces();
    }

    @Override
    public ScoringScheme getScoringScheme() {
        return this.getDelegateLeaderboard().getScoringScheme();
    }

    @Override
    public TimePoint getTimePointOfLatestModification() {
        return this.getDelegateLeaderboard().getTimePointOfLatestModification();
    }

    @Override
    public Util.Pair<GPSFixMoving, Speed> getMaximumSpeedOverGround(Competitor competitor, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getMaximumSpeedOverGround(competitor, timePoint);
    }

    @Override
    public Speed getAverageSpeedOverGround(Competitor competitor, TimePoint timePoint) {
        return this.getDelegateLeaderboard().getAverageSpeedOverGround(competitor, timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) throws NoWindException {
        return this.getDelegateLeaderboard().getNetPoints(competitor, raceColumn, raceColumnsToConsider, timePoint);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        return this.getDelegateLeaderboard().getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns);
    }

    @Override
    public TimePoint getNowMinusDelay() {
        return this.getDelegateLeaderboard().getNowMinusDelay();
    }

    @Override
    public Iterable<CourseArea> getCourseAreas() {
        return this.getDelegateLeaderboard().getCourseAreas();
    }

    @Override
    public NumberOfCompetitorsInLeaderboardFetcher getNumberOfCompetitorsInLeaderboardFetcher() {
        return this.getDelegateLeaderboard().getNumberOfCompetitorsInLeaderboardFetcher();
    }

    @Override
    public Util.Pair<RaceColumn, Fleet> getRaceColumnAndFleet(TrackedRace trackedRace) {
        return this.getDelegateLeaderboard().getRaceColumnAndFleet(trackedRace);
    }

    @Override
    public BoatClass getBoatClass() {
        return this.getDelegateLeaderboard().getBoatClass();
    }

    @Override
    public Boat getBoatOfCompetitor(Competitor competitor, RaceColumn raceColumn, Fleet fleet) {
        return this.getDelegateLeaderboard().getBoatOfCompetitor(competitor, raceColumn, fleet);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        this.getDelegateLeaderboard();
        oos.defaultWriteObject();
    }

    @Override
    public Iterable<Boat> getBoatsRegisteredInRegattaLog() {
        return this.getDelegateLeaderboard().getBoatsRegisteredInRegattaLog();
    }

    @Override
    public Iterable<Boat> getAllBoats() {
        return this.getDelegateLeaderboard().getAllBoats();
    }

    @Override
    public void registerBoat(Boat boat) {
        this.getDelegateLeaderboard().registerBoat(boat);
    }

    @Override
    public void registerBoats(Iterable<Boat> boats) {
        this.getDelegateLeaderboard().registerBoats(boats);
    }

    @Override
    public void deregisterBoat(Boat boat) {
        this.getDelegateLeaderboard().deregisterBoat(boat);
    }

    @Override
    public void deregisterBoats(Iterable<Boat> boats) {
        this.getDelegateLeaderboard().deregisterBoats(boats);
    }

    @Override
    public Double getNetPoints(Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns, Supplier<Double> totalPointsProvider) {
        return this.getDelegateLeaderboard().getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns, totalPointsProvider);
    }

    @Override
    public boolean isResultsAreOfficial(RaceColumn raceColumn, Fleet fleet) {
        return this.getDelegateLeaderboard().isResultsAreOfficial(raceColumn, fleet);
    }
}

