/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.RaceLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.race.tracking.RaceLogUseCompetitorsFromRaceLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterBoatEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRegisterCompetitorEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogRevokeEvent;
import com.sap.sailing.domain.abstractlog.regatta.impl.BaseRegattaLogEventVisitor;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorsInLogAnalyzer;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.leaderboard.HasRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sse.common.Util;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CompetitorProviderFromRaceColumnsAndRegattaLike {
    private static final Logger logger = Logger.getLogger(CompetitorProviderFromRaceColumnsAndRegattaLike.class.getName());
    private final HasRaceColumnsAndRegattaLike provider;
    private final RegattaLogEventVisitor regattaLogCompetitorsCacheInvalidationListener;
    private final RaceLogEventVisitor raceLogCompetitorsCacheInvalidationListener;
    private final RaceColumnListener raceColumnListener;
    private Iterable<Competitor> allCompetitorsCache;
    private Set<RaceDefinition> raceDefinitionsConsidered;
    private final ConcurrentMap<Util.Pair<RaceColumn, Fleet>, Iterable<Competitor>> allCompetitorsCacheByRace;

    public CompetitorProviderFromRaceColumnsAndRegattaLike(HasRaceColumnsAndRegattaLike provider) {
        this.provider = provider;
        this.raceDefinitionsConsidered = new HashSet<RaceDefinition>();
        this.allCompetitorsCacheByRace = new ConcurrentHashMap<Util.Pair<RaceColumn, Fleet>, Iterable<Competitor>>();
        this.regattaLogCompetitorsCacheInvalidationListener = new BaseRegattaLogEventVisitor(){

            public void visit(RegattaLogRegisterCompetitorEvent event) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            public void visit(RegattaLogRegisterBoatEvent event) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            public void visit(RegattaLogRevokeEvent event) {
                try {
                    if (RegattaLogRegisterCompetitorEvent.class.isAssignableFrom(Class.forName(event.getRevokedEventType())) || RegattaLogRegisterBoatEvent.class.isAssignableFrom(Class.forName(event.getRevokedEventType()))) {
                        CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.WARNING, "Problem occurred trying to resolve revoked event class " + event.getRevokedEventType(), e);
                }
            }
        };
        this.raceLogCompetitorsCacheInvalidationListener = new BaseRaceLogEventVisitor(){

            public void visit(RaceLogRegisterCompetitorEvent event) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            public void visit(RaceLogUseCompetitorsFromRaceLogEvent event) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            public void visit(RaceLogRevokeEvent event) {
                try {
                    Class<?> revokedEventClass = Class.forName(event.getRevokedEventType());
                    if (RaceLogRegisterCompetitorEvent.class.isAssignableFrom(revokedEventClass) || RaceLogUseCompetitorsFromRaceLogEvent.class.isAssignableFrom(revokedEventClass)) {
                        CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
                    }
                }
                catch (ClassNotFoundException e) {
                    logger.log(Level.WARNING, "Problem occurred trying to resolve revoked event class " + event.getRevokedEventType(), e);
                }
            }
        };
        this.raceColumnListener = new RaceColumnListenerWithDefaultAction(){
            private static final long serialVersionUID = -8678230058730043052L;

            @Override
            public void defaultAction() {
            }

            @Override
            public boolean isTransient() {
                return true;
            }

            @Override
            public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            @Override
            public void trackedRaceUnlinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            @Override
            public void raceColumnAddedToContainer(RaceColumn raceColumn) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }

            @Override
            public void raceColumnRemovedFromContainer(RaceColumn raceColumn) {
                CompetitorProviderFromRaceColumnsAndRegattaLike.this.invalidateAllCompetitorsCaches();
            }
        };
    }

    public Iterable<Competitor> getAllCompetitors() {
        return (Iterable)this.getAllCompetitorsWithRaceDefinitionsConsidered().getB();
    }

    public Iterable<Boat> getAllBoats() {
        HashSet<Boat> result = new HashSet<Boat>();
        for (RaceColumn raceColumn : this.provider.getRaceColumns()) {
            result.addAll(raceColumn.getAllCompetitorsAndTheirBoats().values());
        }
        for (Boat boat : this.provider.getBoatsRegisteredInRegattaLog()) {
            result.add(boat);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        if (this.allCompetitorsCache == null) {
            HashSet<Competitor> result = new HashSet<Competitor>();
            HashSet<RaceDefinition> raceDefinitions = new HashSet<RaceDefinition>();
            for (RaceColumn raceColumn : this.provider.getRaceColumns()) {
                Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> allCompetitorsInRaceColumnWithRaceDefinitionsConsidered = raceColumn.getAllCompetitorsWithRaceDefinitionsConsidered();
                Util.addAll((Iterable)((Iterable)allCompetitorsInRaceColumnWithRaceDefinitionsConsidered.getB()), result);
                Util.addAll((Iterable)((Iterable)allCompetitorsInRaceColumnWithRaceDefinitionsConsidered.getA()), raceDefinitions);
                for (Fleet fleet : raceColumn.getFleets()) {
                    raceColumn.getRaceLog(fleet).addListener((Object)this.raceLogCompetitorsCacheInvalidationListener);
                }
            }
            RegattaLog regattaLog = this.provider.getRegattaLike().getRegattaLog();
            Set regattaLogProvidedCompetitors = (Set)new CompetitorsInLogAnalyzer((AbstractLog)regattaLog).analyze();
            result.addAll(regattaLogProvidedCompetitors);
            this.provider.addRaceColumnListener(this.raceColumnListener);
            regattaLog.addListener((Object)this.regattaLogCompetitorsCacheInvalidationListener);
            CompetitorProviderFromRaceColumnsAndRegattaLike competitorProviderFromRaceColumnsAndRegattaLike = this;
            synchronized (competitorProviderFromRaceColumnsAndRegattaLike) {
                this.allCompetitorsCache = result;
                this.raceDefinitionsConsidered = raceDefinitions;
            }
        }
        CompetitorProviderFromRaceColumnsAndRegattaLike competitorProviderFromRaceColumnsAndRegattaLike = this;
        synchronized (competitorProviderFromRaceColumnsAndRegattaLike) {
            return new Util.Pair(this.raceDefinitionsConsidered, this.allCompetitorsCache);
        }
    }

    public Iterable<Competitor> getAllCompetitors(RaceColumn raceColumn, Fleet fleet) {
        Util.Pair key = new Util.Pair((Object)raceColumn, (Object)fleet);
        HashSet result = (HashSet)this.allCompetitorsCacheByRace.get(key);
        if (result == null) {
            HashSet resultSet = new HashSet();
            Util.addAll(raceColumn.getAllCompetitors(fleet), resultSet);
            raceColumn.getRaceLog(fleet).addListener((Object)this.raceLogCompetitorsCacheInvalidationListener);
            this.provider.addRaceColumnListener(this.raceColumnListener);
            this.provider.getRegattaLike().getRegattaLog().addListener((Object)this.regattaLogCompetitorsCacheInvalidationListener);
            result = resultSet;
            this.allCompetitorsCacheByRace.put((Util.Pair<RaceColumn, Fleet>)key, result);
        }
        return result;
    }

    private void invalidateAllCompetitorsCaches() {
        this.allCompetitorsCache = null;
        this.provider.getRegattaLike().getRegattaLog().removeListener((Object)this.regattaLogCompetitorsCacheInvalidationListener);
        for (RaceColumn raceColumn : this.provider.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                raceColumn.getRaceLog(fleet).removeListener((Object)this.raceLogCompetitorsCacheInvalidationListener);
            }
        }
        this.provider.removeRaceColumnListener(this.raceColumnListener);
        this.allCompetitorsCacheByRace.clear();
    }
}

