/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardTotalRankComparator;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public abstract class AbstractScoringSchemeImpl
implements ScoringScheme {
    private static final long serialVersionUID = 6830414905539642446L;
    private final boolean higherIsBetter;

    public AbstractScoringSchemeImpl(boolean higherIsBetter) {
        this.higherIsBetter = higherIsBetter;
    }

    @Override
    public boolean isHigherBetter() {
        return this.higherIsBetter;
    }

    @Override
    public Comparator<Double> getScoreComparator(boolean nullScoresAreBetter) {
        return new ScoreComparator(nullScoresAreBetter);
    }

    @Override
    public int compareByBetterScore(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, Map<Competitor, Set<RaceColumn>> discardedRaceColumnsPerCompetitor, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Comparator<Util.Pair<RaceColumn, Double>> ruleA8_1ScoreComparator = this.getRuleA8_1ScoreComparator(nullScoresAreBetter);
        boolean includeDiscardedResults = this.isConsiderDiscardedScoresDuringBetterScoreTieBreak();
        ArrayList<Util.Pair> o1NetScores = new ArrayList<Util.Pair>();
        Set<RaceColumn> o1Discards = discardedRaceColumnsPerCompetitor.get(o1);
        for (Util.Pair<RaceColumn, Double> o1ColumnAndScore : o1Scores) {
            if (!includeDiscardedResults && o1Discards.contains(o1ColumnAndScore.getA())) continue;
            o1NetScores.add(new Util.Pair((Object)((RaceColumn)o1ColumnAndScore.getA()), (Object)this.getOriginalScoreFromScoreScaledByFactor((RaceColumn)o1ColumnAndScore.getA(), (Double)o1ColumnAndScore.getB())));
        }
        ArrayList<Util.Pair> o2NetScores = new ArrayList<Util.Pair>();
        Set<RaceColumn> o2Discards = discardedRaceColumnsPerCompetitor.get(o2);
        for (Util.Pair<RaceColumn, Double> o2ColumnAndScore : o2Scores) {
            if (!includeDiscardedResults && o2Discards.contains(o2ColumnAndScore.getA())) continue;
            o2NetScores.add(new Util.Pair((Object)((RaceColumn)o2ColumnAndScore.getA()), (Object)this.getOriginalScoreFromScoreScaledByFactor((RaceColumn)o2ColumnAndScore.getA(), (Double)o2ColumnAndScore.getB())));
        }
        Collections.sort(o1NetScores, ruleA8_1ScoreComparator);
        Collections.sort(o2NetScores, ruleA8_1ScoreComparator);
        Iterator o1Iter = o1NetScores.iterator();
        Iterator o2Iter = o2NetScores.iterator();
        int result = 0;
        while (result == 0 && o1Iter.hasNext() && o2Iter.hasNext()) {
            result = this.getScoreComparator(nullScoresAreBetter).compare((Double)((Util.Pair)o1Iter.next()).getB(), (Double)((Util.Pair)o2Iter.next()).getB());
        }
        if (o1Iter.hasNext() != o2Iter.hasNext()) {
            result = o1Iter.hasNext() ? -1 : 1;
        }
        return result;
    }

    protected boolean isConsiderDiscardedScoresDuringBetterScoreTieBreak() {
        return false;
    }

    protected Comparator<Util.Pair<RaceColumn, Double>> getRuleA8_1ScoreComparator(boolean nullScoresAreBetter) {
        return (p1, p2) -> this.getScoreComparator(nullScoresAreBetter).compare((Double)p1.getB(), (Double)p2.getB());
    }

    @Override
    public int compareByNumberOfRacesScored(int competitor1NumberOfRacesScored, int competitor2NumberOfRacesScored) {
        return 0;
    }

    @Override
    public LeaderboardTotalRankComparator getOpeningSeriesRankComparator(Iterable<RaceColumn> raceColumnsToConsider, boolean nullScoresAreBetter, TimePoint timePoint, Leaderboard leaderboard, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Iterable openingSeriesRaceColumnsFromThoseToConsider = Util.filter(raceColumnsToConsider, rc -> !rc.isMedalRace());
        LeaderboardTotalRankComparator openingSeriesRankComparator = new LeaderboardTotalRankComparator(leaderboard, timePoint, this, nullScoresAreBetter, openingSeriesRaceColumnsFromThoseToConsider, totalPointsSupplier, cache);
        return openingSeriesRankComparator;
    }

    @Override
    public int compareByLastRace(List<Util.Pair<RaceColumn, Double>> o1ScoresIncludingDiscarded, List<Util.Pair<RaceColumn, Double>> o2ScoresIncludingDiscarded, boolean nullScoresAreBetter, Competitor o1, Competitor o2, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int result = 0;
        Comparator<Double> pureScoreComparator = this.getScoreComparator(nullScoresAreBetter);
        ListIterator<Util.Pair<RaceColumn, Double>> o1Iter = o1ScoresIncludingDiscarded.listIterator(o1ScoresIncludingDiscarded.size());
        ListIterator<Util.Pair<RaceColumn, Double>> o2Iter = o2ScoresIncludingDiscarded.listIterator(o2ScoresIncludingDiscarded.size());
        while (result == 0 && o1Iter.hasPrevious() && o2Iter.hasPrevious()) {
            result = pureScoreComparator.compare((Double)o1Iter.previous().getB(), (Double)o2Iter.previous().getB());
        }
        if (o1Iter.hasPrevious() != o2Iter.hasPrevious()) {
            result = o1Iter.hasPrevious() ? -1 : 1;
        }
        return result;
    }

    protected int getNumberOfCompetitorsInBetterFleets(RaceColumn raceColumn, int competitorFleetOrdering) {
        int numberOfCompetitorsInBetterFleets = 0;
        for (Fleet fleet : raceColumn.getFleets()) {
            TrackedRace trackedRaceOfBetterFleet;
            if (fleet.getOrdering() == 0 || fleet.getOrdering() >= competitorFleetOrdering || (trackedRaceOfBetterFleet = raceColumn.getTrackedRace(fleet)) == null) continue;
            numberOfCompetitorsInBetterFleets += Util.size(trackedRaceOfBetterFleet.getRace().getCompetitors());
        }
        return numberOfCompetitorsInBetterFleets;
    }

    @Override
    public int compareByLatestRegattaInMetaLeaderboard(Leaderboard leaderboard, Competitor o1, Competitor o2, TimePoint timePoint) {
        return 0;
    }

    @Override
    public int compareByOtherTieBreakingLeaderboard(RegattaLeaderboardWithOtherTieBreakingLeaderboard leaderboard, Competitor o1, Competitor o2, TimePoint timePoint) {
        return 0;
    }

    private class ScoreComparator
    implements Comparator<Double>,
    Serializable {
        private static final long serialVersionUID = -2767385186133743330L;
        private static final double THRESHOLD_FOR_EQUALITY = 1.0E-10;
        private final boolean nullScoresAreBetter;

        public ScoreComparator(boolean nullScoresAreBetter) {
            this.nullScoresAreBetter = nullScoresAreBetter;
        }

        @Override
        public int compare(Double o1, Double o2) {
            int result = o1 == null ? (o2 == null ? 0 : (this.nullScoresAreBetter ? -1 : 1)) : (o2 == null ? (this.nullScoresAreBetter ? 1 : -1) : this.compareDoublesWithThreshold(o1, o2) * (AbstractScoringSchemeImpl.this.isHigherBetter() ? -1 : 1));
            return result;
        }

        private int compareDoublesWithThreshold(double d1, double d2) {
            int result = Math.abs(d1 - d2) < 1.0E-10 ? 0 : (d1 > d2 ? 1 : -1);
            return result;
        }
    }
}

