/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.impl;

import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ResultsAreOfficialFinder;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterBoatEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogRegisterCompetitorEventImpl;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogBoatDeregistrator;
import com.sap.sailing.domain.abstractlog.regatta.tracking.analyzing.impl.RegattaLogBoatsInLogAnalyzer;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorDeregistrator;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorsInLogAnalyzer;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.HasRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.AbstractSimpleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.CompetitorAndRankComparable;
import com.sap.sailing.domain.leaderboard.impl.CompetitorProviderFromRaceColumnsAndRegattaLike;
import com.sap.sailing.domain.leaderboard.impl.RankAndRankComparable;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public abstract class AbstractLeaderboardImpl
extends AbstractSimpleLeaderboardImpl
implements HasRaceColumnsAndRegattaLike {
    private static final long serialVersionUID = -328091952760083438L;
    private transient CompetitorProviderFromRaceColumnsAndRegattaLike competitorsProvider;
    private final AbstractLogEventAuthor regattaLogEventAuthorForAbstractLeaderboard = new LogEventAuthorImpl(AbstractLeaderboardImpl.class.getName(), 0);

    public AbstractLeaderboardImpl(ThresholdBasedResultDiscardingRule resultDiscardingRule) {
        super(resultDiscardingRule);
    }

    @Override
    public Fleet getFleet(String fleetName) {
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                if (!fleet.getName().equals(fleetName)) continue;
                return fleet;
            }
        }
        return null;
    }

    @Override
    public Iterable<TrackedRace> getTrackedRaces() {
        HashSet<TrackedRace> trackedRaces = new HashSet<TrackedRace>();
        for (RaceColumn r : this.getRaceColumns()) {
            for (Fleet fleet : r.getFleets()) {
                TrackedRace trackedRace = r.getTrackedRace(fleet);
                if (trackedRace == null) continue;
                trackedRaces.add(trackedRace);
            }
        }
        return Collections.unmodifiableSet(trackedRaces);
    }

    @Override
    public Util.Pair<Iterable<RaceDefinition>, Iterable<Competitor>> getAllCompetitorsWithRaceDefinitionsConsidered() {
        return this.getOrCreateCompetitorsProvider().getAllCompetitorsWithRaceDefinitionsConsidered();
    }

    @Override
    public Iterable<Boat> getAllBoats() {
        return this.getOrCreateCompetitorsProvider().getAllBoats();
    }

    @Override
    public Iterable<Competitor> getAllCompetitors(RaceColumn raceColumn, Fleet fleet) {
        return this.getOrCreateCompetitorsProvider().getAllCompetitors(raceColumn, fleet);
    }

    @Override
    public Boat getBoatOfCompetitor(Competitor competitor, RaceColumn raceColumn, Fleet fleet) {
        return fleet == null ? null : raceColumn.getAllCompetitorsAndTheirBoats(fleet).get(competitor);
    }

    @Override
    public CompetitorProviderFromRaceColumnsAndRegattaLike getOrCreateCompetitorsProvider() {
        if (this.competitorsProvider == null) {
            this.competitorsProvider = new CompetitorProviderFromRaceColumnsAndRegattaLike(this);
        }
        return this.competitorsProvider;
    }

    @Override
    public Competitor getCompetitorByIdAsString(String idAsString) {
        for (Competitor competitor : this.getAllCompetitors()) {
            if (!competitor.getId().toString().equals(idAsString)) continue;
            return competitor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getTrackedRank(Competitor competitor, RaceColumn race, TimePoint timePoint, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        int trackedRank;
        TrackedRace trackedRace = race.getTrackedRace(competitor);
        if (trackedRace == null || !trackedRace.hasStarted(timePoint)) {
            trackedRank = 0;
        } else if (race.hasCrossFleetMergedRanking()) {
            ArrayList<Fleet> fleetsOfSameOrderAsCompetitorsFleet = new ArrayList<Fleet>();
            int rankOfCompetitorsFleet = race.getFleetOfCompetitor(competitor).getOrdering();
            for (Fleet fleet : race.getFleets()) {
                if (fleet.getOrdering() != rankOfCompetitorsFleet) continue;
                fleetsOfSameOrderAsCompetitorsFleet.add(fleet);
            }
            if (fleetsOfSameOrderAsCompetitorsFleet.size() > 1) {
                void var9_13;
                Object var9_12 = null;
                ArrayList<CompetitorAndRankComparable> competitorsFromBestToWorstAndRankComparable = new ArrayList<CompetitorAndRankComparable>();
                for (Fleet fleet : fleetsOfSameOrderAsCompetitorsFleet) {
                    for (Map.Entry<Competitor, RankAndRankComparable> e : race.getTrackedRace(fleet).getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, cache).entrySet()) {
                        competitorsFromBestToWorstAndRankComparable.add(new CompetitorAndRankComparable(e.getKey(), e.getValue().getRankComparable()));
                        if (e.getKey() != competitor) continue;
                        Integer n = e.getValue().getRank();
                    }
                }
                Collections.sort(competitorsFromBestToWorstAndRankComparable);
                Iterator<Competitor> competitorsIterator = competitorsFromBestToWorstAndRankComparable.stream().map(v -> v.getCompetitor()).iterator();
                trackedRank = this.getRankImprovedByDisqualificationsOfBetterRankedCompetitors(competitor, race, timePoint, (Integer)var9_13, competitorsIterator);
            } else {
                LinkedHashMap<Competitor, RankAndRankComparable> linkedHashMap = trackedRace.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, cache);
                trackedRank = this.getRankImprovedByDisqualificationsOfBetterRankedCompetitors(competitor, race, timePoint, linkedHashMap.get(competitor).getRank(), linkedHashMap.keySet().iterator());
            }
        } else {
            LinkedHashMap<Competitor, RankAndRankComparable> competitorsFromBestToWorstAndRankAndRankComparable = trackedRace.getCompetitorsFromBestToWorstAndRankAndRankComparable(timePoint, cache);
            trackedRank = this.getRankImprovedByDisqualificationsOfBetterRankedCompetitors(competitor, race, timePoint, competitorsFromBestToWorstAndRankAndRankComparable.get(competitor).getRank(), competitorsFromBestToWorstAndRankAndRankComparable.keySet().iterator());
        }
        return trackedRank;
    }

    private int getRankImprovedByDisqualificationsOfBetterRankedCompetitors(Competitor competitor, RaceColumn race, TimePoint timePoint, Integer originalRank, Iterator<Competitor> competitorsFromBestToWorst) {
        int result;
        if (originalRank == null || originalRank == 0) {
            result = 0;
        } else {
            int rank = 1;
            int numberOfDisqualificationsOfBetterRankedCompetitors = 0;
            while (competitorsFromBestToWorst.hasNext()) {
                Competitor currentCompetitor = competitorsFromBestToWorst.next();
                if (competitor.equals(currentCompetitor)) break;
                MaxPointsReason maxPointsReasonForBetterCompetitor = this.getScoreCorrection().getMaxPointsReason(currentCompetitor, race, timePoint);
                if (this.isSuppressed(currentCompetitor) || maxPointsReasonForBetterCompetitor != null && maxPointsReasonForBetterCompetitor != MaxPointsReason.NONE && maxPointsReasonForBetterCompetitor.isAdvanceCompetitorsTrackedWorse()) {
                    ++numberOfDisqualificationsOfBetterRankedCompetitors;
                }
                ++rank;
            }
            result = rank - numberOfDisqualificationsOfBetterRankedCompetitors;
        }
        return result;
    }

    @Override
    public Long getDelayToLiveInMillis() {
        TimePoint startOfLatestRace = null;
        Long delayToLiveInMillisForLatestRace = null;
        for (RaceColumn raceColumn : this.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                if (trackedRace == null || startOfLatestRace != null && (trackedRace.getStartOfRace() == null || trackedRace.getStartOfRace().compareTo(startOfLatestRace) <= 0)) continue;
                delayToLiveInMillisForLatestRace = trackedRace.getDelayToLiveInMillis();
                startOfLatestRace = trackedRace.getStartOfRace();
            }
        }
        return delayToLiveInMillisForLatestRace;
    }

    @Override
    public RaceLog getRacelog(String raceColumnName, String fleetName) {
        RaceColumn raceColumn = this.getRaceColumnByName(raceColumnName);
        Fleet fleet = raceColumn.getFleetByName(fleetName);
        return raceColumn.getRaceLog(fleet);
    }

    @Override
    public Iterable<Competitor> getCompetitorsRegisteredInRegattaLog() {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        CompetitorsInLogAnalyzer analyzer = new CompetitorsInLogAnalyzer((AbstractLog)regattaLog);
        return (Iterable)analyzer.analyze();
    }

    @Override
    public void registerCompetitor(Competitor competitor) {
        this.registerCompetitors(Collections.singletonList(competitor));
    }

    @Override
    public void registerCompetitors(Iterable<Competitor> competitors) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        TimePoint now = MillisecondsTimePoint.now();
        for (Competitor competitor : competitors) {
            regattaLog.add((AbstractLogEvent)new RegattaLogRegisterCompetitorEventImpl(now, now, this.regattaLogEventAuthorForAbstractLeaderboard, (Serializable)UUID.randomUUID(), competitor));
        }
    }

    @Override
    public void deregisterCompetitor(Competitor competitor) {
        this.deregisterCompetitors(Collections.singleton(competitor));
    }

    @Override
    public void deregisterCompetitors(Iterable<Competitor> competitors) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        CompetitorDeregistrator deregisterer = new CompetitorDeregistrator((AbstractLog)regattaLog, competitors, this.regattaLogEventAuthorForAbstractLeaderboard);
        deregisterer.deregister((Set)deregisterer.analyze());
    }

    @Override
    public Iterable<Boat> getBoatsRegisteredInRegattaLog() {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        RegattaLogBoatsInLogAnalyzer analyzer = new RegattaLogBoatsInLogAnalyzer((AbstractLog)regattaLog);
        return (Iterable)analyzer.analyze();
    }

    @Override
    public void registerBoat(Boat boat) {
        this.registerBoats(Collections.singleton(boat));
    }

    @Override
    public void registerBoats(Iterable<Boat> boats) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        TimePoint now = MillisecondsTimePoint.now();
        for (Boat boat : boats) {
            regattaLog.add((AbstractLogEvent)new RegattaLogRegisterBoatEventImpl(now, now, this.regattaLogEventAuthorForAbstractLeaderboard, (Serializable)UUID.randomUUID(), boat));
        }
    }

    @Override
    public void deregisterBoat(Boat boat) {
        this.deregisterBoats(Collections.singleton(boat));
    }

    @Override
    public void deregisterBoats(Iterable<Boat> boats) {
        RegattaLog regattaLog = this.getRegattaLike().getRegattaLog();
        RegattaLogBoatDeregistrator deregisterer = new RegattaLogBoatDeregistrator((AbstractLog)regattaLog, boats, this.regattaLogEventAuthorForAbstractLeaderboard);
        deregisterer.deregister((Set)deregisterer.analyze());
    }

    @Override
    public boolean isResultsAreOfficial(RaceColumn raceColumn, Fleet fleet) {
        RaceLog raceLog = raceColumn.getRaceLog(fleet);
        return new ResultsAreOfficialFinder(raceLog).analyze() != null;
    }
}

