/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard.caching;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.LegType;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.orc.AverageWindOnLegCache;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveCourse;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLeg;
import com.sap.sailing.domain.common.orc.ORCPerformanceCurveLegTypes;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveCourseImpl;
import com.sap.sailing.domain.common.orc.impl.ORCPerformanceCurveLegImpl;
import com.sap.sailing.domain.orc.ORCPerformanceCurve;
import com.sap.sailing.domain.orc.ORCPerformanceCurveCache;
import com.sap.sailing.domain.orc.impl.AbstractORCPerformanceCurveTwaLegAdapter;
import com.sap.sailing.domain.tracking.MarkPositionAtTimePointCache;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.math.ArgumentOutsideDomainException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;

public class LeaderboardDTOCalculationReuseCache
implements WindLegTypeAndLegBearingAndORCPerformanceCurveCache {
    private final TimePoint timePoint;
    final ConcurrentMap<Leg, LegType> legTypeCache = new ConcurrentHashMap<Leg, LegType>();
    final ConcurrentHashMap<Util.Triple<TrackedRace, Competitor, TimePoint>, Wind> windCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<ORCPerformanceCurveLeg, Wind> trackedLegAverageWindCache;
    private static final Wind NULL_WIND = new WindImpl((Position)new DegreePosition(0.0, 0.0), MillisecondsTimePoint.now(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(0.0, (Bearing)new DegreeBearingImpl(0.0)));
    final ConcurrentHashMap<Leg, Bearing> legBearingCache;
    private final ConcurrentHashMap<TrackedRace, ORCPerformanceCurveCourse> totalCourse;
    private final ConcurrentHashMap<Util.Triple<TrackedRace, Waypoint, TimePoint>, Position> approximateWaypointPositions;
    private final ConcurrentHashMap<Util.Pair<TimePoint, TrackedRace>, Competitor> scratchBoat = new ConcurrentHashMap();
    private final ConcurrentHashMap<Util.Triple<TimePoint, TrackedRace, Competitor>, ORCPerformanceCurve> performanceCurvesPerCompetitor;
    private final ConcurrentHashMap<Util.Triple<TimePoint, TrackedRace, Competitor>, Speed> impliedWindPerCompetitor;
    private final ConcurrentHashMap<Util.Triple<TimePoint, TrackedRace, Competitor>, Duration> relativeCorrectedTimePerCompetitor;
    private static final Bearing NULL_BEARING = new DegreeBearingImpl(0.0);
    private static final Speed NULL_IMPLIED_WIND = new KnotSpeedImpl(0.0);
    private static final Duration NULL_RELATIVE_CORRECTED_TIME = new MillisecondsDurationImpl(0L);
    private static final ORCPerformanceCurve NULL_PERFORMANCE_CURVE = new ORCPerformanceCurve(){

        @Override
        public Speed getImpliedWind(Duration durationToCompleteCourse) throws MaxIterationsExceededException, FunctionEvaluationException {
            return null;
        }

        @Override
        public Duration getCalculatedTime(ORCPerformanceCurve referenceBoat, Duration durationToCompleteCourse) throws MaxIterationsExceededException, FunctionEvaluationException {
            return null;
        }

        @Override
        public Duration getAllowancePerCourse(Speed trueWindSpeed) throws ArgumentOutsideDomainException {
            return null;
        }

        @Override
        public ORCPerformanceCurveCourse getCourse() {
            return null;
        }
    };

    public LeaderboardDTOCalculationReuseCache(TimePoint timePoint) {
        this.legBearingCache = new ConcurrentHashMap();
        this.trackedLegAverageWindCache = new ConcurrentHashMap();
        this.relativeCorrectedTimePerCompetitor = new ConcurrentHashMap();
        this.approximateWaypointPositions = new ConcurrentHashMap();
        this.performanceCurvesPerCompetitor = new ConcurrentHashMap();
        this.impliedWindPerCompetitor = new ConcurrentHashMap();
        this.totalCourse = new ConcurrentHashMap();
        this.timePoint = timePoint;
    }

    @Override
    public LegType getLegType(TrackedLeg trackedLeg, TimePoint timePoint) throws NoWindException {
        LegType result;
        if (Util.equalsWithNull((Object)this.timePoint, (Object)timePoint)) {
            result = (LegType)this.legTypeCache.get(trackedLeg.getLeg());
            if (result == null) {
                result = trackedLeg.getLegType(timePoint);
                this.legTypeCache.put(trackedLeg.getLeg(), result);
            }
        } else {
            result = trackedLeg.getLegType(timePoint);
        }
        return result;
    }

    @Override
    public Bearing getLegBearing(TrackedLeg trackedLeg, TimePoint timePoint) {
        Bearing result;
        if (Util.equalsWithNull((Object)this.timePoint, (Object)timePoint)) {
            result = this.legBearingCache.get(trackedLeg.getLeg());
            if (result == null) {
                result = trackedLeg.getLegBearing(timePoint, this.getMarkPositionAtTimePointCache(timePoint, trackedLeg.getTrackedRace()));
                this.legBearingCache.put(trackedLeg.getLeg(), result == null ? NULL_BEARING : result);
            } else if (result == NULL_BEARING) {
                result = null;
            }
        } else {
            result = trackedLeg.getLegBearing(timePoint, this.getMarkPositionAtTimePointCache(timePoint, trackedLeg.getTrackedRace()));
        }
        return result;
    }

    @Override
    public Position getApproximatePosition(TrackedRace trackedRace, Waypoint waypoint, TimePoint timePoint) {
        Util.Triple cacheKey = new Util.Triple((Object)trackedRace, (Object)waypoint, (Object)timePoint);
        return this.approximateWaypointPositions.computeIfAbsent((Util.Triple<TrackedRace, Waypoint, TimePoint>)cacheKey, key -> ((TrackedRace)key.getA()).getApproximatePosition((Waypoint)key.getB(), (TimePoint)key.getC()));
    }

    @Override
    public Wind getWind(TrackedRace trackedRace, Competitor competitor, TimePoint timePoint) {
        Util.Triple cacheKey = new Util.Triple((Object)trackedRace, (Object)competitor, (Object)timePoint);
        Wind result = this.windCache.get(cacheKey);
        if (result == null) {
            result = trackedRace.getWind(trackedRace.getTrack(competitor).getEstimatedPosition(timePoint, false), timePoint);
            this.windCache.put((Util.Triple<TrackedRace, Competitor, TimePoint>)cacheKey, result == null ? NULL_WIND : result);
        } else if (result == NULL_WIND) {
            result = null;
        }
        return result;
    }

    @Override
    public ORCPerformanceCurveCourse getTotalCourse(TrackedRace raceContext, Supplier<ORCPerformanceCurveCourse> totalCourseSupplier) {
        return this.totalCourse.computeIfAbsent(raceContext, key -> this.fixORCPerformanceCurveCourse((ORCPerformanceCurveCourse)totalCourseSupplier.get(), this));
    }

    private ORCPerformanceCurveCourse fixORCPerformanceCurveCourse(ORCPerformanceCurveCourse course, ORCPerformanceCurveCache cache) {
        ArrayList<Object> legs = new ArrayList<Object>();
        boolean changed = false;
        for (ORCPerformanceCurveLeg leg : course.getLegs()) {
            if (leg instanceof AbstractORCPerformanceCurveTwaLegAdapter) {
                ORCPerformanceCurveLegImpl pcl = leg.getType() == ORCPerformanceCurveLegTypes.TWA ? new ORCPerformanceCurveLegImpl(((AbstractORCPerformanceCurveTwaLegAdapter)leg).getLength(this), leg.getTwa((AverageWindOnLegCache)cache)) : new ORCPerformanceCurveLegImpl(((AbstractORCPerformanceCurveTwaLegAdapter)leg).getLength(this), leg.getType());
                legs.add(pcl);
                changed = true;
                continue;
            }
            legs.add(leg);
        }
        Object result = changed ? new ORCPerformanceCurveCourseImpl(legs) : course;
        return result;
    }

    @Override
    public Competitor getScratchBoat(TimePoint timePoint, TrackedRace raceContext, Function<TimePoint, Competitor> scratchBoatSupplier) {
        return this.scratchBoat.computeIfAbsent((Util.Pair<TimePoint, TrackedRace>)new Util.Pair((Object)timePoint, (Object)raceContext), timePointAndRaceContext -> (Competitor)scratchBoatSupplier.apply((TimePoint)timePointAndRaceContext.getA()));
    }

    @Override
    public ORCPerformanceCurve getPerformanceCurveForPartialCourse(TimePoint timePoint, TrackedRace raceContext, Competitor competitor, BiFunction<TimePoint, Competitor, ORCPerformanceCurve> performanceCurveSupplier) {
        ORCPerformanceCurve result = this.performanceCurvesPerCompetitor.computeIfAbsent((Util.Triple<TimePoint, TrackedRace, Competitor>)new Util.Triple((Object)timePoint, (Object)raceContext, (Object)competitor), timePointAndTrackedRaceAndCompetitor -> {
            ORCPerformanceCurve performanceCurve = (ORCPerformanceCurve)performanceCurveSupplier.apply((TimePoint)timePointAndTrackedRaceAndCompetitor.getA(), (Competitor)timePointAndTrackedRaceAndCompetitor.getC());
            return performanceCurve == null ? NULL_PERFORMANCE_CURVE : performanceCurve;
        });
        return result == NULL_PERFORMANCE_CURVE ? null : result;
    }

    @Override
    public Speed getImpliedWind(TimePoint timePoint, TrackedRace raceContext, Competitor competitor, BiFunction<TimePoint, Competitor, Speed> impliedWindSupplier) {
        Speed result = this.impliedWindPerCompetitor.computeIfAbsent((Util.Triple<TimePoint, TrackedRace, Competitor>)new Util.Triple((Object)timePoint, (Object)raceContext, (Object)competitor), timePointAndTrackedRaceAndCompetitor -> {
            Speed impliedWind = (Speed)impliedWindSupplier.apply((TimePoint)timePointAndTrackedRaceAndCompetitor.getA(), (Competitor)timePointAndTrackedRaceAndCompetitor.getC());
            return impliedWind == null ? NULL_IMPLIED_WIND : impliedWind;
        });
        return result == NULL_IMPLIED_WIND ? null : result;
    }

    @Override
    public Duration getRelativeCorrectedTime(Competitor competitor, TrackedRace raceContext, TimePoint timePoint, BiFunction<Competitor, TimePoint, Duration> relativeCorrectedTimeSupplier) {
        Duration result = this.relativeCorrectedTimePerCompetitor.computeIfAbsent((Util.Triple<TimePoint, TrackedRace, Competitor>)new Util.Triple((Object)timePoint, (Object)raceContext, (Object)competitor), timePointAndTrackedRaceAndCompetitor -> {
            Duration relativeCorrectedTime = (Duration)relativeCorrectedTimeSupplier.apply((Competitor)timePointAndTrackedRaceAndCompetitor.getC(), (TimePoint)timePointAndTrackedRaceAndCompetitor.getA());
            return relativeCorrectedTime == null ? NULL_RELATIVE_CORRECTED_TIME : relativeCorrectedTime;
        });
        return result == NULL_RELATIVE_CORRECTED_TIME ? null : result;
    }

    @Override
    public MarkPositionAtTimePointCache getMarkPositionAtTimePointCache(final TimePoint markPositionTimePoint, final TrackedRace trackedRace) {
        return new MarkPositionAtTimePointCache(){

            @Override
            public Position getEstimatedPosition(Mark mark) {
                return this.getTrackedRace().getOrCreateTrack(mark).getEstimatedPosition(markPositionTimePoint, false);
            }

            @Override
            public Position getApproximatePosition(Waypoint waypoint) {
                return LeaderboardDTOCalculationReuseCache.this.getApproximatePosition(this.getTrackedRace(), waypoint, markPositionTimePoint);
            }

            @Override
            public Bearing getLegBearing(TrackedLeg trackedLeg) {
                return LeaderboardDTOCalculationReuseCache.this.getLegBearing(trackedLeg, markPositionTimePoint);
            }

            @Override
            public TimePoint getTimePoint() {
                return markPositionTimePoint;
            }

            @Override
            public TrackedRace getTrackedRace() {
                return trackedRace;
            }
        };
    }

    public <L extends ORCPerformanceCurveLeg> Wind getAverageWind(L leg, Function<L, Wind> averageWindForLegSupplier) {
        Wind result = this.trackedLegAverageWindCache.get(leg);
        if (result == null && (result = averageWindForLegSupplier.apply(leg)) != null) {
            this.trackedLegAverageWindCache.put(leg, result);
        }
        return result;
    }
}

