/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.NumberOfCompetitorsInLeaderboardFetcher;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.impl.AbstractSimpleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardTotalRankComparator;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;

public interface ScoringScheme
extends Serializable {
    public static final double DEFAULT_MEDAL_RACE_FACTOR = 2.0;
    public static final /* synthetic */ boolean $assertionsDisabled;

    public boolean isHigherBetter();

    public Comparator<Double> getScoreComparator(boolean var1);

    public Double getScoreForRank(Leaderboard var1, RaceColumn var2, Competitor var3, int var4, Callable<Integer> var5, NumberOfCompetitorsInLeaderboardFetcher var6, TimePoint var7);

    public Double getPenaltyScore(RaceColumn var1, Competitor var2, MaxPointsReason var3, Integer var4, NumberOfCompetitorsInLeaderboardFetcher var5, TimePoint var6, Leaderboard var7, Supplier<Double> var8);

    public int compareByBetterScore(Competitor var1, List<Util.Pair<RaceColumn, Double>> var2, Competitor var3, List<Util.Pair<RaceColumn, Double>> var4, Iterable<RaceColumn> var5, boolean var6, TimePoint var7, Leaderboard var8, Map<Competitor, Set<RaceColumn>> var9, BiFunction<Competitor, RaceColumn, Double> var10, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var11);

    public int compareByNumberOfRacesScored(int var1, int var2);

    default public int compareByMedalRaceParticipation(int zeroBasedIndexOfLastMedalSeriesInWhichO1Scored, int zeroBasedIndexOfLastMedalSeriesInWhichO2Scored) {
        return -Integer.compare(zeroBasedIndexOfLastMedalSeriesInWhichO1Scored, zeroBasedIndexOfLastMedalSeriesInWhichO2Scored);
    }

    public ScoringSchemeType getType();

    public int compareByLastRace(List<Util.Pair<RaceColumn, Double>> var1, List<Util.Pair<RaceColumn, Double>> var2, boolean var3, Competitor var4, Competitor var5, TimePoint var6, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var7);

    public boolean isValidInNetScore(Leaderboard var1, RaceColumn var2, Competitor var3, TimePoint var4);

    public int compareByLatestRegattaInMetaLeaderboard(Leaderboard var1, Competitor var2, Competitor var3, TimePoint var4);

    public int compareByOtherTieBreakingLeaderboard(RegattaLeaderboardWithOtherTieBreakingLeaderboard var1, Competitor var2, Competitor var3, TimePoint var4);

    default public boolean isMedalWinAmountCriteria() {
        return false;
    }

    default public boolean isCarryForwardInMedalsCriteria() {
        return false;
    }

    default public double getScoreFactor(RaceColumn raceColumn) {
        Double factor = raceColumn.getExplicitFactor();
        if (factor == null) {
            factor = raceColumn.isMedalRace() ? 2.0 : 1.0;
        }
        return factor;
    }

    default public double getScoreScaledByFactor(RaceColumn raceColumn, double originalScore) {
        return ScoringSchemeType.getScaledScore((double)this.getScoreFactor(raceColumn), (double)originalScore, (boolean)raceColumn.isOneAlwaysStaysOne());
    }

    default public double getOriginalScoreFromScoreScaledByFactor(RaceColumn raceColumn, double scaledScore) {
        return ScoringSchemeType.getUnscaledScore((double)this.getScoreFactor(raceColumn), (double)scaledScore, (boolean)raceColumn.isOneAlwaysStaysOne());
    }

    default public boolean isWin(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        Fleet fleetOfCompetitor = raceColumn.getFleetOfCompetitor(competitor);
        Iterable<Competitor> competitorsFromBestToWorstInColumn = leaderboard.getCompetitorsFromBestToWorst(raceColumn, timePoint, totalPointsSupplier, cache);
        for (Competitor betterCompetitor : competitorsFromBestToWorstInColumn) {
            if (betterCompetitor != competitor && raceColumn.getFleetOfCompetitor(betterCompetitor) == fleetOfCompetitor) {
                return false;
            }
            if (betterCompetitor != competitor) continue;
            return true;
        }
        return false;
    }

    default public double getNetPoints(AbstractSimpleLeaderboardImpl leaderboard, Competitor competitor, Iterable<RaceColumn> raceColumnsToConsider, TimePoint timePoint) {
        boolean needToResetScoreUponNextNonEmptyEntry = false;
        double result = leaderboard.getCarriedPoints(competitor);
        Set<RaceColumn> discardedRaceColumns = leaderboard.getResultDiscardingRule().getDiscardedRaceColumns(competitor, leaderboard, raceColumnsToConsider, timePoint, this);
        for (RaceColumn raceColumn : raceColumnsToConsider) {
            Double netPoints;
            if (raceColumn.isStartsWithZeroScore()) {
                needToResetScoreUponNextNonEmptyEntry = true;
            }
            if (!this.isValidInNetScore(leaderboard, raceColumn, competitor, timePoint) || (netPoints = this.getNetPointsForScoreSum(leaderboard, competitor, raceColumn, timePoint, discardedRaceColumns)) == null) continue;
            if (needToResetScoreUponNextNonEmptyEntry) {
                result = 0.0;
                needToResetScoreUponNextNonEmptyEntry = false;
            }
            result += netPoints.doubleValue();
        }
        return result;
    }

    default public Double getNetPointsForScoreSum(AbstractSimpleLeaderboardImpl leaderboard, Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Set<RaceColumn> discardedRaceColumns) {
        return leaderboard.getNetPoints(competitor, raceColumn, timePoint, discardedRaceColumns);
    }

    default public Util.Pair<Integer, Boolean> getNewNumberOfMedalRacesWon(int numberOfMedalRacesWonSoFar, boolean clearNumberOfMedalRacesWonUponNextValidMedalRaceScore, Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        boolean newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore;
        int newNumberOfMedalRacesWonSoFar;
        Double totalPoints = totalPointsSupplier.apply(competitor);
        int winCount = this.getWinCount(leaderboard, competitor, raceColumn, totalPoints, timePoint, totalPointsSupplier, cache);
        if (raceColumn.isStartsWithZeroScore()) {
            if (totalPoints != null) {
                newNumberOfMedalRacesWonSoFar = winCount;
                newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore = false;
            } else {
                newNumberOfMedalRacesWonSoFar = numberOfMedalRacesWonSoFar;
                newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore = true;
            }
        } else if (totalPoints != null) {
            newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore = false;
            newNumberOfMedalRacesWonSoFar = clearNumberOfMedalRacesWonUponNextValidMedalRaceScore ? winCount : numberOfMedalRacesWonSoFar + winCount;
        } else {
            newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore = clearNumberOfMedalRacesWonUponNextValidMedalRaceScore;
            newNumberOfMedalRacesWonSoFar = numberOfMedalRacesWonSoFar;
        }
        return new Util.Pair((Object)newNumberOfMedalRacesWonSoFar, (Object)newClearNumberOfMedalRacesWonUponNextValidMedalRaceScore);
    }

    default public int getWinCount(Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, Double totalPoints, TimePoint timePoint, Function<Competitor, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) {
        return totalPoints == null ? 0 : (this.isWin(leaderboard, competitor, raceColumn, timePoint, totalPointsSupplier, cache) ? 1 : 0);
    }

    default public int compareByMedalRacesWon(int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        return Integer.compare(numberOfMedalRacesWonO2, numberOfMedalRacesWonO1);
    }

    default public int compareByScoreSum(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, double o1ScoreSum, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, double o2ScoreSum, boolean nullScoresAreBetter, boolean haveValidMedalRaceScores, Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries) {
        return this.getScoreComparator(nullScoresAreBetter).compare(o1ScoreSum, o2ScoreSum);
    }

    default public int compareByMedalRaceScore(Double o1MedalRaceScore, Double o2MedalRaceScore, boolean nullScoresAreBetter) {
        assert (o1MedalRaceScore != null || o2MedalRaceScore == null);
        int result = o1MedalRaceScore != null ? this.getScoreComparator(nullScoresAreBetter).compare(o1MedalRaceScore, o2MedalRaceScore) : 0;
        return result;
    }

    default public int compareBySingleRaceColumnScore(Double o1Score, Double o2Score, boolean nullScoresAreBetter) {
        return Comparator.nullsLast((o1s, o2s) -> this.getScoreComparator(nullScoresAreBetter).compare((Double)o1s, (Double)o2s)).compare(o1Score, o2Score);
    }

    default public int compareByLastMedalRacesCriteria(Competitor o1, List<Util.Pair<RaceColumn, Double>> o1Scores, Competitor o2, List<Util.Pair<RaceColumn, Double>> o2Scores, boolean nullScoresAreBetter, Leaderboard leaderboard, Iterable<RaceColumn> raceColumnsToConsider, BiFunction<Competitor, RaceColumn, Double> totalPointsSupplier, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache, TimePoint timePoint, int zeroBasedIndexOfLastMedalSeriesInWhichBothScored, int numberOfMedalRacesWonO1, int numberOfMedalRacesWonO2) {
        return 0;
    }

    public LeaderboardTotalRankComparator getOpeningSeriesRankComparator(Iterable<RaceColumn> var1, boolean var2, TimePoint var3, Leaderboard var4, BiFunction<Competitor, RaceColumn, Double> var5, WindLegTypeAndLegBearingAndORCPerformanceCurveCache var6);

    default public boolean isParticipatingInMedalRace(Competitor competitor, Double competitorMedalRaceScore, RaceColumnInSeries medalRaceColumn, Supplier<Map<Competitor, Integer>> competitorsRankedByOpeningSeries) {
        return competitorMedalRaceScore != null;
    }
}

