/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.leaderboard;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatChangeListener;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorChangeListener;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardChangeListener;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.WithNationality;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.leaderboard.AbstractScoreCorrectionListenerWithDefaultAction;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardCache;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sse.common.Color;
import com.sap.sse.common.Duration;
import com.sap.sse.concurrent.ConcurrentWeakHashMap;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class LeaderboardCacheManager {
    private final WeakHashMap<Leaderboard, CacheInvalidationUponScoreCorrectionListener> scoreCorrectionListeners;
    private final WeakHashMap<Leaderboard, NameChangeListener> nameChangeListeners;
    private final NamedReentrantReadWriteLock scoreCorrectionAndCompetitorAndNameChangeListenersLock;
    private final WeakHashMap<Leaderboard, CacheInvalidationUponCompetitorChangeListener> competitorChangeListeners;
    private final WeakHashMap<Leaderboard, CacheInvalidationUponBoatChangeListener> boatChangeListeners;
    private final ConcurrentWeakHashMap<Leaderboard, ConcurrentMap<TrackedRace, Set<CacheInvalidationListener>>> invalidationListenersPerLeaderboard;
    private final WeakHashMap<Leaderboard, RaceColumnListener> raceColumnListeners;
    private final LeaderboardCache leaderboardCache;

    public LeaderboardCacheManager(LeaderboardCache leaderboardCache) {
        this.leaderboardCache = leaderboardCache;
        this.invalidationListenersPerLeaderboard = new ConcurrentWeakHashMap();
        this.raceColumnListeners = new WeakHashMap();
        this.scoreCorrectionListeners = new WeakHashMap();
        this.nameChangeListeners = new WeakHashMap();
        this.scoreCorrectionAndCompetitorAndNameChangeListenersLock = new NamedReentrantReadWriteLock("Score correction and competitor and name change listeners", false);
        this.competitorChangeListeners = new WeakHashMap();
        this.boatChangeListeners = new WeakHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromCache(Leaderboard leaderboard) {
        NameChangeListener removedNameChangeListener;
        CacheInvalidationUponBoatChangeListener removedBoatChangeListener;
        CacheInvalidationUponCompetitorChangeListener removedCompetitorChangeListener;
        CacheInvalidationUponScoreCorrectionListener cacheInvalidationUponScoreCorrectionListener;
        ConcurrentMap listenersMap = (ConcurrentMap)this.invalidationListenersPerLeaderboard.remove((Object)leaderboard);
        if (listenersMap != null) {
            for (Map.Entry entry : listenersMap.entrySet()) {
                Set set = (Set)entry.getValue();
                synchronized (set) {
                    for (CacheInvalidationListener listener : (Set)entry.getValue()) {
                        listener.removeFromTrackedRace();
                    }
                }
            }
        }
        WeakHashMap<Leaderboard, RaceColumnListener> weakHashMap = this.raceColumnListeners;
        synchronized (weakHashMap) {
            leaderboard.removeRaceColumnListener(this.raceColumnListeners.remove(leaderboard));
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
        try {
            cacheInvalidationUponScoreCorrectionListener = this.scoreCorrectionListeners.remove(leaderboard);
            removedCompetitorChangeListener = this.competitorChangeListeners.remove(leaderboard);
            removedBoatChangeListener = this.boatChangeListeners.remove(leaderboard);
            removedNameChangeListener = this.nameChangeListeners.remove(leaderboard);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
        }
        if (cacheInvalidationUponScoreCorrectionListener != null) {
            leaderboard.getScoreCorrection().removeScoreCorrectionListener(cacheInvalidationUponScoreCorrectionListener);
        }
        if (removedCompetitorChangeListener != null) {
            removedCompetitorChangeListener.removeFromAllCompetitors();
        }
        if (removedBoatChangeListener != null) {
            removedBoatChangeListener.removeFromAllBoats();
        }
        if (removedNameChangeListener != null) {
            leaderboard.removeLeaderboardChangeListener(removedNameChangeListener);
        }
        this.leaderboardCache.invalidate(leaderboard);
    }

    public void add(Leaderboard leaderboard) {
        this.leaderboardCache.add(leaderboard);
        this.registerAsListener(leaderboard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerAsListener(final Leaderboard leaderboard) {
        boolean containsKey;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
        try {
            containsKey = this.scoreCorrectionListeners.containsKey(leaderboard);
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
        }
        if (!containsKey) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
            try {
                for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                    this.registerListener(leaderboard, trackedRace);
                }
                CacheInvalidationUponScoreCorrectionListener scoreCorrectionListener = new CacheInvalidationUponScoreCorrectionListener(leaderboard);
                CacheInvalidationUponCompetitorChangeListener competitorChangeListener = new CacheInvalidationUponCompetitorChangeListener(leaderboard);
                CacheInvalidationUponBoatChangeListener boatChangeListener = new CacheInvalidationUponBoatChangeListener(leaderboard);
                NameChangeListener nameChangeListener = new NameChangeListener(leaderboard);
                leaderboard.addScoreCorrectionListener(scoreCorrectionListener);
                leaderboard.addLeaderboardChangeListener(nameChangeListener);
                this.scoreCorrectionListeners.put(leaderboard, scoreCorrectionListener);
                this.competitorChangeListeners.put(leaderboard, competitorChangeListener);
                this.boatChangeListeners.put(leaderboard, boatChangeListener);
                this.nameChangeListeners.put(leaderboard, nameChangeListener);
                RaceColumnListenerWithDefaultAction raceColumnListener = new RaceColumnListenerWithDefaultAction(){
                    private static final long serialVersionUID = 8165124797028386317L;

                    @Override
                    public void defaultAction() {
                        LeaderboardCacheManager.this.removeFromCache(leaderboard);
                    }

                    @Override
                    public void trackedRaceLinked(RaceColumn raceColumn, Fleet fleet, TrackedRace trackedRace) {
                        this.defaultAction();
                        LeaderboardCacheManager.this.registerListener(leaderboard, trackedRace);
                    }

                    @Override
                    public boolean isTransient() {
                        return true;
                    }
                };
                leaderboard.addRaceColumnListener(raceColumnListener);
                WeakHashMap<Leaderboard, RaceColumnListener> weakHashMap = this.raceColumnListeners;
                synchronized (weakHashMap) {
                    this.raceColumnListeners.put(leaderboard, raceColumnListener);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.scoreCorrectionAndCompetitorAndNameChangeListenersLock);
            }
        }
    }

    private void registerListener(Leaderboard leaderboard, TrackedRace trackedRace) {
        Set<CacheInvalidationListener> listeners;
        CacheInvalidationListener listener = new CacheInvalidationListener(leaderboard, trackedRace);
        trackedRace.addListener(listener);
        ConcurrentHashMap<TrackedRace, Set<CacheInvalidationListener>> invalidationListeners = (ConcurrentHashMap<TrackedRace, Set<CacheInvalidationListener>>)this.invalidationListenersPerLeaderboard.get((Object)leaderboard);
        if (invalidationListeners == null) {
            invalidationListeners = new ConcurrentHashMap<TrackedRace, Set<CacheInvalidationListener>>();
            this.invalidationListenersPerLeaderboard.put((Object)leaderboard, invalidationListeners);
        }
        if ((listeners = (Set<CacheInvalidationListener>)invalidationListeners.get(trackedRace)) == null) {
            listeners = Collections.synchronizedSet(new HashSet());
            invalidationListeners.put(trackedRace, listeners);
        }
        listeners.add(listener);
    }

    private class CacheInvalidationListener
    extends AbstractRaceChangeListener {
        private final Leaderboard leaderboard;
        private final TrackedRace trackedRace;

        public CacheInvalidationListener(Leaderboard leaderboard, TrackedRace trackedRace) {
            this.leaderboard = leaderboard;
            this.trackedRace = trackedRace;
        }

        @Override
        protected void defaultAction() {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        private void removeFromTrackedRace() {
            this.trackedRace.removeListener(this);
        }
    }

    private class CacheInvalidationUponBoatChangeListener
    implements BoatChangeListener {
        private static final long serialVersionUID = -8117073993497852698L;
        private final Leaderboard leaderboard;
        private final Set<Boat> boatsToStopObserving;

        public CacheInvalidationUponBoatChangeListener(Leaderboard leaderboard) {
            this.leaderboard = leaderboard;
            this.boatsToStopObserving = this.registerBoatListeners();
        }

        public Set<Boat> registerBoatListeners() {
            HashSet<Boat> boatsToStopObserving = new HashSet<Boat>();
            for (Boat boat : this.leaderboard.getAllBoats()) {
                boat.addBoatChangeListener((BoatChangeListener)this);
                boatsToStopObserving.add(boat);
            }
            return boatsToStopObserving;
        }

        public synchronized void removeFromAllBoats() {
            for (Boat boat : this.boatsToStopObserving) {
                boat.removeBoatChangeListener((BoatChangeListener)this);
            }
        }

        public void nameChanged(String oldName, String newName) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void colorChanged(Color oldColor, Color newColor) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void sailIdChanged(String oldSailId, String newSailId) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }
    }

    private class CacheInvalidationUponCompetitorChangeListener
    implements CompetitorChangeListener {
        private static final long serialVersionUID = 8308312509904366143L;
        private final Leaderboard leaderboard;
        private final Set<Competitor> competitorsToStopObserving;

        public CacheInvalidationUponCompetitorChangeListener(Leaderboard leaderboard) {
            this.leaderboard = leaderboard;
            this.competitorsToStopObserving = this.registerCompetitorListeners();
        }

        public void nationalityChanged(WithNationality what, Nationality oldNationality, Nationality newNationality) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void colorChanged(Color oldColor, Color newColor) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void nameChanged(String oldName, String newName) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void shortNameChanged(String oldShortName, String newShortName) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public Set<Competitor> registerCompetitorListeners() {
            HashSet<Competitor> competitorsToStopObserving = new HashSet<Competitor>();
            for (Competitor competitor : this.leaderboard.getCompetitors()) {
                competitor.addCompetitorChangeListener((CompetitorChangeListener)this);
                competitorsToStopObserving.add(competitor);
            }
            return competitorsToStopObserving;
        }

        public synchronized void removeFromAllCompetitors() {
            for (Competitor competitor : this.competitorsToStopObserving) {
                competitor.removeCompetitorChangeListener((CompetitorChangeListener)this);
            }
        }

        public void emailChanged(String oldEmail, String newEmail) {
        }

        public void searchTagChanged(String oldSearchTag, String newSearchTag) {
        }

        public void flagImageChanged(URI oldFlagImageURL, URI newFlagImageURL) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void timeOnTimeFactorChanged(Double oldTimeOnTimeFactor, Double newTimeOnTimeFactor) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }

        public void timeOnDistanceAllowancePerNauticalMileChanged(Duration oldTimeOnDistanceAllowancePerNauticalMile, Duration newTimeOnDistanceAllowancePerNauticalMile) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }
    }

    private class CacheInvalidationUponScoreCorrectionListener
    extends AbstractScoreCorrectionListenerWithDefaultAction {
        private final Leaderboard leaderboard;

        public CacheInvalidationUponScoreCorrectionListener(Leaderboard leaderboard) {
            this.leaderboard = leaderboard;
        }

        @Override
        public void defaultAction() {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }
    }

    private class NameChangeListener
    implements LeaderboardChangeListener {
        private final Leaderboard leaderboard;

        public NameChangeListener(Leaderboard leaderboard) {
            this.leaderboard = leaderboard;
        }

        public void displayNameChanged(String oldDisplayName, String newDisplayName) {
            LeaderboardCacheManager.this.removeFromCache(this.leaderboard);
        }
    }
}

