/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.AbstractRaceColumn;
import com.sap.sailing.domain.common.racelog.tracking.CompetitorRegistrationOnRaceLogDisabledException;
import com.sap.sailing.domain.tracking.RaceExecutionOrderProvider;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import java.util.Iterator;
import java.util.Map;

public class RaceColumnInSeriesImpl
extends AbstractRaceColumn
implements RaceColumnInSeries {
    private static final long serialVersionUID = -2199678838624406645L;
    private final Series series;
    private final String name;
    private final transient TrackedRegattaRegistry trackedRegattaRegistry;

    public RaceColumnInSeriesImpl(String name, Series series, TrackedRegattaRegistry trackedRegattaRegistry) {
        this.name = name;
        this.series = series;
        this.trackedRegattaRegistry = trackedRegattaRegistry;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Regatta getRegatta() {
        return this.getSeries().getRegatta();
    }

    @Override
    public Iterable<? extends Fleet> getFleets() {
        return this.series.getFleets();
    }

    @Override
    public boolean isMedalRace() {
        return this.series.isMedal();
    }

    @Override
    public boolean isOneAlwaysStaysOne() {
        return this.getSeries().isOneAlwaysStaysOne();
    }

    @Override
    public Series getSeries() {
        return this.series;
    }

    @Override
    public void setTrackedRace(Fleet fleet, TrackedRace trackedRace) {
        TrackedRegatta trackedRegatta;
        Regatta regatta;
        if (this.trackedRegattaRegistry != null && trackedRace != null && (regatta = (trackedRegatta = trackedRace.getTrackedRegatta()).getRegatta()) != this.getRegatta()) {
            throw new IllegalArgumentException("Trying to associate tracked race of regatta " + regatta.getName() + " to a race column of regatta " + this.getRegatta().getName());
        }
        super.setTrackedRace(fleet, trackedRace);
    }

    private boolean isFirstColumnInSeries() {
        Iterator<? extends RaceColumnInSeries> columnIter = this.getSeries().getRaceColumns().iterator();
        return columnIter.hasNext() && columnIter.next() == this;
    }

    @Override
    public boolean isStartsWithZeroScore() {
        return this.getSeries().isStartsWithZeroScore() && this.isFirstColumnInSeries();
    }

    @Override
    public boolean isDiscardable() {
        return !this.isMedalRace() && (!this.isFirstColumnInSeries() || !this.getSeries().isFirstColumnNonDiscardableCarryForward());
    }

    @Override
    public boolean isCarryForward() {
        return this.isFirstColumnInSeries() && this.getSeries().isFirstColumnNonDiscardableCarryForward();
    }

    @Override
    public boolean hasSplitFleetContiguousScoring() {
        return this.getSeries().hasSplitFleetContiguousScoring();
    }

    @Override
    public boolean hasCrossFleetMergedRanking() {
        return this.getSeries().hasCrossFleetMergedRanking();
    }

    @Override
    public RaceExecutionOrderProvider getRaceExecutionOrderProvider() {
        RaceExecutionOrderProvider result = this.getRegatta() != null ? this.getRegatta().getRaceExecutionOrderProvider() : null;
        return result;
    }

    @Override
    public RegattaLog getRegattaLog() {
        Regatta regatta = this.getRegatta();
        return regatta == null ? null : regatta.getRegattaLog();
    }

    @Override
    public void registerCompetitor(CompetitorWithBoat competitorWithBoat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        assert (!this.getRegatta().canBoatsOfCompetitorsChangePerRace());
        super.registerCompetitor(competitorWithBoat, fleet);
    }

    @Override
    public void registerCompetitors(Iterable<CompetitorWithBoat> competitorWithBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        assert (!this.getRegatta().canBoatsOfCompetitorsChangePerRace());
        super.registerCompetitors(competitorWithBoats, fleet);
    }

    @Override
    public void registerCompetitor(Competitor competitor, Boat boat, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        assert (this.getRegatta().canBoatsOfCompetitorsChangePerRace());
        super.registerCompetitor(competitor, boat, fleet);
    }

    @Override
    public void registerCompetitors(Map<Competitor, Boat> competitorsAndBoats, Fleet fleet) throws CompetitorRegistrationOnRaceLogDisabledException {
        super.registerCompetitors(competitorsAndBoats, fleet);
    }
}

