/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.base.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.tracking.TrackedRace;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class LeaderboardSearchResultImpl
implements LeaderboardSearchResult {
    private final Leaderboard leaderboard;
    private final Set<Event> events;
    private final Set<LeaderboardGroup> leaderboardGroups;

    public LeaderboardSearchResultImpl(Leaderboard leaderboard, Set<Event> events, Set<LeaderboardGroup> leaderboardGroups) {
        this.leaderboard = leaderboard;
        this.leaderboardGroups = leaderboardGroups == null ? Collections.emptySet() : leaderboardGroups;
        this.events = events;
    }

    @Override
    public Regatta getRegatta() {
        Regatta regatta = this.leaderboard instanceof RegattaLeaderboard ? ((RegattaLeaderboard)this.leaderboard).getRegatta() : null;
        return regatta;
    }

    public String getRegattaName() {
        return this.getRegatta() != null ? this.getRegatta().getName() : null;
    }

    @Override
    public Leaderboard getLeaderboard() {
        return this.leaderboard;
    }

    @Override
    public Iterable<Event> getEvents() {
        return this.events;
    }

    @Override
    public Iterable<LeaderboardGroup> getLeaderboardGroups() {
        return this.leaderboardGroups;
    }

    public String getBoatClassName() {
        BoatClass boatClass = this.getBoatClass();
        return boatClass == null ? null : boatClass.getName();
    }

    public BoatClass getBoatClass() {
        BoatClass boatClass = this.getRegatta() != null ? this.getRegatta().getBoatClass() : this.getBoatClassFromTrackedRaces();
        return boatClass;
    }

    private BoatClass getBoatClassFromTrackedRaces() {
        Iterator<TrackedRace> iterator = this.getLeaderboard().getTrackedRaces().iterator();
        if (iterator.hasNext()) {
            TrackedRace trackedRace = iterator.next();
            return trackedRace.getRace().getBoatClass();
        }
        return null;
    }
}

