/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MetadataCollection;
import com.sap.sailing.domain.persistence.racelog.tracking.impl.MetadataUpdate;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.TransformationException;
import com.sap.sse.util.ThreadPoolUtil;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MetadataUpdater {
    private static final Logger logger = Logger.getLogger(MetadataUpdater.class.getName());
    private final ScheduledExecutorService executor;
    private final DeviceIdentifier forDevice;
    private final MetadataCollection metadataCollection;
    private Future<?> runningUpdateTask;
    private MetadataUpdate<?> nextUpdate;
    private MetadataUpdate<?> currentUpdate;
    private long updatesProcessed;

    MetadataUpdater(ScheduledExecutorService executor, MetadataCollection metadataCollection, DeviceIdentifier forDevice) {
        this.executor = executor;
        this.metadataCollection = metadataCollection;
        this.forDevice = forDevice;
    }

    MetadataUpdater(MetadataCollection metadataCollection, DeviceIdentifier forDevice) {
        this(ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor(), metadataCollection, forDevice);
    }

    synchronized <FixT extends Timed> void enqueueMetadataUpdate(DeviceIdentifier device, Object dbDeviceId, int nrOfTotalFixes, TimeRange fixesTimeRange, FixT latestFix) throws TransformationException {
        MetadataUpdate<FixT> update = new MetadataUpdate<FixT>(device, dbDeviceId, nrOfTotalFixes, fixesTimeRange, latestFix);
        if (this.runningUpdateTask == null) {
            this.setNextUpdate(update);
            this.scheduleUpdate();
        } else if (this.getNextUpdate() == null) {
            this.setNextUpdate(update);
        } else {
            MetadataUpdate<FixT> theNextUpdate = this.getNextUpdate();
            this.setNextUpdate(theNextUpdate.merge(update));
        }
    }

    private synchronized <FixT extends Timed> void scheduleUpdate() {
        assert (this.runningUpdateTask == null && this.nextUpdate != null);
        this.runningUpdateTask = this.executor.submit(() -> {
            boolean currentUpdateNullInSynchronizedBlock;
            logger.fine(() -> "Starting metadata updater task for device " + this.forDevice);
            MetadataUpdater metadataUpdater = this;
            synchronized (metadataUpdater) {
                this.currentUpdate = this.getNextUpdate();
                boolean bl = currentUpdateNullInSynchronizedBlock = this.currentUpdate == null;
                if (currentUpdateNullInSynchronizedBlock) {
                    this.runningUpdateTask = null;
                } else {
                    this.setNextUpdate(null);
                }
            }
            do {
                if (currentUpdateNullInSynchronizedBlock) continue;
                boolean success = false;
                int retryCount = 3;
                do {
                    try {
                        this.metadataCollection.update(this.currentUpdate);
                        success = true;
                    }
                    catch (Exception e) {
                        logger.severe("Unable to write update " + this.currentUpdate + " to the metadata collection for device " + this.forDevice + ": " + e.getMessage() + "; retrying " + retryCount + " more times.");
                        Thread.sleep(3000L);
                    }
                } while (!success && retryCount-- > 0);
                MetadataUpdater metadataUpdater2 = this;
                synchronized (metadataUpdater2) {
                    this.currentUpdate = this.getNextUpdate();
                    boolean bl = currentUpdateNullInSynchronizedBlock = this.currentUpdate == null;
                    if (currentUpdateNullInSynchronizedBlock) {
                        this.runningUpdateTask = null;
                    } else {
                        this.setNextUpdate(null);
                    }
                    ++this.updatesProcessed;
                    this.notifyAll();
                }
            } while (!currentUpdateNullInSynchronizedBlock);
            logger.fine(() -> "Terminating metadata updater task for device " + this.forDevice);
            return null;
        });
    }

    private <FixT extends Timed> void setNextUpdate(MetadataUpdate<FixT> update) {
        assert (update == null || update.getDevice().equals(this.forDevice));
        this.nextUpdate = update;
    }

    private synchronized <FixT extends Timed> MetadataUpdate<FixT> getNextUpdate() {
        return this.nextUpdate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitForPendingUpdates() {
        MetadataUpdater metadataUpdater = this;
        synchronized (metadataUpdater) {
            if (this.runningUpdateTask != null) {
                long waitUntilTheseManyUpdatesProcessed = this.getNextUpdate() == null ? (this.currentUpdate == null ? this.updatesProcessed : this.updatesProcessed + 1L) : (this.currentUpdate == null ? this.updatesProcessed + 1L : this.updatesProcessed + 2L);
                while (this.updatesProcessed < waitUntilTheseManyUpdatesProcessed) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        logger.log(Level.WARNING, "Interrupted while waiting for pending updates; continuing to wait...", e);
                    }
                }
            }
        }
    }
}

