/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.racelog.tracking.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Positioned;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.impl.DomainObjectFactoryImpl;
import com.sap.sailing.domain.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sailing.domain.persistence.racelog.tracking.FixMongoHandler;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import org.bson.Document;

public class GPSFixMovingMongoHandlerImpl
implements FixMongoHandler<GPSFixMoving> {
    private final MongoObjectFactoryImpl mof;
    private final DomainObjectFactoryImpl dof;

    public GPSFixMovingMongoHandlerImpl(MongoObjectFactory mof, DomainObjectFactory dof) {
        this.mof = (MongoObjectFactoryImpl)mof;
        this.dof = (DomainObjectFactoryImpl)dof;
    }

    public Document transformForth(GPSFixMoving fix) throws IllegalArgumentException {
        Document result = new Document();
        this.mof.storeTimed((Timed)fix, result);
        this.mof.storePositioned((Positioned)fix, result);
        this.mof.storeSpeedWithBearing(fix.getSpeed(), result);
        this.mof.storeOptionalTrueHeading(fix.getOptionalTrueHeading(), result);
        return result;
    }

    public GPSFixMoving transformBack(Document dbObject) {
        TimePoint timePoint = this.dof.loadTimePoint(dbObject);
        Position position = com.sap.sailing.shared.persistence.impl.DomainObjectFactoryImpl.loadPosition((Document)dbObject);
        SpeedWithBearing speed = this.dof.loadSpeedWithBearing(dbObject);
        Bearing optionalTrueHeading = this.dof.loadOptionalTrueHeading(dbObject);
        return new GPSFixMovingImpl(position, timePoint, speed, optionalTrueHeading);
    }
}

