/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.persistence.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.MigratableRegatta;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MigratableRegattaImpl
extends RegattaImpl
implements MigratableRegatta {
    private static final long serialVersionUID = -3545488249832218320L;
    private static final Logger logger = Logger.getLogger(MigratableRegattaImpl.class.getName());
    private final transient MongoObjectFactory mongoObjectFactory;

    public <S extends Series> MigratableRegattaImpl(RaceLogStore raceLogStore, RegattaLogStore regattaLogStore, String name, BoatClass boatClass, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, TimePoint startDate, TimePoint endDate, Iterable<S> series, boolean persistent, ScoringScheme scoringScheme, Serializable id, Iterable<CourseArea> courseAreas, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor, MongoObjectFactory mongoObjectFactory, String registrationLinkSecret) {
        super(raceLogStore, regattaLogStore, name, boatClass, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, series, persistent, scoringScheme, id, courseAreas, buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, registrationLinkSecret);
        this.mongoObjectFactory = mongoObjectFactory;
        mongoObjectFactory.storeRegatta((Regatta)this);
    }

    public synchronized void migrateCanBoatsOfCompetitorsChangePerRace() {
        assert (!this.canBoatsOfCompetitorsChangePerRace() && Util.size((Iterable)this.getAllRaces()) == 0);
        super.setCanBoatsOfCompetitorsChangePerRace(true);
        if (this.mongoObjectFactory != null) {
            logger.log(Level.INFO, "Bug2822 DB-Migration: Store migrated regatta '" + this.getName() + "' having now canBoatsOfCompetitorsChangePerRace=true.");
            this.mongoObjectFactory.storeRegatta((Regatta)this);
        }
    }
}

