/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.manage2sail;

import com.sap.sailing.domain.common.CompetitorGenderType;
import com.sap.sailing.manage2sail.Activator;
import com.sap.sailing.manage2sail.EventResultDescriptor;
import com.sap.sailing.manage2sail.Manage2SailEventResultsParser;
import com.sap.sailing.manage2sail.RaceResultDescriptor;
import com.sap.sailing.manage2sail.RegattaResultDescriptor;
import com.sap.sse.InvalidDateException;
import com.sap.sse.util.DateParser;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class Manage2SailEventResultsParserImpl
implements Manage2SailEventResultsParser {
    public EventResultDescriptor getEventResult(URL eventJsonUrl) throws MalformedURLException, IOException, URISyntaxException {
        return this.getEventResult((InputStream)HttpUrlConnectionHelper.redirectConnection((URL)Activator.getInstance().addAccessTokenToManage2SailUrl(eventJsonUrl)).getContent());
    }

    @Override
    public EventResultDescriptor getEventResult(InputStream is) throws IOException {
        EventResultDescriptor result = null;
        try {
            try {
                JSONObject jsonRoot = (JSONObject)new JSONParser().parse((Reader)new InputStreamReader(is, "UTF-8"));
                result = new EventResultDescriptor();
                result.setId((String)jsonRoot.get((Object)"Id"));
                result.setIsafId((String)jsonRoot.get((Object)"IsafId"));
                result.setName((String)jsonRoot.get((Object)"Name"));
                result.setXrrUrl(this.parseURL(jsonRoot, "XrrUrl"));
                JSONObject jsonTracking = (JSONObject)jsonRoot.get((Object)"Tracking");
                if (jsonTracking != null) {
                    result.setTrackingDataHost((String)jsonTracking.get((Object)"Host"));
                    result.setTrackingDataPort(this.parseInteger(jsonTracking, "Port"));
                }
                JSONArray jsonRegattas = (JSONArray)jsonRoot.get((Object)"Regattas");
                for (Object regattaObject : jsonRegattas) {
                    RegattaResultDescriptor regattaResult = new RegattaResultDescriptor();
                    JSONObject jsonRegatta = (JSONObject)regattaObject;
                    regattaResult.setId((String)jsonRegatta.get((Object)"Id"));
                    regattaResult.setIsafId((String)jsonRegatta.get((Object)"IsafId"));
                    regattaResult.setExternalId((String)jsonRegatta.get((Object)"ExternalId"));
                    regattaResult.setName((String)jsonRegatta.get((Object)"Name"));
                    regattaResult.setCompetitorGenderType(this.parseCompetitorGenderType(jsonRegatta, "Gender"));
                    regattaResult.setClassName((String)jsonRegatta.get((Object)"ClassName"));
                    regattaResult.setPdfUrl(this.parseURL(jsonRegatta, "PdfUrl"));
                    regattaResult.setXrrPreliminaryUrl(this.parseURL(jsonRegatta, "XrrPreliminaryUrl"));
                    regattaResult.setXrrFinalUrl(this.parseURL(jsonRegatta, "XrrFinalUrl"));
                    regattaResult.setXrrEntriesUrl(this.parseURL(jsonRegatta, "XrrEntriesUrl"));
                    regattaResult.setHtmlUrl(this.parseURL(jsonRegatta, "HtmlUrl"));
                    regattaResult.setPublishedAt(this.parseDate(jsonRegatta, "Published"));
                    regattaResult.setIsFinal((Boolean)jsonRegatta.get((Object)"Final"));
                    JSONArray jsonRaces = (JSONArray)jsonRegatta.get((Object)"Races");
                    if (jsonRaces != null) {
                        for (Object raceObject : jsonRaces) {
                            RaceResultDescriptor raceResult = new RaceResultDescriptor();
                            JSONObject jsonRace = (JSONObject)raceObject;
                            raceResult.setId((String)jsonRace.get((Object)"Id"));
                            raceResult.setName((String)jsonRace.get((Object)"Name"));
                            raceResult.setRaceColumnNumber(this.parseInteger(jsonRace, "RaceIndex"));
                            raceResult.setStatus((String)jsonRace.get((Object)"Status"));
                            raceResult.setSeriesName((String)jsonRace.get((Object)"Series"));
                            raceResult.setFleetName((String)jsonRace.get((Object)"Fleet"));
                            raceResult.setTracked((Boolean)jsonRace.get((Object)"IsTracked"));
                            raceResult.setStartTime(this.parseDate(jsonRace, "StartTime"));
                            regattaResult.getRaceResults().add(raceResult);
                        }
                    }
                    result.getRegattaResults().add(regattaResult);
                }
                is.close();
            }
            catch (ParseException e) {
                e.printStackTrace();
                is.close();
            }
        }
        finally {
            is.close();
        }
        return result;
    }

    private CompetitorGenderType parseCompetitorGenderType(JSONObject jsonDate, String attributeName) {
        CompetitorGenderType result;
        block16: {
            result = null;
            String genderTypeAsString = (String)jsonDate.get((Object)attributeName);
            if (genderTypeAsString == null) break block16;
            switch (genderTypeAsString) {
                case "M": {
                    result = CompetitorGenderType.Men;
                    break;
                }
                case "W": {
                    result = CompetitorGenderType.Women;
                    break;
                }
                case "X": {
                    result = CompetitorGenderType.Mixed;
                    break;
                }
                case "Open": {
                    result = CompetitorGenderType.Open;
                }
            }
        }
        return result;
    }

    private Integer parseInteger(JSONObject jsonNumber, String attributeName) {
        Integer result = null;
        Object object = jsonNumber.get((Object)attributeName);
        if (object != null) {
            String numberAsString;
            if (object instanceof Number) {
                result = ((Number)object).intValue();
            } else if (object instanceof String && !(numberAsString = (String)object).isEmpty()) {
                try {
                    result = Integer.parseInt(numberAsString);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private Date parseDate(JSONObject jsonDate, String attributeName) {
        Date result = null;
        String dateAsString = (String)jsonDate.get((Object)attributeName);
        if (dateAsString != null && !dateAsString.isEmpty()) {
            try {
                result = DateParser.parseUTC((String)dateAsString);
            }
            catch (InvalidDateException invalidDateException) {
                // empty catch block
            }
        }
        return result;
    }

    private URL parseURL(JSONObject jsonURL, String attributeName) {
        URL result = null;
        String urlAsString = (String)jsonURL.get((Object)attributeName);
        if (urlAsString != null && !urlAsString.isEmpty()) {
            try {
                result = new URL(urlAsString);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return result;
    }
}

