/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.subscription;

import com.sap.sse.security.shared.impl.Role;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.subscription.SubscriptionPlanRole;
import com.sap.sse.security.shared.subscription.SubscriptionPrice;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class SubscriptionPlan
implements Serializable {
    private static final long serialVersionUID = -555811806344107292L;
    private final String id;
    private final Set<SubscriptionPrice> prices;
    private final Set<PlanCategory> planCategory;
    private final Boolean isOneTimePlan;
    private final PlanGroup group;
    private final SubscriptionPlanRole[] roles;

    protected SubscriptionPlan(String id, Set<SubscriptionPrice> prices, Set<PlanCategory> planCategory, Boolean isOneTimePlan, PlanGroup group, SubscriptionPlanRole[] roles) {
        this.id = id;
        this.roles = roles;
        this.prices = prices;
        this.planCategory = planCategory;
        this.isOneTimePlan = isOneTimePlan;
        this.group = group;
    }

    public String getId() {
        return this.id;
    }

    public Set<SubscriptionPrice> getPrices() {
        return this.prices;
    }

    public SubscriptionPlanRole[] getRoles() {
        return this.roles;
    }

    public Set<PlanCategory> getPlanCategories() {
        return this.planCategory;
    }

    public Boolean getIsOneTimePlan() {
        return this.isOneTimePlan;
    }

    public PlanGroup getGroup() {
        return this.group;
    }

    public boolean isUserInPossessionOfRoles(User user) {
        boolean foundAll = true;
        SubscriptionPlanRole[] subscriptionPlanRoleArray = this.getRoles();
        int n = subscriptionPlanRoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            SubscriptionPlanRole planRole = subscriptionPlanRoleArray[n2];
            boolean found = false;
            for (Role userRole : user.getRoles()) {
                if (!userRole.getRoleDefinition().getId().equals(planRole.getRoleId())) continue;
                found = true;
                break;
            }
            if (!found) {
                foundAll = false;
                break;
            }
            ++n2;
        }
        return foundAll;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + Arrays.hashCode(this.roles);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionPlan other = (SubscriptionPlan)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return Arrays.equals(this.roles, other.roles);
    }

    public static enum PlanCategory {
        BASIC("free_subscription_plan", "features_organize_events", "features_events_with_more_regatta", "features_connect_to_tractrac", "features_imports", "features_media_management", "features_limited_live_analytics", "features_media_tags", "features_scoring"),
        PREMIUM("premium", "features_organize_events", "features_events_with_more_regatta", "features_connect_to_tractrac", "features_imports", "features_media_management", "features_limited_live_analytics", "features_media_tags", "features_scoring", "features_wind_analytics", "features_maneuver_analytics", "features_competitor_analytics", "features_advanced_leaderboard_info", "features_simulator", "features_map_analytics"),
        DATA_MINING_ARCHIVE("data_mining_archive", "features_organize_events", "features_events_with_more_regatta", "features_connect_to_tractrac", "features_imports", "features_media_management", "features_limited_live_analytics", "features_media_tags", "features_scoring", "features_wind_analytics", "features_maneuver_analytics", "features_competitor_analytics", "features_advanced_leaderboard_info", "features_simulator", "features_map_analytics", "features_data_mining"),
        DATA_MINING_ALL("data_mining_all", "features_organize_events", "features_events_with_more_regatta", "features_connect_to_tractrac", "features_imports", "features_media_management", "features_limited_live_analytics", "features_media_tags", "features_scoring", "features_wind_analytics", "features_maneuver_analytics", "features_competitor_analytics", "features_advanced_leaderboard_info", "features_simulator", "features_map_analytics", "features_data_mining", "features_data_mining_all"),
        TRIAL("trial", new String[0]);

        final String id;
        final Set<String> featureIds;

        private PlanCategory(String id, String ... featureIds) {
            this.id = id;
            this.featureIds = new HashSet<String>(Arrays.asList(featureIds));
        }

        public String getId() {
            return this.id;
        }

        public boolean containsFeature(String featureId) {
            return this.featureIds.contains(featureId);
        }

        private boolean hasFeature() {
            return !this.featureIds.isEmpty();
        }

        public static List<PlanCategory> getCategoriesWithFeature() {
            return Stream.of(PlanCategory.values()).filter(c -> c.hasFeature()).collect(Collectors.toList());
        }

        public static Set<String> getAllFeatureIds() {
            LinkedHashSet<String> featureIds = new LinkedHashSet<String>();
            PlanCategory[] planCategoryArray = PlanCategory.values();
            int n = planCategoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                PlanCategory category = planCategoryArray[n2];
                featureIds.addAll(category.featureIds);
                ++n2;
            }
            return featureIds;
        }
    }

    public static enum PlanGroup {
        PREMIUM("premium"),
        DATA_MINING_ARCHIVE("data_mining_archive"),
        DATA_MINING_ALL("data_mining_all"),
        TRIAL("trial");

        final String id;

        private PlanGroup(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

