/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared.impl;

import com.sap.sse.common.impl.NamedImpl;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.QualifiedObjectIdentifierImpl;
import com.sap.sse.security.shared.impl.WildcardPermissionEncoder;
import java.util.ArrayList;

public class HasPermissionsImpl
extends NamedImpl
implements HasPermissions {
    private static final long serialVersionUID = -7901836864741040400L;
    private HasPermissions.Action[] availableActions;

    public <T> HasPermissionsImpl(String logicalTypeName) {
        this(logicalTypeName, HasPermissions.DefaultActions.values());
    }

    public <T> HasPermissionsImpl(String logicalTypeName, HasPermissions.Action ... availableActions) {
        super(logicalTypeName);
        assert (logicalTypeName.equals(new WildcardPermissionEncoder().encodeAsPermissionPart(logicalTypeName)));
        int numberOfActionsAvailable = availableActions == null ? 0 : availableActions.length;
        this.availableActions = new HasPermissions.Action[numberOfActionsAvailable];
        if (availableActions != null) {
            System.arraycopy(availableActions, 0, this.availableActions, 0, numberOfActionsAvailable);
        }
    }

    public boolean equals(Object o) {
        return this.getName().equals(((HasPermissions)o).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public HasPermissions.Action[] getAvailableActions() {
        return this.availableActions;
    }

    @Override
    public boolean supports(HasPermissions.Action action) {
        HasPermissions.Action[] actionArray = this.availableActions;
        int n = this.availableActions.length;
        int n2 = 0;
        while (n2 < n) {
            HasPermissions.Action supportedAction = actionArray[n2];
            if (action.equals(supportedAction)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public String getStringPermission(HasPermissions.Action ... actions) {
        String result;
        if (actions == null || actions.length == 0) {
            result = this.getName();
        } else {
            StringBuilder modesString = new StringBuilder();
            boolean first = true;
            HasPermissions.Action[] actionArray = actions;
            int n = actions.length;
            int n2 = 0;
            while (n2 < n) {
                HasPermissions.Action action = actionArray[n2];
                assert (this.supports(action));
                if (first) {
                    first = false;
                } else {
                    modesString.append(",");
                }
                modesString.append(action.name());
                ++n2;
            }
            result = String.valueOf(this.getName()) + ":" + modesString.toString();
        }
        return result;
    }

    @Override
    public WildcardPermission getPermission(HasPermissions.Action ... actions) {
        return new WildcardPermission(this.getStringPermission(actions));
    }

    @Override
    public String getStringPermissionForTypeRelativeIdentifier(HasPermissions.Action action, TypeRelativeObjectIdentifier typeRelativeObjectIdentifier) {
        return this.getStringPermissionForTypeRelativeIdentifiers(action, typeRelativeObjectIdentifier.toString());
    }

    private String getStringPermissionForTypeRelativeIdentifiers(HasPermissions.Action action, String ... typeRelativeObjectIdentifiers) {
        assert (this.supports(action));
        StringBuilder result = new StringBuilder(this.getStringPermission(action));
        if (typeRelativeObjectIdentifiers != null && typeRelativeObjectIdentifiers.length > 0) {
            result.append(":");
            boolean first = true;
            String[] stringArray = typeRelativeObjectIdentifiers;
            int n = typeRelativeObjectIdentifiers.length;
            int n2 = 0;
            while (n2 < n) {
                String typeRelativeObjectIdentifier = stringArray[n2];
                if (first) {
                    first = false;
                } else {
                    result.append(",");
                }
                result.append(typeRelativeObjectIdentifier);
                ++n2;
            }
        }
        return result.toString();
    }

    @Override
    public String getStringPermissionForObject(HasPermissions.Action action, WithQualifiedObjectIdentifier domainObject) {
        return this.getStringPermissionForTypeRelativeIdentifiers(action, domainObject.getIdentifier().getTypeRelativeObjectIdentifier().toString());
    }

    @Override
    public QualifiedObjectIdentifier getQualifiedObjectIdentifier(TypeRelativeObjectIdentifier typeRelativeObjectIdentifier) {
        return new QualifiedObjectIdentifierImpl(this.getName(), typeRelativeObjectIdentifier);
    }

    @Override
    public WildcardPermission[] getPermissionsForTypeRelativeIdentifier(HasPermissions.Action[] actions, TypeRelativeObjectIdentifier typeRelativeIdentifier) {
        ArrayList<WildcardPermission> result = new ArrayList<WildcardPermission>();
        HasPermissions.Action[] actionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            HasPermissions.Action action = actionArray[n2];
            result.add(this.getPermissionForTypeRelativeIdentifier(action, typeRelativeIdentifier));
            ++n2;
        }
        return result.toArray(new WildcardPermission[result.size()]);
    }

    @Override
    public WildcardPermission getPermissionForTypeRelativeIdentifier(HasPermissions.Action action, TypeRelativeObjectIdentifier typeRelativeIdentifier) {
        assert (this.supports(action));
        return new WildcardPermission(this.getStringPermissionForTypeRelativeIdentifier(action, typeRelativeIdentifier));
    }

    @Override
    public WildcardPermission getPermissionForObject(HasPermissions.Action action, WithQualifiedObjectIdentifier object) {
        assert (this.supports(action));
        return new WildcardPermission(this.getStringPermissionForTypeRelativeIdentifier(action, object.getIdentifier().getTypeRelativeObjectIdentifier()));
    }
}

