/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.UserGroup;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public interface SecurityAccessControlList<G extends SecurityUserGroup<?>>
extends Serializable {
    public static final String DENY_PREFIX = "!";

    public PermissionChecker.PermissionState hasPermission(String var1, Iterable<G> var2);

    public Map<G, Set<String>> getActionsByUserGroup();

    public boolean addPermission(G var1, String var2);

    public boolean removePermission(G var1, String var2);

    public void setPermissions(G var1, Set<String> var2);

    public static boolean isDeniedAction(String action) {
        return action.startsWith(DENY_PREFIX);
    }

    public static String invertAction(String action) {
        String result = SecurityAccessControlList.isDeniedAction(action) ? action.substring(DENY_PREFIX.length()) : DENY_PREFIX + action;
        return result;
    }

    public Set<String> getAllowedActions(UserGroup var1);

    public Set<String> getDeniedActions(UserGroup var1);

    public Map<G, Set<WildcardPermission>> getDeniedActions();

    public Map<G, Set<WildcardPermission>> getAllowedActions();
}

