/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.shared;

import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.RoleDefinition;
import com.sap.sse.security.shared.SecurityUserGroup;
import com.sap.sse.security.shared.UserReference;
import com.sap.sse.security.shared.WildcardPermission;
import java.util.Set;

public abstract class AbstractRole<RD extends RoleDefinition, G extends SecurityUserGroup<?>, U extends UserReference>
implements Named {
    private static final long serialVersionUID = 1243342091492822614L;
    private static final String QUALIFIER_SEPARATOR = ":";
    protected RD roleDefinition;
    protected G qualifiedForTenant;
    protected U qualifiedForUser;
    protected Boolean transitive;

    @Deprecated
    protected AbstractRole() {
    }

    public AbstractRole(RD roleDefinition, Boolean transitive) {
        this(roleDefinition, null, null, transitive);
    }

    public AbstractRole(RD roleDefinition, G qualifiedForTenant, U qualifiedForUser, Boolean isTransitive) {
        if (roleDefinition == null) {
            throw new NullPointerException("A role's definition must not be null");
        }
        this.roleDefinition = roleDefinition;
        this.qualifiedForTenant = qualifiedForTenant;
        this.qualifiedForUser = qualifiedForUser;
        this.transitive = isTransitive;
    }

    public String getName() {
        return this.roleDefinition.getName();
    }

    public Boolean isTransitive() {
        return this.transitive;
    }

    public RD getRoleDefinition() {
        return this.roleDefinition;
    }

    public Set<WildcardPermission> getPermissions() {
        return this.roleDefinition.getPermissions();
    }

    public G getQualifiedForTenant() {
        return this.qualifiedForTenant;
    }

    public U getQualifiedForUser() {
        return this.qualifiedForUser;
    }

    public Util.Triple<String, String, String> getRoleDefinitionNameAndTenantQualifierNameAndUserQualifierName() {
        String roleDefinitionName = this.roleDefinition == null ? null : this.roleDefinition.getName();
        String tenantQualifierName = this.qualifiedForTenant == null ? null : this.qualifiedForTenant.getName();
        String userQualifierName = this.qualifiedForUser == null ? null : this.qualifiedForUser.getName();
        return new Util.Triple((Object)roleDefinitionName, (Object)tenantQualifierName, (Object)userQualifierName);
    }

    public String toString() {
        return String.valueOf(this.getName()) + (this.getQualifiedForTenant() != null || this.getQualifiedForUser() != null ? QUALIFIER_SEPARATOR : "") + (this.getQualifiedForTenant() != null ? this.getQualifiedForTenant().getName() : "") + (this.getQualifiedForUser() != null ? QUALIFIER_SEPARATOR + this.getQualifiedForUser().getName() : "");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.qualifiedForTenant == null ? 0 : this.qualifiedForTenant.getId().hashCode());
        result = 31 * result + (this.qualifiedForUser == null ? 0 : this.qualifiedForUser.getName().hashCode());
        result = 31 * result + (this.roleDefinition == null ? 0 : this.roleDefinition.hashCode());
        result = 31 * result + (this.transitive == null ? 0 : this.transitive.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractRole other = (AbstractRole)obj;
        if (this.qualifiedForTenant == null) {
            if (other.qualifiedForTenant != null) {
                return false;
            }
        } else {
            if (other.qualifiedForTenant == null) {
                return false;
            }
            if (!this.qualifiedForTenant.getId().equals(other.qualifiedForTenant.getId())) {
                return false;
            }
        }
        if (this.qualifiedForUser == null) {
            if (other.qualifiedForUser != null) {
                return false;
            }
        } else {
            if (other.qualifiedForUser == null) {
                return false;
            }
            if (!this.qualifiedForUser.getName().equals(other.qualifiedForUser.getName())) {
                return false;
            }
        }
        if (this.roleDefinition == null ? other.roleDefinition != null : !this.roleDefinition.equals(other.roleDefinition)) {
            return false;
        }
        return !(this.transitive == null ? other.transitive != null : !this.transitive.equals(other.transitive));
    }
}

