/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.ReplicaDescriptor;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ReplicationInstancesManager {
    private final Map<UUID, ReplicaDescriptor> replicaDescriptors = new HashMap<UUID, ReplicaDescriptor>();
    private final Map<ReplicaDescriptor, Map<Class<? extends OperationWithResult<?, ?>>, Integer>> replicationCounts = new HashMap();
    private final Map<ReplicaDescriptor, Long> totalNumberOfOperations;
    private final Map<ReplicaDescriptor, Long> totalMessageCount = new HashMap<ReplicaDescriptor, Long>();
    private final Map<ReplicaDescriptor, Long> totalQueueMessagesRawSizeInBytes;
    private ReplicationMasterDescriptor replicationMasterDescriptor;

    public ReplicationInstancesManager() {
        this.totalNumberOfOperations = new HashMap<ReplicaDescriptor, Long>();
        this.totalQueueMessagesRawSizeInBytes = new HashMap<ReplicaDescriptor, Long>();
    }

    public boolean hasReplicas() {
        return !this.replicaDescriptors.isEmpty();
    }

    public Iterable<ReplicaDescriptor> getReplicaDescriptors() {
        return Collections.unmodifiableCollection(this.replicaDescriptors.values());
    }

    public ReplicaDescriptor getReplicaDescriptor(UUID replicaId) {
        return this.replicaDescriptors.get(replicaId);
    }

    public ReplicationMasterDescriptor getReplicationMasterDescriptor() {
        return this.replicationMasterDescriptor;
    }

    public Iterable<String> getAllReplicableIdsAtLeastOneReplicaIsReplicating() {
        return this.replicaDescriptors.values().stream().map(replicableDescriptor -> Arrays.asList(replicableDescriptor.getReplicableIdsAsStrings())).reduce(new HashSet(), (result, ids) -> {
            result.addAll(ids);
            return result;
        }, (r1, r2) -> {
            r1.addAll(r2);
            return r1;
        });
    }

    public void registerReplica(ReplicaDescriptor replica) {
        this.replicaDescriptors.put(replica.getUuid(), replica);
        this.replicationCounts.put(replica, new HashMap());
    }

    public void unregisterReplica(ReplicaDescriptor replica) {
        this.unregisterReplica(replica.getUuid());
    }

    public ReplicaDescriptor unregisterReplica(UUID replicaUuid) {
        ReplicaDescriptor replica = this.replicaDescriptors.remove(replicaUuid);
        this.replicationCounts.remove(replica);
        return replica;
    }

    public void log(List<Class<?>> classes, long sizeOfQueueMessageInBytes) {
        for (ReplicaDescriptor replica : this.getReplicaDescriptors()) {
            Map<Class<OperationWithResult<?, ?>>, Integer> counts = this.replicationCounts.get(replica);
            if (counts == null) {
                counts = new HashMap();
                this.replicationCounts.put(replica, counts);
            }
            for (Class<?> replicatedOperationClass : classes) {
                Class<?> operationClass = replicatedOperationClass;
                Integer count = counts.get(operationClass);
                if (count == null) {
                    count = 0;
                }
                count = count + 1;
                counts.put(operationClass, count);
            }
            Long totalOps = this.totalNumberOfOperations.get(replica);
            if (totalOps == null) {
                totalOps = 0L;
            }
            totalOps = totalOps + (long)Util.size(classes);
            this.totalNumberOfOperations.put(replica, totalOps);
            Long totalMessages = this.totalMessageCount.get(replica);
            if (totalMessages == null) {
                totalMessages = 0L;
            }
            totalMessages = totalMessages + 1L;
            this.totalMessageCount.put(replica, totalMessages);
            Long totalQueueMessagesSizeInBytes = this.totalQueueMessagesRawSizeInBytes.get(replica);
            if (totalQueueMessagesSizeInBytes == null) {
                totalQueueMessagesSizeInBytes = 0L;
            }
            this.totalQueueMessagesRawSizeInBytes.put(replica, totalQueueMessagesSizeInBytes + sizeOfQueueMessageInBytes);
        }
    }

    public Map<Class<? extends OperationWithResult<?, ?>>, Integer> getStatistics(ReplicaDescriptor replica) {
        return this.replicationCounts.get(replica);
    }

    public long getNumberOfBytesSent(ReplicaDescriptor replica) {
        Long totalQueueMessageSize = this.totalQueueMessagesRawSizeInBytes.get(replica);
        long result = totalQueueMessageSize == null ? 0L : totalQueueMessageSize;
        return result;
    }

    public double getAverageNumberOfOperationsPerMessage(ReplicaDescriptor replica) {
        Long operationsCount;
        Long messageCount = this.totalMessageCount.get(replica);
        double result = messageCount != null ? ((operationsCount = this.totalNumberOfOperations.get(replica)) == null ? 0.0 : (double)operationsCount.longValue() / (double)messageCount.longValue()) : 0.0;
        return result;
    }

    public double getAverageNumberOfBytesPerMessage(ReplicaDescriptor replica) {
        Long messageSizeInTotal;
        Long messageCount = this.totalMessageCount.get(replica);
        double result = messageCount != null ? ((messageSizeInTotal = this.totalQueueMessagesRawSizeInBytes.get(replica)) == null ? 0.0 : (double)messageSizeInTotal.longValue() / (double)messageCount.longValue()) : 0.0;
        return result;
    }

    public long getNumberOfMessagesSent(ReplicaDescriptor replica) {
        Long messageCount = this.totalMessageCount.get(replica);
        long result = messageCount != null ? messageCount : 0L;
        return result;
    }

    public void removeAll() {
        this.replicationCounts.clear();
        this.replicaDescriptors.clear();
    }
}

