/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.replication.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.Replicable;
import com.sap.sse.replication.impl.OperationSerializerBuffer;
import com.sap.sse.replication.impl.ReplicationMessageSender;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jpountz.lz4.LZ4BlockOutputStream;

public class OperationSerializerBufferImpl
implements OperationSerializerBuffer {
    private static final Logger logger = Logger.getLogger(OperationSerializerBufferImpl.class.getName());
    private static final int PROTOCOL_VERSION = 2;
    private String replicableIdAsString;
    private final ReplicationMessageSender sender;
    private final ByteArrayOutputStream bos;
    private DataOutputStream dos;
    private ObjectOutputStream objectOutputStream;
    private List<Class<?>> listOfClasses;
    private final Duration timeout;
    private final int maximumBufferSizeInBytes;
    private final Timer timer;
    private TimerTask timerTask;

    public OperationSerializerBufferImpl(ReplicationMessageSender sender, Duration timeout, int maximumBufferSizeInBytes, Timer timer) throws IOException {
        this.sender = sender;
        this.bos = new ByteArrayOutputStream();
        this.timeout = timeout;
        this.timer = timer;
        this.maximumBufferSizeInBytes = maximumBufferSizeInBytes;
    }

    private synchronized void createNewObjectOutputStream(String replicableIdAsString) throws IOException {
        ObjectOutputStream compressingObjectOutputStream;
        this.bos.reset();
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        this.listOfClasses = new ArrayList();
        LZ4BlockOutputStream zipper = new LZ4BlockOutputStream((OutputStream)this.bos);
        this.dos = new DataOutputStream((OutputStream)zipper);
        this.replicableIdAsString = replicableIdAsString;
        this.dos.writeUTF("***");
        this.dos.write(2);
        this.dos.writeUTF(replicableIdAsString);
        this.objectOutputStream = compressingObjectOutputStream = new ObjectOutputStream((OutputStream)zipper);
    }

    private synchronized void sendBuffer() throws IOException {
        if (this.replicableIdAsString != null && !this.listOfClasses.isEmpty()) {
            logger.fine("Preparing " + this.listOfClasses.size() + " operations for sending to RabbitMQ exchange");
            try {
                this.objectOutputStream.close();
                this.objectOutputStream = null;
                logger.fine("Sucessfully closed ObjectOutputStream");
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error trying to replicate " + this.listOfClasses.size() + " operations", e);
            }
            byte[] message = this.bos.toByteArray();
            logger.fine(() -> "Successfully produced message array for replicable " + this.replicableIdAsString + " of length " + message.length);
            List<Class<?>> listOfClasses = this.listOfClasses;
            this.listOfClasses = null;
            this.sender.send(message, listOfClasses);
        }
        this.replicableIdAsString = null;
    }

    @Override
    public synchronized <S, O extends OperationWithResult<S, ?>> void write(OperationWithResult<?, ?> operation, Replicable<S, O> replicable) throws IOException {
        if (this.replicableIdAsString == null) {
            this.createNewObjectOutputStream(replicable.getId().toString());
        } else if (!this.replicableIdAsString.equals(replicable.getId().toString())) {
            logger.fine(() -> "Received operation for replicable " + replicable.getId().toString() + " which is different from " + this.replicableIdAsString + "; sending buffer first");
            this.sendBuffer();
            this.createNewObjectOutputStream(replicable.getId().toString());
        }
        this.objectOutputStream.writeObject(operation);
        this.listOfClasses.add(operation.getClassForLogging());
        if (this.bos.size() > this.maximumBufferSizeInBytes) {
            logger.info("Triggering replication for replicable ID " + this.replicableIdAsString + " because buffer holds " + this.bos.size() + " bytes which exceeds trigger size " + this.maximumBufferSizeInBytes + " bytes");
            this.sendBuffer();
        } else if (this.timerTask == null) {
            this.timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    OperationSerializerBufferImpl operationSerializerBufferImpl = OperationSerializerBufferImpl.this;
                    synchronized (operationSerializerBufferImpl) {
                        try {
                            OperationSerializerBufferImpl.this.timerTask = null;
                            logger.fine("Running timer task for replicable ID " + OperationSerializerBufferImpl.this.replicableIdAsString + ", flushing buffer");
                            OperationSerializerBufferImpl.this.sendBuffer();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Exception while trying to replicate operations", e);
                        }
                    }
                }
            };
            this.timer.schedule(this.timerTask, this.timeout.asMillis());
        }
    }

    public int size() {
        return this.listOfClasses == null ? 0 : this.listOfClasses.size();
    }
}

