/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.DBConnectInfo;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.MessageTranslator;
import com.sap.db.util.security.AbstractAuthenticationManager;
import com.sap.db.util.security.AbstractAuthenticationMethod;
import com.sap.db.util.security.AuthenticationMethodType;
import com.sap.db.util.security.GSSAuthentication;
import com.sap.db.util.security.JWTAuthentication;
import com.sap.db.util.security.LDAPAuthentication;
import com.sap.db.util.security.SAMLAuthentication;
import com.sap.db.util.security.SAPLogonAuthentication;
import com.sap.db.util.security.ScramPBKDF2SHA256Authentication;
import com.sap.db.util.security.ScramSHA256Authentication;
import com.sap.db.util.security.SessionCookieAuthentication;
import com.sap.db.util.security.X509Authentication;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.ietf.jgss.GSSException;

@NotThreadSafe
public class AuthenticationManager
extends AbstractAuthenticationManager {
    private final Map<String, AbstractAuthenticationMethod> _methods = new LinkedHashMap<String, AbstractAuthenticationMethod>();
    private AbstractAuthenticationMethod _currentMethod;

    @Override
    public Session authenticate(SessionFactory factory, ConnectionSapDB connection, Session session, String userName, String passwd, String x509, Set<AuthenticationMethodType> activeMethods) throws RTEException, SQLException {
        byte[] data;
        String methodName;
        HAuthenticationPart authenticationPart;
        HRequestPacket requestPacket;
        boolean errorOccurred;
        boolean hasPasswd;
        boolean hasUserName;
        Tracer tracer;
        block34: {
            boolean hasX509;
            tracer = connection.getTracer();
            hasUserName = userName != null && !userName.isEmpty();
            hasPasswd = !passwd.isEmpty();
            boolean bl = hasX509 = x509 != null && !x509.isEmpty();
            if (!hasUserName && !hasPasswd && hasX509 && x509.startsWith("-----BEGIN") && activeMethods.contains((Object)AuthenticationMethodType.X509)) {
                this._methods.put("X509", new X509Authentication());
            }
            if (connection.getCookie() != null && hasUserName) {
                if (activeMethods.contains((Object)AuthenticationMethodType.SESSIONCOOKIE)) {
                    this._methods.put("SessionCookie", new SessionCookieAuthentication(connection));
                    if (tracer.on()) {
                        tracer.printDebugMessage("Using Session Cookie Authentication");
                    }
                }
            } else {
                if (!hasPasswd) {
                    try {
                        if (activeMethods.contains((Object)AuthenticationMethodType.KERBEROS)) {
                            this._methods.put("GSS", new GSSAuthentication(connection));
                        }
                        break block34;
                    }
                    catch (GSSException e) {
                        if (tracer.on()) {
                            tracer.printDebugThrowable(e, "Reject GSS Authentication");
                        }
                        break block34;
                    }
                }
                if (tracer.on()) {
                    tracer.printDebugMessage("Reject GSS Authentication: Password is not empty or authentication method excluded");
                }
                if (!hasUserName) {
                    if (passwd.startsWith("<") && activeMethods.contains((Object)AuthenticationMethodType.SAML)) {
                        this._methods.put("SAML", new SAMLAuthentication());
                    } else if (passwd.startsWith("Aj") && activeMethods.contains((Object)AuthenticationMethodType.SAPLOGON)) {
                        this._methods.put("SAPLogon", new SAPLogonAuthentication());
                    } else if (passwd.startsWith("ey") && activeMethods.contains((Object)AuthenticationMethodType.JWT)) {
                        this._methods.put("JWT", new JWTAuthentication());
                    } else if (tracer.on()) {
                        tracer.printDebugMessage("Reject SAML, SAPLogon and JWT Authentication: Unknown ticket prefix or authentication methods excluded");
                    }
                } else if (tracer.on()) {
                    tracer.printDebugMessage("Reject SAML, SAPLogon and JWT Authentication: User name is not empty");
                }
            }
        }
        if (hasUserName && hasPasswd && activeMethods.contains((Object)AuthenticationMethodType.LDAP)) {
            this._methods.put("LDAP", new LDAPAuthentication());
        }
        if (activeMethods.contains((Object)AuthenticationMethodType.PBKDF2)) {
            this._methods.put("SCRAMPBKDF2SHA256", new ScramPBKDF2SHA256Authentication());
        }
        if (activeMethods.contains((Object)AuthenticationMethodType.PASSWORD)) {
            this._methods.put("SCRAMSHA256", new ScramSHA256Authentication());
        }
        if (this._methods.isEmpty()) {
            throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable", new Object[0]), "08001", -11111);
        }
        do {
            errorOccurred = false;
            requestPacket = connection.initAuthenticate(session);
            authenticationPart = requestPacket.addAuthenticationPart();
            authenticationPart.addArg();
            authenticationPart.addRow(2 * this._methods.size() + 1);
            authenticationPart.addString(userName);
            for (Map.Entry<String, AbstractAuthenticationMethod> entry : new LinkedHashMap<String, AbstractAuthenticationMethod>(this._methods).entrySet()) {
                methodName = entry.getKey();
                AbstractAuthenticationMethod method = entry.getValue();
                try {
                    authenticationPart.addBytes(methodName.getBytes(StandardCharsets.UTF_8));
                    authenticationPart.addBytes(method.getInitialData(passwd.getBytes(StandardCharsets.UTF_8)));
                }
                catch (SQLException e) {
                    errorOccurred = true;
                    if (tracer.on()) {
                        tracer.printDebugThrowable(e, "Reject authentication method " + method.getMethodName());
                    }
                    this._methods.remove(methodName);
                    if (this._methods.size() != 0) continue;
                    throw new SQLException(MessageTranslator.translate("error.connection.noauthenticationmethodavailable", new Object[0]), "08001", -11111);
                }
            }
            if (errorOccurred) continue;
            authenticationPart.close();
        } while (errorOccurred);
        do {
            requestPacket.close();
            HReplyPacket replyPacket = connection.exchange(session, requestPacket, null, ConnectionSapDB.ExchangeFlag.IGNORE_ERRORS);
            DBConnectInfo dbConnectInfo = replyPacket.findDBConnectInfo(0);
            if (dbConnectInfo != null) {
                connection.setDefaultDatabaseRedirection(true);
                Session newSession = session._processDBConnectInfoPart(factory, dbConnectInfo);
                return this.authenticate(factory, connection, newSession, userName, passwd, x509, activeMethods);
            }
            SQLException sqlExceptionChain = replyPacket.findSQLExceptionChain(null, 0);
            if (sqlExceptionChain != null) {
                throw sqlExceptionChain;
            }
            authenticationPart = replyPacket.findAuthenticationPart(0);
            if (authenticationPart == null || !authenticationPart.nextField()) {
                throw SQLExceptionSapDB.newInstance("error.connection.noauthenticationmethodavailable", new String[0]);
            }
            methodName = authenticationPart.getValueAsString();
            this._currentMethod = this._methods.get(methodName);
            authenticationPart.nextField();
            data = this._currentMethod.evaluateAuthenticateReply(tracer, authenticationPart);
            if (data == null) continue;
            requestPacket = connection.initAuthenticate(session);
            authenticationPart = requestPacket.addAuthenticationPart();
            authenticationPart.addArg();
            authenticationPart.addRow(2);
            authenticationPart.addBytes(methodName.getBytes(StandardCharsets.UTF_8));
            authenticationPart.addBytes(data);
            authenticationPart.close();
        } while (data != null);
        return session;
    }

    @Override
    public void setClientProofPart(HAuthenticationPart authenticationPart, String userName, String passwd, String x509) throws SQLException {
        authenticationPart.addArg();
        authenticationPart.addRow(3);
        authenticationPart.addString(userName);
        authenticationPart.addString(this._currentMethod.getMethodName());
        authenticationPart.addBytes(this._currentMethod.getFinalData(passwd, x509));
    }

    @Override
    public String getMethodName() {
        return this._currentMethod != null ? this._currentMethod.getMethodName() : "NULL";
    }

    @Override
    public byte[] evaluateConnectReply(Tracer tracer, HAuthenticationPart authenticationPart) throws SQLException {
        return this._currentMethod != null ? this._currentMethod.evaluateConnectReply(tracer, authenticationPart) : null;
    }

    @Override
    String getUserNameFromServer() {
        return this._currentMethod != null ? this._currentMethod.getUserNameFromServer() : null;
    }

    @Override
    void onAuthenticationCompleted() {
        if (this._currentMethod != null) {
            this._currentMethod.onAuthenticationCompleted();
        }
    }
}

