/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.exceptions.Cesu8ConversionException;
import com.sap.db.util.HexUtils;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;

@Immutable
public final class Cesu8Utils {
    public static final int MAX_CESU8_BYTES_PER_UTF16_CHAR = 3;

    private Cesu8Utils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static int getByteLength(String src) {
        int byteLen = 0;
        int n = src.length();
        for (int i = 0; i < n; ++i) {
            char c = src.charAt(i);
            if (c < '\u0080') {
                ++byteLen;
                continue;
            }
            if (c < '\u0800') {
                byteLen += 2;
                continue;
            }
            byteLen += 3;
        }
        return byteLen;
    }

    public static int getCharLength(byte[] src, int off, int len) {
        int pos = off;
        int maxPos = off + len;
        int charLen = 0;
        while (pos < maxPos) {
            byte b = src[pos];
            if ((b & 0x80) == 0) {
                ++pos;
            } else if ((b & 0xE0) == 192) {
                pos += 2;
            } else if ((b & 0xF0) == 224) {
                pos += 3;
            } else {
                Cesu8Utils.validate(false, src, off, len);
            }
            ++charLen;
        }
        return charLen;
    }

    public static byte[] getBytes(String src) {
        byte[] dst = new byte[Cesu8Utils.getByteLength(src)];
        Cesu8Utils._charsToBytes(src, src.length(), dst, 0);
        return dst;
    }

    public static int putBytes(String src, byte[] dst, int off) {
        return Cesu8Utils._charsToBytes(src, src.length(), dst, off);
    }

    public static int putBytes(Reader reader, byte[] dst, int off, int len) throws IOException {
        return Cesu8Utils._charsToBytes(reader, dst, off, len);
    }

    public static String getString(byte[] src, int off, int len) {
        return Cesu8Utils.getString(src, off, len, false);
    }

    public static String getString(byte[] src, int off, int len, boolean lenient) {
        if (len == 0) {
            return "";
        }
        char[] dst = new char[len];
        int charsWritten = Cesu8Utils._bytesToChars(src, off, len, dst, 0, len, lenient);
        return new String(dst, 0, charsWritten);
    }

    public static void validate(boolean test, byte b0) {
        if (!test) {
            throw new Cesu8ConversionException("Invalid CESU-8 sequence: " + HexUtils.toDisplayHexString(new byte[]{b0}));
        }
    }

    public static void validate(boolean test, byte b0, byte b1) {
        if (!test) {
            throw new Cesu8ConversionException("Invalid CESU-8 sequence: " + HexUtils.toDisplayHexString(new byte[]{b0, b1}));
        }
    }

    public static void validate(boolean test, byte b0, byte b1, byte b2) {
        if (!test) {
            throw new Cesu8ConversionException("Invalid CESU-8 sequence: " + HexUtils.toDisplayHexString(new byte[]{b0, b1, b2}));
        }
    }

    public static void validate(boolean test, byte[] buf, int off, int len) {
        if (!test) {
            throw new Cesu8ConversionException("Invalid CESU-8 sequence: " + HexUtils.toDisplayHexString(Arrays.copyOfRange(buf, off, off + len)));
        }
    }

    private static int _charsToBytes(String src, int srcLen, byte[] dst, int dstOff) {
        int pos = dstOff;
        for (int i = 0; i < srcLen; ++i) {
            char c = src.charAt(i);
            pos += Cesu8Utils._charToBytes(c, dst, pos);
        }
        return pos - dstOff;
    }

    private static int _charsToBytes(Reader reader, byte[] dst, int off, int len) throws IOException {
        int byteLen;
        int pos = off;
        for (int availableSpace = len; availableSpace >= 3; availableSpace -= byteLen) {
            int c = reader.read();
            if (c == -1) {
                if (pos > off) {
                    return pos - off;
                }
                return -1;
            }
            byteLen = Cesu8Utils._charToBytes((char)c, dst, pos);
            pos += byteLen;
        }
        return pos - off;
    }

    private static int _charToBytes(char c, byte[] dst, int off) {
        int pos = off;
        if (c < '\u0080') {
            dst[pos++] = (byte)(c & 0x7F);
        } else if (c < '\u0800') {
            dst[pos++] = (byte)(c >>> 6 & 0x1F | 0xC0);
            dst[pos++] = (byte)(c & 0x3F | 0x80);
        } else {
            dst[pos++] = (byte)(c >>> 12 & 0xF | 0xE0);
            dst[pos++] = (byte)(c >>> 6 & 0x3F | 0x80);
            dst[pos++] = (byte)(c & 0x3F | 0x80);
        }
        return pos - off;
    }

    private static int _bytesToChars(byte[] src, int srcOff, int srcLen, char[] dst, int dstOff, int dstLen, boolean lenient) {
        int dstPos;
        int srcPos = srcOff;
        int srcMaxPos = Math.min(srcOff + srcLen, src.length);
        int dstMaxPos = Math.min(dstOff + dstLen, dst.length);
        for (dstPos = dstOff; srcPos < srcMaxPos && dstPos < dstMaxPos; ++dstPos) {
            try {
                byte b1;
                byte b0 = src[srcPos];
                if ((b0 & 0x80) == 0) {
                    dst[dstPos] = (char)b0;
                    ++srcPos;
                    continue;
                }
                if ((b0 & 0xE0) == 192) {
                    if (srcPos + 1 >= srcMaxPos) {
                        Cesu8Utils.validate(false, src, srcOff, srcLen);
                    }
                    Cesu8Utils.validate(((b1 = src[srcPos + 1]) & 0xC0) == 128, src, srcOff, srcLen);
                    dst[dstPos] = (char)((short)((b0 & 0x1F) << 6) + (short)(b1 & 0x3F));
                    srcPos += 2;
                    continue;
                }
                if ((b0 & 0xF0) == 224) {
                    if (srcPos + 2 >= srcMaxPos) {
                        Cesu8Utils.validate(false, src, srcOff, srcLen);
                    }
                    Cesu8Utils.validate(((b1 = src[srcPos + 1]) & 0xC0) == 128, src, srcOff, srcLen);
                    byte b2 = src[srcPos + 2];
                    Cesu8Utils.validate((b2 & 0xC0) == 128, src, srcOff, srcLen);
                    dst[dstPos] = (char)((short)((b0 & 0xF) << 12) + (short)((b1 & 0x3F) << 6) + (short)(b2 & 0x3F));
                    srcPos += 3;
                    continue;
                }
                Cesu8Utils.validate(false, src, srcOff, srcLen);
                continue;
            }
            catch (Cesu8ConversionException e) {
                if (lenient) {
                    dst[dstPos] = 63;
                    ++srcPos;
                    continue;
                }
                throw e;
            }
        }
        return dstPos - dstOff;
    }
}

