/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.deckmanadapter;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.Positioned;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.deckmanadapter.impl.FieldType;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Timed;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Record
implements Timed,
Positioned {
    private static final Logger logger = Logger.getLogger(Record.class.getName());
    private static final long serialVersionUID = -7939775022865795801L;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
    private final TimePoint timePoint;
    private final Position position;
    private final GPSFixMoving gpsFix;
    private final Wind wind;
    private Map<FieldType, String> fieldsAsString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Record(Map<FieldType, String> fieldsAsString) throws ParseException {
        Bearing optionalTrueHeading;
        Date date;
        this.fieldsAsString = fieldsAsString;
        DateFormat dateFormat = Record.dateFormat;
        synchronized (dateFormat) {
            date = Record.dateFormat.parse(this.fieldsAsString.get((Object)FieldType.date));
        }
        this.timePoint = new MillisecondsTimePoint(date);
        this.position = new DegreePosition(Double.valueOf(this.fieldsAsString.get((Object)FieldType.latitude)).doubleValue(), Double.valueOf(this.fieldsAsString.get((Object)FieldType.longitude)).doubleValue());
        KnotSpeedWithBearingImpl speed = new KnotSpeedWithBearingImpl(Double.valueOf(this.fieldsAsString.get((Object)FieldType.sog)).doubleValue(), (Bearing)new DegreeBearingImpl(Double.valueOf(this.fieldsAsString.get((Object)FieldType.cog)).doubleValue()));
        try {
            optionalTrueHeading = this.fieldsAsString.get((Object)FieldType.heading) == null ? null : new DegreeBearingImpl(Double.valueOf(this.fieldsAsString.get((Object)FieldType.heading)).doubleValue()).add(DeclinationService.INSTANCE.getDeclination(this.timePoint, this.position, 1000L).getBearingCorrectedTo(this.timePoint));
        }
        catch (IOException | NumberFormatException | ParseException e) {
            logger.log(Level.WARNING, "Problem obtaining magnetic declination for converting Deckman magnetic heading value to true", e);
            optionalTrueHeading = null;
        }
        this.wind = new WindImpl(this.position, this.timePoint, (SpeedWithBearing)new KnotSpeedWithBearingImpl(Double.valueOf(this.fieldsAsString.get((Object)FieldType.tws)).doubleValue(), (Bearing)new DegreeBearingImpl(Double.valueOf(this.fieldsAsString.get((Object)FieldType.twd)).doubleValue())));
        this.gpsFix = new GPSFixMovingImpl(this.position, this.timePoint, (SpeedWithBearing)speed, optionalTrueHeading);
    }

    public String getField(FieldType fieldType) {
        return this.fieldsAsString.get((Object)fieldType);
    }

    public Map<FieldType, String> getFieldsAsString() {
        return this.fieldsAsString;
    }

    public void setFieldsAsString(Map<FieldType, String> fieldsAsString) {
        this.fieldsAsString = fieldsAsString;
    }

    public TimePoint getTimePoint() {
        return this.timePoint;
    }

    public GPSFixMoving getGpsFix() {
        return this.gpsFix;
    }

    public Wind getWind() {
        return this.wind;
    }

    public Position getPosition() {
        return this.position;
    }
}

