/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.server.riot.impl;

import com.igtimi.IgtimiData;
import com.igtimi.IgtimiDevice;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.DataPointTimePointExtractor;
import com.sap.sailing.domain.igtimiadapter.DataPointVisitor;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.datatypes.Type;
import com.sap.sailing.domain.igtimiadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.MongoObjectFactory;
import com.sap.sailing.domain.igtimiadapter.server.Activator;
import com.sap.sailing.domain.igtimiadapter.server.RiotWebsocketHandler;
import com.sap.sailing.domain.igtimiadapter.server.replication.ReplicableRiotServer;
import com.sap.sailing.domain.igtimiadapter.server.replication.RiotReplicationOperation;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotConnection;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotMessageListener;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotServer;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotStandardCommand;
import com.sap.sailing.domain.igtimiadapter.server.riot.impl.RiotConnectionImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.SessionUtils;
import com.sap.sse.security.shared.AbstractOwnership;
import com.sap.sse.security.shared.AccessControlListAnnotation;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.OwnershipAnnotation;
import com.sap.sse.security.shared.PermissionChecker;
import com.sap.sse.security.shared.SecurityUser;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.impl.AccessControlList;
import com.sap.sse.security.shared.impl.Ownership;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.shared.util.Wait;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class RiotServerImpl
extends AbstractReplicableWithObjectInputStream<ReplicableRiotServer, RiotReplicationOperation<?>>
implements RiotServer,
ReplicableRiotServer,
Runnable {
    private static final Logger logger = Logger.getLogger(RiotServerImpl.class.getName());
    private final ConcurrentMap<Long, DataAccessWindow> dataAccessWindows;
    private final ConcurrentMap<Long, Device> devices;
    private final ConcurrentMap<String, Device> devicesBySerialNumber;
    private final Set<RiotMessageListener> listeners;
    private final Selector socketSelector;
    private final ServerSocketChannel serverSocketChannel;
    private final Thread communicatorThread;
    private boolean running;
    private final MongoObjectFactory mongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;
    private final Set<RiotWebsocketHandler> liveWebSocketConnections;
    private final ConcurrentMap<SocketChannel, RiotConnection> connections;
    private final ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker;
    private final ExecutorService executorForNotifyingListeners;

    public RiotServerImpl(DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, BundleContext context) throws Exception {
        this(0, domainObjectFactory, mongoObjectFactory, context);
    }

    public RiotServerImpl(int port, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, BundleContext context) throws Exception {
        this(new InetSocketAddress("0.0.0.0", port), domainObjectFactory, mongoObjectFactory, context);
    }

    public RiotServerImpl(SocketAddress localAddress, DomainObjectFactory domainObjectFactory, MongoObjectFactory mongoObjectFactory, BundleContext context) throws Exception {
        this.replicationServiceTracker = context == null ? null : ServiceTrackerFactory.createAndOpen((BundleContext)context, ReplicationService.class);
        this.listeners = ConcurrentHashMap.newKeySet();
        this.executorForNotifyingListeners = ThreadPoolUtil.INSTANCE.createForegroundTaskThreadPoolExecutor("Riot Listener Notifier");
        this.dataAccessWindows = new ConcurrentHashMap<Long, DataAccessWindow>();
        this.devices = new ConcurrentHashMap<Long, Device>();
        this.devicesBySerialNumber = new ConcurrentHashMap<String, Device>();
        this.connections = new ConcurrentHashMap<SocketChannel, RiotConnection>();
        this.domainObjectFactory = domainObjectFactory;
        this.mongoObjectFactory = mongoObjectFactory;
        this.liveWebSocketConnections = ConcurrentHashMap.newKeySet();
        for (Device device : domainObjectFactory.getDevices(null)) {
            this.devices.put(device.getId(), device);
            this.devicesBySerialNumber.put(device.getSerialNumber(), device);
        }
        for (DataAccessWindow daw : domainObjectFactory.getDataAccessWindows(null)) {
            this.dataAccessWindows.put(daw.getId(), daw);
        }
        this.socketSelector = Selector.open();
        this.serverSocketChannel = ServerSocketChannel.open();
        this.serverSocketChannel.bind(localAddress);
        this.serverSocketChannel.configureBlocking(false);
        this.serverSocketChannel.register(this.socketSelector, 16);
        this.running = true;
        this.communicatorThread = new Thread((Runnable)this, "Riot thread listening on port " + this.getPort());
        this.communicatorThread.setDaemon(true);
        this.communicatorThread.start();
        Wait.wait(() -> this.communicatorThread.getState() != Thread.State.NEW, Optional.of(Duration.ONE_SECOND.times(5L)), (Duration)Duration.ONE_SECOND);
        logger.info("Riot thread is running and listening for new connections on port " + this.getPort());
    }

    @Override
    public int getPort() throws IOException {
        return ((InetSocketAddress)this.serverSocketChannel.getLocalAddress()).getPort();
    }

    @Override
    public Iterable<RiotConnection> getLiveConnections() {
        return Collections.unmodifiableCollection(this.connections.values());
    }

    @Override
    public void stop() throws IOException {
        if (this.running) {
            logger.info("Stopping Riot server listening on address " + this.serverSocketChannel.getLocalAddress());
            this.running = false;
            this.serverSocketChannel.keyFor(this.socketSelector).cancel();
            this.serverSocketChannel.close();
            for (SocketChannel deviceChannel : this.connections.keySet()) {
                logger.info("Closing active device connection " + this.connections.get(deviceChannel) + " from " + deviceChannel.getRemoteAddress());
                deviceChannel.keyFor(this.socketSelector).cancel();
            }
            this.connections.clear();
            for (RiotWebsocketHandler liveConnection : this.liveWebSocketConnections) {
                liveConnection.close(1000, "Riot Server Stopped");
            }
        } else {
            logger.info("Trying to stop a Riot server that is not running. Ignoring.");
        }
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                this.socketSelector.select(1000L);
                for (SelectionKey selectedKey : this.socketSelector.selectedKeys()) {
                    SocketChannel deviceChannel;
                    if (selectedKey.isAcceptable()) {
                        deviceChannel = this.serverSocketChannel.accept();
                        if (deviceChannel == null) continue;
                        deviceChannel.configureBlocking(false);
                        deviceChannel.register(this.socketSelector, 1);
                        this.connections.put(deviceChannel, new RiotConnectionImpl(deviceChannel, this));
                        logger.info("New device connection from " + deviceChannel.getRemoteAddress());
                        continue;
                    }
                    if (!selectedKey.isReadable()) continue;
                    deviceChannel = (SocketChannel)selectedKey.channel();
                    ByteBuffer buffer = ByteBuffer.allocate(4096);
                    int numberOfBytesRead = deviceChannel.read(buffer);
                    RiotConnection connection = (RiotConnection)this.connections.get(deviceChannel);
                    if (numberOfBytesRead > 0) {
                        if (connection != null) {
                            connection.dataReceived(buffer);
                            continue;
                        }
                        logger.warning("Data received from a socket with address " + deviceChannel.getRemoteAddress() + " that we don't have a managed connection for");
                        continue;
                    }
                    if (numberOfBytesRead != -1) continue;
                    logger.info("Device channel from " + deviceChannel.getRemoteAddress() + " closed");
                    if (connection != null) {
                        logger.info("The device was handled by connection " + connection);
                        try {
                            connection.close();
                        }
                        catch (Exception e) {
                            logger.warning("Trying to properly close a connection for which we read EOF from its channel threw an exception: " + e.getMessage());
                        }
                    }
                    deviceChannel.close();
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception trying to read or accept new connection. Continuing...", e);
            }
        }
        try {
            logger.info("Riot server listening on " + this.serverSocketChannel.getLocalAddress() + " stops running");
        }
        catch (IOException e) {
            logger.info("Riot server listening on " + this.serverSocketChannel + " stops running");
        }
    }

    void connectionClosed(SocketChannel deviceChannel) {
        this.connections.remove(deviceChannel);
        SelectionKey selectionKey = deviceChannel.keyFor(this.socketSelector);
        if (selectionKey != null) {
            selectionKey.cancel();
        }
    }

    @Override
    public void addListener(RiotMessageListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(RiotMessageListener listener) {
        this.listeners.remove(listener);
    }

    void notifyListeners(IgtimiStream.Msg message, String deviceSerialNumber) {
        this.executorForNotifyingListeners.execute(() -> {
            Object object = this.apply((RiotReplicationOperation & Serializable)s -> s.internalNotifyListeners(message, deviceSerialNumber));
        });
    }

    @Override
    public Void internalNotifyListeners(IgtimiStream.Msg message, String deviceSerialNumber) {
        try {
            if (!(this.replicationServiceTracker != null && this.replicationServiceTracker.getService() != null && ((ReplicationService)this.replicationServiceTracker.getService()).isReplicationStarting() || deviceSerialNumber == null)) {
                this.forwardMessageToEligibleWebSocketClients(message, deviceSerialNumber);
            }
            for (RiotMessageListener listener : this.listeners) {
                listener.onMessage(message);
            }
        }
        finally {
            this.storeMessage(message, deviceSerialNumber);
        }
        return null;
    }

    private void storeMessage(IgtimiStream.Msg message, String deviceSerialNumber) {
        this.mongoObjectFactory.storeMessage(deviceSerialNumber, message, null);
    }

    private void forwardMessageToEligibleWebSocketClients(IgtimiStream.Msg message, String deviceSerialNumber) {
        Device device = this.getDeviceBySerialNumber(deviceSerialNumber);
        if (device == null) {
            logger.info("Received message from unknown devices " + deviceSerialNumber + "; creating Device");
            Device newDevice = this.createDevice(deviceSerialNumber);
            this.getSecurityService().setOwnership(newDevice.getIdentifier(), null, this.getSecurityService().getServerGroup(), newDevice.getName());
        } else {
            byte[] messageAsBytes = message.toByteArray();
            TimeRange messageDataTimeRange = this.getTimeRange(message);
            Iterable<DataAccessWindow> daws = this.getDataAccessWindows(Collections.singleton(deviceSerialNumber), MultiTimeRange.of((TimeRange[])new TimeRange[]{messageDataTimeRange}));
            SecurityService securityService = this.liveWebSocketConnections.isEmpty() ? null : this.getSecurityService();
            for (RiotWebsocketHandler webSocketClient : this.liveWebSocketConnections) {
                if (!webSocketClient.getDeviceSerialNumbers().contains(deviceSerialNumber)) continue;
                User user = webSocketClient.getAuthenticatedUser();
                OwnershipAnnotation deviceOwnership = securityService.getOwnership(device.getIdentifier());
                AccessControlListAnnotation deviceAccessControlList = securityService.getAccessControlList(device.getIdentifier());
                if (Util.isEmpty((Iterable)Util.filter(daws, daw -> {
                    OwnershipAnnotation dawOownership = securityService.getOwnership(daw.getIdentifier());
                    AccessControlListAnnotation dawAccessControlList = securityService.getAccessControlList(daw.getIdentifier());
                    return PermissionChecker.isPermitted((WildcardPermission)daw.getIdentifier().getPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ), (SecurityUser)user, (SecurityUser)securityService.getAllUser(), (AbstractOwnership)(dawOownership == null ? null : (Ownership)dawOownership.getAnnotation()), dawAccessControlList == null ? null : (AccessControlList)dawAccessControlList.getAnnotation());
                })) || !PermissionChecker.isPermitted((WildcardPermission)device.getIdentifier().getPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ), (SecurityUser)user, (SecurityUser)securityService.getAllUser(), (AbstractOwnership)(deviceOwnership == null ? null : (Ownership)deviceOwnership.getAnnotation()), deviceAccessControlList == null ? null : (AccessControlList)deviceAccessControlList.getAnnotation())) continue;
                webSocketClient.sendBytesByFuture(ByteBuffer.wrap(messageAsBytes));
            }
        }
    }

    private SecurityService getSecurityService() {
        return Activator.getInstance().getSecurityService();
    }

    private TimeRange getTimeRange(IgtimiStream.Msg message) {
        IgtimiDevice.DeviceManagement deviceManagement;
        TimePoint from = null;
        TimePoint to = null;
        if (message.hasData()) {
            for (IgtimiData.DataMsg data : message.getData().getDataList()) {
                for (IgtimiData.DataPoint dataPoint : data.getDataList()) {
                    TimePoint dataPointTimePoint = (TimePoint)DataPointVisitor.accept((IgtimiData.DataPoint)dataPoint, (DataPointVisitor)new DataPointTimePointExtractor());
                    if (from == null || dataPointTimePoint.before(from)) {
                        from = dataPointTimePoint;
                    }
                    if (to != null && !dataPointTimePoint.after(to)) continue;
                    to = dataPointTimePoint;
                }
            }
        } else if (message.hasDeviceManagement() && (deviceManagement = message.getDeviceManagement()).hasResponse()) {
            IgtimiDevice.DeviceManagementResponse response = deviceManagement.getResponse();
            TimePoint timePoint = TimePoint.of((long)response.getTimestamp());
            if (from == null || timePoint.before(from)) {
                from = timePoint;
            }
            if (to == null || timePoint.after(to)) {
                to = timePoint;
            }
        }
        return TimeRange.create(from, to == null ? null : to.plus(Duration.ONE_MILLISECOND));
    }

    @Override
    public Iterable<Device> getDevices() {
        return Collections.unmodifiableCollection(this.devices.values());
    }

    @Override
    public Device getDeviceById(long id) {
        return (Device)this.devices.get(id);
    }

    @Override
    public Device getDeviceBySerialNumber(String deviceSerialNumber) {
        return (Device)this.devicesBySerialNumber.get(deviceSerialNumber);
    }

    @Override
    public Device createDevice(String deviceSerialNumber) {
        return (Device)this.apply((RiotReplicationOperation & Serializable)s -> s.internalCreateDevice(deviceSerialNumber));
    }

    @Override
    public Device internalCreateDevice(String deviceSerialNumber) {
        long id = this.devices.isEmpty() ? 1L : (Long)Collections.max(this.devices.keySet()) + 1L;
        Device device = Device.create((long)id, (String)deviceSerialNumber);
        this.devices.put(device.getId(), device);
        this.devicesBySerialNumber.put(device.getSerialNumber(), device);
        this.mongoObjectFactory.storeDevice(device, null);
        return device;
    }

    @Override
    public void removeDevice(long deviceId) {
        this.apply((RiotReplicationOperation & Serializable)s -> s.internalRemoveDevice(deviceId));
    }

    @Override
    public Void internalRemoveDevice(long deviceId) {
        Device device = (Device)this.devices.remove(deviceId);
        this.devicesBySerialNumber.remove(device.getSerialNumber());
        this.mongoObjectFactory.removeDevice(deviceId, null);
        return null;
    }

    @Override
    public void updateDeviceName(long deviceId, String name) {
        this.apply((RiotReplicationOperation & Serializable)s -> s.internalUpdateDeviceName(deviceId, name));
    }

    @Override
    public Void internalUpdateDeviceName(long deviceId, String name) {
        Device existingDevice = (Device)this.devices.get(deviceId);
        if (existingDevice != null) {
            existingDevice.setName(name);
            this.mongoObjectFactory.storeDevice(existingDevice, null);
        }
        return null;
    }

    @Override
    public void updateDeviceLastHeartbeat(long deviceId, TimePoint timePointOfLastHeartbeat, String remoteAddress) {
        this.apply((RiotReplicationOperation & Serializable)s -> s.internalUpdateDeviceLastHeartbeat(deviceId, timePointOfLastHeartbeat, remoteAddress));
    }

    @Override
    public Void internalUpdateDeviceLastHeartbeat(long deviceId, TimePoint timePointOfLastHeartbeat, String remoteAddress) {
        Device existingDevice = (Device)this.devices.get(deviceId);
        if (existingDevice != null) {
            existingDevice.setLastHeartbeat(timePointOfLastHeartbeat, remoteAddress);
            this.mongoObjectFactory.storeDevice(existingDevice, null);
        }
        return null;
    }

    @Override
    public Iterable<DataAccessWindow> getDataAccessWindows() {
        return Collections.unmodifiableCollection(this.dataAccessWindows.values());
    }

    @Override
    public DataAccessWindow getDataAccessWindowById(long id) {
        return (DataAccessWindow)this.dataAccessWindows.get(id);
    }

    @Override
    public Iterable<DataAccessWindow> getDataAccessWindows(Iterable<String> deviceSerialNumbers, MultiTimeRange timeRanges) {
        HashSet<DataAccessWindow> result = new HashSet<DataAccessWindow>();
        Set deviceSerialNumbersAsSet = Util.asSet(deviceSerialNumbers);
        for (DataAccessWindow daw : this.getDataAccessWindows()) {
            if (!deviceSerialNumbersAsSet.contains(daw.getDeviceSerialNumber()) || !timeRanges.intersects(daw.getTimeRange())) continue;
            result.add(daw);
        }
        return result;
    }

    @Override
    public DataAccessWindow createDataAccessWindow(String deviceSerialNumber, TimePoint from, TimePoint to) {
        return (DataAccessWindow)this.apply((RiotReplicationOperation & Serializable)s -> s.internalCreateDataAccessWindow(deviceSerialNumber, from, to));
    }

    @Override
    public DataAccessWindow internalCreateDataAccessWindow(String deviceSerialNumber, TimePoint from, TimePoint to) {
        long newId = this.dataAccessWindows.isEmpty() ? 1L : (Long)Collections.max(this.dataAccessWindows.keySet()) + 1L;
        DataAccessWindow daw = DataAccessWindow.create((long)newId, (TimePoint)from, (TimePoint)to, (String)deviceSerialNumber);
        this.dataAccessWindows.put(daw.getId(), daw);
        this.mongoObjectFactory.storeDataAccessWindow(daw, null);
        return daw;
    }

    @Override
    public void removeDataAccessWindow(long dawId) {
        this.apply((RiotReplicationOperation & Serializable)s -> s.internalRemoveDataAccessWindow(dawId));
    }

    @Override
    public Void internalRemoveDataAccessWindow(long dawId) {
        this.dataAccessWindows.remove(dawId);
        this.mongoObjectFactory.removeDataAccessWindow(dawId, null);
        return null;
    }

    public void clear() {
        this.devices.clear();
        this.devicesBySerialNumber.clear();
        this.dataAccessWindows.clear();
        this.connections.clear();
        this.listeners.clear();
        this.mongoObjectFactory.clear(null);
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        this.clear();
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return new ObjectInputStreamResolvingAgainstCache<Object>(is, new Object(), null, classLoaderCache){};
    }

    public void initiallyFillFromInternal(ObjectInputStream is) throws IOException, ClassNotFoundException, InterruptedException {
        this.devices.putAll((Map)is.readObject());
        for (Device device : this.devices.values()) {
            this.devicesBySerialNumber.put(device.getSerialNumber(), device);
        }
        this.dataAccessWindows.putAll((Map)is.readObject());
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(new HashMap<Long, Device>(this.devices));
        objectOutputStream.writeObject(new HashMap<Long, DataAccessWindow>(this.dataAccessWindows));
    }

    @Override
    public Iterable<IgtimiStream.Msg> getMessages(String deviceSerialNumber, MultiTimeRange timeRanges, Set<IgtimiData.DataPoint.DataCase> dataCases) throws IllegalStateException, ClientProtocolException, IOException, ParseException {
        Iterable result;
        if (this.getMasterDescriptor() == null) {
            result = this.domainObjectFactory.getMessages(deviceSerialNumber, timeRanges, dataCases, null);
        } else {
            Type[] types = new Type[dataCases.size()];
            int i = 0;
            for (IgtimiData.DataPoint.DataCase dataCase : dataCases) {
                types[i++] = Type.valueOf((int)dataCase.getNumber());
            }
            result = Util.concat((Iterable)Util.map((Iterable)timeRanges, timeRange -> {
                try {
                    return this.getFromPrimary(deviceSerialNumber, types, (c, dsn, ts) -> c.getMessages(timeRange.from(), timeRange.to(), Collections.singleton(dsn), ts));
                }
                catch (IOException | ParseException e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        return result;
    }

    private <T> T getFromPrimary(String deviceSerialNumber, Type[] types, MessageLoader<T> resultProvider) throws ParseException, IOException {
        int masterPort = this.getMasterDescriptor().getServletPort();
        String masterHostname = this.getMasterDescriptor().getHostname();
        SecurityService securityService = this.getSecurityService();
        String currentUserBearerToken = securityService == null ? null : (securityService.getCurrentUser() == null ? null : securityService.getAccessToken(securityService.getCurrentUser().getName()));
        try {
            URL baseUrl = new URL(masterPort == 443 ? "https" : "http", masterHostname, masterPort, "/");
            IgtimiConnectionFactory igtimiConnectionFactory = IgtimiConnectionFactory.create((URL)baseUrl, (String)currentUserBearerToken);
            IgtimiConnection connection = igtimiConnectionFactory.getOrCreateConnection();
            return resultProvider.getResult(connection, deviceSerialNumber, types);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterable<Util.Pair<TimePoint, String>> getDeviceLogs(String serialNumber, Duration duration) throws ParseException, IOException {
        TimePoint endTime = TimePoint.now();
        TimePoint startTime = endTime.minus(duration);
        Iterable messages = this.getMasterDescriptor() == null ? this.domainObjectFactory.getMessages(serialNumber, MultiTimeRange.of((TimeRange[])new TimeRange[]{TimeRange.create((TimePoint)startTime, (TimePoint)endTime)}), Collections.singleton(IgtimiData.DataPoint.DataCase.LOG), null) : this.getFromPrimary(serialNumber, new Type[]{Type.valueOf((int)IgtimiData.DataPoint.DataCase.LOG.getNumber())}, (c, dsn, ts) -> c.getMessages(startTime, endTime, Collections.singleton(dsn), ts));
        ArrayList<Util.Pair<TimePoint, String>> logMessages = new ArrayList<Util.Pair<TimePoint, String>>();
        for (IgtimiStream.Msg message : messages) {
            for (IgtimiData.DataMsg data : message.getData().getDataList()) {
                for (IgtimiData.DataPoint dataPoint : data.getDataList()) {
                    if (!dataPoint.hasLog()) continue;
                    logMessages.add((Util.Pair<TimePoint, String>)new Util.Pair((Object)TimePoint.of((long)dataPoint.getLog().getTimestamp()), (Object)dataPoint.getLog().getMessage()));
                }
            }
        }
        return logMessages;
    }

    @Override
    public void addWebSocketClient(RiotWebsocketHandler riotWebsocketHandler) {
        this.liveWebSocketConnections.add(riotWebsocketHandler);
    }

    @Override
    public void removeWebSocketClient(RiotWebsocketHandler riotWebsocketHandler) {
        this.liveWebSocketConnections.remove(riotWebsocketHandler);
    }

    @Override
    public IgtimiStream.Msg getLastMessage(String serialNumber, IgtimiData.DataPoint.DataCase dataCase, MultiTimeRange timeRanges) throws ParseException, IOException {
        IgtimiStream.Msg result = this.getMasterDescriptor() == null ? this.domainObjectFactory.getLatestMessage(serialNumber, dataCase, timeRanges, null) : this.getFromPrimary(serialNumber, new Type[]{Type.valueOf((int)dataCase.getNumber())}, (c, dsn, ts) -> c.getLastMessage(dsn, ts[0]));
        return result;
    }

    @Override
    public boolean sendStandardCommand(String deviceSerialNumber, RiotStandardCommand command) throws IOException {
        logger.info("User " + SessionUtils.getPrincipal() + " requests sending standard command " + (Object)((Object)command) + " to device with serial number " + deviceSerialNumber);
        return (Boolean)this.apply((RiotReplicationOperation & Serializable)s -> s.internalSendCommand(deviceSerialNumber, command.getCommand()));
    }

    @Override
    public boolean sendFreestyleCommand(String deviceSerialNumber, String command) throws IOException {
        logger.info("User " + SessionUtils.getPrincipal() + " requests sending freestyle command " + command + " to device with serial number " + deviceSerialNumber);
        return (Boolean)this.apply((RiotReplicationOperation & Serializable)s -> s.internalSendCommand(deviceSerialNumber, command));
    }

    @Override
    public boolean internalSendCommand(String deviceSerialNumber, String command) throws IOException, InterruptedException, ExecutionException {
        boolean foundConnection = false;
        for (RiotConnection connection : this.getLiveConnections()) {
            if (!Util.equalsWithNull((Object)connection.getSerialNumber(), (Object)deviceSerialNumber)) continue;
            connection.sendCommand(command);
            foundConnection = true;
            break;
        }
        return foundConnection;
    }

    @Override
    public boolean enableOverTheAirLog(String deviceSerialNumber, boolean enable) throws IOException, InterruptedException, ExecutionException {
        Device device = this.getDeviceBySerialNumber(deviceSerialNumber);
        if (device == null) {
            throw new IllegalArgumentException("No device with serial number " + deviceSerialNumber + " found");
        }
        return (Boolean)this.apply((RiotReplicationOperation & Serializable)s -> s.internalEnableOverTheAirLog(deviceSerialNumber, enable));
    }

    @Override
    public boolean internalEnableOverTheAirLog(String deviceSerialNumber, boolean enable) throws IOException {
        boolean foundConnection = false;
        for (RiotConnection connection : this.getLiveConnections()) {
            if (!Util.equalsWithNull((Object)connection.getSerialNumber(), (Object)deviceSerialNumber)) continue;
            if (enable) {
                connection.enableOverTheAirLog();
            } else {
                connection.disableOverTheAirLog();
            }
            foundConnection = true;
            break;
        }
        return foundConnection;
    }

    @FunctionalInterface
    private static interface MessageLoader<T> {
        public T getResult(IgtimiConnection var1, String var2, Type[] var3) throws IOException, ParseException;
    }
}

