/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.server.riot.impl;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiAPI;
import com.igtimi.IgtimiData;
import com.igtimi.IgtimiDevice;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.igtimiadapter.ChannelManagementVisitor;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.FixFactory;
import com.sap.sailing.domain.igtimiadapter.FixVisitor;
import com.sap.sailing.domain.igtimiadapter.IgtimiFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiFixReceiverAdapter;
import com.sap.sailing.domain.igtimiadapter.MsgVisitor;
import com.sap.sailing.domain.igtimiadapter.datatypes.Log;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotConnection;
import com.sap.sailing.domain.igtimiadapter.server.riot.RiotMessageListener;
import com.sap.sailing.domain.igtimiadapter.server.riot.impl.RiotServerImpl;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RiotConnectionImpl
implements RiotConnection {
    private static final Logger logger = Logger.getLogger(RiotConnectionImpl.class.getName());
    private static final ExtensionRegistry protobufExtensionRegistry = ExtensionRegistry.newInstance();
    private String serialNumber;
    private String deviceGroupToken;
    private final ByteBuffer messageLengthBuffer;
    private ByteBuffer messageBuffer;
    private int nextMessageLength;
    private final SocketChannel socketChannel;
    private final RiotServerImpl riotServer;
    private final ScheduledFuture<?> heartbeatSendingTask;
    private TimePoint lastHeartbeatReceivedAt;
    private TimePoint requireNextHeartbeatUntil;
    private int overTheAirLogEnabled;
    private static final Duration MAX_ALLOWED_DURATION_BETWEEN_HEARTBEATS = Duration.ONE_SECOND.times(30L);

    RiotConnectionImpl(SocketChannel socketChannel, RiotServerImpl riotServer) {
        this.socketChannel = socketChannel;
        this.riotServer = riotServer;
        this.messageLengthBuffer = ByteBuffer.allocate(5);
        this.requireNextHeartbeatUntil = TimePoint.now().plus(Duration.ONE_MINUTE);
        this.heartbeatSendingTask = this.scheduleHeartbeat();
    }

    private ScheduledFuture<?> scheduleHeartbeat() {
        return ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().scheduleAtFixedRate(this::sendAndCheckHeartbeat, 15L, 15L, TimeUnit.SECONDS);
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    @Override
    public String getDeviceGroupToken() {
        return this.deviceGroupToken;
    }

    @Override
    public SocketChannel getSocketChannel() {
        return this.socketChannel;
    }

    @Override
    public TimePoint getLastHeartbeatReceivedAt() {
        return this.lastHeartbeatReceivedAt;
    }

    @Override
    public void close() throws IOException {
        try {
            this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setDisconnect(IgtimiStream.ServerDisconnecting.newBuilder().setCode(500).setReason("Connection closed by server"))).build());
        }
        finally {
            this.onClosed();
        }
    }

    private void onClosed() throws IOException {
        this.riotServer.connectionClosed(this.socketChannel);
        this.heartbeatSendingTask.cancel(false);
        this.socketChannel.close();
    }

    @Override
    public ConcurrentLinkedQueue<String> sendCommand(final String command) throws IOException, InterruptedException, ExecutionException {
        final ConcurrentLinkedQueue<String> logLines = new ConcurrentLinkedQueue<String>();
        FixFactory fixFactory = new FixFactory();
        IgtimiFixReceiverAdapter fixReceiver = new IgtimiFixReceiverAdapter(){

            public void received(Log fix) {
                logLines.add(fix.getLogMessage());
                logger.info("Log from device " + RiotConnectionImpl.this.getSerialNumber() + " probably in response to command " + command + ": " + fix.getLogMessage());
            }
        };
        FixVisitor fixVisitor = new FixVisitor((IgtimiFixReceiver)fixReceiver);
        RiotMessageListener listener = m -> fixVisitor.received(fixFactory.createFixes(m));
        this.riotServer.addListener(listener);
        this.enableOverTheAirLog();
        this.send((AbstractMessage)this.buildCommandMessage(command));
        ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor().schedule(() -> {
            try {
                this.disableOverTheAirLog();
            }
            catch (IOException e) {
                logger.warning("Couldn't send commands to stop receiving logs to device " + this.getSerialNumber() + ": " + e.getMessage());
            }
            this.riotServer.removeListener(listener);
        }, 10L, TimeUnit.SECONDS);
        return logLines;
    }

    @Override
    public synchronized void enableOverTheAirLog() throws IOException {
        if (this.overTheAirLogEnabled == 0) {
            this.send((AbstractMessage)this.buildCommandMessage("log cell debug"));
            this.send((AbstractMessage)this.buildCommandMessage("log cell block 2"));
        }
        ++this.overTheAirLogEnabled;
    }

    @Override
    public synchronized void disableOverTheAirLog() throws IOException {
        if (this.overTheAirLogEnabled > 0) {
            --this.overTheAirLogEnabled;
            if (this.overTheAirLogEnabled == 0) {
                this.send((AbstractMessage)this.buildCommandMessage("log cell none"));
                this.send((AbstractMessage)this.buildCommandMessage("log cell block 0"));
            }
        }
    }

    private IgtimiStream.Msg buildCommandMessage(String command) {
        return IgtimiStream.Msg.newBuilder().setDeviceManagement(IgtimiDevice.DeviceManagement.newBuilder().setRequest(IgtimiDevice.DeviceManagementRequest.newBuilder().setCommand(IgtimiDevice.DeviceCommand.newBuilder().setText(command)))).build();
    }

    @Override
    public void dataReceived(ByteBuffer data) {
        data.flip();
        while (data.hasRemaining()) {
            if (this.nextMessageLength == 0) {
                byte b = data.get();
                this.messageLengthBuffer.put(b);
                int oldPosition = this.messageLengthBuffer.position();
                this.messageLengthBuffer.flip();
                try {
                    this.nextMessageLength = CodedInputStream.newInstance((ByteBuffer)this.messageLengthBuffer).readRawVarint32();
                    this.messageLengthBuffer.clear();
                    this.messageBuffer = ByteBuffer.allocate(this.nextMessageLength);
                }
                catch (IOException ioe) {
                    this.messageLengthBuffer.limit(this.messageLengthBuffer.capacity());
                    this.messageLengthBuffer.position(oldPosition);
                }
                continue;
            }
            byte[] copyBuffer = new byte[Math.min(data.remaining(), this.messageBuffer.remaining())];
            data.get(copyBuffer);
            this.messageBuffer.put(copyBuffer);
            if (this.messageBuffer.hasRemaining()) continue;
            this.nextMessageLength = 0;
            try {
                this.messageBuffer.flip();
                IgtimiStream.Msg message = IgtimiStream.Msg.parseFrom((ByteBuffer)this.messageBuffer, (ExtensionRegistryLite)protobufExtensionRegistry);
                this.processMessage(message);
                this.riotServer.notifyListeners(message, this.serialNumber);
            }
            catch (InvalidProtocolBufferException e) {
                logger.log(Level.SEVERE, "Error parsing message from device " + this.serialNumber, e);
            }
        }
    }

    private void sendPositiveAuthResponse() {
        new Thread(() -> {
            RiotConnectionImpl riotConnectionImpl = this;
            synchronized (riotConnectionImpl) {
                while (this.serialNumber == null) {
                    try {
                        logger.info("Waiting for serial number before returning successful auth response with device group token");
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            IgtimiStream.Authentication.AuthResponse response = IgtimiStream.Authentication.AuthResponse.newBuilder().setTimestamp(System.currentTimeMillis()).setAck(true).setCode(200).setReason("Authenticated").build();
            logger.info("Sending auth response for device " + this.serialNumber);
            try {
                this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setAuth(IgtimiStream.Authentication.newBuilder().setAuthResponse(response))).build());
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Couldn't send authentication response to device " + this.getSerialNumber(), e);
            }
        }, "sending positive Igtimi auth response when device serial number is known").start();
    }

    private void send(AbstractMessage message) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(4096);
        message.writeDelimitedTo((OutputStream)bos);
        int size = bos.size();
        ByteBuffer buf = ByteBuffer.allocate(size);
        buf.put(bos.toByteArray());
        buf.flip();
        int bytesWritten = this.socketChannel.write(buf);
        if (bytesWritten < size) {
            logger.warning("Trying to write " + size + " bytes to device " + this.socketChannel + " but was able to write only " + bytesWritten + "; message " + message + " most likely not delivered to device " + this.serialNumber + " successfully.");
        }
    }

    private void processMessage(IgtimiStream.Msg message) {
        MsgVisitor.accept((IgtimiStream.Msg)message, (MsgVisitor)new MsgVisitor(){

            public void handleDeviceManagement(IgtimiDevice.DeviceManagement deviceManagement) {
                RiotConnectionImpl.this.updateSerialNumber(deviceManagement.getSerialNumber());
                if (deviceManagement.hasResponse()) {
                    logger.info("Received a response from device " + deviceManagement.getSerialNumber() + ". Code: " + deviceManagement.getResponse().getCode() + ", reason: " + deviceManagement.getResponse().getReason() + ", text: " + deviceManagement.getResponse().getText() + ", timestamp: " + TimePoint.of((long)deviceManagement.getResponse().getTimestamp()));
                }
            }

            public void handleData(IgtimiData.Data data) {
                for (IgtimiData.DataMsg dataMsg : data.getDataList()) {
                    RiotConnectionImpl.this.updateSerialNumber(dataMsg.getSerialNumber());
                    for (IgtimiData.DataPoint d : dataMsg.getDataList()) {
                        if (!d.hasLog()) continue;
                        logger.info("Log from Igtimi device " + RiotConnectionImpl.this.getSerialNumber() + ": " + d.getLog().getMessage());
                    }
                }
            }

            public void handleChannelManagement(IgtimiStream.ChannelManagement channelManagement) {
                ChannelManagementVisitor.accept((IgtimiStream.ChannelManagement)channelManagement, (ChannelManagementVisitor)new ChannelManagementVisitor(){

                    public void handleAuth(IgtimiStream.Authentication auth) {
                        IgtimiAPI.Token token;
                        if (auth.hasAuthRequest() && (token = auth.getAuthRequest().getToken()).hasDeviceGroupToken()) {
                            RiotConnectionImpl.this.deviceGroupToken = token.getDeviceGroupToken();
                            logger.info("Received auth request from device " + RiotConnectionImpl.this.serialNumber + " with device group token " + RiotConnectionImpl.this.deviceGroupToken);
                            RiotConnectionImpl.this.sendPositiveAuthResponse();
                        }
                    }

                    public void handleHeartbeat(long heartbeat) {
                        RiotConnectionImpl.this.lastHeartbeatReceivedAt = TimePoint.now();
                        RiotConnectionImpl.this.requireNextHeartbeatUntil = RiotConnectionImpl.this.lastHeartbeatReceivedAt.plus(MAX_ALLOWED_DURATION_BETWEEN_HEARTBEATS);
                        RiotConnectionImpl.this.updateDeviceHeartbeatIfSerialNumberKnown();
                    }
                });
            }

            public void handleAckResponse(IgtimiStream.AckResponse ackResponse) {
                logger.info("Received AckResponse from device " + RiotConnectionImpl.this.getSerialNumber() + ": " + ackResponse);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSerialNumber(String serialNumber) {
        if (Util.hasLength((String)serialNumber)) {
            boolean serialNumberWasUnknown;
            RiotConnectionImpl riotConnectionImpl = this;
            synchronized (riotConnectionImpl) {
                serialNumberWasUnknown = this.serialNumber == null;
                this.serialNumber = serialNumber;
                if (serialNumberWasUnknown) {
                    this.notifyAll();
                }
            }
            if (serialNumberWasUnknown && this.lastHeartbeatReceivedAt != null) {
                this.updateDeviceHeartbeatIfSerialNumberKnown();
            }
        }
    }

    private void updateDeviceHeartbeatIfSerialNumberKnown() {
        Device device;
        if (this.serialNumber != null && (device = this.riotServer.getDeviceBySerialNumber(this.serialNumber)) != null) {
            try {
                this.riotServer.updateDeviceLastHeartbeat(device.getId(), this.lastHeartbeatReceivedAt, this.getSocketChannel().getRemoteAddress().toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void sendAndCheckHeartbeat() {
        TimePoint now = TimePoint.now();
        if (now.after(this.requireNextHeartbeatUntil)) {
            logger.info("Expected heartbeat from channel " + this.socketChannel + " until " + this.requireNextHeartbeatUntil + " but haven't received it until " + now + "; closing connection");
            try {
                this.close();
            }
            catch (Exception e) {
                logger.warning("Channel " + this.socketChannel + " threw exception while trying to close it: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        try {
            this.send((AbstractMessage)IgtimiStream.Msg.newBuilder().setChannelManagement(IgtimiStream.ChannelManagement.newBuilder().setHeartbeat(1L)).build());
        }
        catch (ClosedChannelException cce) {
            logger.warning("Channel " + this.socketChannel + " closed.");
            try {
                this.onClosed();
            }
            catch (Exception e) {
                logger.warning("Channel " + this.socketChannel + " threw exception while trying to close it: " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Problem while trying to send heartbeat message to device " + this.getSerialNumber(), e);
            try {
                this.close();
            }
            catch (Exception e1) {
                logger.warning("Channel " + this.socketChannel + " threw exception while trying to close it: " + e1.getMessage());
                throw new RuntimeException(e);
            }
        }
    }

    public String toString() {
        return "RiotConnectionImpl [serialNumber=" + this.serialNumber + ", socketChannel=" + this.socketChannel + "]";
    }
}

