/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.generic.support;

import com.sap.sse.common.settings.Settings;
import com.sap.sse.common.settings.generic.GenericSerializableSettings;
import com.sap.sse.common.settings.generic.Setting;
import com.sap.sse.common.settings.generic.SettingsMap;
import com.sap.sse.common.settings.generic.ValueCollectionSetting;
import com.sap.sse.common.settings.generic.ValueSetting;
import java.util.Map;

public final class SettingsUtil {
    private static final ValuesExtractor defaultValuesExtractor = new ValuesExtractor(){

        @Override
        public <V> V getDefaultValue(ValueSetting<V> setting) {
            return setting.getDefaultValue();
        }

        @Override
        public <V> Iterable<V> getDefaultValue(ValueCollectionSetting<V> setting) {
            return setting.getDefaultValues();
        }
    };
    private static final ValuesSetter defaultValuesSetter = new ValuesSetter(){

        @Override
        public <V> void setDefaultValue(ValueSetting<V> setting, V value) {
            setting.setDefaultValue(value);
        }

        @Override
        public <V> void setDefaultValue(ValueCollectionSetting<V> setting, Iterable<V> values) {
            setting.setDefaultValues(values);
        }
    };
    private static final ValuesExtractor valuesExtractor = new ValuesExtractor(){

        @Override
        public <V> V getDefaultValue(ValueSetting<V> setting) {
            return setting.getValue();
        }

        @Override
        public <V> Iterable<V> getDefaultValue(ValueCollectionSetting<V> setting) {
            return setting.getValues();
        }
    };
    private static final ValuesSetter valuesSetter = new ValuesSetter(){

        @Override
        public <V> void setDefaultValue(ValueSetting<V> setting, V value) {
            setting.setValue(value);
        }

        @Override
        public <V> void setDefaultValue(ValueCollectionSetting<V> setting, Iterable<V> values) {
            setting.setValues(values);
        }
    };

    private SettingsUtil() {
    }

    public static <T extends Settings> T copyDefaults(T settingsWithDefaults, T settingsToSetDefaults) {
        return SettingsUtil.copyDefaultsInternal(settingsWithDefaults, settingsToSetDefaults, defaultValuesExtractor, defaultValuesSetter);
    }

    public static <T extends Settings> T copyDefaultsFromValues(T settingsToUseAsDefaults, T settingsToSetDefaults) {
        return SettingsUtil.copyDefaultsInternal(settingsToUseAsDefaults, settingsToSetDefaults, valuesExtractor, defaultValuesSetter);
    }

    public static <T extends Settings> T copyValues(T settingsWithValues, T settingsToSetValues) {
        return SettingsUtil.copyDefaultsInternal(settingsWithValues, settingsToSetValues, valuesExtractor, valuesSetter);
    }

    public static <T extends Settings> T copyValuesAndDefaults(T settingsWithValues, T settingsWithDefaults, T settingsToSetValuesAndDefaults) {
        SettingsUtil.copyDefaultsInternal(settingsWithDefaults, settingsToSetValuesAndDefaults, defaultValuesExtractor, defaultValuesSetter);
        SettingsUtil.copyDefaultsInternal(settingsWithValues, settingsToSetValuesAndDefaults, valuesExtractor, valuesSetter);
        return settingsToSetValuesAndDefaults;
    }

    private static <T extends Settings> T copyDefaultsInternal(T settingsWithDefaults, T settingsToSetDefaults, ValuesExtractor defaultValuesExtractor, ValuesSetter valuesSetter) {
        if (settingsToSetDefaults instanceof GenericSerializableSettings) {
            SettingsUtil.copyDefaultsForGenericSerializableSettings((GenericSerializableSettings)settingsWithDefaults, (GenericSerializableSettings)settingsToSetDefaults, defaultValuesExtractor, valuesSetter);
        } else if (settingsToSetDefaults instanceof SettingsMap) {
            SettingsMap settingsMapWithDefaults = (SettingsMap)settingsWithDefaults;
            SettingsMap settingsMapToSetDefaults = (SettingsMap)settingsToSetDefaults;
            for (Map.Entry<String, Settings> entry : settingsMapToSetDefaults.getSettingsPerComponentId().entrySet()) {
                Settings childSettingsToSetDefaults = entry.getValue();
                Settings childSettingsWithDefaults = settingsMapWithDefaults.getSettingsPerComponentId().get(entry.getKey());
                SettingsUtil.copyDefaultsInternal(childSettingsWithDefaults, childSettingsToSetDefaults, defaultValuesExtractor, valuesSetter);
            }
        }
        return settingsToSetDefaults;
    }

    private static <T extends GenericSerializableSettings> T copyDefaultsForGenericSerializableSettings(T settingsWithDefaults, T settingsToSetDefaults, ValuesExtractor defaultValuesExtractor, ValuesSetter valuesSetter) {
        if (settingsWithDefaults == null) {
            return null;
        }
        Map<String, Setting> childSettingsWithDefaults = settingsWithDefaults.getChildSettings();
        Map<String, Setting> childSettingsToSetDefaults = settingsToSetDefaults.getChildSettings();
        for (Map.Entry<String, Setting> entry : childSettingsToSetDefaults.entrySet()) {
            String settingKey = entry.getKey();
            Setting settingToSetDefault = entry.getValue();
            if (settingToSetDefault instanceof ValueSetting) {
                ValueSetting valueSettingToSetDefault = (ValueSetting)settingToSetDefault;
                ValueSetting valueSettingWithDefault = (ValueSetting)childSettingsWithDefaults.get(settingKey);
                valuesSetter.setDefaultValue(valueSettingToSetDefault, defaultValuesExtractor.getDefaultValue(valueSettingWithDefault));
                continue;
            }
            if (settingToSetDefault instanceof ValueCollectionSetting) {
                ValueCollectionSetting valueCollectionSettingToSetDefault = (ValueCollectionSetting)settingToSetDefault;
                ValueCollectionSetting valueCollectionSettingWithDefault = (ValueCollectionSetting)childSettingsWithDefaults.get(settingKey);
                valuesSetter.setDefaultValue(valueCollectionSettingToSetDefault, defaultValuesExtractor.getDefaultValue(valueCollectionSettingWithDefault));
                continue;
            }
            if (!(settingToSetDefault instanceof GenericSerializableSettings)) continue;
            GenericSerializableSettings settingsToSetDefault = (GenericSerializableSettings)settingToSetDefault;
            GenericSerializableSettings settingsWithDefault = (GenericSerializableSettings)childSettingsWithDefaults.get(settingKey);
            SettingsUtil.copyDefaultsForGenericSerializableSettings(settingsWithDefault, settingsToSetDefault, defaultValuesExtractor, valuesSetter);
        }
        return settingsToSetDefaults;
    }

    private static interface ValuesExtractor {
        public <V> V getDefaultValue(ValueSetting<V> var1);

        public <V> Iterable<V> getDefaultValue(ValueCollectionSetting<V> var1);
    }

    private static interface ValuesSetter {
        public <V> void setDefaultValue(ValueSetting<V> var1, V var2);

        public <V> void setDefaultValue(ValueCollectionSetting<V> var1, Iterable<V> var2);
    }
}

