/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.generic.base;

import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.ValueConverter;
import com.sap.sse.common.settings.generic.ValueSetting;
import com.sap.sse.common.settings.generic.base.AbstractHasValueSetting;
import com.sap.sse.common.settings.value.Value;

public abstract class AbstractValueSetting<T>
extends AbstractHasValueSetting<T>
implements ValueSetting<T> {
    private T defaultValue;

    protected AbstractValueSetting(String name, AbstractGenericSerializableSettings settings, T defaultValue, ValueConverter<T> valueConverter) {
        super(name, settings, valueConverter);
        this.defaultValue = defaultValue;
        if (settings.getValue(this.settingName) == null) {
            this.resetToDefault();
        }
    }

    @Override
    public T getValue() {
        T result = null;
        Value value = this.settings.getValue(this.settingName);
        if (value != null) {
            result = this.getValueConverter().fromValue(value);
        }
        if (result == null) {
            result = this.defaultValue;
        }
        return result;
    }

    @Override
    public void setValue(T value) {
        this.setValueWithoutPermittionCheck(value);
    }

    private void setValueWithoutPermittionCheck(T value) {
        this.settings.setValue(this.settingName, this.getValueConverter().toValue(value));
    }

    @Override
    public boolean isDefaultValue() {
        T value = this.getValue();
        if (value == this.defaultValue) {
            return true;
        }
        if (value != null) {
            return value.equals(this.defaultValue);
        }
        return false;
    }

    @Override
    public void resetToDefault() {
        this.setValueWithoutPermittionCheck(this.defaultValue);
    }

    @Override
    public final void setDefaultValue(T defaultValue) {
        boolean wasDefault = this.isDefaultValue();
        this.defaultValue = defaultValue;
        if (wasDefault) {
            this.resetToDefault();
        }
    }

    @Override
    public final T getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "" + this.getValue();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        T value = this.getValue();
        result = 31 * result + (value == null ? 0 : value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractValueSetting other = (AbstractValueSetting)obj;
        T value = this.getValue();
        T otherValue = other.getValue();
        return !(value == null ? otherValue != null : !value.equals(otherValue));
    }
}

