/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.settings.generic;

import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.AbstractSetting;
import com.sap.sse.common.settings.generic.SettingsFactory;
import com.sap.sse.common.settings.generic.SettingsListSetting;
import com.sap.sse.common.settings.value.SettingsValue;
import com.sap.sse.common.settings.value.Value;
import com.sap.sse.common.settings.value.ValueCollectionValue;
import com.sap.sse.common.settings.value.ValueListValue;
import java.util.ArrayList;
import java.util.List;

public class SettingsList<T extends AbstractGenericSerializableSettings>
extends AbstractSetting
implements SettingsListSetting<T> {
    private SettingsFactory<T> settingsFactory;
    private final List<T> values = new ArrayList<T>();

    public SettingsList(String name, AbstractGenericSerializableSettings settings, SettingsFactory<T> settingsFactory) {
        super(name, settings);
        this.settingsFactory = settingsFactory;
        this.adoptValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adoptValue() {
        List<T> list = this.values;
        synchronized (list) {
            this.values.clear();
            ValueListValue value = this.getValue();
            if (value != null) {
                for (Value val : value.getValueObjects()) {
                    AbstractGenericSerializableSettings childSettingsInstance = (AbstractGenericSerializableSettings)this.settingsFactory.newInstance();
                    childSettingsInstance.adoptValue((SettingsValue)val);
                    this.values.add(childSettingsInstance);
                }
            }
        }
    }

    @Override
    public SettingsFactory<T> getSettingsFactory() {
        return this.settingsFactory;
    }

    private ValueCollectionValue<List<Value>> ensureValue() {
        ValueListValue result = this.getValue();
        if (result == null) {
            result = new ValueListValue();
            this.settings.setValue(this.settingName, result);
        }
        return result;
    }

    private ValueListValue getValue() {
        return (ValueListValue)this.settings.getValue(this.settingName);
    }

    public String toString() {
        return this.getValues().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDefaultValue() {
        List<T> list = this.values;
        synchronized (list) {
            return this.values.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetToDefault() {
        List<T> list = this.values;
        synchronized (list) {
            this.values.clear();
            this.settings.setValue(this.settingName, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<T> getValues() {
        List<T> list = this.values;
        synchronized (list) {
            ArrayList<T> result = new ArrayList<T>(this.values);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValues(Iterable<T> values) {
        List<T> list = this.values;
        synchronized (list) {
            this.values.clear();
            ValueCollectionValue<List<Value>> valueObject = this.ensureValue();
            valueObject.clear();
            if (values != null) {
                for (AbstractGenericSerializableSettings value : values) {
                    this.values.add(value);
                    valueObject.addValue(value.getInnerValueObject());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addValue(T value) {
        List<T> list = this.values;
        synchronized (list) {
            ValueCollectionValue<List<Value>> valueObject = this.ensureValue();
            this.values.add(value);
            valueObject.addValue(((AbstractGenericSerializableSettings)value).getInnerValueObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        List<T> list = this.values;
        synchronized (list) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        List<T> list = this.values;
        synchronized (list) {
            block13: {
                SettingsList other;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                if (this != obj) break block9;
                                return true;
                            }
                            if (obj != null) break block10;
                            return false;
                        }
                        if (this.getClass() == obj.getClass()) break block11;
                        return false;
                    }
                    other = (SettingsList)obj;
                    if (this.values != null) break block12;
                    if (other.values != null) {
                        return false;
                    }
                    break block13;
                }
                if (this.values.equals(other.values)) break block13;
                return false;
            }
            return true;
        }
    }
}

