/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.media;

import com.sap.sse.common.media.MimeType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public enum MediaTagConstants {
    GALLERY("Gallery", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    STAGE("Stage", 720, 2880, 290, 1160),
    LOGO("Logo", 70, 560, 70, 560),
    TEASER("Teaser", 185, 1110, 120, 720),
    SPONSOR("Sponsor", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    HIGHLIGHT("Highlight", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    LIVESTREAM("Livestream", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    FEATURED("Featured", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    BIGSCREEN("BigScreen", 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE),
    TAGGING_IMAGE("Tagging Image", 100, 500, 100, 500);

    private final String name;
    private final int minWidth;
    private final int maxWidth;
    private final int minHeight;
    private final int maxHeight;
    public static final Iterable<String> imageTagSuggestions;
    public static final Iterable<String> videoTagSuggestions;
    public static final Set<MimeType> SUPPORTED_VIDEO_TYPES;

    static {
        imageTagSuggestions = Arrays.asList(BIGSCREEN.getName(), STAGE.getName(), TEASER.getName(), SPONSOR.getName(), LOGO.getName(), GALLERY.getName());
        videoTagSuggestions = Arrays.asList(BIGSCREEN.getName(), LIVESTREAM.getName(), HIGHLIGHT.getName(), FEATURED.getName(), STAGE.getName());
        SUPPORTED_VIDEO_TYPES = new HashSet<MimeType>(Arrays.asList(MimeType.youtube, MimeType.vimeo, MimeType.mp4, MimeType.mp4panorama, MimeType.mp4panoramaflip, MimeType.mov, MimeType.qt));
    }

    private MediaTagConstants(String name, int minWidth, int maxWidth, int minHeight, int maxHeight) {
        this.name = name;
        this.minWidth = minWidth;
        this.maxWidth = maxWidth;
        this.minHeight = minHeight;
        this.maxHeight = maxHeight;
    }

    public String getName() {
        return this.name;
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMinHeight() {
        return this.minHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public static MediaTagConstants fromName(String name) {
        MediaTagConstants toReturn = null;
        MediaTagConstants[] mediaTagConstantsArray = MediaTagConstants.values();
        int n = mediaTagConstantsArray.length;
        int n2 = 0;
        while (n2 < n) {
            MediaTagConstants mediaTagConstant = mediaTagConstantsArray[n2];
            if (mediaTagConstant.getName().equals(name)) {
                toReturn = mediaTagConstant;
            }
            ++n2;
        }
        return toReturn;
    }
}

