/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Timed;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.impl.MultiTimeRangeImpl;
import java.util.ArrayList;

public class TimeRangeImpl
extends Util.Pair<TimePoint, TimePoint>
implements TimeRange {
    private static final long serialVersionUID = 8710198176227507300L;

    @Deprecated
    TimeRangeImpl() {
    }

    public static TimeRange create(long fromMillis, long toMillisExclusive) {
        return new TimeRangeImpl(new MillisecondsTimePoint(fromMillis), new MillisecondsTimePoint(toMillisExclusive));
    }

    public static TimeRange create(long fromMillis, long toMillis, boolean toIsInclusive) {
        return new TimeRangeImpl(new MillisecondsTimePoint(fromMillis), new MillisecondsTimePoint(toMillis), toIsInclusive);
    }

    public TimeRangeImpl(TimePoint from, TimePoint to, boolean toIsInclusive) {
        this(from, TimeRangeImpl.computeInclusiveOrExclusiveTo(to, toIsInclusive));
    }

    private static TimePoint computeInclusiveOrExclusiveTo(TimePoint to, boolean toIsInclusive) {
        Object finalTo = toIsInclusive ? (to == null ? null : new MillisecondsTimePoint(to.asMillis() + 1L)) : to;
        return finalTo;
    }

    public TimeRangeImpl(TimePoint from, TimePoint toExclusive) {
        super(from == null ? TimePoint.BeginningOfTime : from, toExclusive == null ? TimePoint.EndOfTime : toExclusive);
        if (this.from().after(this.to())) {
            throw new IllegalArgumentException("from " + this.from() + " must lie before to " + this.to() + " in a TimeRange");
        }
    }

    @Override
    public int compareTo(TimeRange other) {
        int result = other.from().equals(this.from()) && other.to().equals(this.to()) ? 0 : (this.from().equals(other.from()) ? this.to().compareTo(other.to()) : this.from().compareTo(other.from()));
        return result;
    }

    @Override
    public TimePoint from() {
        return (TimePoint)this.getA();
    }

    @Override
    public TimePoint to() {
        return (TimePoint)this.getB();
    }

    @Override
    public boolean isEmpty() {
        return this.from().equals(this.to());
    }

    @Override
    public boolean liesWithin(TimeRange other) {
        return this.from().compareTo(other.from()) >= 0 && this.to().compareTo(other.to()) <= 0;
    }

    @Override
    public boolean includes(TimeRange other) {
        return other.liesWithin(this);
    }

    @Override
    public boolean intersects(TimeRange other) {
        return this.includes(other.from()) || this.includes(other.to()) || this.liesWithin(other);
    }

    @Override
    public boolean touches(TimeRange other) {
        return this.intersects(other) || this.from().equals(other.to()) || this.to().equals(other.from());
    }

    @Override
    public boolean includes(TimePoint timePoint) {
        return this.from().compareTo(timePoint) <= 0 && this.to().compareTo(timePoint) > 0;
    }

    @Override
    public boolean includes(Timed timed) {
        return timed == null ? false : this.includes(timed.getTimePoint());
    }

    @Override
    public boolean startsBefore(TimeRange other) {
        return this.from().before(other.from());
    }

    @Override
    public boolean startsBefore(TimePoint other) {
        return this.from().before(other);
    }

    @Override
    public boolean startsAtOrAfter(TimePoint timePoint) {
        return !this.from().before(timePoint);
    }

    @Override
    public boolean startsAfter(TimePoint timePoint) {
        return this.from().after(timePoint);
    }

    @Override
    public boolean startsAfter(TimeRange other) {
        return this.startsAtOrAfter(other.to());
    }

    @Override
    public boolean endsAfter(TimeRange other) {
        return this.to().after(other.to());
    }

    @Override
    public boolean endsBefore(TimePoint timePoint) {
        return !this.to().after(timePoint);
    }

    @Override
    public Duration timeDifference(TimePoint timePoint) {
        Duration result = this.includes(timePoint) ? Duration.NULL : (timePoint.before(this.from()) ? timePoint.until(this.from()) : this.to().until(timePoint));
        return result;
    }

    @Override
    public TimeRange union(TimeRange other) {
        TimeRangeImpl result;
        if (!this.touches(other)) {
            result = null;
        } else {
            TimePoint newFrom = this.startsBefore(other) ? this.from() : other.from();
            TimePoint newTo = this.endsAfter(other) ? this.to() : other.to();
            result = new TimeRangeImpl(newFrom, newTo);
        }
        return result;
    }

    @Override
    public boolean hasOpenBeginning() {
        return this.from().equals(TimePoint.BeginningOfTime);
    }

    @Override
    public boolean hasOpenEnd() {
        return this.to().equals(TimePoint.EndOfTime);
    }

    @Override
    public TimeRange intersection(TimeRange other) {
        TimeRangeImpl result;
        if (!this.intersects(other)) {
            result = null;
        } else {
            TimePoint newFrom = this.startsBefore(other) ? other.from() : this.from();
            TimePoint newTo = this.endsAfter(other) ? other.to() : this.to();
            result = new TimeRangeImpl(newFrom, newTo);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else {
            if (obj instanceof TimeRange) {
                TimeRange other = (TimeRange)obj;
                return this.from().equals(other.from()) && this.to().equals(other.to());
            }
            result = super.equals(obj);
        }
        return result;
    }

    @Override
    public MultiTimeRange subtract(TimeRange other) {
        TimeRangeImpl remainder;
        ArrayList<TimeRange> result = new ArrayList<TimeRange>();
        if (this.startsBefore(other)) {
            TimePoint thisTo;
            TimePoint otherFrom = other.from();
            TimePoint to = otherFrom.after(thisTo = this.to()) ? thisTo : otherFrom;
            remainder = new TimeRangeImpl(this.from(), to);
            result.add(remainder);
        }
        if (this.endsAfter(other)) {
            TimePoint thisFrom;
            TimePoint otherTo = other.to();
            TimePoint from = otherTo.after(thisFrom = this.from()) ? otherTo : thisFrom;
            remainder = new TimeRangeImpl(from, this.to());
            result.add(remainder);
        }
        return new MultiTimeRangeImpl(result);
    }

    @Override
    public TimeRange extend(TimePoint timePoint) {
        TimeRangeImpl result;
        if (timePoint == null || this.includes(timePoint)) {
            result = this;
        } else if (this.startsAfter(timePoint)) {
            result = new TimeRangeImpl(timePoint, this.to());
        } else {
            assert (this.endsBefore(timePoint));
            result = new TimeRangeImpl(this.from(), TimeRangeImpl.computeInclusiveOrExclusiveTo(timePoint, true));
        }
        return result;
    }

    @Override
    public TimeRange extend(TimeRange other) {
        TimeRange preResult;
        TimeRange result = other == null ? this : ((preResult = this.extend(other.from())).to().before(other.to()) ? new TimeRangeImpl(preResult.from(), other.to()) : preResult);
        return result;
    }

    @Override
    public Duration getDuration() {
        return this.from().until(this.to());
    }

    @Override
    public String toString() {
        return this.from() + "-" + this.to();
    }
}

