/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.AbstractDuration;

public class SecondsDurationImpl
extends AbstractDuration {
    private static final long serialVersionUID = 7575912908654324216L;
    private final double seconds;

    public SecondsDurationImpl(double seconds) {
        this.seconds = seconds;
    }

    @Override
    public int compareTo(Duration o) {
        double diff = this.seconds - o.asSeconds();
        return diff > 0.0 ? 1 : (diff < 0.0 ? -1 : 0);
    }

    @Override
    public long asMillis() {
        return Math.round(this.seconds / Duration.ONE_MILLISECOND.asSeconds());
    }

    @Override
    public double asSeconds() {
        return this.seconds;
    }

    @Override
    public double asMinutes() {
        return this.seconds / Duration.ONE_MINUTE.asSeconds();
    }

    @Override
    public double asHours() {
        return this.seconds / Duration.ONE_HOUR.asSeconds();
    }

    @Override
    public double asDays() {
        return this.seconds / Duration.ONE_DAY.asSeconds();
    }

    @Override
    public Duration abs() {
        return this.seconds >= 0.0 ? this : new SecondsDurationImpl(-this.seconds);
    }

    @Override
    public Duration divide(long divisor) {
        return new SecondsDurationImpl(this.seconds / (double)divisor);
    }

    @Override
    public Duration divide(double divisor) {
        return new SecondsDurationImpl(this.seconds / divisor);
    }

    @Override
    public double divide(Duration duration) {
        return this.seconds / duration.asSeconds();
    }

    @Override
    public Duration times(long factor) {
        return new SecondsDurationImpl(this.seconds * (double)factor);
    }

    @Override
    public Duration times(double factor) {
        return new SecondsDurationImpl(this.seconds * factor);
    }

    @Override
    public Duration minus(Duration duration) {
        return new SecondsDurationImpl(this.seconds - duration.asSeconds());
    }

    @Override
    public Duration minus(long milliseconds) {
        return new SecondsDurationImpl(this.seconds - (double)milliseconds / 1000.0);
    }

    @Override
    public Duration plus(long milliseconds) {
        return new SecondsDurationImpl(this.seconds + (double)milliseconds / 1000.0);
    }

    @Override
    public Duration plus(Duration duration) {
        return new SecondsDurationImpl(this.seconds + duration.asSeconds());
    }

    @Override
    public Duration mod(Duration d) {
        return new SecondsDurationImpl(this.seconds % d.asSeconds());
    }
}

