/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.impl;

import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.TimeRangeImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;

public class MultiTimeRangeImpl
implements MultiTimeRange {
    private static final long serialVersionUID = -2440743542692297352L;
    private final TimeRange[] timeRanges;

    public MultiTimeRangeImpl(TimeRange ... timeRanges) {
        this.timeRanges = this.minimizeAndSort(timeRanges);
    }

    public MultiTimeRangeImpl(Iterable<TimeRange> timeRanges) {
        TimeRange[] timeRangesAsArray = new TimeRange[Util.size(timeRanges)];
        int i = 0;
        for (TimeRange timeRange : timeRanges) {
            timeRangesAsArray[i++] = timeRange;
        }
        this.timeRanges = this.minimizeAndSort(timeRangesAsArray);
    }

    private TimeRange[] minimizeAndSort(TimeRange ... timeRanges) {
        TimeRange[] sortedTimeRanges = new TimeRange[timeRanges.length];
        System.arraycopy(timeRanges, 0, sortedTimeRanges, 0, timeRanges.length);
        Arrays.sort(sortedTimeRanges, new TimeRangeByStartTimeComparator());
        ArrayList<TimeRange> minimalTimeRanges = new ArrayList<TimeRange>();
        TimeRange lastAdded = null;
        TimeRange[] timeRangeArray = sortedTimeRanges;
        int n = sortedTimeRanges.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRange timeRange = timeRangeArray[n2];
            if (!timeRange.isEmpty()) {
                if (lastAdded == null) {
                    lastAdded = timeRange;
                    minimalTimeRanges.add(lastAdded);
                } else if (timeRange.touches(lastAdded)) {
                    lastAdded = lastAdded.union(timeRange);
                    minimalTimeRanges.set(minimalTimeRanges.size() - 1, lastAdded);
                } else {
                    lastAdded = timeRange;
                    minimalTimeRanges.add(lastAdded);
                }
                assert (lastAdded != null);
                if (lastAdded.to().equals(TimePoint.EndOfTime)) break;
            }
            ++n2;
        }
        return minimalTimeRanges.toArray(new TimeRange[minimalTimeRanges.size()]);
    }

    @Override
    public Iterator<TimeRange> iterator() {
        return Collections.unmodifiableCollection(Arrays.asList(this.timeRanges)).iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.timeRanges.length == 0;
    }

    @Override
    public MultiTimeRange union(MultiTimeRange other) {
        ArrayList<TimeRange> newTimeRanges = new ArrayList<TimeRange>();
        TimeRange[] timeRangeArray = this.timeRanges;
        int n = this.timeRanges.length;
        int n2 = 0;
        while (n2 < n) {
            TimeRange timeRange = timeRangeArray[n2];
            newTimeRanges.add(timeRange);
            ++n2;
        }
        Util.addAll(other, newTimeRanges);
        return new MultiTimeRangeImpl(newTimeRanges);
    }

    @Override
    public MultiTimeRange union(TimeRange timeRange) {
        return this.union(new MultiTimeRangeImpl(timeRange));
    }

    private TimeRange nextOrNull(Iterator<TimeRange> i) {
        TimeRange result = i.hasNext() ? i.next() : null;
        return result;
    }

    @Override
    public MultiTimeRange intersection(MultiTimeRange other) {
        ArrayList<TimeRange> preResult = new ArrayList<TimeRange>();
        Iterator<TimeRange> thisI = this.iterator();
        Iterator<TimeRange> otherI = other.iterator();
        TimeRange thisRange = this.nextOrNull(thisI);
        TimeRange otherRange = this.nextOrNull(otherI);
        while (thisRange != null && otherRange != null) {
            boolean needToMoveOtherI;
            if (thisRange.endsBefore(otherRange.from())) {
                thisRange = this.nextOrNull(thisI);
                continue;
            }
            if (otherRange.endsBefore(thisRange.from())) {
                otherRange = this.nextOrNull(otherI);
                continue;
            }
            assert (thisRange.from().compareTo(otherRange.to()) < 0 && thisRange.to().compareTo(otherRange.from()) > 0);
            assert (thisRange.intersects(otherRange));
            TimeRange intersection = thisRange.intersection(otherRange);
            assert (intersection != null);
            preResult.add(intersection);
            boolean needToMoveThisI = !thisRange.to().after(otherRange.to());
            boolean bl = needToMoveOtherI = !otherRange.to().after(thisRange.to());
            if (needToMoveThisI) {
                thisRange = this.nextOrNull(thisI);
            }
            if (!needToMoveOtherI) continue;
            otherRange = this.nextOrNull(otherI);
        }
        return new MultiTimeRangeImpl(preResult);
    }

    @Override
    public MultiTimeRange intersection(TimeRange timeRange) {
        return this.intersection(new MultiTimeRangeImpl(timeRange));
    }

    @Override
    public boolean intersects(MultiTimeRange other) {
        return !this.intersection(other).isEmpty();
    }

    @Override
    public boolean intersects(TimeRange other) {
        return !this.intersection(other).isEmpty();
    }

    @Override
    public MultiTimeRange subtract(MultiTimeRange other) {
        ArrayList<TimeRange> preResult = new ArrayList<TimeRange>();
        Iterator<TimeRange> thisI = this.iterator();
        Iterator<TimeRange> otherI = other.iterator();
        TimeRange thisRange = this.nextOrNull(thisI);
        TimeRange otherRange = this.nextOrNull(otherI);
        HashSet unaffectedTimeRangesFromThis = new HashSet();
        Util.addAll(this, unaffectedTimeRangesFromThis);
        while (thisRange != null && otherRange != null) {
            boolean needToMoveOtherI;
            if (thisRange.endsBefore(otherRange.from())) {
                thisRange = this.nextOrNull(thisI);
                continue;
            }
            if (otherRange.endsBefore(thisRange.from())) {
                otherRange = this.nextOrNull(otherI);
                continue;
            }
            assert (thisRange.from().compareTo(otherRange.to()) < 0 && thisRange.to().compareTo(otherRange.from()) > 0);
            assert (thisRange.intersects(otherRange));
            unaffectedTimeRangesFromThis.remove(thisRange);
            for (TimeRange subtractResult : thisRange.subtract(otherRange)) {
                if (subtractResult.to().before(thisRange.to())) {
                    preResult.add(subtractResult);
                    continue;
                }
                thisRange = subtractResult;
            }
            boolean needToMoveThisI = !thisRange.to().after(otherRange.to());
            boolean bl = needToMoveOtherI = !otherRange.to().after(thisRange.to());
            if (needToMoveThisI) {
                thisRange = this.nextOrNull(thisI);
            }
            if (!needToMoveOtherI) continue;
            otherRange = this.nextOrNull(otherI);
        }
        preResult.addAll(unaffectedTimeRangesFromThis);
        if (thisRange != null) {
            preResult.add(thisRange);
        }
        return new MultiTimeRangeImpl(preResult);
    }

    @Override
    public MultiTimeRange subtract(TimeRange timeRange) {
        return this.subtract(new MultiTimeRangeImpl(timeRange));
    }

    @Override
    public boolean includes(TimePoint timePoint) {
        int pos = Arrays.binarySearch(this.timeRanges, 0, this.timeRanges.length, new TimeRangeImpl(timePoint, null), new TimeRangeByStartTimeComparator());
        if (pos < 0) {
            pos = -pos - 2;
        }
        assert (pos == -1 || this.timeRanges[pos].from().compareTo(timePoint) <= 0);
        return pos >= 0 && timePoint.before(this.timeRanges[pos].to());
    }

    @Override
    public boolean includes(TimeRange timeRange) {
        for (TimeRange tr : this) {
            if (!tr.includes(timeRange)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean includes(MultiTimeRange other) {
        for (TimeRange otherTimeRange : other) {
            if (this.includes(otherTimeRange)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.timeRanges);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTimeRangeImpl other = (MultiTimeRangeImpl)obj;
        return Arrays.equals(this.timeRanges, other.timeRanges);
    }

    public String toString() {
        return Arrays.toString(this.timeRanges);
    }

    private static class TimeRangeByStartTimeComparator
    implements Comparator<TimeRange> {
        private TimeRangeByStartTimeComparator() {
        }

        @Override
        public int compare(TimeRange tr1, TimeRange tr2) {
            return tr1.from().compareTo(tr2.from());
        }
    }
}

