/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common.filter;

import com.sap.sse.common.filter.FilterOperator;
import java.util.Comparator;

public class BinaryOperator<T extends Number>
implements FilterOperator<T> {
    private Operators operator;
    private NumberComparator<T> numberComparator = new NumberComparator();

    public BinaryOperator(Operators operator) {
        this.operator = operator;
    }

    public Operators getOperator() {
        return this.operator;
    }

    public void setOperator(Operators operator) {
        if (operator != null) {
            this.operator = operator;
        }
    }

    @Override
    public boolean matchValues(T filterValue, T valueToMatch) {
        boolean result = false;
        if (this.operator != null) {
            int compareResult = this.numberComparator.compare(valueToMatch, filterValue);
            switch (this.operator) {
                case LessThanEquals: {
                    result = compareResult < 0 || compareResult == 0;
                    break;
                }
                case Equals: {
                    result = compareResult == 0;
                    break;
                }
                case GreaterThanEquals: {
                    result = compareResult > 0 || compareResult == 0;
                    break;
                }
                case LessThan: {
                    result = compareResult < 0;
                    break;
                }
                case GreaterThan: {
                    result = compareResult > 0;
                    break;
                }
                case NotEqualTo: {
                    result = compareResult < 0 || compareResult > 0;
                }
            }
        }
        return result;
    }

    @Override
    public String getName() {
        return this.operator.name();
    }

    class NumberComparator<S extends Number>
    implements Comparator<S> {
        NumberComparator() {
        }

        @Override
        public int compare(S a, S b) throws ClassCastException {
            return ((Comparable)a).compareTo(b);
        }
    }

    public static enum Operators {
        Equals,
        NotEqualTo,
        LessThan,
        LessThanEquals,
        GreaterThan,
        GreaterThanEquals;

    }
}

