/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.common;

import com.sap.sse.common.ColorMapperChangedListener;
import com.sap.sse.common.ValueRangeFlexibleBoundaries;
import com.sap.sse.common.ValueRangeFlexibleBoundariesChangedListener;
import java.util.HashSet;
import java.util.Set;

public class ColorMapper
implements ValueRangeFlexibleBoundariesChangedListener {
    public static final int MAX_HUE = 315;
    private final ValueRangeFlexibleBoundaries valueRange;
    private double minValue;
    private double maxValue;
    private boolean isGrey;
    private final Set<ColorMapperChangedListener> colorMapperChangedListeners;
    private final ValueSpreader valueSpreader;

    public ColorMapper(ValueRangeFlexibleBoundaries valueRange, boolean isGrey, ValueSpreader valueSpreader) {
        this.valueRange = valueRange;
        this.valueSpreader = valueSpreader;
        this.valueRange.addListener(this);
        this.minValue = this.valueRange.getMinLeft();
        this.maxValue = this.valueRange.getMaxRight();
        this.isGrey = isGrey;
        this.colorMapperChangedListeners = new HashSet<ColorMapperChangedListener>();
    }

    public void setGrey(boolean isGrey) {
        this.isGrey = isGrey;
        this.notifyListeners();
    }

    public String getColor(double value) {
        String result;
        if (this.isGrey) {
            result = value < this.minValue ? "rgba(255,255,255,0.0)" : (value > this.maxValue ? "rgba(255,255,255,1.0)" : "rgba(255,255,255," + this.valueSpreader.getSpreadOutValue((value - this.minValue) / (this.maxValue - this.minValue)) + ")");
        } else if (value < this.minValue) {
            result = "hsl(315, 100%, 50%)";
        } else if (value > this.maxValue) {
            result = "hsl(0, 100%, 50%)";
        } else {
            double h = this.valueSpreader.getSpreadOutValue(1.0 - (value - this.minValue) / (this.maxValue - this.minValue)) * 315.0;
            result = "hsl(" + Math.round(h) + ", 100%, 50%)";
        }
        return result;
    }

    private void updateMinMax() {
        this.minValue = this.valueRange.getMinLeft();
        this.maxValue = this.valueRange.getMaxRight();
    }

    @Override
    public void onValueRangeBoundariesChanged() {
        this.updateMinMax();
        this.notifyListeners();
    }

    public void addListener(ColorMapperChangedListener listener) {
        this.colorMapperChangedListeners.add(listener);
    }

    public void removeListener(ColorMapperChangedListener listener) {
        this.colorMapperChangedListeners.remove(listener);
    }

    public void notifyListeners() {
        for (ColorMapperChangedListener listener : this.colorMapperChangedListeners) {
            listener.onColorMappingChanged();
        }
    }

    @FunctionalInterface
    public static interface ValueSpreader {
        public static final ValueSpreader LINEAR = v -> v;
        public static final ValueSpreader CUBIC_ROOT = v -> (Math.pow(Math.abs(2.0 * (v - 0.5)), 0.3333333333333333) * Math.signum(v - 0.5) + 1.0) / 2.0;

        public double getSpreadOutValue(double var1);
    }
}

